/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.pdfa2;

import com.adobe.internal.pdftoolkit.core.exceptions.PDFConfigurationException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidXMLException;
import com.adobe.internal.pdftoolkit.services.pdfa2.PDFA2XMPSchema;
import com.adobe.internal.pdftoolkit.services.pdfa2.processor.SchemaCollector;
import com.adobe.internal.pdftoolkit.xml.XMLUtils;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class PDFA2ExternalSchemas {
    @Deprecated
    private Map<String, PDFA2XMPSchema> externalSchemas = new HashMap<String, PDFA2XMPSchema>();

    public void addExternalSchema(InputStream schemaStream) throws PDFConfigurationException, PDFInvalidXMLException {
        Map<String, PDFA2XMPSchema> schemas = this.extractSchemas(schemaStream, false);
        this.externalSchemas.putAll(schemas);
    }

    private Map<String, PDFA2XMPSchema> extractSchemas(InputStream schemaStream, boolean badSchemas) throws PDFConfigurationException, PDFInvalidXMLException {
        SchemaCollector collector;
        try {
            collector = new SchemaCollector(badSchemas);
            InputSource source = new InputSource(schemaStream);
            Source inputXML = XMLUtils.createSource(source, collector, false, true);
            Result outputXML = XMLUtils.createNullResult();
            XMLUtils.transformToXML(inputXML, outputXML, true);
        }
        catch (SAXException e) {
            throw new PDFConfigurationException("Unable to set namespace features on XML Reader.", (Throwable)e);
        }
        catch (TransformerException e) {
            throw new PDFInvalidXMLException("Supplied XMP Schema was invalid.", (Throwable)e);
        }
        return collector.getSchemas();
    }

    public Map<String, PDFA2XMPSchema> getSchemas() {
        return Collections.unmodifiableMap(this.externalSchemas);
    }
}

