/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.pdfa.xmp;

import com.adobe.internal.pdftoolkit.services.pdfa.xmp.MetadataUsageTreeNode;
import com.adobe.internal.pdftoolkit.services.pdfa.xmp.XMPSimpleType;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

class XMPURI
extends XMPSimpleType {
    private static XMPURI _xmpURI = new XMPURI();

    private XMPURI() {
    }

    public static XMPURI getInstance() {
        return _xmpURI;
    }

    @Override
    public boolean isValid(MetadataUsageTreeNode m) {
        block6: {
            if (!super.isValid(m)) {
                return false;
            }
            String value = m.getValue();
            try {
                new URI(value);
            }
            catch (URISyntaxException e) {
                Pattern URIpattern;
                Matcher matcher;
                int index = value.lastIndexOf(58);
                if (index != -1) {
                    value = value.substring(index + 1);
                }
                if (!(matcher = (URIpattern = Pattern.compile("[\\}*\\{*\\(*\\)*]*([0-9A-Fa-f]{8}\\-?([0-9A-Fa-f]{4}\\-?){3}[0-9A-Fa-f]{12})[\\}*\\{*\\(*\\)*]*")).matcher(value)).matches()) break block6;
                try {
                    new URI("uuid:" + matcher.group(1));
                }
                catch (URISyntaxException e1) {
                    return false;
                }
            }
        }
        return true;
    }
}

