/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.pdfa.xmp;

import com.adobe.internal.pdftoolkit.services.pdfa.xmp.RDFArrayTypes;
import java.util.ArrayList;
import java.util.List;

class MetadataUsageTreeNode {
    private String prefix;
    private String nameSpaceURI;
    private String name;
    private String value;
    private String languageQualifier;
    private RDFArrayTypes arrayType = RDFArrayTypes.NONE;
    private List<MetadataUsageTreeNode> nodes;
    private MetadataUsageTreeNode parentNode;

    public MetadataUsageTreeNode(MetadataUsageTreeNode parentNode) {
        this.parentNode = parentNode;
    }

    public void setName(String name) {
        this.name = name;
    }

    private RDFArrayTypes getRDFEnum(String rdfArrayType) {
        return RDFArrayTypes.valueOf(rdfArrayType.replaceAll("rdf:", "").toUpperCase());
    }

    public void startArray(String arrayType) {
        this.arrayType = this.getRDFEnum(arrayType);
        this.nodes = new ArrayList<MetadataUsageTreeNode>();
    }

    public void endArray() {
    }

    public MetadataUsageTreeNode startLI() {
        return new MetadataUsageTreeNode(this);
    }

    public MetadataUsageTreeNode endLI() {
        MetadataUsageTreeNode pNode = this.parentNode;
        pNode.nodes.add(this);
        return pNode;
    }

    public MetadataUsageTreeNode startElement(String uri, String localName, String prefix) {
        if (this.arrayType == RDFArrayTypes.NONE) {
            if (this.nodes == null) {
                this.nodes = new ArrayList<MetadataUsageTreeNode>();
            }
            MetadataUsageTreeNode childNode = new MetadataUsageTreeNode(this);
            childNode.nameSpaceURI = uri;
            childNode.name = localName;
            childNode.prefix = prefix;
            this.nodes.add(childNode);
            return childNode;
        }
        return null;
    }

    public MetadataUsageTreeNode endElement() {
        return this.parentNode;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public RDFArrayTypes getArrayType() {
        return this.arrayType;
    }

    public String getName() {
        return this.name;
    }

    public MetadataUsageTreeNode getParentNode() {
        return this.parentNode;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public String getNameSpaceURI() {
        return this.nameSpaceURI;
    }

    public String getValue() {
        return this.value;
    }

    public List<MetadataUsageTreeNode> getNodes() {
        return this.nodes;
    }

    public boolean isNodeArray() {
        return this.arrayType != RDFArrayTypes.NONE;
    }

    public void setLanguageQualifier(String languageQualifier) {
        this.languageQualifier = languageQualifier;
    }

    public String getLanguageQualifier() {
        return this.languageQualifier;
    }

    public String toString() {
        if (this.arrayType != RDFArrayTypes.NONE) {
            try {
                return (this.name != null ? this.name : "") + " ";
            }
            catch (Exception e) {
                return "";
            }
        }
        StringBuilder str = new StringBuilder();
        for (MetadataUsageTreeNode node : this.nodes) {
            str.append(node.name != null ? node.name : " ");
            str.append("(" + (Object)((Object)node.arrayType) + ") ");
        }
        return str.toString();
    }
}

