/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.pdfa.processor;

import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.content.Content;
import com.adobe.internal.pdftoolkit.pdf.contentmodify.ModifiableContent;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosDictionary;
import com.adobe.internal.pdftoolkit.pdf.document.PDFResources;
import com.adobe.internal.pdftoolkit.pdf.graphics.patterns.PDFPattern;
import com.adobe.internal.pdftoolkit.pdf.graphics.patterns.PDFPatternMap;
import com.adobe.internal.pdftoolkit.pdf.graphics.patterns.PDFPatternTiling;
import com.adobe.internal.pdftoolkit.services.pdfa.PDFAConformanceLevel;
import com.adobe.internal.pdftoolkit.services.pdfa.PDFAConversionHandler;
import com.adobe.internal.pdftoolkit.services.pdfa.PDFAConversionOptions;
import com.adobe.internal.pdftoolkit.services.pdfa.PDFAErrorSetPattern;
import com.adobe.internal.pdftoolkit.services.pdfa.PDFAValidationHandler;
import com.adobe.internal.pdftoolkit.services.pdfa.PDFAValidationOptions;
import com.adobe.internal.pdftoolkit.services.pdfa.error.PDFAPatternErrorCode;
import com.adobe.internal.pdftoolkit.services.pdfa.processor.ContentProcessor;
import com.adobe.internal.pdftoolkit.services.pdfa.processor.DocumentProcessor;
import java.util.Set;

class PatternProcessor {
    PatternProcessor() {
    }

    static boolean process(PDFPatternMap patternMap, Set referencedPatternNames, DocumentProcessor docProcessor, PDFAConformanceLevel conformance, PDFAConversionOptions conversionOptions, PDFAConversionHandler conversionHandler, PDFAValidationOptions validationOptions, PDFAValidationHandler validationHandler) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (patternMap == null || patternMap.isEmpty()) {
            return true;
        }
        if (validationOptions.validateUnusedResourcesEnabled()) {
            for (ASName name : patternMap.keySet()) {
                PDFPattern pattern = patternMap.get(name);
                if (!(pattern instanceof PDFPatternTiling) || PatternProcessor.process(name, (PDFPatternTiling)pattern, docProcessor, conformance, conversionOptions, conversionHandler, validationOptions, validationHandler)) continue;
                return false;
            }
        } else {
            if (referencedPatternNames == null || referencedPatternNames.isEmpty()) {
                return true;
            }
            for (ASName name : referencedPatternNames) {
                PDFPatternTiling pattern;
                if (PatternProcessor.process(name, pattern = (PDFPatternTiling)patternMap.get(name), docProcessor, conformance, conversionOptions, conversionHandler, validationOptions, validationHandler)) continue;
                return false;
            }
        }
        return true;
    }

    static boolean process(ASName name, PDFPatternTiling pattern, DocumentProcessor docProcessor, PDFAConformanceLevel conformance, PDFAConversionOptions conversionOptions, PDFAConversionHandler conversionHandler, PDFAValidationOptions validationOptions, PDFAValidationHandler validationHandler) throws PDFIOException, PDFSecurityException {
        if (pattern == null) {
            return true;
        }
        if (!validationHandler.beginPatternScan(name, pattern)) {
            return false;
        }
        PDFAErrorSetPattern errorCodes = new PDFAErrorSetPattern();
        try {
            PDFResources resources;
            ModifiableContent content = ModifiableContent.newInstance((PDFPatternTiling)pattern);
            if (!ContentProcessor.process((Content)content, (PDFCosDictionary)pattern, null, docProcessor, conformance, conversionOptions, conversionHandler, validationOptions, validationHandler)) {
                return false;
            }
            if (conversionHandler != null && content.resourcesDetached() && (resources = content.getResources()) != null && !resources.isEmpty()) {
                try {
                    pattern.setResources(content.getResources());
                }
                catch (PDFInvalidParameterException e) {}
            }
        }
        catch (PDFInvalidDocumentException e) {
            errorCodes.addErrorCode(PDFAPatternErrorCode.pdfGeneralFailure);
        }
        if (errorCodes.hasErrors() && !validationHandler.patternError(errorCodes)) {
            return false;
        }
        return validationHandler.endPatternScan();
    }
}

