/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.pdfa.processor;

import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.cos.CosStream;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFConfigurationException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFFontException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFRuntimeException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.fontset.PDFFontSet;
import com.adobe.internal.pdftoolkit.core.types.ASMatrix;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.content.Content;
import com.adobe.internal.pdftoolkit.pdf.content.InstructionFactory;
import com.adobe.internal.pdftoolkit.pdf.contentmodify.ContentWriter;
import com.adobe.internal.pdftoolkit.pdf.contentmodify.ModifiableContent;
import com.adobe.internal.pdftoolkit.pdf.document.PDFContents;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosDictionary;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosStream;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.document.PDFResources;
import com.adobe.internal.pdftoolkit.pdf.graphics.PDFRotation;
import com.adobe.internal.pdftoolkit.pdf.graphics.colorspaces.PDFColorSpace;
import com.adobe.internal.pdftoolkit.pdf.graphics.colorspaces.PDFColorSpaceDeviceRGB;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFFont;
import com.adobe.internal.pdftoolkit.pdf.graphics.xobject.PDFGroupAttributes;
import com.adobe.internal.pdftoolkit.pdf.graphics.xobject.PDFXObject;
import com.adobe.internal.pdftoolkit.pdf.graphics.xobject.PDFXObjectImage;
import com.adobe.internal.pdftoolkit.pdf.graphics.xobject.PDFXObjectMap;
import com.adobe.internal.pdftoolkit.pdf.interactive.action.PDFAction;
import com.adobe.internal.pdftoolkit.pdf.interactive.action.PDFActionNamed;
import com.adobe.internal.pdftoolkit.pdf.interactive.action.PDFAdditionalActions;
import com.adobe.internal.pdftoolkit.pdf.interactive.action.PDFAdditionalActionsPage;
import com.adobe.internal.pdftoolkit.pdf.page.PDFPage;
import com.adobe.internal.pdftoolkit.pdf.page.PDFPageTreeNode;
import com.adobe.internal.pdftoolkit.pdf.utils.ContentUtil;
import com.adobe.internal.pdftoolkit.services.pdfa.PDFAConformanceLevel;
import com.adobe.internal.pdftoolkit.services.pdfa.PDFAConversionHandler;
import com.adobe.internal.pdftoolkit.services.pdfa.PDFAConversionOptions;
import com.adobe.internal.pdftoolkit.services.pdfa.PDFAErrorSet;
import com.adobe.internal.pdftoolkit.services.pdfa.PDFAErrorSetFont;
import com.adobe.internal.pdftoolkit.services.pdfa.PDFAErrorSetPage;
import com.adobe.internal.pdftoolkit.services.pdfa.PDFAValidationHandler;
import com.adobe.internal.pdftoolkit.services.pdfa.PDFAValidationOptions;
import com.adobe.internal.pdftoolkit.services.pdfa.error.PDFAFontErrorCode;
import com.adobe.internal.pdftoolkit.services.pdfa.error.PDFAPageErrorCode;
import com.adobe.internal.pdftoolkit.services.pdfa.font.UnembeddedFontInfo;
import com.adobe.internal.pdftoolkit.services.pdfa.processor.AnnotationProcessor;
import com.adobe.internal.pdftoolkit.services.pdfa.processor.ContentProcessor;
import com.adobe.internal.pdftoolkit.services.pdfa.processor.DocumentProcessor;
import com.adobe.internal.pdftoolkit.services.pdfa.processor.MetadataProcessor;
import com.adobe.internal.pdftoolkit.services.rasterizer.RasterizationOptions;
import com.adobe.internal.pdftoolkit.services.rasterizer.impl.PDFToRasterConverter;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

class PageProcessor {
    PageProcessor() {
    }

    static boolean process(PDFPageTreeNode pages, DocumentProcessor docProcessor, PDFAConformanceLevel conformance, PDFAConversionOptions conversionOptions, PDFAConversionHandler conversionHandler, PDFAValidationOptions validationOptions, PDFAValidationHandler validationHandler) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (pages == null) {
            return true;
        }
        if (!validationHandler.beginPageTreeScan()) {
            return false;
        }
        int index = 1;
        Iterator iter = pages.iterator();
        while (iter.hasNext()) {
            HashMap<PDFFont, UnembeddedFontInfo> unembeddedFonts = new HashMap<PDFFont, UnembeddedFontInfo>();
            unembeddedFonts.putAll(docProcessor.getFontContext().getUnembeddedFonts());
            PDFPage page = (PDFPage)iter.next();
            if (!PageProcessor.process(page, index++, docProcessor, conformance, conversionOptions, conversionHandler, validationOptions, validationHandler)) {
                return false;
            }
            if (conversionHandler != null && conversionOptions.isFallbackToRaster()) {
                PageProcessor.fallbacktoRaster(page, docProcessor, conversionHandler, conversionOptions, validationHandler, unembeddedFonts);
            }
            docProcessor.usesDeviceCMYKColorSpace = false;
            docProcessor.usesDeviceRGBColorSpace = false;
        }
        return validationHandler.endPageTreeScan();
    }

    private static void fallbacktoRaster(PDFPage page, DocumentProcessor docProcessor, PDFAConversionHandler conversionHandler, PDFAConversionOptions conversionOptions, PDFAValidationHandler validationHandler, Map<PDFFont, UnembeddedFontInfo> unembeddedFonts) throws PDFIOException, PDFInvalidDocumentException, PDFSecurityException {
        Map<CosObject, PDFAErrorSetFont> fontErrorMap = docProcessor.getFontContext().getFontDictErrors();
        Collection<PDFAErrorSetFont> errorSet = fontErrorMap.values();
        Iterator<PDFAErrorSetFont> itr = errorSet.iterator();
        boolean fontEmbeddingErrorFound = false;
        while (itr.hasNext()) {
            PDFAErrorSet error = itr.next();
            if (!error.errorCodeSet(PDFAFontErrorCode.fontEmbeddingFailedFontNotInFontSet) && !error.errorCodeSet(PDFAFontErrorCode.openTypeFontEmbeddingNotAllowed) && !error.errorCodeSet(PDFAFontErrorCode.fontEmbeddingFailedPermissionError) && !error.errorCodeSet(PDFAFontErrorCode.fontEmbeddingFailure) && !error.errorCodeSet(PDFAFontErrorCode.fontEmbeddingFailedGlyphError)) continue;
            fontEmbeddingErrorFound = true;
            break;
        }
        if (fontEmbeddingErrorFound) {
            try {
                PageProcessor.rasterPageAndUpdatePageResourcesAndContents(page, conversionOptions.getResolution());
                conversionHandler.rasterGeneratedforPage(page);
                PageProcessor.clearUnembeddedFontEntriesAddedByCurrentPageProcesing(docProcessor, unembeddedFonts);
            }
            catch (PDFConfigurationException | PDFFontException | PDFInvalidParameterException | IOException e) {
                if (e.getMessage() != null && e.getMessage().indexOf("FontSet not supplied in PDFOpenOptions during PDFDoc Creation") != -1) {
                    validationHandler.fontError(new PDFAErrorSetFont(PDFAFontErrorCode.fontSetNotSuppliedForFallbackRaster));
                }
                validationHandler.fontError(new PDFAErrorSetFont(PDFAFontErrorCode.fontEmbeddingFailedFontNotInFontSet));
                throw new PDFInvalidDocumentException(e.getMessage());
            }
        }
    }

    private static void rasterPageAndUpdatePageResourcesAndContents(PDFPage pdfPage, int resolution) throws PDFIOException, PDFInvalidDocumentException, PDFSecurityException, PDFFontException, PDFConfigurationException, PDFInvalidParameterException, IOException {
        int width = (int)Math.round(pdfPage.getCropBox().width() * (double)resolution);
        int height = (int)Math.round(pdfPage.getCropBox().height() * (double)resolution);
        int[] pageRaster = PageProcessor.rasterizePageAtGivenWidthAndHeight(pdfPage, width, height);
        PDFXObjectImage xObjImage = PageProcessor.createImageXObject(pdfPage, pageRaster, width, 0, 0, width, height);
        ContentWriter contentWriter = ContentWriter.newInstance((ModifiableContent)ModifiableContent.getInstance((PDFContents)PDFContents.newInstance((PDFDocument)pdfPage.getPDFDocument()), (PDFResources)pdfPage.getResources()));
        ASName imageName = PageProcessor.writeContentStreamInstructions(contentWriter, width, height, resolution, xObjImage);
        pdfPage.setRotation(PDFRotation.ROTATE_0);
        pdfPage.setMediaBox(0.0, 0.0, (double)(width / resolution), (double)(height / resolution));
        pdfPage.setCropBox(null);
        pdfPage.setContents(contentWriter.close().getContents());
        PDFResources newResources = PageProcessor.createNewPageResources(pdfPage, imageName, xObjImage);
        pdfPage.setResources(newResources);
    }

    private static int[] rasterizePageAtGivenWidthAndHeight(PDFPage pdfPage, int width, int height) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFFontException, PDFConfigurationException, PDFInvalidParameterException, IOException {
        RasterizationOptions rasterOptions = new RasterizationOptions();
        rasterOptions.setWidth(width);
        rasterOptions.setHeight(height);
        BufferedImage image = null;
        PDFFontSet pdfFontSet = pdfPage.getPDFDocument().getCosDocument().getOptions().getFontSet();
        if (pdfFontSet == null) {
            throw new PDFFontException("FontSet not supplied in PDFOpenOptions during PDFDoc Creation. Fontset is required for creating fallback raster!!");
        }
        image = PDFToRasterConverter.toBufferedImage((PDFPage)pdfPage, (PDFFontSet)pdfFontSet, (RasterizationOptions)rasterOptions);
        int[] pageRaster = ((DataBufferInt)image.getRaster().getDataBuffer()).getData();
        return pageRaster;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static PDFXObjectImage createImageXObject(PDFPage pdfPage, int[] pageRaster, int rasterWidth, int x, int y, int w, int h) throws IOException, PDFIOException, PDFSecurityException, PDFInvalidDocumentException {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        byte[] image = null;
        try {
            int rgbValue = 0;
            for (int i = y; i < y + h; ++i) {
                for (int j = x; j < x + w; ++j) {
                    rgbValue = pageRaster[i * rasterWidth + j];
                    os.write(rgbValue >> 16);
                    os.write(rgbValue >> 8);
                    os.write(rgbValue);
                }
            }
        }
        finally {
            if (os != null) {
                image = os.toByteArray();
                os.close();
            }
        }
        PDFXObjectImage xObjImage = PDFXObjectImage.newInstance((PDFDocument)pdfPage.getPDFDocument());
        xObjImage.setStreamData((InputStream)new ByteArrayInputStream(image));
        PDFCosStream.setStreamFilter((CosStream)xObjImage.getCosStream(), (String)"FlateDecode");
        xObjImage.setWidth(w);
        xObjImage.setHeight(h);
        xObjImage.setColorSpace((PDFColorSpace)PDFColorSpaceDeviceRGB.newInstance((PDFDocument)pdfPage.getPDFDocument()));
        xObjImage.setBitsPerComponent(8);
        return xObjImage;
    }

    private static ASName writeContentStreamInstructions(ContentWriter contentWriter, int width, int height, int resolution, PDFXObjectImage xObjImage) throws PDFIOException, PDFInvalidDocumentException, PDFSecurityException {
        contentWriter.write(InstructionFactory.newGSave());
        ASMatrix ctm = new ASMatrix((double)(width / resolution), 0.0, 0.0, (double)(height / resolution), 0.0, 0.0);
        contentWriter.write(InstructionFactory.newConcatMatrix((double)ctm.geta(), (double)ctm.getb(), (double)ctm.getc(), (double)ctm.getd(), (double)ctm.getx(), (double)ctm.gety()));
        ASName imageName = contentWriter.write((PDFXObject)xObjImage);
        contentWriter.write(InstructionFactory.newGRestore());
        return imageName;
    }

    private static PDFResources createNewPageResources(PDFPage pdfPage, ASName imageName, PDFXObjectImage xObjImage) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        pdfPage.setResources(null);
        PDFResources newResources = PDFResources.newInstance((PDFDocument)pdfPage.getPDFDocument());
        PDFXObjectMap xobjMap = PDFXObjectMap.newInstance((PDFDocument)pdfPage.getPDFDocument());
        xobjMap.set(imageName, (PDFXObject)xObjImage);
        newResources.setXObjectMap(xobjMap);
        return newResources;
    }

    private static void clearUnembeddedFontEntriesAddedByCurrentPageProcesing(DocumentProcessor docProcessor, Map<PDFFont, UnembeddedFontInfo> unembeddedFonts) {
        docProcessor.getFontContext().getFontDictErrors().clear();
        Map<PDFFont, UnembeddedFontInfo> unembeddedFontsUpdated = docProcessor.getFontContext().getUnembeddedFonts();
        Iterator<Map.Entry<PDFFont, UnembeddedFontInfo>> mapItr = unembeddedFontsUpdated.entrySet().iterator();
        while (mapItr.hasNext()) {
            Map.Entry<PDFFont, UnembeddedFontInfo> entry = mapItr.next();
            if (unembeddedFonts.get(entry.getKey()) != null) continue;
            mapItr.remove();
        }
    }

    static boolean process(PDFPage page, int index, DocumentProcessor docProcessor, PDFAConformanceLevel conformance, PDFAConversionOptions conversionOptions, PDFAConversionHandler conversionHandler, PDFAValidationOptions validationOptions, PDFAValidationHandler validationHandler) throws PDFIOException, PDFSecurityException {
        block20: {
            if (page == null) {
                return true;
            }
            if (!validationHandler.beginPageScan(page, index)) {
                return false;
            }
            PDFAErrorSetPage errorCodes = new PDFAErrorSetPage();
            try {
                PDFAdditionalActionsPage additionalActions;
                PDFGroupAttributes group = page.getGroup();
                if (group != null && group.getSubType() == ASName.k_Transparency) {
                    errorCodes.addErrorCode(PDFAPageErrorCode.transparencyGroupNotAllowed);
                }
                if (conversionHandler != null && errorCodes.transparencyGroupNotAllowed() && conversionOptions.isRemoveTransparentGroupDict()) {
                    page.setGroup(null);
                    errorCodes.unSetErrorFlag(PDFAPageErrorCode.transparencyGroupNotAllowed);
                }
                if (page.hasUserUnit() && page.getUserUnit() != 1.0) {
                    errorCodes.addErrorCode(PDFAPageErrorCode.nonUnityUserUnits);
                }
                if ((additionalActions = page.getAdditionalActions()) != null) {
                    if (conversionHandler != null && conversionOptions.getRemoveIllegalAdditionalActions()) {
                        PDFAdditionalActionsPage aa = page.getAdditionalActions();
                        page.removeValue(ASName.k_AA);
                        conversionHandler.illegalAdditionalActionsRemoved((PDFAdditionalActions)aa);
                    } else {
                        PDFAction openAction = additionalActions.getActionOnOpen();
                        PageProcessor.processActionInPage(page, openAction, errorCodes, conversionOptions, conversionHandler);
                        PDFAction closeAction = additionalActions.getActionOnClose();
                        PageProcessor.processActionInPage(page, closeAction, errorCodes, conversionOptions, conversionHandler);
                    }
                }
            }
            catch (PDFInvalidDocumentException e) {
                errorCodes.addErrorCode(PDFAPageErrorCode.pdfGeneralFailure);
            }
            if (errorCodes.hasErrors() && !validationHandler.pageError(errorCodes)) {
                return false;
            }
            try {
                Content content = ContentUtil.getContent((conversionHandler != null ? 1 : 0) != 0, (PDFPage)page);
                if (content != null) {
                    PDFResources resources;
                    if (!ContentProcessor.process(content, (PDFCosDictionary)page, null, docProcessor, conformance, conversionOptions, conversionHandler, validationOptions, validationHandler)) {
                        return false;
                    }
                    if (conversionHandler != null && content.resourcesDetached() && !(resources = content.getResources()).isEmpty()) {
                        page.setResources(content.getResources());
                    }
                }
                if (page.hasAnnotations() && !AnnotationProcessor.process(page, docProcessor, page.getResources(), conformance, conversionOptions, conversionHandler, validationOptions, validationHandler)) {
                    return false;
                }
                if (!MetadataProcessor.processDictionaryXMP((PDFCosDictionary)page, conversionHandler)) {
                    errorCodes.addErrorCode(PDFAPageErrorCode.objectXMPMetadataInvalid);
                }
            }
            catch (PDFInvalidDocumentException e) {
                if (!validationHandler.pageError(new PDFAErrorSetPage(PDFAPageErrorCode.pdfGeneralFailure))) {
                    return false;
                }
            }
            catch (PDFRuntimeException e) {
                if (validationHandler.pageError(new PDFAErrorSetPage(PDFAPageErrorCode.pdfGeneralFailure))) break block20;
                return false;
            }
        }
        return validationHandler.endPageScan();
    }

    private static void processActionInPage(PDFPage page, PDFAction action, PDFAErrorSetPage errorCodes, PDFAConversionOptions conversionOptions, PDFAConversionHandler conversionHandler) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (action != null) {
            PDFAction.TreeIterator actionIter = action.treeIterator();
            while (actionIter.hasNext()) {
                action = actionIter.next();
                ASName subtype = action.getSubtype();
                if (subtype == ASName.k_Named) {
                    PDFActionNamed namedAction = (PDFActionNamed)action;
                    ASName actionName = namedAction.getName();
                    if (actionName == ASName.create((String)"NextPage") || actionName == ASName.create((String)"PrevPage") || actionName == ASName.create((String)"FirstPage") || actionName == ASName.create((String)"LastPage")) continue;
                    if (conversionHandler != null && conversionOptions.getRemoveIllegalAdditionalActions()) {
                        PDFAdditionalActionsPage aa = page.getAdditionalActions();
                        page.removeValue(ASName.k_AA);
                        conversionHandler.illegalAdditionalActionsRemoved((PDFAdditionalActions)aa);
                        continue;
                    }
                    errorCodes.addErrorCode(PDFAPageErrorCode.namedActionNotAllowed);
                    continue;
                }
                PDFAPageErrorCode ec = PDFAErrorSetPage.getErrorCode(action.getSubtype());
                if (ec == null) continue;
                if (conversionHandler != null && conversionOptions.getRemoveIllegalAdditionalActions()) {
                    PDFAdditionalActionsPage aa = page.getAdditionalActions();
                    page.removeValue(ASName.k_AA);
                    conversionHandler.illegalAdditionalActionsRemoved((PDFAdditionalActions)aa);
                    continue;
                }
                errorCodes.addErrorCode(ec);
            }
        }
    }

    static boolean hasTransparency(PDFPage page) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFGroupAttributes group = page.getGroup();
        if (group != null && group.getSubType() == ASName.k_Transparency) {
            return true;
        }
        Content content = ContentUtil.getContent((boolean)false, (PDFPage)page);
        return content != null && ContentProcessor.hasTransparency(content);
    }
}

