/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.pdfa.processor;

import com.adobe.internal.pdftoolkit.services.pdfa.PDFASaveTypes;

class PDFASaveModes {
    public static final int incrementalSave = 1;
    public static final int linearSave = 2;
    public static final int fullSave = 4;
    public static final int partiallyFixBySave = 8;
    public static final int noSave = 0;
    private int flags;
    private boolean linearizationBlockingIncSave = true;

    PDFASaveModes(int arg) {
        this.flags = arg;
    }

    PDFASaveModes() {
        this.appendOptions(1);
        this.appendOptions(2);
        this.appendOptions(4);
    }

    public boolean incrementalSave() {
        return this.modeSet(1);
    }

    public boolean linearSave() {
        return this.modeSet(2);
    }

    public boolean fullSave() {
        return this.modeSet(4);
    }

    public boolean partiallyFixBySave() {
        return this.modeSet(8);
    }

    public boolean isLinearizationBlockingIncSave() {
        return this.linearizationBlockingIncSave;
    }

    public void setLinearizationBlockingIncSave(boolean value) {
        this.linearizationBlockingIncSave = value;
    }

    void setOptions(int flags) {
        this.flags = flags;
    }

    public void appendOptions(int flags) {
        this.flags |= flags;
    }

    public void removeOptions(int flags) {
        int invertedFlag = ~flags;
        this.flags &= invertedFlag;
    }

    public int getOptions() {
        return this.flags;
    }

    public boolean modeSet(int mode) {
        return (this.flags & mode) == mode;
    }

    public String toString() {
        String className = this.getClass().getName();
        return className.substring(className.lastIndexOf(46) + 1);
    }

    public void removeAllSaveOptions() {
        this.removeOptions(1);
        this.removeOptions(2);
        this.removeOptions(4);
    }

    static PDFASaveTypes convertToSaveType(PDFASaveModes modes) {
        PDFASaveTypes saveTypes = null;
        if (modes.linearSave() && modes.fullSave() && modes.incrementalSave()) {
            return PDFASaveTypes.ANYSAVE;
        }
        if (modes.linearSave() || modes.fullSave()) {
            saveTypes = PDFASaveTypes.FULL_OR_LINEARSAVE;
            if (modes.isLinearizationBlockingIncSave()) {
                saveTypes.setLinearizationBlockingIncSave(true);
            }
            return saveTypes;
        }
        if (modes.partiallyFixBySave()) {
            saveTypes = PDFASaveTypes.PARTIALLYFIXABLE_BY_FULL_OR_LINEARSAVE;
            if (modes.isLinearizationBlockingIncSave()) {
                saveTypes.setLinearizationBlockingIncSave(true);
            }
            return saveTypes;
        }
        if (modes.getOptions() == 0) {
            return PDFASaveTypes.UNFIXABLE_ERRORS;
        }
        return null;
    }
}

