/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.pdfa.processor;

import com.adobe.internal.pdftoolkit.core.cos.CosDictionary;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.content.ContentReader;
import com.adobe.internal.pdftoolkit.pdf.content.Instruction;
import com.adobe.internal.pdftoolkit.pdf.content.OperandStack;
import com.adobe.internal.pdftoolkit.pdf.graphics.optionalcontent.PDFOCObject;
import com.adobe.internal.pdftoolkit.pdf.interactive.markedcontent.PDFMCProperty;
import com.adobe.internal.pdftoolkit.pdf.interactive.markedcontent.PDFMCPropertyMap;
import com.adobe.internal.pdftoolkit.services.optionalcontent.OCManager;
import java.util.ArrayList;
import java.util.LinkedList;

class MarkedContentSniffer {
    MarkedContentSniffer() {
    }

    MarkedContentInfo scanAhead(ContentReader reader, PDFMCPropertyMap propertyMap, Instruction bdc, Instruction lastInstruction, int gStateDepth, OCManager ocManager) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        MarkedContentInfo mcInfo = new MarkedContentInfo();
        MarkedContentRegionInfo mcri = null;
        MarkedContentRegionInfo lastMcri = null;
        int mcDepth = 0;
        boolean fetchOneInstructionPast = false;
        boolean terminateScan = false;
        while (bdc != null || reader.hasNext()) {
            ASName lastOperator;
            Instruction instruction;
            if (bdc != null) {
                instruction = bdc;
                bdc = null;
            } else {
                instruction = reader.next();
            }
            ASName operator = instruction.getOperator();
            if (fetchOneInstructionPast) {
                terminateScan = true;
            }
            if (!fetchOneInstructionPast) {
                if (operator == ASName.k_BMC || operator == ASName.k_BDC) {
                    ++mcDepth;
                    mcri = mcInfo.startMarkedContentRegion(instruction, propertyMap, ocManager, gStateDepth);
                } else if (operator == ASName.k_EMC) {
                    lastMcri = mcri;
                    mcri = mcInfo.endMarkedContentRegion();
                    if (--mcDepth == 0) {
                        fetchOneInstructionPast = true;
                    }
                } else if (operator == ASName.k_q) {
                    ++gStateDepth;
                } else if (operator == ASName.k_Q && --gStateDepth < mcri.lowestGStateDepth) {
                    mcri.lowestGStateDepth = gStateDepth;
                }
            }
            ASName aSName = lastOperator = lastInstruction == null ? null : lastInstruction.getOperator();
            if (mcri != null && lastInstruction != null) {
                boolean atBMC = false;
                boolean qBMCPresent = false;
                boolean BMCqPresent = false;
                if (operator == ASName.k_BMC || operator == ASName.k_BDC) {
                    atBMC = true;
                    if (lastOperator == ASName.k_q) {
                        qBMCPresent = true;
                    }
                } else if (lastOperator == ASName.k_BMC || lastOperator == ASName.k_BDC) {
                    atBMC = true;
                    if (operator == ASName.k_q) {
                        BMCqPresent = true;
                    }
                }
                if (atBMC && (qBMCPresent || BMCqPresent)) {
                    mcri.opensWithGStatePush = true;
                    if (BMCqPresent) {
                        mcri.startingGStateDepth = gStateDepth;
                    }
                }
            }
            if (lastMcri != null && lastInstruction != null) {
                boolean atEMC = false;
                boolean QEMCPresent = false;
                boolean EMCQPresent = false;
                if (operator == ASName.k_EMC) {
                    atEMC = true;
                    if (lastOperator == ASName.k_Q) {
                        QEMCPresent = true;
                    }
                } else if (lastOperator == ASName.k_EMC) {
                    atEMC = true;
                    if (operator == ASName.k_Q) {
                        EMCQPresent = true;
                    }
                }
                if (atEMC) {
                    lastMcri.endingGStateDepth = gStateDepth;
                    if (QEMCPresent || EMCQPresent) {
                        lastMcri.endsWithGStatePop = true;
                        if (QEMCPresent) {
                            lastMcri.endingGStateDepth = gStateDepth - 1;
                        }
                    }
                }
            }
            lastInstruction = instruction;
            if (!terminateScan) continue;
            break;
        }
        return mcInfo;
    }

    static ASName getMarkedContentOCName(Instruction markedContentInstruction, PDFMCPropertyMap propertyMap) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        OperandStack operands;
        ASName operator = markedContentInstruction.getOperator();
        if (operator == ASName.k_BDC && (operands = markedContentInstruction.getOperands()).peekTypeIsName()) {
            ASName type;
            CosDictionary dict;
            CosObject cosObj;
            PDFMCProperty property;
            ASName propertyName = null;
            if (operands.peekTypeIsName()) {
                propertyName = operands.popName();
            }
            ASName tag = operands.peekName();
            operands.pushName(propertyName);
            if (tag == ASName.k_OC && propertyMap != null && (property = propertyMap.get(propertyName)) != null && (cosObj = property.getCosObject()).getType() == 6 && (dict = (CosDictionary)cosObj).containsKey((Object)ASName.k_Type) && ((type = dict.getName(ASName.k_Type)) == ASName.k_OCG || type == ASName.k_OCMD)) {
                return propertyName;
            }
        }
        return null;
    }

    static class MarkedContentRegionInfo {
        private ASName ocName;
        private PDFOCObject oc;
        private boolean isOCVisible;
        private int parentMCRegionIndex;
        private boolean opensWithGStatePush;
        private boolean endsWithGStatePop;
        private int startingGStateDepth;
        private int lowestGStateDepth;
        private int endingGStateDepth;

        MarkedContentRegionInfo(ASName ocName, PDFOCObject oc, boolean isOCVisible, int parentOCRegionIndex, int startingGStateDepth) {
            this.ocName = ocName;
            this.oc = oc;
            this.isOCVisible = isOCVisible;
            this.parentMCRegionIndex = parentOCRegionIndex;
            this.opensWithGStatePush = false;
            this.endsWithGStatePop = false;
            this.startingGStateDepth = startingGStateDepth;
            this.lowestGStateDepth = startingGStateDepth;
            this.endingGStateDepth = 0;
        }

        ASName getOCName() {
            return this.ocName;
        }

        PDFOCObject getOC() {
            return this.oc;
        }

        boolean isOCRegion() {
            return this.ocName != null;
        }

        int getParentIndex() {
            return this.parentMCRegionIndex;
        }

        boolean isProperlyGStateBracketed() {
            return this.opensWithGStatePush && this.endsWithGStatePop && this.startingGStateDepth == this.endingGStateDepth && this.lowestGStateDepth == this.startingGStateDepth;
        }
    }

    static class MarkedContentInfo {
        private ArrayList<MarkedContentRegionInfo> mcriArray = new ArrayList();
        private LinkedList<Integer> parentIndexStack = new LinkedList();
        private int currentMCRegionIndex = -1;

        MarkedContentInfo() {
        }

        MarkedContentRegionInfo startMarkedContentRegion(Instruction mcInstr, PDFMCPropertyMap propertyMap, OCManager ocManager, int gStateDepth) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
            ASName ocName = MarkedContentSniffer.getMarkedContentOCName(mcInstr, propertyMap);
            PDFOCObject oc = null;
            if (ocName != null) {
                oc = PDFOCObject.getInstance((CosObject)propertyMap.get(ocName).getCosObject());
            }
            MarkedContentRegionInfo mcri = new MarkedContentRegionInfo(ocName, oc, ocManager.isVisible(oc), this.parentIndexStack.isEmpty() ? -1 : this.parentIndexStack.getLast(), gStateDepth);
            this.mcriArray.add(++this.currentMCRegionIndex, mcri);
            this.parentIndexStack.addLast(this.currentMCRegionIndex);
            return mcri;
        }

        MarkedContentRegionInfo endMarkedContentRegion() {
            int parentIndex;
            this.parentIndexStack.removeLast();
            if (!this.parentIndexStack.isEmpty() && (parentIndex = this.parentIndexStack.getLast().intValue()) > -1) {
                return this.mcriArray.get(parentIndex);
            }
            return null;
        }

        MarkedContentRegionInfo getMarkedContentRegionInfo(int index) {
            if (index < 0) {
                return null;
            }
            return this.mcriArray.get(index);
        }

        boolean isOCRegion(MarkedContentRegionInfo mcri) {
            return mcri.isOCRegion();
        }

        boolean isVisible(MarkedContentRegionInfo mcri) {
            boolean isVisible = mcri.isOCVisible;
            int parentIndex = mcri.parentMCRegionIndex;
            while (parentIndex != -1) {
                MarkedContentRegionInfo parentMcri = this.mcriArray.get(parentIndex);
                if (!parentMcri.isOCVisible) {
                    isVisible = false;
                }
                parentIndex = parentMcri.parentMCRegionIndex;
            }
            return isVisible;
        }

        boolean isRemovableOCRegion(MarkedContentRegionInfo mcri) {
            return mcri.isOCRegion() && !this.isVisible(mcri) && mcri.isProperlyGStateBracketed();
        }
    }
}

