/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.pdfa.processor;

import com.adobe.internal.io.stream.InputByteStream;
import com.adobe.internal.pdftoolkit.core.cos.CosArray;
import com.adobe.internal.pdftoolkit.core.cos.CosContainer;
import com.adobe.internal.pdftoolkit.core.cos.CosContainerValuesIterator;
import com.adobe.internal.pdftoolkit.core.cos.CosDictionary;
import com.adobe.internal.pdftoolkit.core.cos.CosDocument;
import com.adobe.internal.pdftoolkit.core.cos.CosName;
import com.adobe.internal.pdftoolkit.core.cos.CosNumeric;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.cos.CosScalar;
import com.adobe.internal.pdftoolkit.core.cos.CosScalarOps;
import com.adobe.internal.pdftoolkit.core.cos.CosStream;
import com.adobe.internal.pdftoolkit.core.cos.CosString;
import com.adobe.internal.pdftoolkit.core.cos.CosToken;
import com.adobe.internal.pdftoolkit.core.cos.REPAIRTYPE;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFCosNumberParseRuntimeException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFCosParseException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFCosUnexpectedTypeException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFFontException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.traverser.GeneralDispatcher;
import com.adobe.internal.pdftoolkit.core.traverser.GeneralTraverser;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.core.util.ByteOps;
import com.adobe.internal.pdftoolkit.core.util.ParseOps;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.document.PDFVersion;
import com.adobe.internal.pdftoolkit.pdf.filters.PDFFilterList;
import com.adobe.internal.pdftoolkit.services.pdfa.PDFAConformanceLevel;
import com.adobe.internal.pdftoolkit.services.pdfa.PDFAConversionHandler;
import com.adobe.internal.pdftoolkit.services.pdfa.PDFAConversionOptions;
import com.adobe.internal.pdftoolkit.services.pdfa.PDFAErrorSetFileStructure;
import com.adobe.internal.pdftoolkit.services.pdfa.PDFAValidationHandler;
import com.adobe.internal.pdftoolkit.services.pdfa.PDFAValidationOptions;
import com.adobe.internal.pdftoolkit.services.pdfa.error.PDFAFileStructureErrorCode;
import com.adobe.internal.pdftoolkit.services.pdfa.processor.PDFAErrorFlags;
import com.adobe.internal.pdftoolkit.services.pdfa.processor.PDFASaveModes;
import com.adobe.internal.pdftoolkit.services.pdfa.processor.ParserUtils;
import com.adobe.internal.util.ArrayListStack;
import java.io.IOException;

class FileStructureProcessor {
    private static int NUM_INDIRECT_OBJECTS = 0x7FFFFF;
    private static final boolean DEBUG = false;

    FileStructureProcessor() {
    }

    public static boolean validate(PDFDocument doc, PDFAConformanceLevel conformanceLevel, PDFAValidationOptions validationOptions, PDFAValidationHandler validationHandler, PDFAConversionOptions conversionOptions, PDFAConversionHandler conversionHandler) throws PDFIOException, PDFSecurityException, PDFInvalidDocumentException {
        CosDocument cosDoc;
        if (doc == null) {
            return true;
        }
        if (!validationHandler.beginFileStructureScan()) {
            return false;
        }
        PDFAErrorFlags flags = new PDFAErrorFlags();
        if (conversionHandler == null) {
            flags.fixableErrors = null;
        }
        if ((cosDoc = doc.getCosDocument()).getXRefType() == 2 || cosDoc.getXRefType() == 3) {
            FileStructureProcessor.printDebugMsg("File is not using the table xref.");
            flags.errorsFound.addErrorCode(PDFAFileStructureErrorCode.nonCompressedXRefNotPresent);
            if (flags.fixableErrors != null) {
                flags.fixableErrors.addErrorCode(PDFAFileStructureErrorCode.nonCompressedXRefNotPresent);
            }
        }
        if (conversionHandler != null) {
            try {
                cosDoc.freeUnreferencedObjects();
            }
            catch (PDFCosParseException e) {
                throw new PDFInvalidDocumentException("Exception encountered while freeing unreferenced cos objects.", (Throwable)e);
            }
        }
        InputByteStream buf = cosDoc.getStream();
        try {
            long bufferPos = buf.getPosition();
            FileStructureProcessor.validateFileHeader(buf, cosDoc, flags);
            buf.seek(bufferPos);
            bufferPos = buf.getPosition();
            FileStructureProcessor.validateFileTrailer(buf, doc, cosDoc, flags, validationOptions);
            buf.seek(bufferPos);
            bufferPos = buf.getPosition();
            FileStructureProcessor.validateCrossRefTables(cosDoc, buf, flags);
            buf.seek(bufferPos);
            bufferPos = buf.getPosition();
            FileStructureProcessor.validateCosObjects(cosDoc, flags);
            buf.seek(bufferPos);
            bufferPos = buf.getPosition();
            FileStructureProcessor.validateStreamObjects(buf, cosDoc, flags, conversionOptions);
            buf.seek(bufferPos);
        }
        catch (IOException e) {
            throw new PDFIOException((Throwable)e);
        }
        PDFASaveModes saveOptions = new PDFASaveModes();
        try {
            saveOptions = FileStructureProcessor.computeSaveOptions(doc, flags.errorsFound, validationOptions);
        }
        catch (PDFInvalidDocumentException e) {
            flags.errorsFound.addErrorCode(PDFAFileStructureErrorCode.pdfGeneralFailure);
        }
        if (conversionHandler != null) {
            if (!conversionHandler.fileStructureErrorsFixed(flags.errorsFound, flags.fixableErrors)) {
                return false;
            }
            PDFAErrorSetFileStructure unfixableErrors = flags.getUnFixableErrors();
            if (unfixableErrors.hasErrors() && !conversionHandler.fileStructureError(flags.getUnFixableErrors())) {
                return false;
            }
        } else if (flags.errorsFound.hasErrors() && !validationHandler.fileStructureError(flags.errorsFound)) {
            return false;
        }
        return validationHandler.endFileStructureScan(PDFASaveModes.convertToSaveType(saveOptions));
    }

    static PDFASaveModes computeSaveOptions(PDFDocument pdfDoc, PDFAErrorSetFileStructure flags, PDFAValidationOptions validationOptions) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFASaveModes options = new PDFASaveModes();
        PDFAErrorSetFileStructure errors = new PDFAErrorSetFileStructure(flags);
        if (validationOptions.checkDocVersion() && pdfDoc.getOriginalVersion().greaterThan(PDFVersion.v1_4)) {
            options.removeOptions(1);
            options.setLinearizationBlockingIncSave(false);
            options.appendOptions(8);
        }
        if (errors.IDKwdNotPresentInMainTrailer() || errors.IDKwdNotPresentInZeroUpdateTrailer() || errors.IDValuesNotEqual()) {
            options.removeOptions(1);
            options.setLinearizationBlockingIncSave(false);
        }
        if (errors.nonCompressedXRefNotPresent()) {
            options.removeOptions(1);
            options.setLinearizationBlockingIncSave(false);
        }
        if (errors.fileHeaderCommentNotPresent() || errors.fileHeaderPercentCharPositionNotAllowed()) {
            options.removeOptions(1);
            options.appendOptions(8);
            options.setLinearizationBlockingIncSave(false);
        }
        if (errors.fileTrailerAdditionalDataPresent() || errors.fileTrailerEncryptKwdPresent() || errors.fileTrailerIDKwdNotPresent()) {
            options.removeOptions(1);
            options.appendOptions(8);
            options.setLinearizationBlockingIncSave(false);
        }
        if (errors.crossRefTableEOLMarkerNotPresent() || errors.crossRefTableSpaceCharNotPresent()) {
            options.removeOptions(1);
            options.appendOptions(8);
            options.setLinearizationBlockingIncSave(false);
        }
        if (errors.streamEOLMarkerNotPresent() || errors.streamSuffixCharsNotAllowed() || errors.streamLengthIncorrect()) {
            options.removeOptions(1);
            options.appendOptions(8);
            options.setLinearizationBlockingIncSave(false);
        }
        if (errors.indirectObjEOLMarkerNotPresent() || errors.indirectObjNumWhitespaceCharsIncorrect()) {
            options.removeOptions(1);
            options.appendOptions(8);
            options.setLinearizationBlockingIncSave(false);
        }
        if (errors.hexStrEvenNumCharsNotPresent()) {
            options.removeOptions(1);
            options.appendOptions(8);
            options.setLinearizationBlockingIncSave(false);
        }
        if (errors.hexStrInvalidChrsPresent()) {
            options.removeAllSaveOptions();
            options.setLinearizationBlockingIncSave(false);
        }
        if (errors.streamFDecodeParamsKeyPresent() || errors.streamFFilterKeyPresent() || errors.streamFKeyPresent()) {
            options.removeAllSaveOptions();
            options.setLinearizationBlockingIncSave(false);
        }
        if (errors.fileSpecDictContainsEF()) {
            options.removeAllSaveOptions();
            options.setLinearizationBlockingIncSave(false);
        }
        if (errors.indirectObjectNumberIncorrect() || errors.integerNumberFormatIncorrect() || errors.nameLengthIncorrect()) {
            options.removeAllSaveOptions();
            options.setLinearizationBlockingIncSave(false);
        }
        if (pdfDoc.getCosDocument().isLinearized()) {
            options.removeOptions(1);
        } else {
            options.setLinearizationBlockingIncSave(false);
        }
        if (options.incrementalSave()) {
            options.setLinearizationBlockingIncSave(false);
        }
        return options;
    }

    static void validateFileTrailer(InputByteStream buf, PDFDocument pdfDoc, CosDocument cosDoc, PDFAErrorFlags flags, PDFAValidationOptions validationOptions) throws PDFIOException, IOException, PDFSecurityException {
        CosDictionary trailer;
        CosDictionary[] trailerDicts;
        try {
            FileStructureProcessor.validateHexStringsInTrailer(cosDoc.getTrailerList(), flags);
        }
        catch (PDFCosParseException e) {
            flags.errorsFound.addErrorCode(PDFAFileStructureErrorCode.pdfGeneralFailure);
        }
        if (cosDoc.isLinearized() && validationOptions.checkDocID() && (trailerDicts = cosDoc.getTrailerList()) != null && trailerDicts.length == 2) {
            try {
                CosObject docIDInMainSection = FileStructureProcessor.getIDFromTrailerDict(trailerDicts[0]);
                CosObject docIDInZeroUpdateSection = FileStructureProcessor.getIDFromTrailerDict(trailerDicts[1]);
                if (docIDInMainSection != null && docIDInZeroUpdateSection != null && !FileStructureProcessor.compareDocIDArrays(trailerDicts[0], trailerDicts[1])) {
                    flags.errorsFound.addErrorCode(PDFAFileStructureErrorCode.IDValuesNotEqual);
                    FileStructureProcessor.printDebugMsg("ID values in both trailer dicts of linearized file are not identical");
                    if (flags.fixableErrors != null) {
                        flags.fixableErrors.addErrorCode(PDFAFileStructureErrorCode.IDValuesNotEqual);
                    }
                }
            }
            catch (PDFCosParseException e) {
                flags.errorsFound.addErrorCode(PDFAFileStructureErrorCode.pdfGeneralFailure);
            }
        }
        if (!(trailer = cosDoc.getTrailer()).containsKey((Object)ASName.k_ID)) {
            flags.errorsFound.addErrorCode(PDFAFileStructureErrorCode.fileTrailerIDKwdNotPresent);
            FileStructureProcessor.printDebugMsg("ID keyword not present in File Trailer");
            if (flags.fixableErrors != null) {
                flags.fixableErrors.addErrorCode(PDFAFileStructureErrorCode.fileTrailerIDKwdNotPresent);
            }
        }
        if (trailer.containsKey((Object)ASName.k_Encrypt)) {
            flags.errorsFound.addErrorCode(PDFAFileStructureErrorCode.fileTrailerEncryptKwdPresent);
            FileStructureProcessor.printDebugMsg("Encrypt keyword present in File Trailer");
            if (flags.fixableErrors != null) {
                flags.fixableErrors.addErrorCode(PDFAFileStructureErrorCode.fileTrailerEncryptKwdPresent);
            }
        }
        try {
            long eofpos = ParserUtils.getEOFPosition(buf);
            buf.seek(eofpos + 5L);
            byte cur = (byte)buf.read();
            if (cur == -1) {
                return;
            }
            if (!ParserUtils.isEOLChar(cur)) {
                flags.errorsFound.addErrorCode(PDFAFileStructureErrorCode.fileTrailerAdditionalDataPresent);
                FileStructureProcessor.printDebugMsg("Invalid Trailer: Trailer Trash Count > 0. Value = " + cosDoc.getTrailerTrashCount());
                if (flags.fixableErrors != null) {
                    flags.fixableErrors.addErrorCode(PDFAFileStructureErrorCode.fileTrailerAdditionalDataPresent);
                }
            }
            if ((cur = (byte)buf.read()) == -1) {
                return;
            }
            if (!ParserUtils.isEOLChar(cur)) {
                flags.errorsFound.addErrorCode(PDFAFileStructureErrorCode.fileTrailerAdditionalDataPresent);
                FileStructureProcessor.printDebugMsg("Invalid Trailer: Trailer Trash Count > 0. Value = " + cosDoc.getTrailerTrashCount());
                if (flags.fixableErrors != null) {
                    flags.fixableErrors.addErrorCode(PDFAFileStructureErrorCode.fileTrailerAdditionalDataPresent);
                }
            }
            if ((cur = (byte)buf.read()) != -1) {
                flags.errorsFound.addErrorCode(PDFAFileStructureErrorCode.fileTrailerAdditionalDataPresent);
                FileStructureProcessor.printDebugMsg("Invalid Trailer: Trailer Trash Count > 0. Value = " + cosDoc.getTrailerTrashCount());
                if (flags.fixableErrors != null) {
                    flags.fixableErrors.addErrorCode(PDFAFileStructureErrorCode.fileTrailerAdditionalDataPresent);
                }
            }
        }
        catch (PDFCosParseException e) {
            flags.errorsFound.addErrorCode(PDFAFileStructureErrorCode.pdfGeneralFailure);
        }
    }

    private static boolean compareDocIDArrays(CosDictionary trailerDict1, CosDictionary trailerDict2) throws PDFCosParseException, PDFIOException, PDFSecurityException {
        CosObject docIDArray1 = trailerDict1.get(ASName.k_ID);
        CosObject docIDArray2 = trailerDict2.get(ASName.k_ID);
        if (FileStructureProcessor.isValidDocIDArray(docIDArray1) && FileStructureProcessor.isValidDocIDArray(docIDArray2)) {
            CosArray docIDCosArray1 = (CosArray)docIDArray1;
            CosArray docIDCosArray2 = (CosArray)docIDArray2;
            if (CosScalarOps.equivalent((CosScalar)docIDCosArray1.getCosString(0), (CosScalar)docIDCosArray2.getCosString(0)) && CosScalarOps.equivalent((CosScalar)docIDCosArray1.getCosString(1), (CosScalar)docIDCosArray2.getCosString(1))) {
                return true;
            }
        }
        return false;
    }

    private static boolean isValidDocIDArray(CosObject docIDArray) throws PDFCosParseException, PDFIOException, PDFSecurityException {
        CosArray docIDCosArray;
        if (docIDArray == null) {
            return false;
        }
        return docIDArray instanceof CosArray && (docIDCosArray = (CosArray)docIDArray).size() == 2 && docIDCosArray.get(0) instanceof CosString && docIDCosArray.get(1) instanceof CosString && docIDCosArray.getCosString(0) != null && docIDCosArray.getCosString(1) != null;
    }

    private static void validateHexStringsInTrailer(CosDictionary[] trailerDicts, PDFAErrorFlags flags) throws PDFCosParseException, PDFIOException, PDFSecurityException {
        if (trailerDicts != null) {
            for (int i = 0; i < trailerDicts.length; ++i) {
                FileStructureProcessor.checkDocIDHexStrings(trailerDicts[i], flags);
            }
        }
    }

    private static void checkDocIDHexStrings(CosDictionary trailerDict, PDFAErrorFlags flags) throws PDFCosParseException, PDFIOException, PDFSecurityException {
        CosArray docIDArray;
        CosObject docIDTrailerEntry = trailerDict.get(ASName.k_ID);
        if (docIDTrailerEntry != null && docIDTrailerEntry instanceof CosArray && (docIDArray = (CosArray)trailerDict.get(ASName.k_ID)) != null) {
            FileStructureProcessor.checkOddBallHexStrings(docIDArray.getCosString(0), flags);
            FileStructureProcessor.checkOddBallHexStrings(docIDArray.getCosString(1), flags);
        }
    }

    static void validateFileHeader(InputByteStream buf, CosDocument cosDoc, PDFAErrorFlags flags) throws PDFIOException, IOException {
        byte charAfterHeaderString;
        if (!FileStructureProcessor.isFileHeaderPercentCharPresentAtOffsetZero(cosDoc)) {
            flags.errorsFound.addErrorCode(PDFAFileStructureErrorCode.fileHeaderPercentCharPosNotAllowed);
            FileStructureProcessor.printDebugMsg("Header InValid: Header trash count = " + cosDoc.getHeaderTrashCount());
            if (flags.fixableErrors != null) {
                flags.fixableErrors.addErrorCode(PDFAFileStructureErrorCode.fileHeaderPercentCharPosNotAllowed);
            }
        } else {
            FileStructureProcessor.printDebugMsg("Header valid: Header trash count = " + cosDoc.getHeaderTrashCount());
        }
        if (!ParserUtils.isEOLChar(charAfterHeaderString = (byte)ParserUtils.peekAtPos(buf, 8L))) {
            flags.errorsFound.addErrorCode(PDFAFileStructureErrorCode.fileHeaderCommentNotPresent);
            FileStructureProcessor.printDebugMsg("Header Invalid: Second Line is not comment with 4 chars. There is some char after the %PDF-m.n");
            if (flags.fixableErrors != null) {
                flags.fixableErrors.addErrorCode(PDFAFileStructureErrorCode.fileHeaderCommentNotPresent);
            }
        }
        ParserUtils.readLine(buf);
        if (!FileStructureProcessor.validateSecondLine(buf)) {
            flags.errorsFound.addErrorCode(PDFAFileStructureErrorCode.fileHeaderCommentNotPresent);
            FileStructureProcessor.printDebugMsg("Header Invalid: Second Line is not comment with 4 chars");
            if (flags.fixableErrors != null) {
                flags.fixableErrors.addErrorCode(PDFAFileStructureErrorCode.fileHeaderCommentNotPresent);
            }
        } else {
            FileStructureProcessor.printDebugMsg("Header Valid: Second Line is comment with 4 chars");
        }
    }

    private static boolean validateSecondLine(InputByteStream buf) throws IOException {
        byte b = (byte)buf.read();
        if (b != 37) {
            return false;
        }
        int i = b & 0xFF;
        for (int j = 0; j < 4; ++j) {
            b = (byte)buf.read();
            i = b & 0xFF;
            if (i > 127) continue;
            return false;
        }
        return true;
    }

    private static boolean isFileHeaderPercentCharPresentAtOffsetZero(CosDocument cosDoc) throws IOException {
        return cosDoc.getHeaderTrashCount() <= 0;
    }

    private static void validateCrossRefTables(CosDocument cosDoc, InputByteStream buf, PDFAErrorFlags flags) throws PDFIOException, IOException {
        try {
            long lastXrefOffset = ParserUtils.getLastXRefSectionPosition(buf);
            buf.seek(lastXrefOffset);
            FileStructureProcessor.validateCrossRefTable(buf, flags);
            if (cosDoc.getRepairTypes().contains(REPAIRTYPE.xrefRepair)) {
                flags.errorsFound.addErrorCode(PDFAFileStructureErrorCode.crossRefTableDamagedNeedsRepair);
                if (flags.fixableErrors != null) {
                    flags.fixableErrors.addErrorCode(PDFAFileStructureErrorCode.crossRefTableDamagedNeedsRepair);
                }
            }
            CosDictionary[] trailers = cosDoc.getTrailerList();
            for (int i = 0; i < trailers.length; ++i) {
                CosObject prevXrefOffset = trailers[i].get(ASName.k_Prev);
                if (trailers[i] == null || !(prevXrefOffset instanceof CosNumeric)) continue;
                long xrefPos = ((CosNumeric)prevXrefOffset).longValue();
                buf.seek(xrefPos);
                FileStructureProcessor.validateCrossRefTable(buf, flags);
            }
        }
        catch (PDFCosParseException e) {
            flags.errorsFound.addErrorCode(PDFAFileStructureErrorCode.pdfGeneralFailure);
        }
        catch (PDFSecurityException e) {
            flags.errorsFound.addErrorCode(PDFAFileStructureErrorCode.pdfGeneralFailure);
        }
    }

    private static void validateCrossRefTable(InputByteStream buf, PDFAErrorFlags flags) throws PDFIOException, IOException {
        block10: {
            ParserUtils.skipWhiteCharacters(buf);
            String line = ParserUtils.readLine(buf);
            if (line.startsWith("xref")) {
                block9: {
                    try {
                        ParserUtils.readNumber(buf, (byte)43, true);
                    }
                    catch (PDFCosParseException e) {
                        FileStructureProcessor.printDebugMsg("CrossRefTable Invalid: xref<eol> not followed by number");
                        flags.errorsFound.addErrorCode(PDFAFileStructureErrorCode.crossRefTableEOLMarkerNotPresent);
                        if (flags.fixableErrors == null) break block9;
                        flags.fixableErrors.addErrorCode(PDFAFileStructureErrorCode.crossRefTableEOLMarkerNotPresent);
                    }
                }
                byte inp = (byte)buf.read();
                if (inp != 32) {
                    FileStructureProcessor.printDebugMsg("CrossRefTable Invalid: xref subsection header not separated by single SPACE");
                    flags.errorsFound.addErrorCode(PDFAFileStructureErrorCode.crossRefTableSpaceCharNotPresent);
                    if (flags.fixableErrors != null) {
                        flags.fixableErrors.addErrorCode(PDFAFileStructureErrorCode.crossRefTableSpaceCharNotPresent);
                    }
                }
                try {
                    ParserUtils.readNumber(buf, (byte)43, true);
                }
                catch (PDFCosParseException e) {
                    FileStructureProcessor.printDebugMsg("CrossRefTable Invalid: xref subsection header not separated by single SPACE");
                    flags.errorsFound.addErrorCode(PDFAFileStructureErrorCode.crossRefTableSpaceCharNotPresent);
                    if (flags.fixableErrors != null) {
                        flags.fixableErrors.addErrorCode(PDFAFileStructureErrorCode.crossRefTableSpaceCharNotPresent);
                    }
                    break block10;
                }
            }
            FileStructureProcessor.printDebugMsg("Incorrect offset mentioned for Cross Reference Table in startXref");
            flags.errorsFound.addErrorCode(PDFAFileStructureErrorCode.incorrectOffsetofCrossRefTable);
            if (flags.fixableErrors != null) {
                flags.fixableErrors.addErrorCode(PDFAFileStructureErrorCode.incorrectOffsetofCrossRefTable);
            }
        }
        FileStructureProcessor.printDebugMsg("Finished xref scan");
    }

    private static void validateCosObjects(CosDocument cosDoc, PDFAErrorFlags flags) throws IOException, PDFIOException, PDFSecurityException {
        LocalDispatcher dispatcher = new LocalDispatcher(flags);
        GeneralTraverser traverser = new GeneralTraverser((GeneralDispatcher)dispatcher);
        try {
            CosDictionary root = cosDoc.getRoot();
            traverser.traverseCosGraph((CosContainer)root, null);
        }
        catch (PDFInvalidDocumentException e) {
            flags.errorsFound.addErrorCode(PDFAFileStructureErrorCode.pdfGeneralFailure);
        }
        catch (PDFInvalidParameterException e) {
            flags.errorsFound.addErrorCode(PDFAFileStructureErrorCode.pdfGeneralFailure);
        }
        catch (PDFFontException e) {
            flags.errorsFound.addErrorCode(PDFAFileStructureErrorCode.pdfGeneralFailure);
        }
        catch (PDFCosNumberParseRuntimeException e) {
            flags.errorsFound.addErrorCode(PDFAFileStructureErrorCode.pdfGeneralFailure);
        }
    }

    private static void validateStreamObjects(InputByteStream buf, CosDocument cosDoc, PDFAErrorFlags flags, PDFAConversionOptions conversionOptions) throws PDFIOException, PDFSecurityException, IOException {
        try {
            int numIndirectObjects = 0;
            int nObjects = cosDoc.getNumObjects();
            for (int j = 0; j < nObjects; ++j) {
                CosObject cosObj = cosDoc.getIndirectObjectByNumber(j);
                if (cosObj == null) continue;
                ++numIndirectObjects;
                if (!cosObj.isDirty()) {
                    FileStructureProcessor.validateIndirectObject(cosObj, flags);
                }
                if (cosObj instanceof CosString) {
                    CosString cosString = (CosString)cosObj;
                    FileStructureProcessor.checkOddBallHexStrings(cosString, flags);
                }
                if (cosObj instanceof CosStream) {
                    CosStream streamObj = (CosStream)cosObj;
                    long beginOfStream = streamObj.getObjPos();
                    Integer streamLength = streamObj.getInt(ASName.k_Length);
                    if (streamLength == null) {
                        throw new PDFInvalidDocumentException("Stream does not contain length entry.");
                    }
                    long dataOffset = streamObj.getStreamDataOffset();
                    if (!cosObj.isDirty()) {
                        FileStructureProcessor.validateStream(buf, beginOfStream, streamLength.intValue(), flags, dataOffset);
                    }
                    FileStructureProcessor.validateStreamFilters(streamObj, flags, conversionOptions);
                    FileStructureProcessor.validateCosStreamDictKeys(streamObj, flags);
                }
                FileStructureProcessor.validateEmbeddedFiles(cosObj, flags);
            }
            FileStructureProcessor.validateNumIndirectObjects(numIndirectObjects, flags);
        }
        catch (PDFCosUnexpectedTypeException e) {
            flags.errorsFound.addErrorCode(PDFAFileStructureErrorCode.pdfGeneralFailure);
        }
        catch (PDFInvalidDocumentException e) {
            flags.errorsFound.addErrorCode(PDFAFileStructureErrorCode.pdfGeneralFailure);
        }
    }

    private static void validateEmbeddedFiles(CosObject cosObj, PDFAErrorFlags flags) throws PDFIOException, PDFSecurityException {
        CosDictionary cosDict;
        if (cosObj instanceof CosDictionary && (cosDict = (CosDictionary)cosObj).containsKey((Object)ASName.k_Type)) {
            try {
                CosObject typeCosObj = cosDict.get(ASName.k_Type);
                if (typeCosObj instanceof CosName && typeCosObj.nameValue().equals((Object)ASName.k_Filespec) && cosDict.containsKey((Object)ASName.k_EF)) {
                    FileStructureProcessor.printDebugMsg("EmbeddedFile reference found in file spec dictionary");
                    flags.errorsFound.addErrorCode(PDFAFileStructureErrorCode.fileSpecDictContainsEF);
                }
            }
            catch (PDFInvalidDocumentException e) {
                flags.errorsFound.addErrorCode(PDFAFileStructureErrorCode.pdfGeneralFailure);
            }
        }
    }

    private static void validateIndirectObject(CosObject cosObj, PDFAErrorFlags flags) throws PDFIOException, PDFCosParseException, PDFSecurityException {
        try {
            byte inp;
            Number genno;
            Number objno;
            InputByteStream mBuf = cosObj.getDocument().getStream();
            long beginOfObjStream = cosObj.getObjPos();
            if (beginOfObjStream == 0L) {
                return;
            }
            mBuf.seek(beginOfObjStream);
            if (!ParserUtils.isPreviousCharEOL(mBuf)) {
                FileStructureProcessor.printDebugMsg("IndirectObj Invalid: Indirect Obj not preceeded by EOL");
                flags.errorsFound.addErrorCode(PDFAFileStructureErrorCode.indirectObjEOLMarkerNotPresent);
                if (flags.fixableErrors != null) {
                    flags.fixableErrors.addErrorCode(PDFAFileStructureErrorCode.indirectObjEOLMarkerNotPresent);
                }
            }
            while (ParserUtils.skipEOL(mBuf)) {
                FileStructureProcessor.printDebugMsg("IndirectObj Invalid: Indirect Obj preceded by Multiple EOL");
                flags.errorsFound.addErrorCode(PDFAFileStructureErrorCode.indirectObjPrecededByMultipleEOLMarker);
                if (flags.fixableErrors == null) continue;
                flags.fixableErrors.addErrorCode(PDFAFileStructureErrorCode.indirectObjPrecededByMultipleEOLMarker);
            }
            while (ByteOps.isWhitespace((byte)((byte)ParserUtils.peek(mBuf)))) {
                FileStructureProcessor.printDebugMsg("IndirectObj Invalid: Indirect Obj not preceeded by EOL");
                flags.errorsFound.addErrorCode(PDFAFileStructureErrorCode.indirectObjEOLMarkerNotPresent);
                if (flags.fixableErrors != null) {
                    flags.fixableErrors.addErrorCode(PDFAFileStructureErrorCode.indirectObjEOLMarkerNotPresent);
                }
                mBuf.read();
            }
            try {
                objno = ParserUtils.readNumber(mBuf, (byte)43, true);
            }
            catch (PDFCosParseException e) {
                FileStructureProcessor.printDebugMsg("IndirectObj Invalid: First string is not a number in this object");
                if (flags.fixableErrors == null) {
                    flags.errorsFound.addErrorCode(PDFAFileStructureErrorCode.pdfGeneralFailure);
                }
                return;
            }
            if (objno.intValue() != cosObj.getObjNum()) {
                FileStructureProcessor.printDebugMsg("IndirectObject Invalid: Object Number mismatch between XRef and definition ");
                flags.errorsFound.addErrorCode(PDFAFileStructureErrorCode.indirectObjectNumberMismatchFromCrossRefTable);
                if (flags.fixableErrors != null) {
                    flags.fixableErrors.addErrorCode(PDFAFileStructureErrorCode.indirectObjectNumberMismatchFromCrossRefTable);
                }
            }
            if (!ParserUtils.readAndCheck(mBuf, (byte)32)) {
                FileStructureProcessor.printDebugMsg("IndirectObj Invalid: <num> not followed by space");
                flags.errorsFound.addErrorCode(PDFAFileStructureErrorCode.indirectObjNumWhitespaceCharsIncorrect);
                if (flags.fixableErrors != null) {
                    flags.fixableErrors.addErrorCode(PDFAFileStructureErrorCode.indirectObjNumWhitespaceCharsIncorrect);
                }
            }
            while (ByteOps.isWhitespace((byte)((byte)ParserUtils.peek(mBuf)))) {
                FileStructureProcessor.printDebugMsg("IndirectObj Invalid: <num> not followed by space");
                flags.errorsFound.addErrorCode(PDFAFileStructureErrorCode.indirectObjNumWhitespaceCharsIncorrect);
                if (flags.fixableErrors != null) {
                    flags.fixableErrors.addErrorCode(PDFAFileStructureErrorCode.indirectObjNumWhitespaceCharsIncorrect);
                }
                mBuf.read();
            }
            try {
                genno = ParserUtils.readNumber(mBuf, (byte)43, true);
            }
            catch (PDFCosParseException e) {
                FileStructureProcessor.printDebugMsg("IndirectObj Invalid: Number did not follow the space");
                if (flags.fixableErrors == null) {
                    flags.errorsFound.addErrorCode(PDFAFileStructureErrorCode.pdfGeneralFailure);
                }
                return;
            }
            if (!ParserUtils.readAndCheck(mBuf, (byte)32)) {
                FileStructureProcessor.printDebugMsg("IndirectObj Invalid: <genno> not followed by space");
                flags.errorsFound.addErrorCode(PDFAFileStructureErrorCode.indirectObjNumWhitespaceCharsIncorrect);
                if (flags.fixableErrors != null) {
                    flags.fixableErrors.addErrorCode(PDFAFileStructureErrorCode.indirectObjNumWhitespaceCharsIncorrect);
                }
            }
            while (ByteOps.isWhitespace((byte)((byte)ParserUtils.peek(mBuf)))) {
                FileStructureProcessor.printDebugMsg("IndirectObj Invalid: <genno> not followed by space");
                flags.errorsFound.addErrorCode(PDFAFileStructureErrorCode.indirectObjNumWhitespaceCharsIncorrect);
                if (flags.fixableErrors != null) {
                    flags.fixableErrors.addErrorCode(PDFAFileStructureErrorCode.indirectObjNumWhitespaceCharsIncorrect);
                }
                mBuf.read();
            }
            if (!ParserUtils.readAndCheck(mBuf, "obj")) {
                FileStructureProcessor.printDebugMsg("IndirectObj Invalid: <genno><space> not followed by obj");
                flags.errorsFound.addErrorCode(PDFAFileStructureErrorCode.indirectObjNumWhitespaceCharsIncorrect);
                if (flags.fixableErrors != null) {
                    flags.fixableErrors.addErrorCode(PDFAFileStructureErrorCode.indirectObjNumWhitespaceCharsIncorrect);
                }
            }
            if (!ParserUtils.isEOLChar(inp = (byte)mBuf.read())) {
                FileStructureProcessor.printDebugMsg("Offset at problem location EOL: " + mBuf.getPosition() + " objno:" + objno.intValue() + " genno: " + genno.intValue());
                FileStructureProcessor.printDebugMsg("IndirectObj Invalid: <obj> not followed by EOL");
                flags.errorsFound.addErrorCode(PDFAFileStructureErrorCode.indirectObjEOLMarkerNotPresent);
                if (flags.fixableErrors != null) {
                    flags.fixableErrors.addErrorCode(PDFAFileStructureErrorCode.indirectObjEOLMarkerNotPresent);
                }
            }
            CosToken.skipObject((CosDocument)cosObj.getDocument(), (InputByteStream)mBuf, (byte)CosToken.skipWhitespace((InputByteStream)mBuf));
            long endobjPos = ParseOps.getEndObjPos((InputByteStream)mBuf);
            boolean endObjLineFound = false;
            if (endobjPos != -1L) {
                endObjLineFound = true;
                mBuf.seek(endobjPos - 1L);
                if (!ParserUtils.isEOLChar((byte)mBuf.read())) {
                    FileStructureProcessor.printDebugMsg("IndirectObj Invalid: <endobj> not preceeded by EOL");
                    flags.errorsFound.addErrorCode(PDFAFileStructureErrorCode.indirectObjEOLMarkerNotPresent);
                    if (flags.fixableErrors != null) {
                        flags.fixableErrors.addErrorCode(PDFAFileStructureErrorCode.indirectObjEOLMarkerNotPresent);
                    }
                }
                mBuf.seek(endobjPos + 6L);
                if (!ParserUtils.isEOLChar((byte)mBuf.read())) {
                    FileStructureProcessor.printDebugMsg("IndirectObj Invalid: <endobj> not followed by EOL");
                    flags.errorsFound.addErrorCode(PDFAFileStructureErrorCode.indirectObjEOLMarkerNotPresent);
                    if (flags.fixableErrors != null) {
                        flags.fixableErrors.addErrorCode(PDFAFileStructureErrorCode.indirectObjEOLMarkerNotPresent);
                    }
                }
            }
            if (!endObjLineFound) {
                FileStructureProcessor.printDebugMsg("IndirectObj Invalid: <endobj> not preceeded by EOL");
                flags.errorsFound.addErrorCode(PDFAFileStructureErrorCode.indirectObjEOLMarkerNotPresent);
                if (flags.fixableErrors != null) {
                    flags.fixableErrors.addErrorCode(PDFAFileStructureErrorCode.indirectObjEOLMarkerNotPresent);
                }
            }
        }
        catch (IOException e) {
            throw new PDFIOException("IOException occured while validating indirect objects for PDF/A-1b.", (Throwable)e);
        }
    }

    private static void validateStreamFilters(CosStream streamObj, PDFAErrorFlags flags, PDFAConversionOptions conversionOptions) throws PDFIOException, PDFSecurityException {
        try {
            CosArray streamFilters = streamObj.getInputFiltersList();
            for (int i = 0; i < streamFilters.size(); ++i) {
                CosArray oneFilter = (CosArray)streamFilters.get(i);
                CosName filterName = (CosName)oneFilter.get(0);
                if (filterName.nameValue() == ASName.create((String)"JPXDecode")) {
                    FileStructureProcessor.printDebugMsg("Stream Filters Invalid : JPXDecode Filter used");
                    flags.errorsFound.addErrorCode(PDFAFileStructureErrorCode.jpxDecodeFilterPresent);
                    if (flags.fixableErrors != null) {
                        if (!FileStructureProcessor.applyNewFilters(streamObj, FileStructureProcessor.substituteJPXFiltersProvided(conversionOptions))) {
                            FileStructureProcessor.printDebugMsg("Stream Filters Invalid : JPXDecode Filter used");
                            flags.errorsFound.addErrorCode(PDFAFileStructureErrorCode.jpxDecodeFilterPresent);
                        } else {
                            flags.fixableErrors.addErrorCode(PDFAFileStructureErrorCode.jpxDecodeFilterPresent);
                        }
                    }
                }
                if (filterName.nameValue() != ASName.k_LZWDecode) continue;
                FileStructureProcessor.printDebugMsg("Stream Filters Invalid: LZWDecode Filter used");
                flags.errorsFound.addErrorCode(PDFAFileStructureErrorCode.lzwDecodeFilterPresent);
                if (flags.fixableErrors == null) continue;
                if (!FileStructureProcessor.applyNewFilters(streamObj, FileStructureProcessor.substituteLZWFiltersProvided(conversionOptions))) {
                    FileStructureProcessor.printDebugMsg("Stream Filters Invalid: LZWDecode Filter used");
                    flags.errorsFound.addErrorCode(PDFAFileStructureErrorCode.lzwDecodeFilterPresent);
                    continue;
                }
                flags.fixableErrors.addErrorCode(PDFAFileStructureErrorCode.lzwDecodeFilterPresent);
            }
        }
        catch (PDFCosParseException e) {
            flags.errorsFound.addErrorCode(PDFAFileStructureErrorCode.pdfGeneralFailure);
        }
        catch (IOException e) {
            flags.errorsFound.addErrorCode(PDFAFileStructureErrorCode.pdfGeneralFailure);
        }
    }

    private static boolean applyNewFilters(CosStream streamObj, PDFFilterList filterList) throws PDFCosParseException, PDFIOException, PDFSecurityException, IOException {
        if (filterList == null) {
            return false;
        }
        streamObj.setOutputFiltersList(filterList.getCosArray());
        return true;
    }

    private static PDFFilterList substituteJPXFiltersProvided(PDFAConversionOptions conversionOptions) {
        if (conversionOptions != null) {
            if (conversionOptions.getJPXDecodeReplacementFilterList() != null) {
                return conversionOptions.getJPXDecodeReplacementFilterList();
            }
            if (conversionOptions.getDefaultSubstituteFilterList() != null) {
                return conversionOptions.getDefaultSubstituteFilterList();
            }
        }
        return null;
    }

    private static PDFFilterList substituteLZWFiltersProvided(PDFAConversionOptions conversionOptions) {
        if (conversionOptions != null) {
            if (conversionOptions.getLZWReplacementFilterList() != null) {
                return conversionOptions.getLZWReplacementFilterList();
            }
            if (conversionOptions.getDefaultSubstituteFilterList() != null) {
                return conversionOptions.getDefaultSubstituteFilterList();
            }
        }
        return null;
    }

    private static void validateCosStreamDictKeys(CosStream streamObj, PDFAErrorFlags flags) {
        if (streamObj.containsKey((Object)ASName.k_FFilter)) {
            FileStructureProcessor.printDebugMsg("Streams Invalid : FFilter key present");
            flags.errorsFound.addErrorCode(PDFAFileStructureErrorCode.streamFFilterKeyPresent);
        }
        if (streamObj.containsKey((Object)ASName.k_FDecodeParms)) {
            FileStructureProcessor.printDebugMsg("Streams Invalid : FDecodeParams key present");
            flags.errorsFound.addErrorCode(PDFAFileStructureErrorCode.streamFDecodeParamsKeyPresent);
        }
        if (streamObj.containsKey((Object)ASName.k_F)) {
            FileStructureProcessor.printDebugMsg("Streams Invalid : F key present");
            flags.errorsFound.addErrorCode(PDFAFileStructureErrorCode.streamFKeyPresent);
        }
    }

    private static void validateNumIndirectObjects(int numObjects, PDFAErrorFlags flags) {
        if (numObjects > NUM_INDIRECT_OBJECTS) {
            FileStructureProcessor.printDebugMsg("Implementation Limits Violated : Allowed num indirect objects exceeded");
            flags.errorsFound.addErrorCode(PDFAFileStructureErrorCode.indirectObjectNumberIncorrect);
        }
    }

    private static void validateStream(InputByteStream buf, long beginOfStream, long streamLength, PDFAErrorFlags flags, long dataOffset) throws IOException, PDFIOException {
        buf.seek(beginOfStream);
        FileStructureProcessor.printDebugMsg("Stream Begin = " + beginOfStream + " Data Offset = " + dataOffset);
        FileStructureProcessor.validateStreamStart(buf, beginOfStream + dataOffset, flags);
        FileStructureProcessor.validateStreamLength(buf, beginOfStream + dataOffset, streamLength, flags);
    }

    private static void validateStreamStart(InputByteStream buf, long beginOfStreamData, PDFAErrorFlags flags) throws IOException, PDFIOException {
        buf.seek(beginOfStreamData);
        if (beginOfStreamData != -1L) {
            long curPos = beginOfStreamData - 1L;
            FileStructureProcessor.printDebugMsg("\nAt curPos Position we have: " + (char)ParserUtils.peekAtPos(buf, curPos));
            byte inp = (byte)ParserUtils.peekAtPos(buf, curPos);
            if (inp != 10) {
                FileStructureProcessor.printDebugMsg("Stream Invalid: Extra Characters after stream keyword at:" + buf.getPosition() + "Extra Char: " + inp);
                flags.errorsFound.addErrorCode(PDFAFileStructureErrorCode.streamSuffixCharsNotAllowed);
                if (flags.fixableErrors != null) {
                    flags.fixableErrors.addErrorCode(PDFAFileStructureErrorCode.streamSuffixCharsNotAllowed);
                }
            }
            inp = (byte)ParserUtils.peekAtPos(buf, --curPos);
            FileStructureProcessor.printDebugMsg("\nAt curPos Position we have: " + (char)ParserUtils.peekAtPos(buf, curPos));
            if (inp == 13) {
                inp = (byte)ParserUtils.peekAtPos(buf, --curPos);
            }
            if (inp != 109) {
                FileStructureProcessor.printDebugMsg("Stream Invalid: Extra Characters after stream keyword at:" + buf.getPosition() + "Extra Char: " + inp);
                flags.errorsFound.addErrorCode(PDFAFileStructureErrorCode.streamSuffixCharsNotAllowed);
                if (flags.fixableErrors != null) {
                    flags.fixableErrors.addErrorCode(PDFAFileStructureErrorCode.streamSuffixCharsNotAllowed);
                }
            }
        }
    }

    private static void validateStreamLength(InputByteStream buf, long streamStart, long streamLength, PDFAErrorFlags flags) throws IOException {
        long curStreamPos = streamStart + streamLength;
        boolean streamLengthIncorrect = false;
        boolean eolNotBeforeEndStream = false;
        boolean eolNotPresent = false;
        byte peekedChar = (byte)ParserUtils.peekAtPos(buf, curStreamPos);
        if (peekedChar != 10) {
            if (peekedChar == 13) {
                peekedChar = (byte)ParserUtils.peekAtPos(buf, curStreamPos + 1L);
                if (peekedChar == 10) {
                    ++curStreamPos;
                }
            } else {
                peekedChar = (byte)ParserUtils.peekAtPos(buf, curStreamPos + 1L);
                if (peekedChar == 101) {
                    eolNotPresent = true;
                } else {
                    streamLengthIncorrect = true;
                }
            }
        }
        if (!streamLengthIncorrect && !eolNotPresent && (byte)ParserUtils.peekAtPos(buf, ++curStreamPos) != 101) {
            eolNotBeforeEndStream = true;
        }
        if (streamLengthIncorrect) {
            flags.errorsFound.addErrorCode(PDFAFileStructureErrorCode.streamLengthIncorrect);
            if (flags.fixableErrors != null) {
                flags.fixableErrors.addErrorCode(PDFAFileStructureErrorCode.streamLengthIncorrect);
            }
            FileStructureProcessor.printDebugMsg("Stream length: No endstream:" + buf.getPosition() + "Extra Char: " + peekedChar);
            FileStructureProcessor.printDebugMsg("Stream Invalid: Incorrect Length Property set");
            FileStructureProcessor.printDebugMsg("StreamLength:" + streamLength);
        } else if (eolNotBeforeEndStream) {
            flags.errorsFound.addErrorCode(PDFAFileStructureErrorCode.endstreamNotPrecededByEOL);
            if (flags.fixableErrors != null) {
                flags.fixableErrors.addErrorCode(PDFAFileStructureErrorCode.endstreamNotPrecededByEOL);
            }
            FileStructureProcessor.printDebugMsg("Stream Invalid: Stream start = " + streamStart + " Stream length = " + streamLength);
            FileStructureProcessor.printDebugMsg("Stream Invalid: peeked char = " + peekedChar + " Cur pos = " + curStreamPos);
        } else if (eolNotPresent) {
            flags.errorsFound.addErrorCode(PDFAFileStructureErrorCode.streamEOLMarkerNotPresent);
            if (flags.fixableErrors != null) {
                flags.fixableErrors.addErrorCode(PDFAFileStructureErrorCode.streamEOLMarkerNotPresent);
            }
            FileStructureProcessor.printDebugMsg("Stream Invalid: Stream start = " + streamStart + " Stream length = " + streamLength);
            FileStructureProcessor.printDebugMsg("Stream Invalid: peeked char = " + peekedChar + " Cur pos = " + curStreamPos);
        }
    }

    private static void checkOddBallHexStrings(CosString str, PDFAErrorFlags flags) {
        if (str.isOddBall()) {
            FileStructureProcessor.printDebugMsg("HexString Invalid: Hex String has odd number of chars");
            flags.errorsFound.addErrorCode(PDFAFileStructureErrorCode.hexStrEvenNumCharsNotPresent);
            if (flags.fixableErrors != null) {
                flags.fixableErrors.addErrorCode(PDFAFileStructureErrorCode.hexStrEvenNumCharsNotPresent);
            }
        }
    }

    private static void printCosObject(CosObject cosObj) {
        int rev = cosObj.getObjRevision();
        long pos = cosObj.getObjPos();
        long eof = cosObj.getObjEOF();
        String cls = cosObj.getClass().toString();
        FileStructureProcessor.printDebugMsg("Obj , " + cls.substring(cls.lastIndexOf(46) + 1) + ", rev " + rev + ", pos " + pos + ", eof " + eof);
    }

    private static void printCosScalar(CosObject cosObj) throws PDFSecurityException {
        if (cosObj instanceof CosNumeric) {
            FileStructureProcessor.printDebugMsg("\tNumericObj: " + cosObj.numberValue().toString());
        } else if (cosObj instanceof CosString) {
            CosString str = (CosString)cosObj;
            if (str.getWriteHex()) {
                FileStructureProcessor.printDebugMsg("\tHexStringObj: " + cosObj.stringValue().asString());
            } else {
                FileStructureProcessor.printDebugMsg("\tStringObj: " + cosObj.stringValue().asString());
            }
        } else if (cosObj instanceof CosName) {
            FileStructureProcessor.printDebugMsg("\tStringObj: " + cosObj.nameValue().asString());
        }
    }

    private static void printDebugMsg(String msg) {
    }

    static void printNextXBytes(InputByteStream buf, int n) throws IOException {
        long curpos = buf.getPosition();
        for (int i = 0; i < n; ++i) {
            long pos = curpos + (long)i;
            int cur = ParserUtils.peekAtPos(buf, pos);
            System.out.println("Char at: " + pos + " is:" + cur);
        }
    }

    static CosObject getIDFromTrailerDict(CosDictionary trailerDict) throws PDFCosParseException, PDFIOException, PDFSecurityException {
        return trailerDict.get(ASName.k_ID);
    }

    static class LocalDispatcher
    implements GeneralDispatcher {
        PDFAErrorFlags flags;

        LocalDispatcher(PDFAErrorFlags flags) {
            this.flags = flags;
        }

        public boolean finishDispatch(CosContainerValuesIterator.Entry entry, ArrayListStack visitorStack) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException, PDFFontException {
            return true;
        }

        public boolean isCandidate(CosContainerValuesIterator.Entry entry, ArrayListStack visitorStack, boolean wasSeen) {
            return true;
        }

        public boolean startDispatch(CosContainerValuesIterator.Entry entry, ArrayListStack visitorStack, boolean wasSeen) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
            CosObject object = entry.getValue();
            this.validateCosObject(object);
            return true;
        }

        void validateCosObject(CosObject object) throws PDFSecurityException {
            if (object instanceof CosNumeric) {
                double num;
                Number number = object.numberValue();
                if (number instanceof Integer || number instanceof Long) {
                    long num2 = number.longValue();
                    if (num2 < Integer.MIN_VALUE || num2 > Integer.MAX_VALUE) {
                        FileStructureProcessor.printDebugMsg("Integer Invalid: Value of given integer outside limits");
                        this.flags.errorsFound.addErrorCode(PDFAFileStructureErrorCode.integerNumberFormatIncorrect);
                    }
                } else if ((number instanceof Double || number instanceof Float) && ((num = number.doubleValue()) > 32767.0 || num < -32767.0)) {
                    FileStructureProcessor.printDebugMsg("RealNumber Invalid: Value of given real number outside limits");
                    this.flags.errorsFound.addErrorCode(PDFAFileStructureErrorCode.realNumberFormatIncorrect);
                }
            } else if (object instanceof CosString) {
                CosString str = (CosString)object;
                FileStructureProcessor.checkOddBallHexStrings(str, this.flags);
                if (str.byteArrayValue().length > 65535) {
                    FileStructureProcessor.printDebugMsg("CosString Invalid: CosString has a byte length > 65535");
                    this.flags.errorsFound.addErrorCode(PDFAFileStructureErrorCode.stringLengthIncorrect);
                }
            } else if (object instanceof CosName) {
                CosName name = (CosName)object;
                if (name.nameValue().getBytes().length > 127) {
                    FileStructureProcessor.printDebugMsg("CosName Invalid: CosName has a length > 127");
                    this.flags.errorsFound.addErrorCode(PDFAFileStructureErrorCode.nameLengthIncorrect);
                }
            } else if (object instanceof CosArray) {
                CosArray array = (CosArray)object;
                if (array.size() > 8191) {
                    FileStructureProcessor.printDebugMsg("CosArray Invalid: CosArray has a length > 8191");
                    this.flags.errorsFound.addErrorCode(PDFAFileStructureErrorCode.arrayLengthIncorrect);
                }
            } else if (object instanceof CosDictionary) {
                CosDictionary dict = (CosDictionary)object;
                if (dict.size() > 4095) {
                    FileStructureProcessor.printDebugMsg("CosDictionary Invalid: CosDictionary has a size > 4095");
                    this.flags.errorsFound.addErrorCode(PDFAFileStructureErrorCode.dictionarySizeIncorrect);
                }
                if (dict.isInvalidDict()) {
                    FileStructureProcessor.printDebugMsg("CosDictionary Invalid: Number of keys differ from value");
                    this.flags.errorsFound.addErrorCode(PDFAFileStructureErrorCode.misMatchedKeyValuePairsInDict);
                    if (this.flags.fixableErrors != null) {
                        this.flags.fixableErrors.addErrorCode(PDFAFileStructureErrorCode.misMatchedKeyValuePairsInDict);
                    }
                }
            }
        }

        public boolean continueTraversing(PDFInvalidDocumentException exceptionOccured) {
            this.flags.errorsFound.addErrorCode(PDFAFileStructureErrorCode.pdfGeneralFailure);
            return true;
        }
    }
}

