/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.pdfa.processor;

import com.adobe.fontengine.font.opentype.Head;
import com.adobe.internal.io.stream.InputByteStream;
import com.adobe.internal.pdftoolkit.core.cos.CosArray;
import com.adobe.internal.pdftoolkit.core.cos.CosName;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFFontException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidContentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFUnableToCompleteOperationException;
import com.adobe.internal.pdftoolkit.core.types.ASDictionary;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.content.Content;
import com.adobe.internal.pdftoolkit.pdf.content.ContentReader;
import com.adobe.internal.pdftoolkit.pdf.content.Instruction;
import com.adobe.internal.pdftoolkit.pdf.content.OperandStack;
import com.adobe.internal.pdftoolkit.pdf.contentmodify.IContentStreamFilter;
import com.adobe.internal.pdftoolkit.pdf.contentmodify.impl.ContentStreamTransformer;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCatalog;
import com.adobe.internal.pdftoolkit.pdf.document.PDFContents;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosDictionary;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosObjectContainer;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.document.PDFNameDictionary;
import com.adobe.internal.pdftoolkit.pdf.document.PDFOpenAction;
import com.adobe.internal.pdftoolkit.pdf.document.PDFPermissions;
import com.adobe.internal.pdftoolkit.pdf.document.PDFResources;
import com.adobe.internal.pdftoolkit.pdf.document.PDFVersion;
import com.adobe.internal.pdftoolkit.pdf.document.listener.DocumentListenerRegistryBase;
import com.adobe.internal.pdftoolkit.pdf.document.listener.DocumentMessage;
import com.adobe.internal.pdftoolkit.pdf.graphics.colorspaces.PDFColorSpace;
import com.adobe.internal.pdftoolkit.pdf.graphics.colorspaces.PDFColorSpaceDeviceCMYK;
import com.adobe.internal.pdftoolkit.pdf.graphics.colorspaces.PDFColorSpaceDeviceGray;
import com.adobe.internal.pdftoolkit.pdf.graphics.colorspaces.PDFColorSpaceDeviceN;
import com.adobe.internal.pdftoolkit.pdf.graphics.colorspaces.PDFColorSpaceDeviceRGB;
import com.adobe.internal.pdftoolkit.pdf.graphics.colorspaces.PDFColorSpaceICCBased;
import com.adobe.internal.pdftoolkit.pdf.graphics.colorspaces.PDFColorSpaceIndexed;
import com.adobe.internal.pdftoolkit.pdf.graphics.colorspaces.PDFColorSpaceMap;
import com.adobe.internal.pdftoolkit.pdf.graphics.colorspaces.PDFColorSpaceSeparation;
import com.adobe.internal.pdftoolkit.pdf.graphics.colorspaces.PDFICCProfile;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFFont;
import com.adobe.internal.pdftoolkit.pdf.graphics.optionalcontent.PDFOCGroup;
import com.adobe.internal.pdftoolkit.pdf.graphics.optionalcontent.PDFOCGroupArray;
import com.adobe.internal.pdftoolkit.pdf.graphics.optionalcontent.PDFOCGroupList;
import com.adobe.internal.pdftoolkit.pdf.graphics.optionalcontent.PDFOCMembership;
import com.adobe.internal.pdftoolkit.pdf.graphics.optionalcontent.PDFOCObject;
import com.adobe.internal.pdftoolkit.pdf.graphics.optionalcontent.PDFOCProperties;
import com.adobe.internal.pdftoolkit.pdf.graphics.patterns.PDFPattern;
import com.adobe.internal.pdftoolkit.pdf.graphics.patterns.PDFPatternMap;
import com.adobe.internal.pdftoolkit.pdf.graphics.patterns.PDFPatternTiling;
import com.adobe.internal.pdftoolkit.pdf.graphics.shading.PDFShading;
import com.adobe.internal.pdftoolkit.pdf.graphics.shading.PDFShadingMap;
import com.adobe.internal.pdftoolkit.pdf.graphics.xobject.PDFXObject;
import com.adobe.internal.pdftoolkit.pdf.graphics.xobject.PDFXObjectForm;
import com.adobe.internal.pdftoolkit.pdf.graphics.xobject.PDFXObjectImage;
import com.adobe.internal.pdftoolkit.pdf.graphics.xobject.PDFXObjectMap;
import com.adobe.internal.pdftoolkit.pdf.graphics.xobject.PDFXObjectPostScript;
import com.adobe.internal.pdftoolkit.pdf.inlineimage.InlineImage;
import com.adobe.internal.pdftoolkit.pdf.inlineimage.InlineImageColorSpace;
import com.adobe.internal.pdftoolkit.pdf.interactive.action.PDFAction;
import com.adobe.internal.pdftoolkit.pdf.interactive.action.PDFActionNamed;
import com.adobe.internal.pdftoolkit.pdf.interactive.action.PDFAdditionalActions;
import com.adobe.internal.pdftoolkit.pdf.interactive.action.PDFAdditionalActionsDocument;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotation;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationIterator;
import com.adobe.internal.pdftoolkit.pdf.interactive.forms.PDFInteractiveForm;
import com.adobe.internal.pdftoolkit.pdf.interactive.navigation.PDFBookmark;
import com.adobe.internal.pdftoolkit.pdf.interactive.navigation.PDFBookmarkNode;
import com.adobe.internal.pdftoolkit.pdf.interactive.navigation.PDFBookmarkRoot;
import com.adobe.internal.pdftoolkit.pdf.interchange.prepress.PDFOutputIntent;
import com.adobe.internal.pdftoolkit.pdf.interchange.prepress.PDFOutputIntentsList;
import com.adobe.internal.pdftoolkit.pdf.page.PDFPage;
import com.adobe.internal.pdftoolkit.pdf.page.PDFPageTree;
import com.adobe.internal.pdftoolkit.pdf.page.PDFPageTreeNode;
import com.adobe.internal.pdftoolkit.pdf.utils.ContentUtil;
import com.adobe.internal.pdftoolkit.services.optionalcontent.OCManager;
import com.adobe.internal.pdftoolkit.services.optionalcontent.OCUsageAppHandler;
import com.adobe.internal.pdftoolkit.services.pdfa.PDFAConformanceLevel;
import com.adobe.internal.pdftoolkit.services.pdfa.PDFAConversionHandler;
import com.adobe.internal.pdftoolkit.services.pdfa.PDFAConversionOptions;
import com.adobe.internal.pdftoolkit.services.pdfa.PDFAErrorSetBookmark;
import com.adobe.internal.pdftoolkit.services.pdfa.PDFAErrorSetCatalog;
import com.adobe.internal.pdftoolkit.services.pdfa.PDFAErrorSetField;
import com.adobe.internal.pdftoolkit.services.pdfa.PDFAErrorSetFont;
import com.adobe.internal.pdftoolkit.services.pdfa.PDFAErrorSetOutputIntent;
import com.adobe.internal.pdftoolkit.services.pdfa.PDFAErrorSetPage;
import com.adobe.internal.pdftoolkit.services.pdfa.PDFAOCConversionMode;
import com.adobe.internal.pdftoolkit.services.pdfa.PDFAValidationHandler;
import com.adobe.internal.pdftoolkit.services.pdfa.PDFAValidationOptions;
import com.adobe.internal.pdftoolkit.services.pdfa.common.FontProcessorUtils;
import com.adobe.internal.pdftoolkit.services.pdfa.common.TextLayoutPreservingFilter;
import com.adobe.internal.pdftoolkit.services.pdfa.error.PDFABookmarkErrorCode;
import com.adobe.internal.pdftoolkit.services.pdfa.error.PDFACatalogErrorCode;
import com.adobe.internal.pdftoolkit.services.pdfa.error.PDFAErrorCode;
import com.adobe.internal.pdftoolkit.services.pdfa.error.PDFAFieldErrorCode;
import com.adobe.internal.pdftoolkit.services.pdfa.error.PDFAFontErrorCode;
import com.adobe.internal.pdftoolkit.services.pdfa.error.PDFAOutputIntentErrorCode;
import com.adobe.internal.pdftoolkit.services.pdfa.error.PDFAPageErrorCode;
import com.adobe.internal.pdftoolkit.services.pdfa.font.FontContext;
import com.adobe.internal.pdftoolkit.services.pdfa.font.FontEmbedder;
import com.adobe.internal.pdftoolkit.services.pdfa.processor.AcroFormProcessor;
import com.adobe.internal.pdftoolkit.services.pdfa.processor.AnnotationProcessor;
import com.adobe.internal.pdftoolkit.services.pdfa.processor.ColorSpaceProcessor;
import com.adobe.internal.pdftoolkit.services.pdfa.processor.FileStructureProcessor;
import com.adobe.internal.pdftoolkit.services.pdfa.processor.MetadataProcessor;
import com.adobe.internal.pdftoolkit.services.pdfa.processor.PDFObjectCache;
import com.adobe.internal.pdftoolkit.services.pdfa.processor.PageProcessor;
import com.adobe.internal.pdftoolkit.services.pdfa.processor.SharedConstraints;
import com.adobe.internal.pdftoolkit.services.pdfa.processor.TrackingConversionHandler;
import com.adobe.internal.pdftoolkit.services.pdfa.processor.TrackingValidationHandler;
import java.awt.color.ColorSpace;
import java.awt.color.ICC_ColorSpace;
import java.awt.color.ICC_Profile;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class DocumentProcessor {
    PDFDocument document;
    boolean hasRGBOutputIntent;
    boolean hasCMYKOutputIntent;
    boolean hasGRAYOutputIntent;
    boolean usesDeviceRGBColorSpace;
    boolean usesDeviceCMYKColorSpace;
    private FontContext fontContext;
    PDFObjectCache modifiedObjects;
    OCManager ocManager;
    private HashSet unremovableOCGs;
    boolean outputIntentReplaced;
    private boolean skippedCharacters;

    public boolean isSkippedCharacters() {
        return this.skippedCharacters;
    }

    public void setSkippedCharacters(boolean skippedCharacters) {
        this.skippedCharacters = skippedCharacters;
    }

    public boolean process(PDFDocument document, PDFAConformanceLevel conformance, PDFAConversionOptions conversionOptions, PDFAConversionHandler clientConversionHandler, PDFAValidationOptions validationOptions, PDFAValidationHandler clientValidationHandler) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        int umebmeddedFontCount;
        TrackingValidationHandler validationHandler;
        TrackingConversionHandler conversionHandler;
        block41: {
            PDFCatalog catalog;
            block40: {
                block39: {
                    block38: {
                        PDFOutputIntent outputIntent;
                        block37: {
                            if (document == null) {
                                return true;
                            }
                            this.document = document;
                            try {
                                ((DocumentListenerRegistryBase)document.getListenerRegistry()).sendMessage(new DocumentMessage(DocumentMessage.FLUSH_FONTS, document), true);
                            }
                            catch (PDFUnableToCompleteOperationException e) {
                                // empty catch block
                            }
                            conversionHandler = null;
                            validationHandler = null;
                            if (clientConversionHandler != null) {
                                conversionHandler = new TrackingConversionHandler(clientConversionHandler);
                                validationHandler = conversionHandler;
                            } else {
                                validationHandler = new TrackingValidationHandler(clientValidationHandler);
                            }
                            this.fontContext = new FontContext(document);
                            if (validationHandler != null) {
                                Head.setFontHeaderValidationRequired((boolean)false);
                            }
                            if (!validationHandler.beginDocumentScan()) {
                                return false;
                            }
                            try {
                                PDFPageTree page = document.requirePages();
                                this.process(page, this, clientValidationHandler, (PDFAConversionHandler)conversionHandler, conversionOptions);
                            }
                            catch (PDFInvalidDocumentException e) {
                                // empty catch block
                            }
                            catalog = document.requireCatalog();
                            if (!this.process(catalog, conversionOptions, conversionHandler, validationOptions, validationHandler)) {
                                return false;
                            }
                            try {
                                PDFBookmarkRoot bmRoot = catalog.getBookmarkRoot();
                                if (!this.process(bmRoot, conversionOptions, conversionHandler, validationHandler)) {
                                    return false;
                                }
                            }
                            catch (PDFInvalidDocumentException e) {
                                if (validationHandler.catalogError(new PDFAErrorSetCatalog(PDFACatalogErrorCode.pdfGeneralFailure))) break block37;
                                return false;
                            }
                        }
                        if (conversionHandler != null && (outputIntent = conversionOptions.getPDFAOutputIntent()) != null && conversionOptions.overWritePDFAOutputIntentSet()) {
                            this.outputIntentReplaced = true;
                            PDFOutputIntentsList outputIntentsList = PDFOutputIntentsList.newInstance((PDFDocument)document);
                            outputIntentsList.add((PDFCosObjectContainer)outputIntent);
                            catalog.setOutputIntents(outputIntentsList);
                            conversionHandler.pdfaOutputIntentSet(outputIntent);
                        }
                        try {
                            PDFOutputIntentsList outputIntents = catalog.getOutputIntents();
                            if (!this.process(outputIntents, conformance, (PDFAValidationHandler)validationHandler, (PDFAConversionHandler)conversionHandler, conversionOptions)) {
                                return false;
                            }
                            this.hasRGBOutputIntent = ColorSpaceProcessor.hasValidPDFAOutputIntentWithRGBCS(document);
                            this.hasCMYKOutputIntent = ColorSpaceProcessor.hasValidPDFAOutputIntentWithCMYKCS(document);
                            this.hasGRAYOutputIntent = ColorSpaceProcessor.hasValidPDFAOutputIntent(document);
                        }
                        catch (PDFInvalidDocumentException e) {
                            if (validationHandler.outputIntentsError(null, new PDFAErrorSetOutputIntent(PDFAOutputIntentErrorCode.pdfGeneralFailure))) break block38;
                            return false;
                        }
                    }
                    try {
                        PDFInteractiveForm iform = catalog.getInteractiveForm();
                        if (!AcroFormProcessor.process(iform, conversionOptions, (PDFAConversionHandler)conversionHandler, (PDFAValidationHandler)validationHandler)) {
                            return false;
                        }
                    }
                    catch (PDFInvalidDocumentException e) {
                        if (validationHandler.formFieldError(new PDFAErrorSetField(PDFAFieldErrorCode.pdfGeneralFailure))) break block39;
                        return false;
                    }
                }
                try {
                    PDFPageTree pages = document.requirePages();
                    if (!PageProcessor.process((PDFPageTreeNode)pages, this, conformance, conversionOptions, conversionHandler, validationOptions, validationHandler)) {
                        return false;
                    }
                }
                catch (PDFInvalidDocumentException e) {
                    if (validationHandler.pageError(new PDFAErrorSetPage(PDFAPageErrorCode.pdfGeneralFailure))) break block40;
                    return false;
                }
            }
            if (catalog.dictionaryContains(ASName.k_OCProperties) && conversionHandler != null && conversionOptions.getRemoveOptionalContent()) {
                PDFOCProperties ocp = catalog.getOCProperties();
                if (this.unremovableOCGs.isEmpty()) {
                    catalog.removeValue(ASName.k_OCProperties);
                    conversionHandler.ocPropertiesRemovedFromCatalog(ocp);
                } else {
                    PDFOCGroupArray ocgs = ocp.getOCGs();
                    for (PDFOCGroup ocg : ocgs) {
                        if (this.unremovableOCGs.contains(ocg)) continue;
                        this.ocManager.remove(ocg);
                    }
                    if (!validationHandler.catalogError(new PDFAErrorSetCatalog(PDFACatalogErrorCode.optionalContentNotAllowed))) {
                        return false;
                    }
                }
            }
            umebmeddedFontCount = this.fontContext.getUnembeddedFonts().size();
            if (conversionHandler != null && umebmeddedFontCount > 0) {
                try {
                    if (!FontEmbedder.processUnembeddedFonts(this.fontContext, conversionHandler, validationHandler)) {
                        return false;
                    }
                }
                catch (PDFInvalidDocumentException e) {
                    if (validationHandler.fontError(new PDFAErrorSetFont(PDFAFontErrorCode.pdfGeneralFailure))) break block41;
                    return false;
                }
            }
        }
        if (!FileStructureProcessor.validate(document, conformance, validationOptions, validationHandler, conversionOptions, conversionHandler)) {
            return false;
        }
        if (!MetadataProcessor.process(document, conformance, conversionHandler, conversionOptions, validationHandler, validationOptions)) {
            return false;
        }
        if (conversionHandler != null && (umebmeddedFontCount > 0 || this.isSkippedCharacters())) {
            DocumentProcessor.updateContentStream(this.fontContext, this);
        }
        if (validationHandler != null) {
            Head.setFontHeaderValidationRequired((boolean)true);
        }
        if (conversionHandler != null) {
            conversionHandler.conversionSummary(conversionHandler.errorsFixed(), conversionHandler.errorsFound());
        }
        return validationHandler.endDocumentScan(validationHandler.errorsFound());
    }

    private void process(PDFPageTree pages, DocumentProcessor documentProcessor, PDFAValidationHandler validationHandler, PDFAConversionHandler conversionHandler, PDFAConversionOptions conversionOptions) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (conversionHandler == null) {
            return;
        }
        PDFOutputIntent outputIntent = conversionOptions.getPDFAOutputIntent();
        if (outputIntent == null) {
            return;
        }
        UseColor uc = new UseColor();
        for (PDFPage page : pages) {
            PDFAnnotationIterator itr = page.getAnnotationsIterator();
            while (itr.hasNext()) {
                PDFAnnotation annot = itr.next();
                AnnotationProcessor.process(annot, uc);
                if (!uc.found) continue;
                if (outputIntent.getDestOutputProfileRGB() != null) {
                    outputIntent.setDestOutputProfile(outputIntent.getDestOutputProfileRGB());
                }
                return;
            }
        }
        for (PDFPage page : pages) {
            PDFAnnotationIterator itr = page.getAnnotationsIterator();
            Content content = ContentUtil.getContent((boolean)false, (PDFPage)page);
            DocumentProcessor.process(content, documentProcessor, validationHandler, uc);
            if (!uc.found) continue;
            if (uc.useRGB) break;
            if (!uc.useCMYK) continue;
            if (outputIntent.getDestOutputProfileCMYK() != null) {
                outputIntent.setDestOutputProfile(outputIntent.getDestOutputProfileCMYK());
            }
            return;
        }
        if (outputIntent.getDestOutputProfileRGB() != null) {
            outputIntent.setDestOutputProfile(outputIntent.getDestOutputProfileRGB());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void process(Content content, DocumentProcessor docProcessor, PDFAValidationHandler validationHandler, UseColor uc) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (content == null) {
            return;
        }
        PDFResources resources = content.getResources();
        if (!validationHandler.beginContentScan(content.getContents(), resources)) {
            return;
        }
        ContentReader reader = null;
        try {
            PDFColorSpaceMap colorSpaceMap = null;
            colorSpaceMap = resources != null ? resources.getColorSpaceMap() : PDFColorSpaceMap.newInstance((PDFDocument)docProcessor.document);
            Instruction instruction = null;
            reader = ContentReader.newInstance((Content)content);
            while (reader.hasNext()) {
                try {
                    CosObject csValue;
                    PDFShading shading;
                    InlineImageColorSpace cs;
                    instruction = reader.next();
                    ASName operator = instruction.getOperator();
                    PDFVersion opVers = instruction.getVersion();
                    OperandStack operands = instruction.getOperands();
                    if (opVers == null) continue;
                    if (operator == ASName.k_cs || operator == ASName.k_CS) {
                        ASName csName = operands.peekName();
                        if (csName == ASName.k_DeviceRGB) {
                            uc.found = true;
                            uc.useRGB = true;
                            break;
                        }
                        if (csName == ASName.k_DeviceCMYK) {
                            uc.found = true;
                            uc.useCMYK = true;
                            break;
                        }
                        if (csName == ASName.k_DeviceGray || csName == ASName.k_Pattern) continue;
                        PDFColorSpace colorSpace = colorSpaceMap.get(csName);
                        DocumentProcessor.processColorMap(colorSpace, uc);
                        if (!uc.found) {
                            continue;
                        }
                        break;
                    }
                    if (operator == ASName.k_rg || operator == ASName.k_RG) {
                        uc.found = true;
                        uc.useRGB = true;
                        break;
                    }
                    if (operator == ASName.k_k || operator == ASName.k_K) {
                        uc.found = true;
                        uc.useCMYK = true;
                        break;
                    }
                    if (operator == ASName.k_g || operator == ASName.k_G) continue;
                    if (operator == ASName.k_Do) {
                        PDFXObject xObject;
                        ASName xObjectName = operands.peekName();
                        if (resources == null || (xObject = resources.getXObject(xObjectName)) == null) continue;
                        if (xObject.dictionaryContains(ASName.k_OC)) {
                            // empty if block
                        }
                        if (xObject instanceof PDFXObjectForm || xObject instanceof PDFXObjectPostScript) {
                            // empty if block
                        }
                        if (!(xObject instanceof PDFXObjectImage)) continue;
                        PDFXObjectImage image = (PDFXObjectImage)xObject;
                        cs = image.getColorSpace();
                        if (cs instanceof PDFColorSpaceDeviceRGB) {
                            uc.found = true;
                            uc.useRGB = true;
                            break;
                        }
                        if (cs instanceof PDFColorSpaceDeviceCMYK) {
                            uc.found = true;
                            uc.useCMYK = true;
                            break;
                        }
                        if (cs instanceof PDFColorSpaceDeviceGray) continue;
                        continue;
                    }
                    if (operator == ASName.k_ID) {
                        InputByteStream imageData = operands.peekInputByteStream();
                        ASDictionary imageDict = operands.stackToImageDictionary();
                        InlineImage inlineImage = InlineImage.newInstance((Content)content, (ASDictionary)imageDict, (InputByteStream)imageData);
                        if (!imageDict.containsKey((Object)ASName.k_ColorSpace) && !imageDict.containsKey((Object)ASName.k_CS)) continue;
                        cs = inlineImage.getColorSpace();
                        if (cs.isIndexedColorSpace()) {
                            cs = cs.getIndexedColorSpaceBase();
                        }
                        ASName deviceCSName = null;
                        if (cs.isDeviceColorSpace()) {
                            deviceCSName = cs.getDeviceColorSpaceName();
                        } else if (cs.isExistingResourceColorSpaceName() || cs.isNewResourceColorSpace()) {
                            ASName csName = null;
                            PDFColorSpace pdfCS = null;
                            if (cs.isExistingResourceColorSpaceName() && colorSpaceMap != null) {
                                csName = cs.getExistingResourceColorSpaceName();
                                pdfCS = colorSpaceMap.get(csName);
                            } else if (cs.isNewResourceColorSpace()) {
                                pdfCS = cs.getNewResourceColorSpace();
                            }
                            if (pdfCS instanceof PDFColorSpaceIndexed) {
                                pdfCS = ((PDFColorSpaceIndexed)pdfCS).getBaseColorSpace();
                            }
                            if (pdfCS instanceof PDFColorSpaceDeviceRGB) {
                                deviceCSName = ASName.k_DeviceRGB;
                            } else if (pdfCS instanceof PDFColorSpaceDeviceCMYK) {
                                deviceCSName = ASName.k_DeviceCMYK;
                            } else if (pdfCS instanceof PDFColorSpaceDeviceGray) {
                                deviceCSName = ASName.k_DeviceGray;
                            } else if (csName != null) {
                                DocumentProcessor.processColorMap(colorSpaceMap.get(csName), uc);
                                if (uc.found) break;
                            }
                        }
                        if (deviceCSName == ASName.k_DeviceRGB) {
                            uc.found = true;
                            uc.useRGB = true;
                            break;
                        }
                        if (deviceCSName == ASName.k_DeviceCMYK) {
                            uc.found = true;
                            uc.useCMYK = true;
                            break;
                        }
                        if (deviceCSName == ASName.k_DeviceGray) continue;
                        continue;
                    }
                    if (operator != ASName.k_sh) continue;
                    ASName shadingName = operands.peekName();
                    PDFShadingMap shadingMap = resources.getShadingMap();
                    if (shadingMap == null || (shading = shadingMap.get(shadingName)) == null || (csValue = shading.getPDFCosObject().getCosDictionary().get(ASName.k_ColorSpace)) == null) continue;
                    if (csValue.getType() == 3) {
                        ASName csName = ((CosName)csValue).nameValue();
                        if (csName == ASName.k_DeviceRGB) {
                            uc.found = true;
                            uc.useRGB = true;
                            break;
                        }
                        if (csName == ASName.k_DeviceCMYK) {
                            uc.found = true;
                            uc.useCMYK = true;
                            break;
                        }
                        if (csName == ASName.k_DeviceGray) continue;
                        DocumentProcessor.processColorMap(colorSpaceMap.get(csName), uc);
                        if (!uc.found) {
                            continue;
                        }
                        break;
                    }
                    if (csValue.getType() != 5) continue;
                }
                finally {
                    try {
                        if (instruction == null) continue;
                        instruction.close();
                    }
                    catch (PDFIOException e) {}
                }
            }
        }
        catch (PDFIOException e) {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException e2) {
                throw new PDFIOException("Failed to close a ContentReader.", (Throwable)e2);
            }
        }
        catch (PDFInvalidDocumentException e) {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException e3) {
                throw new PDFIOException("Failed to close a ContentReader.", (Throwable)e3);
            }
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException e) {
                throw new PDFIOException("Failed to close a ContentReader.", (Throwable)e);
            }
        }
    }

    private static void processColorMap(PDFColorSpace colorSpace, UseColor uc) throws PDFIOException, PDFSecurityException, PDFInvalidDocumentException {
        PDFColorSpace altCS = null;
        if (colorSpace == null) {
            return;
        }
        if (colorSpace instanceof PDFColorSpaceDeviceRGB) {
            uc.useRGB = true;
            uc.found = true;
            return;
        }
        if (colorSpace instanceof PDFColorSpaceDeviceCMYK) {
            uc.useCMYK = true;
            uc.found = true;
            return;
        }
        if (colorSpace instanceof PDFColorSpaceDeviceGray || colorSpace instanceof PDFColorSpaceICCBased) {
            return;
        }
        if (colorSpace instanceof PDFColorSpaceSeparation) {
            PDFColorSpaceSeparation sepCS = (PDFColorSpaceSeparation)colorSpace;
            altCS = sepCS.getAlternateColorSpace();
        } else if (colorSpace instanceof PDFColorSpaceDeviceN) {
            PDFColorSpaceDeviceN sepCS = (PDFColorSpaceDeviceN)colorSpace;
            altCS = sepCS.getAlternateColorSpace();
        } else if (colorSpace instanceof PDFColorSpaceIndexed) {
            altCS = ((PDFColorSpaceIndexed)colorSpace).getBaseColorSpace();
        }
        if (altCS != null && altCS instanceof PDFColorSpaceDeviceRGB) {
            uc.found = true;
            uc.useRGB = true;
        } else if (altCS instanceof PDFColorSpaceDeviceCMYK) {
            uc.found = true;
            uc.useCMYK = true;
        }
    }

    private boolean process(PDFCatalog catalog, PDFAConversionOptions conversionOptions, PDFAConversionHandler conversionHandler, PDFAValidationOptions validationOptions, PDFAValidationHandler validationHandler) throws PDFIOException, PDFSecurityException {
        PDFAErrorSetCatalog errorCodes = new PDFAErrorSetCatalog();
        try {
            PDFOpenAction openAction;
            PDFInteractiveForm iform;
            PDFPermissions perms;
            if (validationOptions.detectCertifiedDocumentEnabled() && (perms = catalog.getPermissions()) != null && perms.getDocMDP() != null) {
                errorCodes.addErrorCode(PDFACatalogErrorCode.certifyingSignatureNotAllowed);
            }
            if ((iform = catalog.getInteractiveForm()) != null && iform.hasXFA()) {
                if (conversionHandler != null && conversionOptions.getRemoveXFA()) {
                    iform.removeXFA();
                    if (!conversionHandler.xfaRemoved()) {
                        return false;
                    }
                }
                if (validationOptions.detectXFAEnabled()) {
                    errorCodes.addErrorCode(PDFACatalogErrorCode.xfaNotAllowed);
                }
            }
            if (catalog.dictionaryContains(ASName.k_Names)) {
                PDFNameDictionary names = catalog.getNameDictionary();
                if (names.dictionaryContains(ASName.k_EmbeddedFiles)) {
                    if (conversionHandler != null && conversionOptions.getRemoveEmbeddedFilesNameTree()) {
                        names.removeNamedEmbeddedFiles();
                        conversionHandler.embeddedFilesNameTreeRemoved();
                    } else {
                        errorCodes.addErrorCode(PDFACatalogErrorCode.namedEmbeddedFilesNotAllowed);
                    }
                }
                if (names.dictionaryContains(ASName.k_JavaScript)) {
                    if (conversionHandler != null && conversionOptions.getRemoveJavaScriptNameTree()) {
                        names.removeNamedJavaScripts();
                        conversionHandler.javaScriptNameTreeRemoved();
                    } else {
                        errorCodes.addErrorCode(PDFACatalogErrorCode.namedJavaScriptsNotAllowed);
                    }
                }
            }
            if (catalog.dictionaryContains(ASName.k_OCProperties)) {
                this.initOptionalContentHandling(catalog, conversionOptions);
                if (conversionHandler == null || !conversionOptions.getRemoveOptionalContent()) {
                    errorCodes.addErrorCode(PDFACatalogErrorCode.optionalContentNotAllowed);
                }
            }
            if ((openAction = catalog.getOpenAction()) != null && openAction.isAction()) {
                PDFAction action = openAction.getAction();
                PDFAction.TreeIterator actionIter = action.treeIterator();
                while (actionIter.hasNext()) {
                    PDFActionNamed namedAction;
                    ASName actionName;
                    action = actionIter.next();
                    ASName subtype = action.getSubtype();
                    PDFACatalogErrorCode ec = PDFACatalogErrorCode.getErrorCode(subtype);
                    if (ec != null) {
                        if (conversionHandler != null && conversionOptions.getRemoveIllegalActions()) {
                            catalog.setOpenAction(null);
                            if (conversionHandler.openActionRemovedFromCatalog(openAction)) continue;
                            return false;
                        }
                        errorCodes.addErrorCode(ec);
                        continue;
                    }
                    if (subtype != ASName.k_Named || (actionName = (namedAction = (PDFActionNamed)action).getName()) == ASName.create((String)"NextPage") || actionName == ASName.create((String)"PrevPage") || actionName == ASName.create((String)"FirstPage") || actionName == ASName.create((String)"LastPage")) continue;
                    if (conversionHandler != null && conversionOptions.getRemoveIllegalActions()) {
                        catalog.setOpenAction(null);
                        if (conversionHandler.openActionRemovedFromCatalog(openAction)) continue;
                        return false;
                    }
                    errorCodes.addErrorCode(PDFACatalogErrorCode.openActionNotAllowed);
                }
            }
            if (catalog.dictionaryContains(ASName.k_AA)) {
                if (conversionHandler != null && conversionOptions.getRemoveIllegalAdditionalActions()) {
                    PDFAdditionalActionsDocument aa = catalog.getAdditionalActions();
                    catalog.removeValue(ASName.k_AA);
                    conversionHandler.illegalAdditionalActionsRemoved((PDFAdditionalActions)aa);
                } else {
                    errorCodes.addErrorCode(PDFACatalogErrorCode.additionalActionsNotAllowed);
                }
            }
        }
        catch (PDFInvalidDocumentException e) {
            errorCodes.addErrorCode(PDFACatalogErrorCode.pdfGeneralFailure);
        }
        return !errorCodes.hasErrors() || validationHandler.catalogError(errorCodes);
    }

    private boolean process(PDFBookmarkRoot bmRoot, PDFAConversionOptions conversionOptions, PDFAConversionHandler conversionHandler, PDFAValidationHandler validationHandler) throws PDFIOException, PDFSecurityException {
        block9: {
            if (bmRoot == null) {
                return true;
            }
            try {
                PDFBookmarkNode.Iterator bmIter = bmRoot.iterator();
                while (bmIter.hasNext()) {
                    PDFAErrorSetBookmark errorCodes = new PDFAErrorSetBookmark();
                    PDFBookmark bm = bmIter.next();
                    if (bm.hasAction()) {
                        PDFAction action = bm.getAction();
                        PDFAction.TreeIterator actionIter = action.treeIterator();
                        while (actionIter.hasNext()) {
                            PDFActionNamed namedAction;
                            ASName actionName;
                            action = actionIter.next();
                            ASName subtype = action.getSubtype();
                            PDFABookmarkErrorCode ec = PDFABookmarkErrorCode.getErrorCode(subtype);
                            if (ec != null) {
                                if (conversionHandler != null && conversionOptions.getRemoveIllegalActions()) {
                                    bm.removeValue(ASName.k_A);
                                    if (conversionHandler.illegalActionRemoved(action)) continue;
                                    return false;
                                }
                                errorCodes.addErrorCode(ec);
                                continue;
                            }
                            if (subtype != ASName.k_Named || (actionName = (namedAction = (PDFActionNamed)action).getName()) == ASName.create((String)"NextPage") || actionName == ASName.create((String)"PrevPage") || actionName == ASName.create((String)"FirstPage") || actionName == ASName.create((String)"LastPage")) continue;
                            if (conversionHandler != null && conversionOptions.getRemoveIllegalActions()) {
                                bm.removeValue(ASName.k_A);
                                if (conversionHandler.illegalActionRemoved(action)) continue;
                                return false;
                            }
                            errorCodes.addErrorCode(PDFABookmarkErrorCode.actionNotAllowed);
                        }
                    }
                    if (!errorCodes.hasErrors() || validationHandler.bookmarkError(bm, errorCodes)) continue;
                    return false;
                }
            }
            catch (PDFInvalidDocumentException e) {
                if (validationHandler.bookmarkError(null, new PDFAErrorSetBookmark(PDFABookmarkErrorCode.pdfGeneralFailure))) break block9;
                return false;
            }
        }
        return true;
    }

    private boolean process(PDFOutputIntentsList intents, PDFAConformanceLevel conformance, PDFAValidationHandler handler, PDFAConversionHandler conversionHandler, PDFAConversionOptions conversionOptions) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFOutputIntent intent;
        Boolean continueProcessing;
        if (intents == null) {
            return true;
        }
        if (!handler.beginOutputIntentScan()) {
            return false;
        }
        HashSet foundProfiles = new HashSet();
        Iterator iter = intents.iterator();
        while (iter.hasNext() && (continueProcessing = this.process(intent = (PDFOutputIntent)iter.next(), foundProfiles, conformance, handler, conversionHandler, conversionOptions, false)) != null) {
            if (continueProcessing.booleanValue()) continue;
            return false;
        }
        return handler.endOutputIntentScan();
    }

    private Boolean process(PDFOutputIntent intent, HashSet foundProfiles, PDFAConformanceLevel conformance, PDFAValidationHandler handler, PDFAConversionHandler conversionHandler, PDFAConversionOptions conversionOptions, boolean clientOutputIntentVerified) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (intent == null) {
            return true;
        }
        PDFAErrorSetOutputIntent errorCodes = new PDFAErrorSetOutputIntent();
        try {
            PDFICCProfile profile = intent.getDestOutputProfile();
            if (!MetadataProcessor.processDictionaryXMP((PDFCosDictionary)profile, conversionHandler)) {
                errorCodes.addErrorCode(PDFAOutputIntentErrorCode.objectXMPMetadataInvalid);
            }
            if (foundProfiles.isEmpty()) {
                foundProfiles.add(profile);
            } else if (!foundProfiles.contains(profile)) {
                errorCodes.addErrorCode(PDFAOutputIntentErrorCode.multipleDestOutputProfiles);
            }
            PDFAErrorCode ec = DocumentProcessor.iccProfileVersionAllowed(profile, conformance);
            if (ec != null) {
                errorCodes.addErrorCode(ec);
            }
            try {
                ColorSpace cs = profile.getColorSpace();
                if (intent.getSubType().equals((Object)SharedConstraints.k_GTS_PDFA1)) {
                    int noOfComponents = -1;
                    switch (cs.getType()) {
                        case 6: {
                            noOfComponents = 1;
                            break;
                        }
                        case 5: {
                            noOfComponents = 3;
                            break;
                        }
                        case 9: {
                            noOfComponents = 4;
                            break;
                        }
                    }
                    int N = profile.getNumberOfComponents();
                    if (N != noOfComponents) {
                        errorCodes.addErrorCode(PDFAOutputIntentErrorCode.incorrectValueForKeyN);
                    }
                    if (conversionHandler != null && noOfComponents != -1) {
                        profile.setNumberOfComponents(noOfComponents);
                        errorCodes.unSetErrorFlag(PDFAOutputIntentErrorCode.incorrectValueForKeyN);
                    }
                }
            }
            catch (PDFException e) {
                errorCodes.addErrorCode(PDFAOutputIntentErrorCode.invalidDestOutputProfile);
            }
        }
        catch (Exception e) {
            errorCodes.addErrorCode(PDFAOutputIntentErrorCode.invalidDestOutputProfile);
        }
        if (errorCodes.hasErrors()) {
            if (conversionHandler != null) {
                PDFOutputIntent outputIntent = conversionOptions.getPDFAOutputIntent();
                if (!clientOutputIntentVerified && outputIntent != null && conversionOptions.overWritePDFAOutputIntentSet() && !this.outputIntentReplaced) {
                    PDFOutputIntentsList outputIntentsList = PDFOutputIntentsList.newInstance((PDFDocument)this.document);
                    outputIntentsList.add((PDFCosObjectContainer)outputIntent);
                    intent.getPDFDocument().requireCatalog().setOutputIntents(outputIntentsList);
                    this.outputIntentReplaced = true;
                    conversionHandler.pdfaOutputIntentSet(outputIntent);
                    Boolean continueProcessing = this.process(outputIntent, new HashSet(), conformance, handler, conversionHandler, conversionOptions, true);
                    return continueProcessing == true ? null : Boolean.valueOf(false);
                }
                if (!handler.outputIntentsError(intent, errorCodes)) {
                    return false;
                }
            } else if (!handler.outputIntentsError(intent, errorCodes)) {
                return false;
            }
        }
        return true;
    }

    private void initOptionalContentHandling(PDFCatalog catalog, PDFAConversionOptions conversionOptions) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.unremovableOCGs = new HashSet();
        PDFAOCConversionMode conversionMode = PDFAOCConversionMode.ConvertOCUsingDefaultConfigIgnoringUsageApp;
        ASName usageAppEvent = null;
        if (conversionOptions != null) {
            conversionMode = conversionOptions.getOCConversionMode();
            if (conversionOptions.getOCConversionMode() == PDFAOCConversionMode.ConvertOCUsingDefaultConfigIncludingUsageApp) {
                usageAppEvent = conversionOptions.getOCUsageAppEvent();
            }
        }
        PDFOCProperties properties = catalog.getOCProperties();
        this.ocManager = OCManager.newInstance((PDFOCProperties)properties, (OCUsageAppHandler)new PDFAOCUsageAppHandler(null, usageAppEvent));
        if (conversionMode == PDFAOCConversionMode.MakeAllOptionalContentVisible) {
            PDFOCGroupArray ocgs = properties.getOCGs();
            for (PDFOCGroup ocg : ocgs) {
                this.ocManager.setVisibility(ocg, true);
            }
        }
    }

    private static PDFAErrorCode iccProfileVersionAllowed(PDFICCProfile pdfProfile, PDFAConformanceLevel conformance) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        try {
            ICC_ColorSpace iccCS = (ICC_ColorSpace)pdfProfile.getColorSpace();
            ICC_Profile iccProfile = iccCS.getProfile();
            int majorVersion = iccProfile.getMajorVersion();
            if (conformance == PDFAConformanceLevel.Level_1b && majorVersion > 2) {
                return PDFAOutputIntentErrorCode.iccProfileVersionNotAllowed;
            }
            return null;
        }
        catch (PDFInvalidContentException e) {
            return PDFAOutputIntentErrorCode.iccProfileCouldNotBeParsed;
        }
    }

    void markOCsOCGsUnremovable(PDFOCObject oc) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        block3: {
            PDFOCMembership ocmd;
            block4: {
                block2: {
                    if (!oc.isOCG()) break block2;
                    this.unremovableOCGs.add(oc);
                    break block3;
                }
                if (!oc.isOCMD()) break block3;
                ocmd = (PDFOCMembership)oc;
                if (!ocmd.hasVisibilityExpression()) break block4;
                HashSet ocgs = new HashSet();
                CosArray ve = ocmd.getVisibilityExpression().getCosArray();
                this.recordOCGsInVE(ocgs, ve);
                for (PDFOCGroup ocg : ocgs) {
                    this.unremovableOCGs.add(ocg);
                }
                break block3;
            }
            PDFOCGroupList ocgs = ocmd.getOCGs();
            if (ocgs == null) break block3;
            for (PDFOCGroup ocg : ocgs) {
                this.unremovableOCGs.add(ocg);
            }
        }
    }

    private void recordOCGsInVE(HashSet ocgs, CosArray veArray) throws PDFInvalidDocumentException {
        for (CosObject obj : veArray) {
            if (obj.getType() == 5) {
                this.recordOCGsInVE(ocgs, (CosArray)obj);
                continue;
            }
            if (obj.getType() != 6) continue;
            PDFOCGroup ocg = PDFOCGroup.getInstance((CosObject)obj);
            ocgs.add(ocg);
        }
    }

    boolean canRemovePDFOCObject(PDFOCObject oc) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.ocManager == null || this.ocManager.isVisible(oc);
    }

    private static void updateContentStream(FontContext fontContext, DocumentProcessor documentProcessor) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFDocument document = documentProcessor.document;
        for (PDFPage page : document.requirePages()) {
            PDFPatternMap patternmap;
            Content content = Content.newInstance((PDFPage)page);
            HashSet<PDFFont> fontsInPage = FontProcessorUtils.getFontsInPage(page);
            DocumentProcessor.updateContentStream(fontContext, fontsInPage, content, documentProcessor);
            PDFXObjectMap pdfxObjectMap = page.getResources().getXObjectMap();
            if (pdfxObjectMap != null) {
                for (Map.Entry entry : pdfxObjectMap.entrySet()) {
                    PDFXObject xobj = (PDFXObject)entry.getValue();
                    if (!(xobj instanceof PDFXObjectForm)) continue;
                    Content xContent = Content.newInstance((PDFXObjectForm)((PDFXObjectForm)xobj));
                    DocumentProcessor.updateContentStream(fontContext, fontsInPage, xContent, documentProcessor);
                }
            }
            if ((patternmap = page.getResources().getPatternMap()) == null) continue;
            Iterator pIter = patternmap.entrySet().iterator();
            while (pIter.hasNext()) {
                PDFPattern pattern = (PDFPattern)((Map.Entry)pIter.next()).getValue();
                if (!(pattern instanceof PDFPatternTiling)) continue;
                Content pContent = Content.newInstance((PDFContents)((PDFPatternTiling)pattern).getContents(), (PDFResources)((PDFPatternTiling)pattern).getResources());
                DocumentProcessor.updateContentStream(fontContext, fontsInPage, pContent, documentProcessor);
            }
        }
    }

    private static void updateContentStream(FontContext fontContext, HashSet<PDFFont> fontsInPage, Content content, DocumentProcessor docProcessor) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        Set<PDFFont> updatedFonts = fontContext.getFontWidthMap().keySet();
        boolean updateStream = false;
        for (PDFFont font : fontsInPage) {
            if (updatedFonts != null & updatedFonts.contains(font)) {
                updateStream = true;
                break;
            }
            if (!fontContext.getFontsWithoutTextShowString().contains(font)) continue;
            updateStream = true;
            break;
        }
        if (updateStream || docProcessor.isSkippedCharacters()) {
            try {
                ContentStreamTransformer.transformContent((Content)content, (IContentStreamFilter)new TextLayoutPreservingFilter(fontContext.getFontWidthMap(), content));
            }
            catch (PDFFontException e) {
                throw new PDFInvalidDocumentException((Throwable)e);
            }
        }
    }

    public FontContext getFontContext() {
        return this.fontContext;
    }

    public static List<Integer> processPageTreeforTransparency(PDFPageTree pages) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        int index = 1;
        ArrayList<Integer> pageNumber = null;
        for (PDFPage page : pages) {
            if (PageProcessor.hasTransparency(page)) {
                if (pageNumber == null) {
                    pageNumber = new ArrayList<Integer>(16);
                }
                pageNumber.add(index);
            }
            ++index;
        }
        return pageNumber;
    }

    private static class PDFAOCUsageAppHandler
    implements OCUsageAppHandler {
        private Locale locale = null;
        private ASName event = null;

        private PDFAOCUsageAppHandler(Locale locale, ASName event) {
            this.event = event;
            this.locale = locale;
        }

        public Locale getLocale() {
            return this.locale;
        }

        public ASName getAppEvent() {
            return this.event;
        }
    }

    class UseColor {
        boolean found = false;
        boolean useRGB = false;
        boolean useCMYK = false;

        UseColor() {
        }
    }
}

