/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.pdfa.font;

import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.content.Content;
import com.adobe.internal.pdftoolkit.pdf.document.PDFContents;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosDictionary;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.document.PDFResources;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFCharProcs;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFFont;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFFontType3;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFSimpleFontEncoding;
import com.adobe.internal.pdftoolkit.services.pdfa.PDFAConformanceLevel;
import com.adobe.internal.pdftoolkit.services.pdfa.PDFAConversionHandler;
import com.adobe.internal.pdftoolkit.services.pdfa.PDFAConversionOptions;
import com.adobe.internal.pdftoolkit.services.pdfa.PDFAErrorSetFont;
import com.adobe.internal.pdftoolkit.services.pdfa.PDFAValidationHandler;
import com.adobe.internal.pdftoolkit.services.pdfa.PDFAValidationOptions;
import com.adobe.internal.pdftoolkit.services.pdfa.error.PDFAFontErrorCode;
import com.adobe.internal.pdftoolkit.services.pdfa.font.FontProcessor;
import com.adobe.internal.pdftoolkit.services.pdfa.font.ReferencedFontInfoProcessor;
import com.adobe.internal.pdftoolkit.services.pdfa.processor.ContentProcessor;
import com.adobe.internal.pdftoolkit.services.pdfa.processor.DocumentProcessor;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

class Type3FontProcessor {
    Type3FontProcessor() {
    }

    static PDFAErrorSetFont processType3FontErrors(PDFFont font, List showStringList, DocumentProcessor docProcessor, PDFAConformanceLevel conformance, PDFAConversionOptions conversionOptions, PDFAConversionHandler conversionHandler, PDFAValidationOptions validationOptions, PDFAValidationHandler validationHandler) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (font == null || showStringList == null) {
            return new PDFAErrorSetFont();
        }
        if (!(font instanceof PDFFontType3)) {
            return new PDFAErrorSetFont();
        }
        PDFAErrorSetFont errorCodes = new PDFAErrorSetFont();
        FontProcessor.setTypeErrorCodes(font.getCosDictionary(), ASName.k_Font, conversionHandler, errorCodes, PDFAFontErrorCode.typeIncorrectInFont, PDFAFontErrorCode.typeAbsentInFont);
        PDFFontType3 type3 = (PDFFontType3)font;
        PDFResources resources = type3.getResources();
        PDFCharProcs charProcs = type3.getCharProcs();
        if (charProcs == null) {
            return new PDFAErrorSetFont();
        }
        PDFSimpleFontEncoding encoding = type3.getEncoding();
        if (encoding == null) {
            return errorCodes;
        }
        if (validationOptions.validateUnusedResourcesEnabled()) {
            Set keys = charProcs.keySet();
            for (ASName charName : keys) {
                Content content;
                double glyphWidth;
                int charCode = encoding.fromGlyphName(charName.asString());
                double charProcsWidth = charProcs.getWidth(charName);
                if (Math.abs(charProcsWidth - (glyphWidth = type3.getGlyphWidthDefaultMissingWidth(charCode))) > 1.0) {
                    errorCodes.addErrorCode(PDFAFontErrorCode.mismatchedWidthsInfo);
                }
                PDFContents charStm = (PDFContents)charProcs.get((Object)charName);
                boolean resourcesDetached = false;
                if (conversionHandler != null && resources == null) {
                    resources = PDFResources.newInstance((PDFDocument)type3.getPDFDocument());
                    resourcesDetached = true;
                }
                if (!ContentProcessor.process(content = Content.newInstance((PDFContents)charStm, (PDFResources)resources), (PDFCosDictionary)charProcs, charName, docProcessor, conformance, conversionOptions, conversionHandler, validationOptions, validationHandler)) {
                    return null;
                }
                if (conversionHandler == null || !resourcesDetached || resources.isEmpty()) continue;
                type3.setResources(content.getResources());
            }
        } else {
            HashSet<Integer> referencedCharCodes = ReferencedFontInfoProcessor.getReferencedCharCodes((PDFFont)type3, showStringList);
            for (Integer charCodeInt : referencedCharCodes) {
                PDFContents charStm;
                double glyphWidth;
                int charCode = charCodeInt;
                ASName charName = encoding.getGlyphNameAsASName(charCode);
                double charProcsWidth = charProcs.getWidth(charName) * type3.getFontMatrix().geta();
                if (Math.abs(charProcsWidth - (glyphWidth = type3.getGlyphWidthDefaultMissingWidth(charCode) * type3.getFontMatrix().geta())) > 0.001) {
                    errorCodes.addErrorCode(PDFAFontErrorCode.mismatchedWidthsInfo);
                }
                if ((charStm = (PDFContents)charProcs.get((Object)charName)) != null) {
                    Content content = Content.newInstance((PDFContents)charStm, (PDFResources)resources);
                    if (ContentProcessor.process(content, (PDFCosDictionary)charProcs, charName, docProcessor, conformance, conversionOptions, conversionHandler, validationOptions, validationHandler)) continue;
                    return null;
                }
                errorCodes.addErrorCode(PDFAFontErrorCode.embeddedFontMissingGlyphs);
            }
        }
        return errorCodes;
    }
}

