/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.pdfa.font;

import com.adobe.fontengine.FontEngineException;
import com.adobe.fontengine.font.Font;
import com.adobe.fontengine.font.PDFFontDescription;
import com.adobe.fontengine.font.Subset;
import com.adobe.internal.io.stream.InputByteStream;
import com.adobe.internal.pdftoolkit.core.cos.CosDictionary;
import com.adobe.internal.pdftoolkit.core.cos.CosDocument;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.cos.CosStream;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFCosParseException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFFontException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.core.types.ASString;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.CIDSystemInfo;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.CMapObject;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFCIDFont;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFCIDSet;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFCIDSystemInfo;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFCMap;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFCosFontDescriptor;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFFont;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFFontDescriptor;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFFontFactory;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFFontSimple;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFFontType0;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFType0FontEncoding;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFWritingMode;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.impl.CMapResourceBuilder;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.impl.PDFFontUtils;
import com.adobe.internal.pdftoolkit.services.pdfa.PDFAConversionHandler;
import com.adobe.internal.pdftoolkit.services.pdfa.PDFAErrorSetFont;
import com.adobe.internal.pdftoolkit.services.pdfa.common.FontProcessorUtils;
import com.adobe.internal.pdftoolkit.services.pdfa.error.PDFAFontErrorCode;
import com.adobe.internal.pdftoolkit.services.pdfa.font.FontContext;
import com.adobe.internal.pdftoolkit.services.pdfa.font.FontProcessor;
import com.adobe.internal.pdftoolkit.services.pdfa.font.UnembeddedFontInfo;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class Type0FontProcessor {
    private static PDFAErrorSetFont processCMapErrors(PDFType0FontEncoding cMap, PDFCIDFont cidFont, PDFAConversionHandler conversionHandler, PDFFontType0 type0Font) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFWritingMode cMapStreamWMode;
        PDFWritingMode cMapDictWMode;
        PDFAErrorSetFont errorCodes = new PDFAErrorSetFont();
        if (cMap == null) {
            return errorCodes;
        }
        ASString cmapRegistry = null;
        ASString cmapOrdering = null;
        boolean cMapEmbedded = false;
        if (cMap.isPredefinedCMap()) {
            if (!PDFFontUtils.isCMapIdentity((PDFType0FontEncoding)cMap)) {
                errorCodes.addErrorCode(PDFAFontErrorCode.predefinedCMapNotIdentityHOrIdentityV);
            }
        } else {
            PDFCIDSystemInfo cidInfo;
            CIDSystemInfo cmapInfo;
            PDFType0FontEncoding useCMap;
            if (cMap.getCosObject() != null && cMap.getCosObject().getType() == 7) {
                cMapEmbedded = true;
            } else {
                errorCodes.addErrorCode(PDFAFontErrorCode.CMapNotEmbedded);
            }
            if (cMap.getCosObject() instanceof CosDictionary) {
                FontProcessor.setTypeErrorCodes((CosDictionary)cMap.getCosObject(), ASName.create((String)"CMap"), conversionHandler, errorCodes, PDFAFontErrorCode.typeIncorrectInCMAP, PDFAFontErrorCode.typeAbsentInCMAP);
            }
            if ((useCMap = cMap.getUseCMap()) != null) {
                errorCodes.mergeErrorSet(Type0FontProcessor.processCMapErrors(useCMap, cidFont, conversionHandler, type0Font));
            }
            InputStream encodingStream = null;
            try {
                encodingStream = type0Font.getCosDictionary().getStream(ASName.k_Encoding).toInputStream();
            }
            catch (IOException e) {
                throw new PDFIOException((Throwable)e);
            }
            byte[] encodingStreamBytes = null;
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            byte[] data = new byte[16384];
            try {
                int nRead;
                while ((nRead = encodingStream.read(data, 0, data.length)) != -1) {
                    buffer.write(data, 0, nRead);
                }
            }
            catch (IOException e) {
                throw new PDFIOException((Throwable)e);
            }
            try {
                buffer.flush();
            }
            catch (IOException e) {
                throw new PDFIOException((Throwable)e);
            }
            encodingStreamBytes = buffer.toByteArray();
            String encodingStreamString = new String(encodingStreamBytes);
            List<String> encodingStreamTokens = Arrays.asList(encodingStreamString.split("\\s+"));
            int supplementIndex = encodingStreamTokens.indexOf("/Supplement");
            if (!encodingStreamTokens.get(supplementIndex + 3).equals("end")) {
                errorCodes.addErrorCode(PDFAFontErrorCode.cidSystemInfoMissingEndDef);
            }
            if ((cmapInfo = cMap.getCIDSystemInfo()) != null) {
                cmapRegistry = cmapInfo.getRegistry();
                cmapOrdering = cmapInfo.getOrdering();
            }
            if ((cidInfo = cidFont.getCIDSystemInfo()) != null) {
                ASString cidRegistry = cidInfo.getRegistry();
                ASString cidOrdering = cidInfo.getOrdering();
                if (!cidRegistry.equals(cmapRegistry) || !cidOrdering.equals(cmapOrdering)) {
                    errorCodes.addErrorCode(PDFAFontErrorCode.mismatchedCIDSystemInfo);
                }
            }
        }
        if (cMapEmbedded && (cMapDictWMode = cMap.getWModeFromCMapDict()) != (cMapStreamWMode = CMapResourceBuilder.getWMode((CosStream)cMap.getCosStream()))) {
            errorCodes.addErrorCode(PDFAFontErrorCode.mismatchedCMapWModes);
        }
        return errorCodes;
    }

    static PDFAErrorSetFont processType0FontErrors(PDFFont font, PDFAConversionHandler conversionHandler, Map<ASName, CosStream> cMapsEmbedded, List showStringList) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, FontEngineException {
        PDFAErrorSetFont errorCodes = new PDFAErrorSetFont();
        if (font == null) {
            return errorCodes;
        }
        if (!(font instanceof PDFFontType0)) {
            return errorCodes;
        }
        FontProcessor.setTypeErrorCodes(font.getCosDictionary(), ASName.k_Font, conversionHandler, errorCodes, PDFAFontErrorCode.typeIncorrectInFont, PDFAFontErrorCode.typeAbsentInFont);
        PDFFontType0 type0Font = (PDFFontType0)font;
        PDFType0FontEncoding cMap = type0Font.getEncoding();
        PDFCIDFont cidFont = type0Font.getDescendantFont();
        if (cidFont == null) {
            throw new PDFInvalidDocumentException("Invalid Type0 font - it does not have descendant font");
        }
        FontProcessor.setTypeErrorCodes(cidFont.getCosDictionary(), ASName.k_Font, conversionHandler, errorCodes, PDFAFontErrorCode.typeIncorrectInCIDFont, PDFAFontErrorCode.typeAbsentInCIDFont);
        if (cMap != null) {
            errorCodes.mergeErrorSet(Type0FontProcessor.processCMapErrors(cMap, cidFont, conversionHandler, type0Font));
        }
        if (cidFont.getSubType() == ASName.k_CIDFontType2) {
            if (!cidFont.hasCIDToGIDMap()) {
                errorCodes.addErrorCode(PDFAFontErrorCode.type2CIDFontMissingCIDToGIDMap);
            } else if (cidFont.isCIDToGIDMapAName()) {
                if (cidFont.getCIDToGIDMapName() != ASName.k_Identity) {
                    errorCodes.addErrorCode(PDFAFontErrorCode.type2CIDFontInvalidCIDToGIDMap);
                }
            } else if (!cidFont.isCIDToGIDMapAStream()) {
                errorCodes.addErrorCode(PDFAFontErrorCode.type2CIDFontInvalidCIDToGIDMap);
            }
        }
        if (conversionHandler != null) {
            if ((FontProcessor.isSetErrorFlag(errorCodes, PDFAFontErrorCode.CMapNotEmbedded) || FontProcessor.isSetErrorFlag(errorCodes, PDFAFontErrorCode.predefinedCMapNotIdentityHOrIdentityV)) && Type0FontProcessor.embedCMap(type0Font, cMapsEmbedded)) {
                if (!conversionHandler.cMapEmbeddedInType0Font(font)) {
                    return null;
                }
                FontProcessor.unSetErrorFlag(errorCodes, PDFAFontErrorCode.CMapNotEmbedded);
                FontProcessor.unSetErrorFlag(errorCodes, PDFAFontErrorCode.predefinedCMapNotIdentityHOrIdentityV);
            }
            if (FontProcessor.isSetErrorFlag(errorCodes, PDFAFontErrorCode.mismatchedCMapWModes) && PDFFontUtils.setWModeInEmbeddedCMap((PDFFontType0)type0Font)) {
                if (!conversionHandler.wModeUpdatedInType0Font(font)) {
                    return null;
                }
                FontProcessor.unSetErrorFlag(errorCodes, PDFAFontErrorCode.mismatchedCMapWModes);
            }
            if (FontProcessor.isSetErrorFlag(errorCodes, PDFAFontErrorCode.cidSystemInfoMissingEndDef)) {
                type0Font.addEndDefToCIDSystemInfoDict();
                FontProcessor.unSetErrorFlag(errorCodes, PDFAFontErrorCode.cidSystemInfoMissingEndDef);
            }
        }
        return errorCodes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void addReferencedCIDSetErrors(PDFAConversionHandler conversionHandler, Set<Integer> charCodes, PDFAErrorSetFont errorCodes, PDFFontType0 type0Font, HashSet<Integer> referencedCidset) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFCosParseException {
        block33: {
            PDFFontDescriptor fDesc;
            PDFType0FontEncoding cMap = type0Font.getEncoding();
            PDFCIDFont cidFont = type0Font.getDescendantFont();
            if (PDFFontUtils.isSubsetFont((PDFFont)type0Font) && (fDesc = cidFont.getFontDescriptor()) != null) {
                PDFCosFontDescriptor desc = fDesc.getPDFCosDescriptor();
                if (desc != null) {
                    FontProcessor.setTypeErrorCodes(desc.getCosDictionary(), ASName.k_FontDescriptor, conversionHandler, errorCodes, PDFAFontErrorCode.typeIncorrectInFontDescriptor, PDFAFontErrorCode.typeAbsentInFontDescriptor);
                }
                PDFCIDSet cidSet = fDesc.getCIDSet();
                PDFType0FontEncoding pdfType0FontEncoding = type0Font.getEncoding();
                if (pdfType0FontEncoding != null) {
                    for (Integer charCode : charCodes) {
                        referencedCidset.add(pdfType0FontEncoding.getCID(charCode.intValue()));
                    }
                }
                if (cidSet == null) {
                    errorCodes.addErrorCode(PDFAFontErrorCode.missingOrIncompleteCIDSet);
                } else {
                    InputByteStream cidStream = cidSet.getCosStream().getStreamDecoded();
                    boolean isCMapIdentity = PDFFontUtils.isCMapIdentity((PDFType0FontEncoding)cMap);
                    try {
                        if (!isCMapIdentity && type0Font.getDescendantFont().getSubType() != ASName.k_CIDFontType0 && type0Font.getDescendantFont().getSubType() != ASName.k_CIDFontType2) break block33;
                        int cidSetLength = (int)cidStream.length();
                        byte[] cidByteData = new byte[cidSetLength];
                        cidStream.read(cidByteData);
                        Font afeFont = type0Font.getAFEFont();
                        if (afeFont == null) {
                            return;
                        }
                        PDFFontDescription fontDesc = afeFont.getPDFFontDescription();
                        if (fontDesc == null) {
                            return;
                        }
                        HashSet<Integer> cidHashSet = new HashSet<Integer>();
                        int numGlyphs = fontDesc.getNumGlyphs();
                        for (int i = 0; i < numGlyphs; ++i) {
                            int cid = fontDesc.getROS() == null ? i : fontDesc.getGlyphCid(i);
                            cidHashSet.add(cid);
                        }
                        for (int cid : referencedCidset) {
                            int cidByte = cid / 8;
                            if (cidByte >= cidSetLength) {
                                errorCodes.addErrorCode(PDFAFontErrorCode.missingOrIncompleteCIDSet);
                            } else {
                                byte cidBit = (byte)(1 << 7 - cid % 8);
                                if ((cidByteData[cidByte] & cidBit) != 0 || !cidHashSet.contains(new Integer(cid)) || cid == 0) continue;
                                errorCodes.addErrorCode(PDFAFontErrorCode.missingOrIncompleteCIDSet);
                            }
                            break;
                        }
                    }
                    catch (IOException e) {
                        errorCodes.addErrorCode(PDFAFontErrorCode.pdfGeneralFailure);
                    }
                    catch (FontEngineException e3) {
                        errorCodes.addErrorCode(PDFAFontErrorCode.fontDataCorrupt);
                    }
                    finally {
                        try {
                            cidStream.close();
                        }
                        catch (IOException e) {
                            errorCodes.addErrorCode(PDFAFontErrorCode.pdfGeneralFailure);
                        }
                    }
                }
            }
        }
    }

    static PDFAErrorSetFont embedType0Font(PDFFontType0 font, UnembeddedFontInfo ufInfo, PDFAConversionHandler conversionHandler, Map<ASName, CosStream> cMapsEmbedded, FontContext fontContext) throws PDFIOException, PDFSecurityException, PDFInvalidDocumentException, FontEngineException, PDFInvalidParameterException {
        if (ufInfo == null) {
            return new PDFAErrorSetFont();
        }
        PDFAErrorSetFont errorCodes = ufInfo.getError();
        if (font == null) {
            return errorCodes;
        }
        boolean isEmbedded = false;
        boolean[] isEmbeddedResult = new boolean[1];
        Subset[] fontSubsetResult = new Subset[1];
        int[] cidArray = null;
        int[] gidArray = null;
        Subset fontSubset = null;
        try {
            Map<Integer, int[]> charcodeCidGidMap = ufInfo.getLastFontInfo() == null ? ufInfo.getCharcodeCidGidMap() : ufInfo.getLastFontInfo().getCharcodeCidGidMap();
            cidArray = new int[charcodeCidGidMap.size()];
            gidArray = new int[charcodeCidGidMap.size()];
            if (!FontProcessorUtils.embedType0Font(ufInfo, font, fontContext, charcodeCidGidMap, cidArray, gidArray, isEmbeddedResult, fontSubsetResult)) {
                return errorCodes;
            }
            fontSubset = fontSubsetResult[0];
            isEmbedded = isEmbeddedResult[0];
            if (FontProcessor.isSetErrorFlag(errorCodes, PDFAFontErrorCode.mismatchedWidthsInfo) || FontProcessor.isSetErrorFlag(errorCodes, PDFAFontErrorCode.missingOrIncompleteWidthsArray)) {
                FontProcessor.unSetErrorFlag(errorCodes, PDFAFontErrorCode.mismatchedWidthsInfo);
                FontProcessor.unSetErrorFlag(errorCodes, PDFAFontErrorCode.missingOrIncompleteWidthsArray);
                if (!conversionHandler.widthsMetricsUpdated((PDFFont)font)) {
                    return null;
                }
            }
        }
        catch (IOException e) {
            throw new PDFInvalidDocumentException((Throwable)e);
        }
        if (conversionHandler != null) {
            if ((FontProcessor.isSetErrorFlag(errorCodes, PDFAFontErrorCode.CMapNotEmbedded) || FontProcessor.isSetErrorFlag(errorCodes, PDFAFontErrorCode.predefinedCMapNotIdentityHOrIdentityV)) && Type0FontProcessor.embedCMap(font, cMapsEmbedded)) {
                FontProcessor.unSetErrorFlag(errorCodes, PDFAFontErrorCode.CMapNotEmbedded);
                FontProcessor.unSetErrorFlag(errorCodes, PDFAFontErrorCode.predefinedCMapNotIdentityHOrIdentityV);
                if (!conversionHandler.cMapEmbeddedInType0Font((PDFFont)font)) {
                    return null;
                }
            }
            if (FontProcessor.isSetErrorFlag(errorCodes, PDFAFontErrorCode.mismatchedCMapWModes) && PDFFontUtils.setWModeInEmbeddedCMap((PDFFontType0)font)) {
                FontProcessor.unSetErrorFlag(errorCodes, PDFAFontErrorCode.mismatchedCMapWModes);
                if (!conversionHandler.wModeUpdatedInType0Font((PDFFont)font)) {
                    return null;
                }
            }
            if (isEmbedded) {
                boolean success;
                if (FontProcessor.isSetErrorFlag(errorCodes, PDFAFontErrorCode.fontNotEmbedded)) {
                    FontProcessor.unSetErrorFlag(errorCodes, PDFAFontErrorCode.fontNotEmbedded);
                    if (!conversionHandler.fontEmbedded((PDFFont)font)) {
                        return null;
                    }
                }
                if (FontProcessor.isSetErrorFlag(errorCodes, PDFAFontErrorCode.openTypeFontEmbeddingNotAllowed)) {
                    FontProcessor.unSetErrorFlag(errorCodes, PDFAFontErrorCode.openTypeFontEmbeddingNotAllowed);
                    if (!conversionHandler.openTypeFontReEmbedded((PDFFont)font)) {
                        return null;
                    }
                }
                if ((success = FontProcessorUtils.embedCIDSet(font, ufInfo, fontSubset, cidArray)) && FontProcessor.isSetErrorFlag(errorCodes, PDFAFontErrorCode.missingOrIncompleteCIDSet)) {
                    FontProcessor.unSetErrorFlag(errorCodes, PDFAFontErrorCode.missingOrIncompleteCIDSet);
                    if (!conversionHandler.CIDSetUpdatedInType0Font((PDFFont)font)) {
                        return null;
                    }
                }
                if ((success = FontProcessorUtils.embedCIDToGIDMap(font, cidArray, gidArray, ufInfo)) && (FontProcessor.isSetErrorFlag(errorCodes, PDFAFontErrorCode.type2CIDFontInvalidCIDToGIDMap) || FontProcessor.isSetErrorFlag(errorCodes, PDFAFontErrorCode.type2CIDFontMissingCIDToGIDMap))) {
                    FontProcessor.unSetErrorFlag(errorCodes, PDFAFontErrorCode.type2CIDFontInvalidCIDToGIDMap);
                    FontProcessor.unSetErrorFlag(errorCodes, PDFAFontErrorCode.type2CIDFontMissingCIDToGIDMap);
                    if (!conversionHandler.CIDToGIDMapUpdatedInType0Font((PDFFont)font)) {
                        return null;
                    }
                }
            }
        }
        return errorCodes;
    }

    static PDFAErrorSetFont embedTrueTypeAsType0Font(PDFFontSimple simpleFont, UnembeddedFontInfo ufInfo, PDFAConversionHandler conversionHandler, Set<Integer> charCodes, FontContext fontContext) throws PDFIOException, PDFSecurityException, PDFInvalidDocumentException, FontEngineException, PDFInvalidParameterException {
        if (ufInfo == null) {
            return new PDFAErrorSetFont();
        }
        PDFAErrorSetFont errorCodes = ufInfo.getError();
        Font afeFont = simpleFont.getAFEFont();
        if (afeFont == null) {
            return errorCodes;
        }
        PDFFontDescription afeFontDesc = afeFont.getPDFFontDescription();
        if (afeFontDesc == null) {
            return errorCodes;
        }
        HashMap<Integer, Integer> charCodeGidMap = new HashMap<Integer, Integer>();
        for (Integer charcode : charCodes) {
            try {
                charCodeGidMap.put(charcode, simpleFont.charCode2gid(charcode.intValue()));
            }
            catch (PDFFontException e) {
                return ufInfo.getError();
            }
        }
        if (charCodeGidMap.size() <= 0) {
            return errorCodes;
        }
        int[] cidArray = new int[charCodeGidMap.size()];
        int[] gidArray = new int[charCodeGidMap.size()];
        boolean isEmbedded = false;
        boolean[] isEmbeddedResult = new boolean[1];
        Subset[] fontSubsetResult = new Subset[1];
        Subset fontSubset = null;
        if (!FontProcessorUtils.embedSimpleFontsAsType0Font(ufInfo, simpleFont, fontContext, isEmbeddedResult, fontSubsetResult, charCodes, cidArray, gidArray, charCodeGidMap)) {
            return errorCodes;
        }
        fontSubset = fontSubsetResult[0];
        isEmbedded = isEmbeddedResult[0];
        if (conversionHandler != null && isEmbedded) {
            boolean success;
            PDFFontType0 font = (PDFFontType0)PDFFontFactory.getInstance((CosObject)simpleFont.getCosObject());
            if (FontProcessor.isSetErrorFlag(errorCodes, PDFAFontErrorCode.fontNotEmbedded)) {
                FontProcessor.unSetErrorFlag(errorCodes, PDFAFontErrorCode.fontNotEmbedded);
                if (!conversionHandler.fontEmbedded((PDFFont)font)) {
                    return null;
                }
            }
            if (FontProcessor.isSetErrorFlag(errorCodes, PDFAFontErrorCode.trueTypeEmbeddedFontCouldNotMapGlyph)) {
                FontProcessor.unSetErrorFlag(errorCodes, PDFAFontErrorCode.trueTypeEmbeddedFontCouldNotMapGlyph);
            }
            if (FontProcessor.isSetErrorFlag(errorCodes, PDFAFontErrorCode.symbolicTrueTypeEncodingNotAllowed)) {
                FontProcessor.unSetErrorFlag(errorCodes, PDFAFontErrorCode.symbolicTrueTypeEncodingNotAllowed);
            }
            if (!(success = FontProcessorUtils.embedCIDSet(font, ufInfo, fontSubset, cidArray))) {
                errorCodes.addErrorCode(PDFAFontErrorCode.fontEmbeddingFailure);
            }
            if (!(success = FontProcessorUtils.embedCIDToGIDMap(font, cidArray, gidArray, ufInfo))) {
                errorCodes.addErrorCode(PDFAFontErrorCode.fontEmbeddingFailure);
            }
        }
        return errorCodes;
    }

    private static CosStream getCMapStream(CosDocument cosDoc, ASName cmapName, Map<ASName, CosStream> cMapsEmbedded) throws PDFIOException, PDFSecurityException, PDFInvalidDocumentException {
        if (cMapsEmbedded.containsKey(cmapName)) {
            return cMapsEmbedded.get(cmapName);
        }
        CMapObject preDef = PDFCMap.getCMapObjectForName((String)cmapName.asString());
        CosStream cmapObj = preDef.getCMapStream(cosDoc, true);
        cMapsEmbedded.put(cmapName, cmapObj);
        return cmapObj;
    }

    private static boolean embedCMap(PDFFontType0 type0Font, Map<ASName, CosStream> cMapsEmbedded) throws PDFIOException, PDFSecurityException, PDFInvalidDocumentException {
        PDFType0FontEncoding cMap = type0Font.getEncoding();
        CosDocument cosDoc = type0Font.getCosObject().getDocument();
        if (cMap == null) {
            return true;
        }
        if (!cMap.isPredefinedCMap() && cMap.getCosObject().getType() == 7) {
            PDFType0FontEncoding useCMap = cMap.getUseCMap();
            if (useCMap == null || useCMap.getCosObject().getType() == 7 || useCMap.getCMapName() == ASName.k_Identity_H || useCMap.getCMapName() == ASName.k_Identity_V) {
                return false;
            }
            cMap.getCosStream().put(ASName.k_UseCMap, (CosObject)Type0FontProcessor.getCMapStream(cosDoc, useCMap.getCMapName(), cMapsEmbedded));
            return true;
        }
        ASName cmapName = cMap.getCMapName();
        if (cmapName == ASName.k_Identity_H || cmapName == ASName.k_Identity_V) {
            return false;
        }
        type0Font.getCosDictionary().put(ASName.k_Encoding, (CosObject)Type0FontProcessor.getCMapStream(cosDoc, cmapName, cMapsEmbedded));
        return PDFFontUtils.setWModeInEmbeddedCMap((PDFFontType0)type0Font);
    }
}

