/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.pdfa.font;

import com.adobe.fontengine.FontEngineException;
import com.adobe.fontengine.font.Font;
import com.adobe.fontengine.font.FontData;
import com.adobe.internal.pdftoolkit.core.cos.CosStream;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFFont;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFFontSimple;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFFontType0;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.impl.PDFFontUtils;
import com.adobe.internal.pdftoolkit.services.pdfa.PDFAConversionHandler;
import com.adobe.internal.pdftoolkit.services.pdfa.PDFAErrorSetFont;
import com.adobe.internal.pdftoolkit.services.pdfa.PDFAValidationHandler;
import com.adobe.internal.pdftoolkit.services.pdfa.error.PDFAErrorCode;
import com.adobe.internal.pdftoolkit.services.pdfa.error.PDFAFontErrorCode;
import com.adobe.internal.pdftoolkit.services.pdfa.font.FontContext;
import com.adobe.internal.pdftoolkit.services.pdfa.font.FontProcessor;
import com.adobe.internal.pdftoolkit.services.pdfa.font.ReferencedFontInfoProcessor;
import com.adobe.internal.pdftoolkit.services.pdfa.font.TrueTypeFontProcessor;
import com.adobe.internal.pdftoolkit.services.pdfa.font.Type0FontProcessor;
import com.adobe.internal.pdftoolkit.services.pdfa.font.Type1FontProcessor;
import com.adobe.internal.pdftoolkit.services.pdfa.font.UnembeddedFontInfo;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class FontEmbedder {
    private static PDFAErrorSetFont embedFont(PDFFont font, UnembeddedFontInfo ufInfo, PDFAConversionHandler conversionHandler, Map<ASName, CosStream> cMapsEmbedded, FontContext fontContext) throws PDFIOException, PDFSecurityException, PDFInvalidDocumentException, PDFInvalidParameterException {
        PDFAErrorSetFont errorCodes = ufInfo.getError();
        try {
            Font afeFont = font.getAFEFont();
            if (afeFont == null) {
                errorCodes.addErrorCode(PDFAFontErrorCode.fontEmbeddingFailedFontNotInFontSet);
                return errorCodes;
            }
            if (!afeFont.canEmbedForPrintAndPreview()) {
                errorCodes.addErrorCode(PDFAFontErrorCode.fontEmbeddingFailedPermissionError);
                return errorCodes;
            }
            int fontDataType = ufInfo.getFontDataType();
            if (FontProcessor.willEmbedSimpleFontsAsType0(font, errorCodes)) {
                errorCodes = Type0FontProcessor.embedTrueTypeAsType0Font((PDFFontSimple)font, ufInfo, conversionHandler, fontContext.getCharCodesForSimpleFonts((PDFFontSimple)font), fontContext);
            } else if (fontDataType == 0) {
                errorCodes = Type0FontProcessor.embedType0Font((PDFFontType0)font, ufInfo, conversionHandler, cMapsEmbedded, fontContext);
            } else if (fontDataType == 1) {
                errorCodes = Type1FontProcessor.embedType1Font((PDFFontSimple)font, ufInfo, conversionHandler, fontContext);
            } else if (fontDataType == 2) {
                errorCodes = TrueTypeFontProcessor.embedTrueTypeFont((PDFFontSimple)font, ufInfo, conversionHandler, fontContext);
            }
        }
        catch (FontEngineException e) {
            errorCodes.addErrorCode(PDFAFontErrorCode.fontDataCorrupt);
        }
        return errorCodes;
    }

    public static boolean processUnembeddedFonts(FontContext fontContext, PDFAConversionHandler conversionHandler, PDFAValidationHandler validationHandler) throws PDFIOException, PDFSecurityException, PDFInvalidDocumentException {
        Map<PDFFont, UnembeddedFontInfo> unembeddedFonts = fontContext.getUnembeddedFonts();
        Map<ASName, CosStream> cmapsEmbedded = fontContext.getCMapsEmbedded();
        if (!unembeddedFonts.isEmpty()) {
            PDFAErrorSetFont errorCodes;
            UnembeddedFontInfo ufInfo;
            PDFFont font;
            for (Map.Entry<PDFFont, UnembeddedFontInfo> entry : unembeddedFonts.entrySet()) {
                int fontDataType;
                font = entry.getKey();
                if (fontContext.getFontsWithoutTextShowString().contains(font)) continue;
                ufInfo = entry.getValue();
                errorCodes = ufInfo.getError();
                FontData fontData = font.getAFEFontData();
                if (errorCodes.hasErrors() && (conversionHandler == null || fontData == null)) {
                    if (FontEmbedder.reportErrors(validationHandler, ufInfo.getName(), font, errorCodes)) continue;
                    return false;
                }
                UnembeddedFontInfo lastFontufInfo = ufInfo.getLastFontInfo();
                PDFFont lastFontInMap = ufInfo.getLastFontInstance();
                if (lastFontufInfo == null) {
                    Iterator<PDFFont> fontIter2 = unembeddedFonts.keySet().iterator();
                    while (fontIter2.hasNext() && fontIter2.next() != font) {
                    }
                    lastFontInMap = font;
                    try {
                        while (fontIter2.hasNext()) {
                            PDFFont font2 = fontIter2.next();
                            if (font2.getAFEFont() != font.getAFEFont() || font2.getClass() != font.getClass()) continue;
                            boolean willEmbedFontasType0 = FontProcessor.willEmbedSimpleFontsAsType0(font, errorCodes);
                            boolean willEmbedFontasType2 = FontProcessor.willEmbedSimpleFontsAsType0(font2, unembeddedFonts.get(font2).getError());
                            if ((!willEmbedFontasType0 || !willEmbedFontasType2) && (willEmbedFontasType0 || willEmbedFontasType2)) continue;
                            lastFontInMap = font2;
                        }
                    }
                    catch (FontEngineException e) {
                        if (FontEmbedder.reportErrors(validationHandler, ufInfo.getName(), font, errorCodes)) continue;
                        return false;
                    }
                    lastFontufInfo = ufInfo;
                    if (lastFontInMap != font) {
                        lastFontufInfo = unembeddedFonts.get(lastFontInMap);
                    }
                }
                if (font instanceof PDFFontSimple) {
                    if (FontProcessor.willEmbedSimpleFontsAsType0(font, errorCodes)) {
                        fontDataType = 0;
                    } else if (PDFFontUtils.isFontDataTrueType((FontData)fontData)) {
                        Set<String> postNames;
                        fontDataType = 2;
                        Set<Integer> codePoints = lastFontufInfo.getCodePoints();
                        PDFAErrorCode err = ReferencedFontInfoProcessor.getReferencedCPsPostNames((PDFFontSimple)font, ufInfo, codePoints, postNames = lastFontufInfo.getPostNames());
                        if (err != null) {
                            errorCodes.addErrorCode(err);
                            ufInfo.setLastFontInstance(null);
                            ufInfo.setLastFontInfo(null);
                            if (FontEmbedder.reportErrors(validationHandler, ufInfo.getName(), font, errorCodes)) continue;
                            return false;
                        }
                        lastFontufInfo.setCodePoints(codePoints);
                        lastFontufInfo.setPostNames(postNames);
                    } else {
                        fontDataType = 1;
                        Set<String> glyphNames = lastFontufInfo.getGlyphNames();
                        PDFAErrorCode err = ReferencedFontInfoProcessor.getReferencedCharNames((PDFFontSimple)font, ufInfo, glyphNames);
                        if (err != null) {
                            errorCodes.addErrorCode(err);
                            ufInfo.setLastFontInstance(null);
                            ufInfo.setLastFontInfo(null);
                            if (FontEmbedder.reportErrors(validationHandler, ufInfo.getName(), font, errorCodes)) continue;
                            return false;
                        }
                        lastFontufInfo.setGlyphNames(glyphNames);
                    }
                } else {
                    fontDataType = 0;
                    Map<Integer, int[]> charcodeCidGidMap = lastFontufInfo.getCharcodeCidGidMap();
                    PDFAErrorCode err = ReferencedFontInfoProcessor.getReferencedCIDsGIDs((PDFFontType0)font, ufInfo, charcodeCidGidMap);
                    if (err != null) {
                        errorCodes.addErrorCode(err);
                        ufInfo.setLastFontInstance(null);
                        ufInfo.setLastFontInfo(null);
                        if (FontEmbedder.reportErrors(validationHandler, ufInfo.getName(), font, errorCodes)) continue;
                        return false;
                    }
                    lastFontufInfo.setCharcodeCidGidMap(charcodeCidGidMap);
                }
                ufInfo.setFontDataType(fontDataType);
                if (font == lastFontInMap) {
                    if (!validationHandler.beginFontScan(ufInfo.getName(), font)) {
                        return false;
                    }
                    try {
                        errorCodes = FontEmbedder.embedFont(font, ufInfo, conversionHandler, cmapsEmbedded, fontContext);
                    }
                    catch (PDFInvalidParameterException e) {
                        throw new PDFInvalidDocumentException((Throwable)e);
                    }
                    if (errorCodes.hasErrors() && !validationHandler.fontError(errorCodes)) {
                        return false;
                    }
                    if (validationHandler.endFontScan()) continue;
                    return false;
                }
                if (font == lastFontInMap) continue;
                ufInfo.setLastFontInstance(lastFontInMap);
                ufInfo.setLastFontInfo(lastFontufInfo);
            }
            for (Map.Entry<PDFFont, UnembeddedFontInfo> entry : unembeddedFonts.entrySet()) {
                font = entry.getKey();
                ufInfo = entry.getValue();
                if (ufInfo == null || ufInfo.getLastFontInstance() == null || ufInfo.getLastFontInstance() == font) continue;
                errorCodes = ufInfo.getError();
                if (!validationHandler.beginFontScan(ufInfo.getName(), font)) {
                    return false;
                }
                UnembeddedFontInfo lastUfInfo = unembeddedFonts.get(ufInfo.getLastFontInstance());
                ufInfo.setFontFile(lastUfInfo.getFontFile());
                ufInfo.setSubsetFontName(lastUfInfo.getSubsetFontName());
                try {
                    errorCodes = FontEmbedder.embedFont(font, ufInfo, conversionHandler, cmapsEmbedded, fontContext);
                }
                catch (PDFInvalidParameterException e) {
                    throw new PDFInvalidDocumentException((Throwable)e);
                }
                if (errorCodes.hasErrors() && !validationHandler.fontError(errorCodes)) {
                    return false;
                }
                if (validationHandler.endFontScan()) continue;
                return false;
            }
        }
        unembeddedFonts.clear();
        return true;
    }

    private static boolean reportErrors(PDFAValidationHandler validationHandler, ASName fontName, PDFFont font, PDFAErrorSetFont errorCodes) {
        if (!validationHandler.beginFontScan(fontName, font)) {
            return false;
        }
        if (!validationHandler.fontError(errorCodes)) {
            return false;
        }
        return validationHandler.endFontScan();
    }
}

