/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.pdfa.common;

import com.adobe.internal.pdftoolkit.core.exceptions.PDFFontException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASArray;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.core.types.ASNumber;
import com.adobe.internal.pdftoolkit.core.types.ASObject;
import com.adobe.internal.pdftoolkit.core.types.ASString;
import com.adobe.internal.pdftoolkit.pdf.content.Content;
import com.adobe.internal.pdftoolkit.pdf.content.Instruction;
import com.adobe.internal.pdftoolkit.pdf.content.InstructionFactory;
import com.adobe.internal.pdftoolkit.pdf.content.OperandStack;
import com.adobe.internal.pdftoolkit.pdf.content.XObjectsCycleDetector;
import com.adobe.internal.pdftoolkit.pdf.contentmodify.IContentStreamFilter;
import com.adobe.internal.pdftoolkit.pdf.contentmodify.impl.ContentStreamFilterImpl;
import com.adobe.internal.pdftoolkit.pdf.contentmodify.impl.ContentStreamTransformer;
import com.adobe.internal.pdftoolkit.pdf.document.PDFContents;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.document.PDFResources;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFFont;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.impl.PDFCMapUtils;
import com.adobe.internal.pdftoolkit.pdf.graphics.xobject.PDFXObject;
import com.adobe.internal.pdftoolkit.pdf.graphics.xobject.PDFXObjectForm;
import com.adobe.internal.pdftoolkit.pdf.graphics.xobject.PDFXObjectMap;
import com.adobe.internal.pdftoolkit.services.pdfa.common.CharacterWidthHolder;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Stack;

public class TextLayoutPreservingFilter
extends ContentStreamFilterImpl {
    private Map<PDFFont, CharacterWidthHolder> fontWidthMap;
    private Stack<PDFResources> resourcesStack;
    private PDFResources baseResources;
    private XObjectsCycleDetector xobjectsCycleDetector;
    private Stack<PDFFont> fontStack;
    private PDFFont currentFont;

    public TextLayoutPreservingFilter(Map<PDFFont, CharacterWidthHolder> fontWidthMap, Content content) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.fontWidthMap = fontWidthMap;
        this.resourcesStack = new Stack();
        this.resourcesStack.push(content.getResources());
        this.fontStack = new Stack();
        this.xobjectsCycleDetector = XObjectsCycleDetector.getInstance((PDFDocument)content.getResources().getPDFDocument());
    }

    public void Tf(ASName fontName, double fontSize, Instruction instruction) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.currentFont = this.resourcesStack.peek().getFontMap().get(fontName);
        super.Tf(fontName, fontSize, instruction);
    }

    public void TJ(ASArray array, Instruction instruction) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (array == null || array.isEmpty()) {
            return;
        }
        OperandStack newOS = new OperandStack();
        ASArray newArr = new ASArray();
        boolean streamChanged = false;
        for (ASObject o : array) {
            if (o instanceof ASNumber) {
                int lastIndex = newArr.size() - 1;
                if (lastIndex >= 0 && newArr.get(lastIndex) instanceof ASNumber) {
                    double sum = ((ASNumber)newArr.get(lastIndex)).doubleValue() + ((ASNumber)o).doubleValue();
                    newArr.set(lastIndex, (ASObject)new ASNumber(sum));
                    streamChanged = true;
                    continue;
                }
                newArr.add(o);
                continue;
            }
            if (!(o instanceof ASString)) continue;
            OperandStack stack = this.createNewOperands((ASString)o);
            if (stack == null) {
                newArr.add(o);
                continue;
            }
            streamChanged = true;
            newArr.addAll((Collection)stack.popArray());
        }
        newOS.pushArray(newArr);
        if (streamChanged) {
            super.TJ(newArr, new Instruction(newOS, ASName.k_TJ));
        } else {
            super.TJ(array, instruction);
        }
    }

    public void Tj(ASString string, Instruction instruction) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (string == null || string.getBytes() == null || string.getBytes().length == 0) {
            return;
        }
        OperandStack newOS = this.createNewOperands(string);
        if (newOS != null) {
            super.TJ(newOS.peekArray(), new Instruction(newOS, ASName.k_TJ));
        } else {
            super.Tj(string, instruction);
        }
    }

    public void SingleQuote(ASString string, Instruction instruction) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (string == null || string.getBytes() == null || string.getBytes().length == 0) {
            return;
        }
        this.Tj(string, InstructionFactory.newShowText((ASString)string));
    }

    public void DoubleQuote(double wordSpacing, double charSpacing, ASString string, Instruction instruction) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (string == null || string.getBytes() == null || string.getBytes().length == 0) {
            return;
        }
        this.Tw(wordSpacing, InstructionFactory.newWordSpacing((double)wordSpacing));
        this.Tc(charSpacing, InstructionFactory.newCharactorSpacing((double)charSpacing));
        this.Tj(string, InstructionFactory.newShowText((ASString)string));
    }

    public void Q(Instruction instruction) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.currentFont = this.fontStack.pop();
        if (this.operatorHandler != null) {
            this.operatorHandler.Q(instruction);
        }
    }

    public void q(Instruction instruction) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.fontStack.push(this.currentFont);
        if (this.operatorHandler != null) {
            this.operatorHandler.q(instruction);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void Do(ASName name, Instruction instruction) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFXObject object = null;
        PDFResources xobjectsResources = this.resourcesStack.peek();
        PDFResources pageResources = this.baseResources;
        if (pageResources == null) {
            super.Do(name, instruction);
            return;
        }
        if (xobjectsResources == null) {
            object = pageResources.getXObjectMap().get(name);
        } else {
            PDFXObjectMap xObjectMap = xobjectsResources.getXObjectMap();
            if (xObjectMap == null || (object = xObjectMap.get(name)) == null) {
                if (pageResources.getXObjectMap() == null) {
                    super.Do(name, instruction);
                }
                object = pageResources.getXObjectMap().get(name);
            }
        }
        if (object instanceof PDFXObjectForm) {
            PDFXObjectForm xobject = (PDFXObjectForm)object;
            this.resourcesStack.push(xobject.getResources());
            if (this.xobjectsCycleDetector.cycleDetected(object)) {
                throw new PDFInvalidDocumentException("Cyclic dependency found while processing xobjects.");
            }
            this.xobjectsCycleDetector.push(object);
            try {
                Content xobjectCOntent = Content.newInstance((PDFContents)xobject.getContents(), (PDFResources)xobject.getResources());
                TextLayoutPreservingFilter filter = new TextLayoutPreservingFilter(this.fontWidthMap, xobjectCOntent);
                try {
                    ContentStreamTransformer.transformContent((Content)xobjectCOntent, (IContentStreamFilter)filter);
                }
                catch (PDFFontException e) {
                    throw new PDFInvalidDocumentException((Throwable)e);
                }
            }
            finally {
                this.xobjectsCycleDetector.pop();
            }
            this.resourcesStack.pop();
        }
        super.Do(name, instruction);
    }

    private OperandStack createNewOperands(ASString str) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.currentFont == null || str == null) {
            return null;
        }
        OperandStack newOS = new OperandStack();
        boolean widthsChanged = false;
        List charCodes = this.currentFont.getCharCodes(str.getBytes(), false);
        boolean charsSkipped = false;
        CharacterWidthHolder widthsHolder = this.fontWidthMap.get(this.currentFont);
        if (widthsHolder == null) {
            return null;
        }
        ASArray array = new ASArray();
        for (List charCodeInfo : charCodes) {
            byte[] charCodeBytes = (byte[])charCodeInfo.get(0);
            if (charCodeBytes == null) {
                int notDefWidth = (int)this.currentFont.getFontDescriptor().getMissingWidth();
                if (notDefWidth != 0) {
                    array.add((ASObject)new ASNumber(-1 * notDefWidth));
                }
                charsSkipped = true;
                continue;
            }
            int charCode = (int)PDFCMapUtils.getCharCode((byte[])charCodeBytes);
            int width = widthsHolder.getWidthDifference(charCode);
            if (width != 0) {
                widthsChanged = true;
                array.add((ASObject)new ASString(charCodeBytes));
                array.add((ASObject)new ASNumber(-1 * width));
                continue;
            }
            array.add((ASObject)new ASString(charCodeBytes));
        }
        newOS.pushArray(array);
        return widthsChanged || charsSkipped ? newOS : null;
    }
}

