/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.pdfa.common;

import com.adobe.internal.io.stream.InputByteStream;
import com.adobe.internal.pdftoolkit.core.cos.CosStream;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.core.types.ASString;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.document.PDFStream;
import com.adobe.internal.pdftoolkit.pdf.filters.PDFFilter;
import com.adobe.internal.pdftoolkit.pdf.filters.PDFFilterFlate;
import com.adobe.internal.pdftoolkit.pdf.filters.PDFFilterList;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFCIDSystemInfo;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFFontType0;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFType0FontEncoding;
import com.adobe.internal.pdftoolkit.services.fontresources.subsetting.SubsetUtils;
import java.io.IOException;
import java.util.TreeMap;

public class PDFAType0EncodingBuilder {
    private String encodingName;
    private PDFFontType0 pdfFont;
    private int[] charcodes;

    public PDFAType0EncodingBuilder(PDFFontType0 pdfFont, int[] charcodes) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.encodingName = PDFAType0EncodingBuilder.getEncodingName(pdfFont);
        this.pdfFont = pdfFont;
        this.charcodes = charcodes;
    }

    public PDFCIDSystemInfo createSystemInfo() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFCIDSystemInfo.newInstance((PDFDocument)this.pdfFont.getPDFDocument(), (ASString)new ASString("Gibson"), (ASString)new ASString(this.encodingName), (int)0);
    }

    static String getEncodingName(PDFFontType0 pdfFont) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return pdfFont.getBaseFont().asString();
    }

    private TreeMap<Integer, Integer> getTreeMap(int[] charcodes) {
        TreeMap<Integer, Integer> map = new TreeMap<Integer, Integer>();
        int[] arr$ = charcodes;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            Integer charcode;
            map.put(charcode, (charcode = Integer.valueOf(arr$[i$])) > 255 ? 2 : 1);
        }
        return map;
    }

    public PDFType0FontEncoding createUpdatedCMap() throws PDFIOException, PDFSecurityException, IOException, PDFInvalidDocumentException {
        TreeMap<Integer, Integer> charCodesMap = this.getTreeMap(this.charcodes);
        InputByteStream ibs = SubsetUtils.createUpdatedCMap((PDFDocument)this.pdfFont.getPDFDocument(), null, charCodesMap, (String)this.encodingName, (String)"Gibson", (String)this.encodingName, (int)0);
        PDFStream stream = PDFStream.newInstance((PDFDocument)this.pdfFont.getPDFDocument());
        stream.setStreamData(ibs.toInputStream());
        PDFFilterFlate filter = PDFFilterFlate.newInstance((PDFDocument)this.pdfFont.getPDFDocument(), null);
        PDFFilterList outputFilters = stream.procureOutputFilters();
        outputFilters.add((PDFFilter)filter);
        stream.setOutputFilters(outputFilters);
        CosStream cosstream = stream.getCosStream();
        cosstream.put(ASName.k_CMapName, ASName.create((String)this.encodingName));
        cosstream.put(ASName.k_CIDSystemInfo, this.createSystemInfo().getCosObject());
        return PDFType0FontEncoding.newInstance((CosStream)stream.getCosStream());
    }
}

