/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.pdfa.common;

import com.adobe.fontengine.FontEngineException;
import com.adobe.fontengine.font.Font;
import com.adobe.fontengine.font.FontData;
import com.adobe.fontengine.font.FontImpl;
import com.adobe.fontengine.font.FontLoadingException;
import com.adobe.fontengine.font.InvalidFontException;
import com.adobe.fontengine.font.PDFFontDescription;
import com.adobe.fontengine.font.ROS;
import com.adobe.fontengine.font.Subset;
import com.adobe.fontengine.font.UnsupportedFontException;
import com.adobe.fontengine.font.opentype.Cmap;
import com.adobe.fontengine.font.opentype.OpenTypeFont;
import com.adobe.internal.io.ByteWriterFactory;
import com.adobe.internal.io.stream.InputByteStream;
import com.adobe.internal.io.stream.OutputByteStream;
import com.adobe.internal.pdftoolkit.core.cos.CosArray;
import com.adobe.internal.pdftoolkit.core.cos.CosDictionary;
import com.adobe.internal.pdftoolkit.core.cos.CosDocument;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.cos.CosStream;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFFontException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.core.types.ASString;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.document.PDFResources;
import com.adobe.internal.pdftoolkit.pdf.filters.PDFFilterFlate;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFCIDFont;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFCIDFontWidths;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFCIDSystemInfo;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFCharProcs;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFFont;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFFontDescriptor;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFFontFile;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFFontMap;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFFontSimple;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFFontType0;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFFontType3;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFSimpleFontEncoding;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFToUnicodeCMap;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFType0FontEncoding;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.encodings.CharSetEncoding;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.encodings.WinAnsiEncoding;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.impl.AdobeGlyphList;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.impl.PDFFontUtils;
import com.adobe.internal.pdftoolkit.pdf.graphics.patterns.PDFPattern;
import com.adobe.internal.pdftoolkit.pdf.graphics.patterns.PDFPatternMap;
import com.adobe.internal.pdftoolkit.pdf.graphics.patterns.PDFPatternTiling;
import com.adobe.internal.pdftoolkit.pdf.graphics.xobject.PDFXObject;
import com.adobe.internal.pdftoolkit.pdf.graphics.xobject.PDFXObjectForm;
import com.adobe.internal.pdftoolkit.pdf.graphics.xobject.PDFXObjectMap;
import com.adobe.internal.pdftoolkit.pdf.page.PDFPage;
import com.adobe.internal.pdftoolkit.services.fontresources.FontResources;
import com.adobe.internal.pdftoolkit.services.fontresources.PlaceHolderCompositeFontBuilder;
import com.adobe.internal.pdftoolkit.services.pdfa.common.BaseFontContext;
import com.adobe.internal.pdftoolkit.services.pdfa.common.BaseUnembeddedFontInfo;
import com.adobe.internal.pdftoolkit.services.pdfa.common.CharacterWidthHolder;
import com.adobe.internal.pdftoolkit.services.pdfa.common.CharacterWidthHolderSimpleFont;
import com.adobe.internal.pdftoolkit.services.pdfa.common.CharacterWidthHolderType0Font;
import com.adobe.internal.pdftoolkit.services.pdfa.common.PDFAType0EncodingBuilder;
import com.adobe.internal.pdftoolkit.services.pdfa.common.TrueTypeCmapSelector;
import com.adobe.internal.pdftoolkit.services.pdfa2.PDFA2ConformanceLevel;
import com.adobe.internal.pdftoolkit.services.pdfa2.PDFA2ConversionHandler;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.PDFA2ErrorSet;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.codes.PDFA2AbstractFontErrorCode;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.codes.PDFA2FontErrorTextNotMappedToUnicode;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.codes.PDFA2FontErrorToUnicodeHasZero;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.codes.PDFA2FontErrorUnicodeCMapInappropriateValues;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;

public class FontProcessorUtils {
    public static final double WIDTH_TOLERANCE = 1.0;

    public static boolean embedType0Font(BaseUnembeddedFontInfo ufInfo, PDFFontType0 font, BaseFontContext fontContext, Map<Integer, int[]> charcodeCidGidMap, int[] cidArray, int[] gidArray, boolean[] isEmbeddedResult, Subset[] subsetResult) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, FontLoadingException, InvalidFontException, UnsupportedFontException, IOException, PDFInvalidParameterException {
        String psFontName;
        boolean isEmbedded = PDFFontUtils.isFontEmbedded((PDFFont)font);
        boolean reEmbed = !isEmbedded || font.getDescendantFont().getSubType() != ASName.k_CIDFontType2;
        Subset fontSubset = null;
        boolean widthsChanged = false;
        Font afeFont = font.getAFEFont();
        if (afeFont == null) {
            return false;
        }
        PDFFontDescription afeFontDesc = afeFont.getPDFFontDescription();
        if (afeFontDesc == null) {
            return false;
        }
        PDFFontFile fontFile = null;
        PDFDocument pdfDocument = font.getPDFDocument();
        String string = psFontName = afeFontDesc.getBase14Name() != null ? afeFontDesc.getBase14Name() : afeFontDesc.getPostscriptName();
        if (psFontName == null) {
            psFontName = font.getBaseFont().toString();
        }
        ASName subsetFontName = null;
        PDFCIDFontWidths pdfCIDFontWidths = null;
        int dw = font.getDescendantFont().getDW();
        Subset subset = fontSubset = reEmbed ? afeFont.createSubset() : null;
        if (charcodeCidGidMap.size() <= 0) {
            return false;
        }
        Set<Map.Entry<Integer, int[]>> cidGidEntrySet = charcodeCidGidMap.entrySet();
        Iterator<Map.Entry<Integer, int[]>> iter = cidGidEntrySet.iterator();
        double[] dWidths = new double[1];
        pdfCIDFontWidths = PDFCIDFontWidths.newInstance((PDFDocument)pdfDocument);
        int i = 0;
        while (iter.hasNext()) {
            Map.Entry<Integer, int[]> cidgid = iter.next();
            int cid = cidgid.getValue()[0];
            int gid = cidgid.getValue()[1];
            int oldCid = cidgid.getKey();
            cidArray[i] = cid;
            gidArray[i] = gid;
            dWidths[0] = afeFontDesc.getAdvance(gid);
            if (Math.abs(dWidths[0] - (double)dw) > 1.0) {
                if (dWidths[0] != font.getGlyphWidthFromCID(cid)) {
                    widthsChanged = true;
                }
                pdfCIDFontWidths.addWidths(dWidths, cid, cid);
            }
            if (fontSubset != null) {
                gidArray[i] = fontSubset.getSubsetGid(gid);
            }
            ++i;
        }
        if (fontSubset != null) {
            OutputByteStream outStream = font.getStreamManager().getOutputByteStreamClearDocument(ByteWriterFactory.Fixed.GROWABLE, -1L);
            FontResources.getSubsettedCIDFontStream((Font)afeFont, (OutputStream)outStream.toOutputStream(), (Subset)fontSubset, (boolean)true);
            InputByteStream fontFileStream = outStream.closeAndConvert();
            outStream = null;
            fontFile = PDFFontFile.newInstance((PDFDocument)pdfDocument, (InputByteStream)fontFileStream);
            fontFileStream = null;
            subsetFontName = PDFFontUtils.generateSubsetFontName((Object)fontSubset, (String)psFontName);
            ufInfo.setFontFile((CosStream)fontFile.getCosObject());
            ufInfo.setSubsetFontName(subsetFontName);
            ufInfo.setCidFontWidths(pdfCIDFontWidths.getCosObject());
        }
        if (widthsChanged) {
            Map<PDFFont, CharacterWidthHolder> map = fontContext.getFontWidthMap();
            CharacterWidthHolderType0Font widthHolder = new CharacterWidthHolderType0Font();
            widthHolder.setPdfCIDFontWidths(pdfCIDFontWidths, font.getPDFCIDFontWidths());
            map.put((PDFFont)font, widthHolder);
        }
        if (fontFile != null) {
            PDFFontDescriptor fontDescriptor = PDFFontUtils.generatePDFFontDescriptor((PDFFont)font, (PDFFontDescription)afeFontDesc);
            fontDescriptor.setFontName(subsetFontName);
            PDFCIDFont cidFont = PDFFontUtils.createPDFCIDFont(fontFile, (PDFFontType0)font, (PDFFontDescription)afeFontDesc, (int)dw, (PDFCIDFontWidths)pdfCIDFontWidths, subsetFontName, (PDFFontDescriptor)fontDescriptor);
            PDFCIDFont oldCIDFont = font.getDescendantFont();
            ROS ros = afeFontDesc.getROS();
            if (ros != null) {
                PDFCIDSystemInfo pdfCIDSystemInfo = PDFCIDSystemInfo.newInstance((PDFDocument)pdfDocument, (ASString)new ASString(ros.registry), (ASString)new ASString(ros.ordering), (int)ros.supplement);
                cidFont.setCIDSystemInfo(pdfCIDSystemInfo);
            } else {
                cidFont.setDictionaryValue(ASName.k_CIDSystemInfo, (CosObject)oldCIDFont.getDictionaryDictionaryValue(ASName.k_CIDSystemInfo));
            }
            if (oldCIDFont.dictionaryContains(ASName.k_DW2)) {
                cidFont.setDictionaryArrayValue(ASName.k_DW2, oldCIDFont.getDictionaryArrayValue(ASName.k_DW2));
            }
            if (oldCIDFont.dictionaryContains(ASName.k_W2)) {
                cidFont.setDictionaryArrayValue(ASName.k_W2, oldCIDFont.getDictionaryArrayValue(ASName.k_W2));
            }
            font.setDescendantFont(cidFont);
            isEmbedded = true;
        } else {
            PDFCIDFont cidFont = font.getDescendantFont();
            cidFont.setDW(dw);
            cidFont.setW(pdfCIDFontWidths);
        }
        isEmbeddedResult[0] = isEmbedded;
        subsetResult[0] = fontSubset;
        return true;
    }

    public static boolean embedSimpleFontsAsType0Font(BaseUnembeddedFontInfo ufInfo, PDFFontSimple simpleFont, BaseFontContext fontContext, boolean[] isEmbeddedResult, Subset[] subsetResult, Set<Integer> charCodes, int[] cidArray, int[] gidArray, HashMap<Integer, Integer> charCodeGidMap) throws PDFIOException, PDFSecurityException, PDFInvalidDocumentException, FontEngineException, PDFInvalidParameterException {
        Subset fontSubset;
        boolean isEmbedded;
        block18: {
            Font afeFont = simpleFont.getAFEFont();
            if (afeFont == null) {
                return false;
            }
            PDFFontDescription afeFontDesc = afeFont.getPDFFontDescription();
            if (afeFontDesc == null) {
                return false;
            }
            CosDictionary dict = simpleFont.getCosDictionary();
            ASName origBaseFont = dict.getName(ASName.k_BaseFont);
            dict.clear();
            PlaceHolderCompositeFontBuilder bldr = new PlaceHolderCompositeFontBuilder(simpleFont.getPDFDocument());
            PDFFontType0 font = bldr.createType0FontFromDict(simpleFont.getAFEFont(), dict);
            isEmbedded = false;
            fontSubset = null;
            try {
                PDFFontFile fontFile = null;
                PDFDocument pdfDocument = font.getPDFDocument();
                String psFontName = afeFontDesc.getBase14Name() != null ? afeFontDesc.getBase14Name() : afeFontDesc.getPostscriptName();
                ASName baseFont = font.getBaseFont();
                if (baseFont == null) {
                    font.setBaseFont(origBaseFont);
                }
                if (psFontName == null) {
                    psFontName = font.getBaseFont().toString();
                }
                ASName subsetFontName = null;
                PDFCIDFontWidths pdfCIDFontWidths = PDFCIDFontWidths.newInstance((PDFDocument)pdfDocument);
                int dw = font.getDescendantFont().getDW();
                if (ufInfo.getLastFontInstance() == null) {
                    fontSubset = afeFont.createSubset();
                }
                Iterator<Map.Entry<Integer, Integer>> iter = charCodeGidMap.entrySet().iterator();
                double[] dWidths = new double[1];
                int i = 0;
                while (iter.hasNext()) {
                    Map.Entry<Integer, Integer> entry = iter.next();
                    int cid = entry.getKey();
                    int gid = entry.getValue();
                    cidArray[i] = cid;
                    gidArray[i] = gid;
                    dWidths[0] = afeFontDesc.getAdvance(gid);
                    if (Math.abs(dWidths[0] - (double)dw) > 1.0) {
                        pdfCIDFontWidths.addWidths(dWidths, cid, cid);
                    }
                    if (fontSubset != null) {
                        gidArray[i] = fontSubset.getSubsetGid(gid);
                    }
                    ++i;
                }
                if (ufInfo.getLastFontInstance() == null) {
                    if (fontSubset != null) {
                        OutputByteStream outStream = font.getStreamManager().getOutputByteStreamClearDocument(ByteWriterFactory.Fixed.GROWABLE, -1L);
                        FontResources.getSubsettedCIDFontStream((Font)afeFont, (OutputStream)outStream.toOutputStream(), (Subset)fontSubset, (boolean)true);
                        InputByteStream fontFileStream = outStream.closeAndConvert();
                        outStream = null;
                        fontFile = PDFFontFile.newInstance((PDFDocument)pdfDocument, (InputByteStream)fontFileStream);
                        fontFileStream = null;
                        subsetFontName = PDFFontUtils.generateSubsetFontName((Object)fontSubset, (String)psFontName);
                        ufInfo.setFontFile((CosStream)fontFile.getCosObject());
                        ufInfo.setSubsetFontName(subsetFontName);
                        ufInfo.setCidFontWidths(pdfCIDFontWidths.getCosObject());
                        ufInfo.setCharcodeCidGidMap(null);
                    }
                } else {
                    fontFile = PDFFontFile.getInstance((CosObject)ufInfo.getLastFontInfo().getFontFile());
                    subsetFontName = ufInfo.getLastFontInfo().getSubsetFontName();
                    pdfCIDFontWidths = PDFCIDFontWidths.getInstance((CosObject)ufInfo.getLastFontInfo().getCidFontWidths());
                }
                if (fontFile != null) {
                    PDFCIDFont cidFont;
                    PDFFilterFlate filter = PDFFilterFlate.newInstance((PDFDocument)fontFile.getPDFDocument(), null);
                    fontFile.setFilter(filter);
                    PDFFontDescriptor fontDescriptor = PDFFontUtils.generatePDFFontDescriptor((PDFFont)font, (PDFFontDescription)afeFontDesc);
                    if (!afeFontDesc.pdfFontIsTrueType()) {
                        try {
                            fontFile.setEmbeddedFontType(PDFFontFile.EmbeddedFontType.CIDFontType0C);
                        }
                        catch (PDFInvalidParameterException e) {
                            // empty catch block
                        }
                        fontDescriptor.setFontFile3(fontFile);
                        cidFont = PDFCIDFont.newInstance((PDFDocument)pdfDocument, (ASName)subsetFontName, (ASName)ASName.k_CIDFontType0);
                    } else {
                        fontDescriptor.setFontFile2(fontFile);
                        cidFont = PDFCIDFont.newInstance((PDFDocument)pdfDocument, (ASName)subsetFontName, (ASName)ASName.k_CIDFontType2);
                    }
                    cidFont.setDW(dw);
                    cidFont.setW(pdfCIDFontWidths);
                    PDFAType0EncodingBuilder cmapGenerator = new PDFAType0EncodingBuilder(font, cidArray);
                    cidFont.setCIDSystemInfo(cmapGenerator.createSystemInfo());
                    fontDescriptor.setFontName(subsetFontName);
                    cidFont.setFontDescriptor(fontDescriptor);
                    PDFType0FontEncoding encoding = cmapGenerator.createUpdatedCMap();
                    font.setEncoding(encoding);
                    font.setDescendantFont(cidFont);
                    isEmbedded = true;
                    break block18;
                }
                PDFCIDFont cidFont = font.getDescendantFont();
                cidFont.setDW(dw);
                cidFont.setW(pdfCIDFontWidths);
            }
            catch (IOException e) {
                throw new PDFInvalidDocumentException((Throwable)e);
            }
        }
        isEmbeddedResult[0] = isEmbedded;
        subsetResult[0] = fontSubset;
        return isEmbedded;
    }

    public static boolean embedCIDToGIDMap(PDFFontType0 type0Font, int[] cidArray, int[] gidArray, BaseUnembeddedFontInfo ufInfo) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, FontEngineException {
        PDFCIDFont cidFont = type0Font.getDescendantFont();
        if (cidFont.getSubType() != ASName.k_CIDFontType2) {
            return false;
        }
        CosDictionary cidFontObj = type0Font.getDescendantFont().getCosDictionary();
        CosStream CIDToGIDMapObj = null;
        boolean embedded = FontResources.embedCIDToGIDMap((PDFFontType0)type0Font, (int[])cidArray, (int[])gidArray);
        if (embedded && ufInfo != null) {
            CIDToGIDMapObj = cidFontObj.getCosStream(ASName.k_CIDToGIDMap);
            ufInfo.setCID2GIDMap(CIDToGIDMapObj);
        }
        return true;
    }

    public static boolean embedCIDSet(PDFFontType0 type0Font, BaseUnembeddedFontInfo ufInfo, Subset fontSubset, int[] cidarray) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, FontEngineException {
        if (!PDFFontUtils.isFontEmbedded((PDFFont)type0Font)) {
            return false;
        }
        CosDictionary cidFontObj = type0Font.getDescendantFont().getCosDictionary();
        CosStream CIDSetObj = null;
        CosDictionary fontDescObj = cidFontObj.getCosDictionary(ASName.k_FontDescriptor);
        if (ufInfo != null && ufInfo.getLastFontInfo() != null && ufInfo.getLastFontInfo().getCIDSet() != null && fontDescObj != null) {
            CIDSetObj = ufInfo.getLastFontInfo().getCIDSet();
            fontDescObj.put(ASName.k_CIDSet, (CosObject)CIDSetObj);
            return true;
        }
        boolean embedded = FontResources.embedCIDSet((PDFFontType0)type0Font, (Subset)fontSubset, (int[])cidarray);
        if (embedded && ufInfo != null) {
            CIDSetObj = fontDescObj.getCosStream(ASName.k_CIDSet);
            ufInfo.setCIDSet(CIDSetObj);
        }
        return embedded;
    }

    public static boolean embedType1Font(PDFFontSimple font, BaseUnembeddedFontInfo ufInfo) throws InvalidFontException, UnsupportedFontException, FontLoadingException, PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        boolean success = false;
        try {
            Font afeFont = font.getAFEFont();
            if (afeFont == null) {
                return false;
            }
            PDFFontDescription afeFontDesc = afeFont.getPDFFontDescription();
            if (afeFontDesc == null) {
                return false;
            }
            FontData fdata = font.getAFEFontData();
            if (fdata == null) {
                return false;
            }
            String psFontName = afeFontDesc.getBase14Name() != null ? afeFontDesc.getBase14Name() : afeFontDesc.getPostscriptName();
            PDFFontFile fontFile = null;
            ASName subsetFontName = null;
            if (ufInfo.getLastFontInstance() == null) {
                Set<String> glyphNamesSet = ufInfo.getGlyphNames();
                if (glyphNamesSet.size() <= 0) {
                    return false;
                }
                String[] glyphNames = new String[glyphNamesSet.size()];
                glyphNamesSet.toArray(glyphNames);
                OutputByteStream outStream = font.getStreamManager().getOutputByteStreamClearDocument(ByteWriterFactory.Fixed.GROWABLE, -1L);
                Object type1Subset = FontResources.getSubsettedFontType1Stream((String[])glyphNames, (Font)afeFont, (OutputStream)outStream.toOutputStream());
                InputByteStream fontFileStream = outStream.closeAndConvert();
                outStream = null;
                fontFile = PDFFontFile.newInstance((PDFDocument)font.getPDFDocument(), (InputByteStream)fontFileStream);
                fontFileStream = null;
                try {
                    fontFile.setEmbeddedFontType(PDFFontFile.EmbeddedFontType.Type1C);
                }
                catch (PDFInvalidParameterException e) {
                    // empty catch block
                }
                subsetFontName = PDFFontUtils.generateSubsetFontName((Object)type1Subset, (String)psFontName);
                ufInfo.setFontFile((CosStream)fontFile.getCosObject());
                ufInfo.setSubsetFontName(subsetFontName);
                ufInfo.setGlyphNames(null);
            } else {
                fontFile = PDFFontFile.getInstance((CosObject)ufInfo.getLastFontInfo().getFontFile());
                subsetFontName = ufInfo.getLastFontInfo().getSubsetFontName();
            }
            PDFFontDescriptor fontDescriptor = PDFFontUtils.generatePDFFontDescriptor((PDFFont)font, (PDFFontDescription)afeFontDesc);
            PDFFilterFlate filter = PDFFilterFlate.newInstance((PDFDocument)fontFile.getPDFDocument(), null);
            fontFile.setFilter(filter);
            fontDescriptor.setFontFile3(fontFile);
            fontDescriptor.setFontName(subsetFontName);
            font.setBaseFont(subsetFontName);
            font.setFontDescriptor(fontDescriptor);
            font.resetAFEFont();
            if ("Symbol".equals(psFontName) || "ZapfDingbats".equals(psFontName)) {
                PDFSimpleFontEncoding encoding = PDFSimpleFontEncoding.newInstance((PDFDocument)font.getPDFDocument(), null, ufInfo.getCharNamesMap());
                font.setEncoding(encoding);
                ufInfo.setCharNamesMap(null);
            }
            font.setDictionaryNameValue(ASName.k_Subtype, ASName.k_Type1);
            success = true;
        }
        catch (IOException e) {
            throw new PDFIOException((Throwable)e);
        }
        return success;
    }

    public static boolean embedCharSet(PDFFontSimple type1Font, BaseUnembeddedFontInfo ufInfo) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, FontEngineException {
        boolean embedded;
        if (!PDFFontUtils.isFontEmbedded((PDFFont)type1Font)) {
            return false;
        }
        CosDictionary type1FontObj = type1Font.getCosDictionary();
        CosDictionary fontDescObj = type1FontObj.getCosDictionary(ASName.k_FontDescriptor);
        if (ufInfo != null && ufInfo.getLastFontInfo() != null && ufInfo.getLastFontInfo().getCharSet() != null) {
            CosObject charSetObj = ufInfo.getLastFontInfo().getCharSet();
            if (fontDescObj != null) {
                fontDescObj.put(ASName.k_CharSet, charSetObj);
                return true;
            }
        }
        if ((embedded = FontResources.embedCharsetString((PDFFontSimple)type1Font)) && ufInfo != null) {
            ufInfo.setCharSet(fontDescObj.get(ASName.k_CharSet));
        }
        return embedded;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean embedTrueTypeFont(PDFFontSimple font, BaseUnembeddedFontInfo ufInfo, boolean isPDFA1) throws FontLoadingException, PDFInvalidDocumentException, PDFIOException, PDFSecurityException, InvalidFontException, UnsupportedFontException {
        try {
            Font afeFont = font.getAFEFont();
            if (afeFont == null) {
                return false;
            }
            PDFFontDescription afeFontDesc = afeFont.getPDFFontDescription();
            if (afeFontDesc == null) {
                return false;
            }
            FontData fontData = font.getAFEFontData();
            if (fontData == null) {
                return false;
            }
            PDFFontFile fontFile = null;
            ASName subsetFontName = null;
            if (ufInfo.getLastFontInstance() == null) {
                String psFontName;
                String string = psFontName = afeFontDesc.getBase14Name() != null ? afeFontDesc.getBase14Name() : afeFontDesc.getPostscriptName();
                if (psFontName == null) {
                    String tempPSFontName = font.getBaseFont().toString();
                    psFontName = tempPSFontName.contains("+") ? tempPSFontName.split("\\+")[1] : tempPSFontName;
                }
                Set<Integer> codePoints = ufInfo.getCodePoints();
                Set<String> postNames = ufInfo.getPostNames();
                if (!codePoints.isEmpty() || !postNames.isEmpty()) {
                    int[] codePointsArray = null;
                    String[] postNamesArray = null;
                    if (!codePoints.isEmpty()) {
                        codePointsArray = new int[codePoints.size()];
                        int i = 0;
                        Iterator<Integer> iter = codePoints.iterator();
                        while (iter.hasNext()) {
                            codePointsArray[i++] = iter.next();
                        }
                    }
                    if (!postNames.isEmpty()) {
                        postNamesArray = new String[postNames.size()];
                        postNames.toArray(postNamesArray);
                    }
                    InputByteStream fontFileStream = null;
                    ByteArrayOutputStream outStream = null;
                    try {
                        outStream = new ByteArrayOutputStream();
                        Object trueTypeSubset = FontResources.getSubsettedFontTrueTypeStream((int[])codePointsArray, (Font)afeFont, (OutputStream)outStream, (int)ufInfo.getPlatformID(), (int)ufInfo.getPlatformSpecificID(), (String[])postNamesArray);
                        fontFileStream = font.getStreamManager().getInputByteStream(outStream.toByteArray());
                        fontFile = PDFFontFile.newInstance((PDFDocument)font.getPDFDocument(), (InputByteStream)fontFileStream);
                        try {
                            if (!isPDFA1) {
                                fontFile.setEmbeddedFontType(PDFFontFile.EmbeddedFontType.OpenType);
                            } else {
                                fontFile.setEmbeddedFontType(PDFFontFile.EmbeddedFontType.Type1C);
                            }
                        }
                        catch (PDFInvalidParameterException e) {
                            // empty catch block
                        }
                        subsetFontName = PDFFontUtils.generateSubsetFontName((Object)trueTypeSubset, (String)psFontName);
                        ufInfo.setFontFile((CosStream)fontFile.getCosObject());
                        ufInfo.setSubsetFontName(subsetFontName);
                        ufInfo.setCodePoints(null);
                        ufInfo.setPostNames(null);
                    }
                    finally {
                        try {
                            if (fontFileStream != null) {
                                fontFileStream.close();
                            }
                        }
                        finally {
                            if (outStream != null) {
                                outStream.close();
                            }
                        }
                    }
                }
            } else {
                fontFile = PDFFontFile.getInstance((CosObject)ufInfo.getLastFontInfo().getFontFile());
                subsetFontName = ufInfo.getLastFontInfo().getSubsetFontName();
            }
            if (fontFile != null) {
                PDFFontDescriptor fontDescriptor = PDFFontUtils.generatePDFFontDescriptor((PDFFont)font, (PDFFontDescription)afeFontDesc);
                PDFFilterFlate filter = PDFFilterFlate.newInstance((PDFDocument)fontFile.getPDFDocument(), null);
                fontFile.setFilter(filter);
                fontDescriptor.setFontFile3(fontFile);
                fontDescriptor.setFontName(subsetFontName);
                if ((fontDescriptor.getFlags() & 4) == 0) {
                    if (font.getEncoding() == null) {
                        PDFSimpleFontEncoding fontEncoding = PDFSimpleFontEncoding.newInstance((PDFDocument)fontFile.getPDFDocument(), (CharSetEncoding)WinAnsiEncoding.getEncoding());
                        font.setEncoding(fontEncoding);
                    }
                } else {
                    font.setEncoding(null);
                }
                font.setBaseFont(subsetFontName);
                font.setFontDescriptor(fontDescriptor);
                font.resetAFEFont();
            }
            if (font.getSubtype() != ASName.k_TrueType) {
                font.setDictionaryNameValue(ASName.k_Subtype, ASName.k_TrueType);
            }
        }
        catch (IOException e) {
            throw new PDFIOException((Throwable)e);
        }
        return true;
    }

    public static boolean embedWidthsArray(PDFFontSimple simpleFont, BaseUnembeddedFontInfo ufInfo, BaseFontContext fontContext, TreeSet<Integer> tSet) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, FontEngineException, PDFInvalidParameterException {
        CosArray widthsObj = null;
        CosDictionary fontObj = simpleFont.getCosDictionary();
        Map<PDFFont, CharacterWidthHolder> map = fontContext.getFontWidthMap();
        CharacterWidthHolderSimpleFont widthHolder = new CharacterWidthHolderSimpleFont();
        int firstChar = 0;
        int lastChar = 255;
        try {
            firstChar = simpleFont.getFirstChar();
            lastChar = simpleFont.getLastChar();
        }
        catch (Exception e) {
            // empty catch block
        }
        widthHolder.setInitialFirstChar(firstChar);
        widthHolder.setInitialLastChar(lastChar);
        if (fontObj.getCosArray(ASName.k_Widths) != null) {
            widthHolder.setInitialWidthsArray(fontObj.getCosArray(ASName.k_Widths).getArrayInt());
        }
        CosDocument cosDoc = simpleFont.getCosObject().getDocument();
        try {
            if (simpleFont instanceof PDFFontType3) {
                PDFFontType3 type3Font = (PDFFontType3)simpleFont;
                PDFSimpleFontEncoding encoding = type3Font.getEncoding();
                PDFCharProcs charProcs = type3Font.getCharProcs();
                if (encoding == null) {
                    return false;
                }
                widthsObj = cosDoc.createCosArray(1);
                for (int i = firstChar; i <= lastChar; ++i) {
                    ASName charName = encoding.getGlyphNameAsASName(i);
                    double charProcsWidth = 0.0;
                    if (charProcs.get((Object)charName) != null) {
                        charProcsWidth = charProcs.getWidth(charName) + 0.5;
                    }
                    widthsObj.addInt(i - firstChar, (int)charProcsWidth);
                }
                fontObj.put(ASName.k_FirstChar, firstChar);
                fontObj.put(ASName.k_LastChar, lastChar);
                fontObj.put(ASName.k_Widths, (CosObject)widthsObj);
            } else {
                Font afeFont = simpleFont.getAFEFont();
                if (afeFont == null) {
                    return false;
                }
                PDFFontDescription fontDesc = afeFont.getPDFFontDescription();
                if (fontDesc == null) {
                    return false;
                }
                FontData fdata = simpleFont.getAFEFontData();
                if (fdata == null) {
                    return false;
                }
                if (tSet != null && !tSet.isEmpty()) {
                    int first = tSet.first();
                    int last = tSet.last();
                    firstChar = first < firstChar && first >= 0 ? first : firstChar;
                    lastChar = last > lastChar && last <= 255 ? last : lastChar;
                }
                simpleFont.buildWidths(firstChar, lastChar, afeFont);
                widthsObj = simpleFont.getDictionaryArrayValue(ASName.k_Widths);
            }
        }
        catch (PDFFontException e) {
            throw new PDFInvalidDocumentException((Throwable)e);
        }
        widthHolder.setFinalFirstChar(firstChar);
        widthHolder.setFinalLastChar(lastChar);
        widthHolder.setFinalWidthsArray(widthsObj.getArrayInt());
        if (widthHolder.widthChanged()) {
            map.put((PDFFont)simpleFont, widthHolder);
        }
        if (ufInfo != null) {
            ufInfo.setFirstChar(firstChar);
            ufInfo.setLastChar(lastChar);
            ufInfo.setWidths(widthsObj);
        }
        return true;
    }

    public static TrueTypeCmapSelector getTrueTypeCmapSelector(PDFFont font) throws UnsupportedFontException, FontEngineException, PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        FontData fontData;
        Font afeFont = font.getAFEFont();
        if (afeFont != null && (fontData = ((FontImpl)afeFont).getFontData()) instanceof OpenTypeFont && ((OpenTypeFont)fontData).getCFFFont() == null) {
            OpenTypeFont otFont = (OpenTypeFont)fontData;
            Cmap cmapTable = otFont.cmap;
            if (cmapTable != null) {
                TrueTypeCmapSelector selector = new TrueTypeCmapSelector();
                cmapTable.enumerateCmaps((Cmap.CmapSelector)selector);
                return selector;
            }
        }
        return null;
    }

    public static HashSet<PDFFont> getFontsInPage(PDFPage page) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        HashSet<PDFFont> set = new HashSet<PDFFont>();
        FontProcessorUtils.addFontsUsedToSet(page.getResources(), set);
        return set;
    }

    private static void addFontsUsedToSet(PDFResources resc, HashSet<PDFFont> set) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFPatternMap patternmap;
        PDFXObjectMap xobjectmap;
        if (resc == null) {
            return;
        }
        PDFFontMap fontmap = resc.getFontMap();
        if (fontmap != null) {
            Iterator iter = fontmap.entrySet().iterator();
            while (iter.hasNext()) {
                set.add((PDFFont)((Map.Entry)iter.next()).getValue());
            }
        }
        if ((xobjectmap = resc.getXObjectMap()) != null) {
            Iterator xIter = xobjectmap.entrySet().iterator();
            while (xIter.hasNext()) {
                PDFXObject xobj = (PDFXObject)((Map.Entry)xIter.next()).getValue();
                if (!(xobj instanceof PDFXObjectForm)) continue;
                PDFXObjectForm form = (PDFXObjectForm)xobj;
                FontProcessorUtils.addFontsUsedToSet(form.getResources(), set);
            }
        }
        if ((patternmap = resc.getPatternMap()) != null) {
            Iterator pIter = patternmap.entrySet().iterator();
            while (pIter.hasNext()) {
                PDFPattern xobj = (PDFPattern)((Map.Entry)pIter.next()).getValue();
                if (!(xobj instanceof PDFPatternTiling)) continue;
                PDFPatternTiling pattern = (PDFPatternTiling)xobj;
                FontProcessorUtils.addFontsUsedToSet(pattern.getResources(), set);
            }
        }
    }

    public static void processToUnicodeRequirement(PDFA2ConversionHandler conversionHandler, Set<Integer> referencedCharCodes, PDFA2ErrorSet<PDFA2AbstractFontErrorCode> errorCodes, PDFFont pdfFont, PDFA2ConformanceLevel conformanceLevel) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (conformanceLevel.getConformance().equalsIgnoreCase("b")) {
            return;
        }
        int objectNumber = pdfFont.getCosObject().getObjNum();
        int genNumber = pdfFont.getCosObject().getObjGen();
        boolean isToUnicodeRequired = FontResources.isToUnicodeCmapRequiredForPDFA((PDFFont)pdfFont, referencedCharCodes);
        if (isToUnicodeRequired) {
            HashSet mappings;
            PDFToUnicodeCMap toUnicodeCMap = pdfFont.getToUnicodeCMap();
            if (toUnicodeCMap != null && (mappings = toUnicodeCMap.getCmapCodeMappings()) != null) {
                for (PDFToUnicodeCMap.CMapCodeMapping codeMap : mappings) {
                    int start = codeMap.getStartCode();
                    int end = codeMap.getEndCode();
                    for (int charCode = start; charCode <= end; ++charCode) {
                        char[] chars = null;
                        if (codeMap.isHexData(charCode)) {
                            chars = codeMap.getHexDataAsCharArray(charCode);
                        } else {
                            AdobeGlyphList glyphList = AdobeGlyphList.get();
                            ASName cmGlyphName = ASName.create((String)codeMap.getCharName(charCode));
                            chars = glyphList.toUnicode(cmGlyphName);
                        }
                        for (char ch : chars) {
                            if (ch == '\u0000') {
                                errorCodes.addErrorCode(new PDFA2FontErrorToUnicodeHasZero(objectNumber, genNumber));
                                continue;
                            }
                            if (ch != '\ufffd' && ch != '\ufeff' && ch != '\ufffe') continue;
                            errorCodes.addErrorCode(new PDFA2FontErrorUnicodeCMapInappropriateValues(objectNumber, genNumber));
                        }
                    }
                }
            }
            TreeMap<Integer, byte[]> newUnicodeValues = new TreeMap<Integer, byte[]>();
            for (Integer charCode : referencedCharCodes) {
                byte[] unicodes;
                if (FontProcessorUtils.isToUnicodeMappingPresent(charCode, toUnicodeCMap)) continue;
                if (conversionHandler != null && (unicodes = conversionHandler.getUnicodeValue(pdfFont, charCode)) != null) {
                    newUnicodeValues.put(charCode, unicodes);
                    continue;
                }
                errorCodes.addErrorCode(new PDFA2FontErrorTextNotMappedToUnicode(objectNumber, genNumber));
            }
            if (!(errorCodes.errorCodeSet(PDFA2FontErrorTextNotMappedToUnicode.class) || errorCodes.errorCodeSet(PDFA2FontErrorToUnicodeHasZero.class) || errorCodes.errorCodeSet(PDFA2FontErrorUnicodeCMapInappropriateValues.class) || newUnicodeValues.isEmpty())) {
                FontResources.createToUnicodeCMap((PDFFont)pdfFont, newUnicodeValues);
            }
        }
    }

    private static boolean isToUnicodeMappingPresent(int charCode, PDFToUnicodeCMap toUnicodeCMap) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (toUnicodeCMap != null) {
            char[] unicodes = null;
            HashSet toUnicodeMaps = toUnicodeCMap.getCmapCodeMappings();
            if (toUnicodeMaps != null) {
                for (PDFToUnicodeCMap.CMapCodeMapping codeMap : toUnicodeMaps) {
                    if (!codeMap.contains(charCode)) continue;
                    if (codeMap.isHexData(charCode)) {
                        unicodes = codeMap.getHexDataAsCharArray(charCode);
                        break;
                    }
                    AdobeGlyphList glyphList = AdobeGlyphList.get();
                    ASName aSName = ASName.create((String)codeMap.getCharName(charCode));
                    unicodes = glyphList.toUnicode(aSName);
                    break;
                }
            }
            if (unicodes != null && unicodes.length > 0) {
                for (void var7_10 : unicodes) {
                    if (var7_10 != false && var7_10 != 65534 && var7_10 != 65279) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }
}

