/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.pdfa.common;

import com.adobe.internal.pdftoolkit.core.cos.CosStream;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.document.PDFResources;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFCIDFont;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFFont;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFFontMap;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFFontSimple;
import com.adobe.internal.pdftoolkit.pdf.interactive.forms.PDFInteractiveForm;
import com.adobe.internal.pdftoolkit.services.pdfa.common.CharacterWidthHolder;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public abstract class BaseFontContext {
    protected Map<ASName, CosStream> cMapsEmbedded = new LinkedHashMap<ASName, CosStream>();
    private PDFFontMap drFonts;
    protected Map<PDFFont, CharacterWidthHolder> fontWidthMap = new HashMap<PDFFont, CharacterWidthHolder>();
    protected Map<PDFCIDFont, HashSet<Integer>> fontCidArrayMap;
    protected Map<PDFFontSimple, HashSet<Integer>> trueTypeFontCharcodes = new HashMap<PDFFontSimple, HashSet<Integer>>();
    protected Set<PDFFont> fontsWithoutTextShowString;

    public BaseFontContext(PDFDocument pdfDoc) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.fontCidArrayMap = new HashMap<PDFCIDFont, HashSet<Integer>>();
        this.fontsWithoutTextShowString = new HashSet<PDFFont>();
        this.initDRFonts(pdfDoc);
    }

    public PDFFontMap getDrFonts() {
        return this.drFonts;
    }

    public Map<ASName, CosStream> getCMapsEmbedded() {
        return this.cMapsEmbedded;
    }

    protected void initDRFonts(PDFDocument pdfDoc) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFResources dr;
        PDFInteractiveForm iform = pdfDoc.getInteractiveForm();
        if (iform != null && (dr = iform.getResources()) != null) {
            this.drFonts = dr.getFontMap();
        }
    }

    public Map<PDFFont, CharacterWidthHolder> getFontWidthMap() {
        return this.fontWidthMap;
    }

    public HashSet<Integer> addCidSetToFont(PDFCIDFont font, HashSet<Integer> cids) {
        HashSet<Integer> currentCids = this.fontCidArrayMap.get(font);
        if (currentCids == null) {
            currentCids = new HashSet();
            this.fontCidArrayMap.put(font, currentCids);
        }
        currentCids.addAll(cids);
        return currentCids;
    }

    public void addCharcodesForsimpleFont(PDFFontSimple font, Set<Integer> charcodes) throws PDFIOException, PDFSecurityException, PDFInvalidDocumentException {
        HashSet<Integer> currentCharcodes = this.trueTypeFontCharcodes.get(font);
        if (currentCharcodes == null) {
            currentCharcodes = new HashSet();
            this.trueTypeFontCharcodes.put(font, currentCharcodes);
        }
        currentCharcodes.addAll(charcodes);
    }

    public Set<Integer> getCharCodesForSimpleFonts(PDFFontSimple font) {
        return this.trueTypeFontCharcodes.get(font);
    }

    public Set<PDFFont> getFontsWithoutTextShowString() {
        return this.fontsWithoutTextShowString;
    }
}

