/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.pdfa;

import com.adobe.internal.pdftoolkit.services.pdfa.PDFAErrorSet;
import com.adobe.internal.pdftoolkit.services.pdfa.error.PDFAColorSpaceErrorCode;
import com.adobe.internal.pdftoolkit.services.pdfa.error.PDFAErrorCode;
import java.util.ArrayList;

public class PDFAErrorSetColorSpace
extends PDFAErrorSet {
    public PDFAErrorSetColorSpace() {
        super(PDFAColorSpaceErrorCode.class);
    }

    public PDFAErrorSetColorSpace(PDFAErrorCode errorCode) {
        this();
        this.addErrorCode(errorCode);
    }

    public boolean notDeviceIndependent() {
        return this.errorCodeSet(PDFAColorSpaceErrorCode.notDeviceIndependent);
    }

    public boolean iccProfileNotEmbedded() {
        return this.errorCodeSet(PDFAColorSpaceErrorCode.iccProfileNotEmbedded);
    }

    public boolean bothDeviceRGBAndDeviceCMYKInUse() {
        return this.errorCodeSet(PDFAColorSpaceErrorCode.bothDeviceRGBAndDeviceCMYKInUse);
    }

    public boolean iccProfileVersionNotAllowed() {
        return this.errorCodeSet(PDFAColorSpaceErrorCode.iccProfileVersionNotAllowed);
    }

    public boolean iccProfileCouldNotBeParsed() {
        return this.errorCodeSet(PDFAColorSpaceErrorCode.iccProfileCouldNotBeParsed);
    }

    public boolean objectXMPMetadataInvalid() {
        return this.errorCodeSet(PDFAColorSpaceErrorCode.objectXMPMetadataInvalid);
    }

    @Override
    public boolean pdfGeneralFailure() {
        return this.errorCodeSet(PDFAColorSpaceErrorCode.pdfGeneralFailure);
    }

    @Override
    public String toString() {
        ArrayList<String> violations = new ArrayList<String>(10);
        if (this.pdfGeneralFailure()) {
            violations.add("pdf general failure");
        }
        if (this.notDeviceIndependent()) {
            violations.add("color space not device independent");
        }
        if (this.iccProfileNotEmbedded()) {
            violations.add("ICC profile not embedded");
        }
        if (this.bothDeviceRGBAndDeviceCMYKInUse()) {
            violations.add("both DeviceRGB and DeviceCMYK in use");
        }
        if (this.iccProfileVersionNotAllowed()) {
            violations.add("ICC profile version not allowed");
        }
        if (this.iccProfileCouldNotBeParsed()) {
            violations.add("ICC profile could not be parsed");
        }
        if (this.objectXMPMetadataInvalid()) {
            violations.add("Object XMP metadata is not valid");
        }
        return super.toString() + " " + violations;
    }
}

