/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.optimizer.fontimpl;

import com.adobe.fontengine.font.Font;
import com.adobe.fontengine.font.FontData;
import com.adobe.fontengine.font.FontImpl;
import com.adobe.fontengine.font.FontLoadingException;
import com.adobe.fontengine.font.InvalidFontException;
import com.adobe.fontengine.font.LineMetrics;
import com.adobe.fontengine.font.UnsupportedFontException;
import com.adobe.internal.pdftoolkit.core.cos.CosDictionary;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFFontException;
import com.adobe.internal.pdftoolkit.services.optimizer.fontimpl.EmbeddedFontDetails;
import com.adobe.internal.pdftoolkit.services.optimizer.fontimpl.GlyphComparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class FontSuperSetCheck {
    private Font afeFontInternal;
    private FontData afeFontDataInternal;
    private HashMap<CosDictionary, HashMap<Integer, Integer>> subsetToFullGidMap;

    public FontSuperSetCheck(Font afeFont) throws PDFFontException {
        if (afeFont == null) {
            throw new IllegalArgumentException("AFEFont used to construct object should not be null.");
        }
        this.afeFontInternal = afeFont;
        this.subsetToFullGidMap = new HashMap();
        try {
            this.afeFontDataInternal = ((FontImpl)this.afeFontInternal).getFontData();
        }
        catch (InvalidFontException e) {
            throw new PDFFontException("InvalidFontException occured while getting fontData.", (Throwable)e);
        }
        catch (UnsupportedFontException e) {
            throw new PDFFontException("UnsupportedFontException occured while getting fontData.", (Throwable)e);
        }
        catch (FontLoadingException e) {
            throw new PDFFontException("FontLoadingException occured while getting fontData.", (Throwable)e);
        }
    }

    public boolean isFontSuperSet(EmbeddedFontDetails embeddedFontDetails) throws PDFFontException {
        Font fontToCheck = embeddedFontDetails.getAfeFont();
        if (fontToCheck == null) {
            throw new IllegalArgumentException("Font to be checked should not be null.");
        }
        try {
            FontData ftcData = ((FontImpl)fontToCheck).getFontData();
            boolean topLevelFontCharacteristics = this.checkTopLevelFontCharacteristics(fontToCheck, ftcData);
            if (!topLevelFontCharacteristics) {
                return false;
            }
            GlyphComparator gc = new GlyphComparator();
            HashMap<Integer, Integer> subsetToFullGidMapLocal = new HashMap<Integer, Integer>();
            Iterator<Map.Entry<Integer, int[]>> itr = embeddedFontDetails.getCharCodeToUnicodeMap().entrySet().iterator();
            int unicodeSize = 0;
            int glyphNotFound = 0;
            while (itr.hasNext()) {
                Map.Entry<Integer, int[]> gEntry = itr.next();
                int charCode = gEntry.getKey();
                int[] unicodes = gEntry.getValue();
                unicodeSize += unicodes.length;
                int[] arr$ = unicodes;
                int len$ = arr$.length;
                for (int i$ = 0; i$ < len$; ++i$) {
                    Integer unicode = arr$[i$];
                    int myGid = this.afeFontDataInternal.getGlyphForChar(unicode.intValue());
                    int other = ftcData.getGlyphForChar(unicode.intValue());
                    if (other == 0) {
                        int n = other = embeddedFontDetails.getCharCodeToGlyphIdMap().get(charCode) != null ? embeddedFontDetails.getCharCodeToGlyphIdMap().get(charCode) : 0;
                    }
                    if (other <= 0) {
                        subsetToFullGidMapLocal.put(other, myGid);
                        ++glyphNotFound;
                        continue;
                    }
                    boolean gEqual = gc.compareGlyph(myGid, this.afeFontDataInternal, this.afeFontInternal, other, ftcData, fontToCheck);
                    if (!gEqual) {
                        return false;
                    }
                    subsetToFullGidMapLocal.put(other, myGid);
                }
            }
            if (subsetToFullGidMapLocal.size() != unicodeSize || glyphNotFound > 0) {
                return false;
            }
            if (this.subsetToFullGidMap.get(embeddedFontDetails.getPdfFont().getCosDictionary()) == null) {
                this.subsetToFullGidMap.put(embeddedFontDetails.getPdfFont().getCosDictionary(), subsetToFullGidMapLocal);
            }
        }
        catch (InvalidFontException e) {
            throw new PDFFontException("InvalidFontException occured while checking if given font is superset.", (Throwable)e);
        }
        catch (UnsupportedFontException e) {
            throw new PDFFontException("UnsupportedFontException occured while checking if given font is superset.", (Throwable)e);
        }
        catch (FontLoadingException e) {
            throw new PDFFontException("FontLoadingException occured while checking if given font is superset.", (Throwable)e);
        }
        return true;
    }

    private boolean checkTopLevelFontCharacteristics(Font fontToCheck, FontData ftcData) throws UnsupportedFontException, InvalidFontException {
        return this.compareLineMetrics(ftcData);
    }

    private boolean compareLineMetrics(FontData ftcData) throws UnsupportedFontException, InvalidFontException {
        LineMetrics my = this.afeFontDataInternal.getLineMetrics();
        LineMetrics other = ftcData.getLineMetrics();
        return FontSuperSetCheck.xorEquals(my, other);
    }

    private static boolean xorEquals(Object ob1, Object ob2) {
        if (ob1 != null && ob2 != null) {
            return ob1.equals(ob2);
        }
        return !(ob1 == null ^ ob2 == null);
    }

    public Integer getFullFontGid(CosDictionary pdffont, Integer subsetGid) {
        if (this.subsetToFullGidMap.get(pdffont) != null) {
            return this.subsetToFullGidMap.get(pdffont).get(subsetGid);
        }
        return 0;
    }
}

