/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.optimizer.fontimpl;

import com.adobe.internal.pdftoolkit.core.cos.CosDictionary;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFFont;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.impl.PDFCMapUtils;
import java.util.HashMap;

public class ContentRewriteInfo {
    private PDFFont pdfFont;
    private HashMap<Integer, Integer> oldGlyphIdToNewGlyphIdMap;
    private HashMap<CosDictionary, HashMap<Integer, Integer>> perFontDictOldCharCodeToOldglyphIdMap;

    public ContentRewriteInfo(PDFFont pdfFont) {
        this.pdfFont = pdfFont;
        this.oldGlyphIdToNewGlyphIdMap = new HashMap();
        this.perFontDictOldCharCodeToOldglyphIdMap = new HashMap();
    }

    public void setOldGlyphIdToNewGlyphIdMap(HashMap<Integer, Integer> oldToNewGlyphIdMap) {
        this.oldGlyphIdToNewGlyphIdMap = oldToNewGlyphIdMap;
    }

    public void setPerFontDictOldCharCodeToOldglyphIdMap(HashMap<CosDictionary, HashMap<Integer, Integer>> perFontDictOldCharCodeToOldglyphIdMap) {
        this.perFontDictOldCharCodeToOldglyphIdMap = perFontDictOldCharCodeToOldglyphIdMap;
    }

    public HashMap<CosDictionary, HashMap<Integer, Integer>> getPerFontDictOldCharCodeToOldglyphIdMap() {
        return this.perFontDictOldCharCodeToOldglyphIdMap;
    }

    public HashMap<Integer, Integer> getOldToNewGlyphIdMap() {
        return this.oldGlyphIdToNewGlyphIdMap;
    }

    public PDFFont getPdfFont() {
        return this.pdfFont;
    }

    byte[] getNewCharCode(byte[] oldCharCode) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        int oldCh = (int)PDFCMapUtils.getCharCode((byte[])oldCharCode);
        return this.getNewCharCode(oldCh);
    }

    byte[] getNewCharCode(int oldCh) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        HashMap<Integer, Integer> mapping = this.perFontDictOldCharCodeToOldglyphIdMap.get(this.pdfFont.getCosDictionary());
        if (mapping == null) {
            return null;
        }
        Integer oldGlyphId = mapping.get(oldCh);
        if (oldGlyphId == null) {
            return null;
        }
        Integer newGlyphId = this.oldGlyphIdToNewGlyphIdMap.get(oldGlyphId);
        return PDFCMapUtils.numToByteArray((long)newGlyphId.intValue(), (int)2);
    }
}

