/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.optimizer.fontimpl;

import com.adobe.internal.pdftoolkit.core.cos.CosDictionary;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASArray;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.core.types.ASNumber;
import com.adobe.internal.pdftoolkit.core.types.ASObject;
import com.adobe.internal.pdftoolkit.core.types.ASString;
import com.adobe.internal.pdftoolkit.pdf.content.Content;
import com.adobe.internal.pdftoolkit.pdf.content.Instruction;
import com.adobe.internal.pdftoolkit.pdf.content.InstructionFactory;
import com.adobe.internal.pdftoolkit.pdf.content.OperandStack;
import com.adobe.internal.pdftoolkit.pdf.content.processor.TextState;
import com.adobe.internal.pdftoolkit.pdf.contentmodify.impl.ContentStreamFilterImpl;
import com.adobe.internal.pdftoolkit.pdf.document.PDFResources;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFFont;
import com.adobe.internal.pdftoolkit.services.optimizer.fontimpl.ContentRewriteInfo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Stack;

public class CharcodeRewriter
extends ContentStreamFilterImpl {
    private HashMap<CosDictionary, ContentRewriteInfo> rewriteInfoMap;
    private HashSet<CosDictionary> simpleTypeFonts;
    private Stack<PDFResources> resourcesStack;
    private Stack<PDFFont> fontStack;
    private TextState currentTextState;
    private boolean isTwUsed = false;
    private PDFFont currentFont;

    public CharcodeRewriter(HashMap<CosDictionary, ContentRewriteInfo> rewriteInfoMap, HashSet<CosDictionary> simpleTypeFonts, Content content) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.rewriteInfoMap = rewriteInfoMap;
        this.simpleTypeFonts = simpleTypeFonts;
        this.resourcesStack = new Stack();
        this.resourcesStack.push(content.getResources());
        this.fontStack = new Stack();
    }

    public void Tf(ASName fontName, double fontSize, Instruction instruction) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.currentFont = this.resourcesStack.peek().getFontMap().get(fontName);
        this.currentTextState.setFontSize(fontSize);
        super.Tf(fontName, fontSize, instruction);
    }

    public void BT(Instruction instruction) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.currentTextState = new TextState();
        super.BT(instruction);
    }

    public void ET(Instruction instruction) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.isTwUsed = false;
        super.ET(instruction);
    }

    public void Tc(double charSpacing, Instruction instruction) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.currentTextState.setCharSpacing(charSpacing);
        super.Tc(charSpacing, instruction);
    }

    public void Tw(double wordSpacing, Instruction instruction) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.currentTextState.setWordSpacing(wordSpacing);
        this.isTwUsed = true;
    }

    public void TJ(ASArray array, Instruction instruction) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (array == null || array.isEmpty()) {
            return;
        }
        OperandStack newOS = new OperandStack();
        ASArray newArr = new ASArray();
        for (ASObject o : array) {
            if (o instanceof ASNumber) {
                newArr.add(o);
                continue;
            }
            if (!(o instanceof ASString)) continue;
            List<Integer> spaceIndex = null;
            if (this.isTwUsed && !(spaceIndex = this.scanSpaces((ASString)o)).isEmpty()) {
                ASNumber val = new ASNumber(0);
                if (!newArr.isEmpty() && newArr.get(newArr.size() - 1) instanceof ASNumber) {
                    val = (ASNumber)newArr.remove(newArr.size() - 1);
                }
                double w = this.currentTextState.getWordSpacing();
                double h = this.currentTextState.getHorizScaling() / 100.0;
                double fs = this.currentTextState.getFontSize();
                if (fs == 0.0) {
                    fs = 1.0;
                }
                ASNumber newVal = new ASNumber(-1.0 * (1000.0 * w * h) / fs);
                ASNumber valWithDelta = new ASNumber(newVal.doubleValue() + val.doubleValue());
                int nextIndex2 = 0;
                int prevIndex = 0;
                int ctr = 0;
                for (int nextIndex2 : spaceIndex) {
                    if (nextIndex2 == 0) continue;
                    ASString partOfString = ((ASString)o).substring(prevIndex, nextIndex2);
                    ASString stack = this.createNewString(partOfString);
                    if (spaceIndex.contains(prevIndex)) {
                        if (++ctr == 1) {
                            newArr.add((ASObject)valWithDelta);
                        } else {
                            newArr.add((ASObject)newVal);
                        }
                    } else if (val.doubleValue() != 0.0) {
                        newArr.add((ASObject)val);
                    }
                    if (stack == null) {
                        newArr.add((ASObject)partOfString);
                    } else {
                        newArr.add((ASObject)stack);
                    }
                    prevIndex = nextIndex2;
                }
                ASString lastPart = ((ASString)o).substring(nextIndex2);
                ASString stack = this.createNewString(lastPart);
                if (ctr > 0) {
                    newArr.add((ASObject)newVal);
                } else {
                    newArr.add((ASObject)valWithDelta);
                }
                if (stack == null) {
                    newArr.add((ASObject)lastPart);
                } else {
                    newArr.add((ASObject)stack);
                }
            }
            if (this.isTwUsed && spaceIndex != null && !spaceIndex.isEmpty()) continue;
            ASString stack = this.createNewString((ASString)o);
            if (stack == null) {
                newArr.add(o);
                continue;
            }
            newArr.add((ASObject)stack);
        }
        newOS.pushArray(newArr);
        super.TJ(newArr, new Instruction(newOS, ASName.k_TJ));
    }

    public void Tj(ASString string, Instruction instruction) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (string == null || string.getBytes() == null || string.getBytes().length == 0) {
            return;
        }
        List<Integer> spaceIndex = null;
        if (this.isTwUsed && !(spaceIndex = this.scanSpaces(string)).isEmpty()) {
            double w = this.currentTextState.getWordSpacing();
            double h = this.currentTextState.getHorizScaling() / 100.0;
            double fs = this.currentTextState.getFontSize();
            if (fs == 0.0) {
                fs = 1.0;
            }
            ASNumber newval = new ASNumber(-1.0 * (1000.0 * w * h) / fs);
            int nextIndex2 = 0;
            int prevIndex = 0;
            ASArray newArr = new ASArray();
            OperandStack newOS = new OperandStack();
            for (int nextIndex2 : spaceIndex) {
                if (nextIndex2 == 0) continue;
                ASString partOfString = string.substring(prevIndex, nextIndex2);
                ASString stack = this.createNewString(partOfString);
                if (spaceIndex.contains(prevIndex)) {
                    newArr.add((ASObject)newval);
                }
                if (stack == null) {
                    newArr.add((ASObject)partOfString);
                } else {
                    newArr.add((ASObject)stack);
                }
                prevIndex = nextIndex2;
            }
            ASString lastPart = string.substring(nextIndex2);
            ASString stack = this.createNewString(lastPart);
            newArr.add((ASObject)newval);
            if (stack == null) {
                newArr.add((ASObject)lastPart);
            } else {
                newArr.add((ASObject)stack);
            }
            newOS.pushArray(newArr);
            super.TJ(newArr, new Instruction(newOS, ASName.k_TJ));
        }
        if (!this.isTwUsed || spaceIndex == null || spaceIndex.isEmpty()) {
            ASString newString = this.createNewString(string);
            if (newString != null) {
                super.Tj(newString, InstructionFactory.newShowText((ASString)newString));
            } else {
                super.Tj(string, instruction);
            }
        }
    }

    public void SingleQuote(ASString string, Instruction instruction) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (string == null || string.getBytes() == null || string.getBytes().length == 0) {
            return;
        }
        this.Tj(string, InstructionFactory.newShowText((ASString)string));
    }

    public void DoubleQuote(double wordSpacing, double charSpacing, ASString string, Instruction instruction) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (string == null || string.getBytes() == null || string.getBytes().length == 0) {
            return;
        }
        this.Tw(wordSpacing, InstructionFactory.newWordSpacing((double)wordSpacing));
        this.Tc(charSpacing, InstructionFactory.newCharactorSpacing((double)charSpacing));
        this.Tj(string, InstructionFactory.newShowText((ASString)string));
    }

    public void q(Instruction instruction) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.fontStack.push(this.currentFont);
        super.q(instruction);
    }

    public void Q(Instruction instruction) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.currentFont = this.fontStack.pop();
        super.Q(instruction);
    }

    private ASString createNewString(ASString str) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.currentFont == null || str == null || !this.rewriteInfoMap.containsKey(this.currentFont.getCosDictionary())) {
            return null;
        }
        ArrayList<Byte> newByteList = new ArrayList<Byte>();
        if (!this.simpleTypeFonts.contains(this.currentFont.getCosDictionary())) {
            List charCodes = this.currentFont.getCharCodes(str.getBytes(), false);
            for (List charCodeInfo : charCodes) {
                byte[] charCodeBytes = (byte[])charCodeInfo.get(0);
                byte[] newCharCodeBytes = this.rewriteInfoMap.get(this.currentFont.getCosDictionary()).getNewCharCode(charCodeBytes);
                if (newCharCodeBytes != null) {
                    newByteList.addAll(Arrays.asList(CharcodeRewriter.convertToByte(newCharCodeBytes)));
                    continue;
                }
                newByteList.addAll(Arrays.asList(CharcodeRewriter.convertToByte(charCodeBytes)));
            }
        } else {
            byte[] bytes = str.getBytes();
            for (int i = 0; i < bytes.length; ++i) {
                byte[] charCodeBytes = new byte[]{bytes[i]};
                byte[] newCharCodeBytes = this.rewriteInfoMap.get(this.currentFont.getCosDictionary()).getNewCharCode(charCodeBytes);
                if (newCharCodeBytes != null) {
                    newByteList.addAll(Arrays.asList(CharcodeRewriter.convertToByte(newCharCodeBytes)));
                    continue;
                }
                newByteList.addAll(Arrays.asList(CharcodeRewriter.convertToByte(charCodeBytes)));
            }
        }
        return new ASString(CharcodeRewriter.convertTobyte(newByteList.toArray(new Byte[0])));
    }

    private List<Integer> scanSpaces(ASString str) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        ArrayList<Integer> spaceIndexes = new ArrayList<Integer>();
        if (this.currentFont == null || str == null) {
            return spaceIndexes;
        }
        int index = 0;
        if (!this.simpleTypeFonts.contains(this.currentFont.getCosDictionary())) {
            List charCodes = this.currentFont.getCharCodes(str.getBytes(), false);
            for (List charCodeInfo : charCodes) {
                byte[] charCodeBytes = (byte[])charCodeInfo.get(0);
                if (charCodeBytes.length < 2 && charCodeBytes[0] == 32) {
                    spaceIndexes.add(index);
                }
                ++index;
            }
        } else {
            byte[] bytes = str.getBytes();
            for (int i = 0; i < bytes.length; ++i) {
                byte[] charCodeBytes = new byte[]{bytes[i]};
                if (charCodeBytes.length >= 2 || charCodeBytes[0] != 32) continue;
                spaceIndexes.add(i);
            }
        }
        return spaceIndexes;
    }

    private static Byte[] convertToByte(byte[] arr) {
        if (arr == null) {
            return null;
        }
        int length = arr.length;
        Byte[] newArr = new Byte[length];
        for (int i = 0; i < length; ++i) {
            newArr[i] = arr[i];
        }
        return newArr;
    }

    private static byte[] convertTobyte(Byte[] arr) {
        if (arr == null) {
            return null;
        }
        int length = arr.length;
        byte[] newArr = new byte[length];
        for (int i = 0; i < length; ++i) {
            newArr[i] = arr[i];
        }
        return newArr;
    }
}

