/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.manipulations.impl;

import com.adobe.internal.io.ByteWriterFactory;
import com.adobe.internal.io.stream.IO;
import com.adobe.internal.io.stream.InputByteStream;
import com.adobe.internal.io.stream.OutputByteStream;
import com.adobe.internal.io.stream.StreamManager;
import com.adobe.internal.pdftoolkit.core.cos.CosArray;
import com.adobe.internal.pdftoolkit.core.cos.CosCloneMgr;
import com.adobe.internal.pdftoolkit.core.cos.CosDictionary;
import com.adobe.internal.pdftoolkit.core.cos.CosDocument;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.cos.CosScalar;
import com.adobe.internal.pdftoolkit.core.cos.CosStream;
import com.adobe.internal.pdftoolkit.core.cos.CosUtils;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFCosParseException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFUnableToCompleteOperationException;
import com.adobe.internal.pdftoolkit.core.types.ASDate;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.core.types.ASRectangle;
import com.adobe.internal.pdftoolkit.core.types.ASString;
import com.adobe.internal.pdftoolkit.core.util.Utility;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosObject;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosObjectContainer;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.document.PDFResources;
import com.adobe.internal.pdftoolkit.pdf.document.listener.DocumentListenerRegistryBase;
import com.adobe.internal.pdftoolkit.pdf.document.listener.DocumentMessage;
import com.adobe.internal.pdftoolkit.pdf.graphics.PDFRectangle;
import com.adobe.internal.pdftoolkit.pdf.graphics.optionalcontent.PDFOCObject;
import com.adobe.internal.pdftoolkit.pdf.graphics.xobject.PDFXObject;
import com.adobe.internal.pdftoolkit.pdf.graphics.xobject.PDFXObjectAltImage;
import com.adobe.internal.pdftoolkit.pdf.graphics.xobject.PDFXObjectAltImageList;
import com.adobe.internal.pdftoolkit.pdf.graphics.xobject.PDFXObjectColorMask;
import com.adobe.internal.pdftoolkit.pdf.graphics.xobject.PDFXObjectFactory;
import com.adobe.internal.pdftoolkit.pdf.graphics.xobject.PDFXObjectForm;
import com.adobe.internal.pdftoolkit.pdf.graphics.xobject.PDFXObjectImage;
import com.adobe.internal.pdftoolkit.pdf.graphics.xobject.PDFXObjectImageMask;
import com.adobe.internal.pdftoolkit.pdf.graphics.xobject.PDFXObjectMap;
import com.adobe.internal.pdftoolkit.pdf.interactive.action.PDFAction;
import com.adobe.internal.pdftoolkit.pdf.interactive.action.PDFActionFactory;
import com.adobe.internal.pdftoolkit.pdf.interactive.action.PDFActionGoTo;
import com.adobe.internal.pdftoolkit.pdf.interactive.action.PDFActionGoToRemote;
import com.adobe.internal.pdftoolkit.pdf.interactive.action.PDFActionOCG;
import com.adobe.internal.pdftoolkit.pdf.interactive.action.PDFActionThread;
import com.adobe.internal.pdftoolkit.pdf.interactive.action.PDFAdditionalActions;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotation;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationFactory;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationLink;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationList;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationMarkup;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationPopup;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationWidget;
import com.adobe.internal.pdftoolkit.pdf.interactive.markedcontent.PDFMCProperty;
import com.adobe.internal.pdftoolkit.pdf.interactive.markedcontent.PDFMCPropertyMap;
import com.adobe.internal.pdftoolkit.pdf.interactive.navigation.PDFDestination;
import com.adobe.internal.pdftoolkit.pdf.interactive.navigation.PDFDestinationNamed;
import com.adobe.internal.pdftoolkit.pdf.interchange.PDFApplicationData;
import com.adobe.internal.pdftoolkit.pdf.page.PDFPage;
import com.adobe.internal.pdftoolkit.pdf.page.PDFPagePiece;
import com.adobe.internal.pdftoolkit.pdf.page.PDFPageTree;
import com.adobe.internal.pdftoolkit.pdf.page.PDFPageTreeNode;
import com.adobe.internal.pdftoolkit.pdf.page.PDFTemplate;
import com.adobe.internal.pdftoolkit.pdf.pieceinfo.compoundtype.PDFCompoundTypeInfo;
import com.adobe.internal.pdftoolkit.services.manipulations.impl.PMMNamedDestinations;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;

public class PMMPages {
    private PDFDocument curDoc;
    private CosCloneMgr cloneHandler;
    private Map<PDFXObject, PDFXObject> mClonedXObjects;
    private Map<CosObject, CosObject> mClonedThreads;
    private Map<CosObject, CosObject> mClonedBeads;
    private static final ASName[] specialPageKeys = new ASName[]{ASName.k_Parent, ASName.k_MediaBox, ASName.k_Resources, ASName.k_Annots, ASName.k_B, ASName.k_AA, ASName.k_StructParents, ASName.k_PieceInfo};
    private static final ASName[] specialTemplateKeys = new ASName[]{ASName.k_MediaBox, ASName.k_Resources, ASName.k_Annots, ASName.k_AA, ASName.k_StructParents};
    private static final ASName[] specialAnnotationsKeys = new ASName[]{ASName.k_P, ASName.k_A, ASName.k_AA, ASName.k_StructParent, ASName.k_Popup, ASName.k_IRT, ASName.k_Dest, ASName.k_OC, ASName.k_Parent, ASName.k_Kids, PDFAnnotationWidget.k_PageFromAnnot};
    private static final ASName[] specialActionKeys = new ASName[]{ASName.k_D, ASName.k_Next, ASName.k_B, ASName.k_AN, ASName.k_T};
    private static final ASName[] specialResourcesKeys = new ASName[]{ASName.k_XObject, ASName.k_Properties};
    private static final ASName[] specialXObjectKeys = new ASName[]{ASName.k_OC, ASName.k_Resources, ASName.k_SMask, ASName.k_Alternates, ASName.k_Mask, ASName.k_PieceInfo, ASName.k_StructParent, ASName.k_StructParents};
    private static final ASName[] specialAltImageKeys = new ASName[]{ASName.k_Image};
    private static final ASName[] specialThreadKeys = new ASName[]{ASName.k_F};
    private static final ASName[] specialBeadKeys = new ASName[]{ASName.k_T, ASName.k_N, ASName.k_V, ASName.k_P};

    public PMMPages(PDFDocument pdfDoc, CosCloneMgr clonehandler) {
        this.curDoc = pdfDoc;
        this.cloneHandler = clonehandler;
        this.mClonedXObjects = new LinkedHashMap<PDFXObject, PDFXObject>(100);
        this.mClonedThreads = new HashMap<CosObject, CosObject>(100);
        this.mClonedBeads = new HashMap<CosObject, CosObject>(100);
    }

    public Map<PDFPage, PDFPage> partiallyAppendPages(PDFPage afterPage, PDFPage[] sourcePages) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.partiallyAppendPages(afterPage, sourcePages, false);
    }

    private Map<PDFPage, PDFPage> partiallyAppendPagesAfterLastPage(PDFPage lastPage, PDFPage[] sourcePages) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.partiallyAppendPages(lastPage, sourcePages, true);
    }

    private Map<PDFPage, PDFPage> partiallyAppendPages(PDFPage afterPage, PDFPage[] sourcePages, boolean appendAfterLastPage) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        LinkedHashMap<PDFPage, PDFPage> result = null;
        if (sourcePages != null && sourcePages.length > 0) {
            result = new LinkedHashMap<PDFPage, PDFPage>(sourcePages.length);
            PDFPageTree pageTree = this.curDoc.requireCatalog().getPages();
            for (int i = 0; i < sourcePages.length; ++i) {
                PDFPage srcPage = sourcePages[i];
                PDFPage newPage = this.clonePage(srcPage);
                if (afterPage == null) {
                    if (pageTree == null || pageTree.isEmpty()) {
                        pageTree = PDFPageTree.newInstance((PDFDocument)this.curDoc, (PDFPage)newPage);
                    } else {
                        pageTree.getPage(0).prependPage(newPage);
                    }
                } else if (appendAfterLastPage) {
                    PDFPageTreeNode parent = afterPage.getParent();
                    parent.appendKid(newPage);
                } else {
                    afterPage.appendPage(newPage);
                }
                afterPage = newPage;
                result.put(srcPage, newPage);
            }
        }
        return result;
    }

    private PDFPage spawnAndPartiallyAppendPages(PDFPage afterPage, PDFXObject xObjectForPage, PDFPage template, boolean appendAfterLastPage, String templateName) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFUnableToCompleteOperationException {
        PDFPageTree pageTree = this.curDoc.requireCatalog().getPages();
        PDFPage newPage = null;
        newPage = xObjectForPage == null ? this.createPageFromTemplate(template, templateName) : this.createPageFromXObject(xObjectForPage, template, templateName);
        if (afterPage == null) {
            if (pageTree == null || pageTree.isEmpty()) {
                PDFPageTree.newInstance((PDFDocument)this.curDoc, (PDFPage)newPage);
            } else {
                pageTree.getPage(0).prependPage(newPage);
            }
        } else if (appendAfterLastPage) {
            PDFPageTreeNode parent = afterPage.getParent();
            parent.appendKid(newPage);
        } else {
            afterPage.appendPage(newPage);
        }
        return newPage;
    }

    private PDFPage createPageFromXObject(PDFXObject xObjectForPage, PDFPage template, String templateName) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFRectangle srcMediaBox = template.getMediaBox();
        PDFRectangle curMediaBox = PDFRectangle.newInstance((PDFDocument)this.curDoc, (double)srcMediaBox.llx(), (double)srcMediaBox.lly(), (double)srcMediaBox.urx(), (double)srcMediaBox.ury());
        PDFPage newPage = PDFPage.newInstance((PDFDocument)this.curDoc, (PDFRectangle)curMediaBox);
        ASName[] specialKeys = specialPageKeys;
        Iterator keyIterator = template.getCosDictionary().keyIterator();
        while (keyIterator.hasNext()) {
            CosObject cosObject;
            ASName curKey = (ASName)keyIterator.next();
            if (curKey != ASName.k_Resources && Utility.nameInArray((ASName)curKey, (ASName[])specialKeys) || curKey.asString().equalsIgnoreCase("type")) continue;
            if (curKey.asString().equalsIgnoreCase("Contents")) {
                newPage.setDictionaryValue(curKey, (PDFCosObject)((PDFXObjectForm)xObjectForPage).getContents());
            }
            if ((cosObject = xObjectForPage.getCosDictionary().get(curKey)) == null) continue;
            newPage.setDictionaryValue(curKey, cosObject);
        }
        newPage.setTemplateName(templateName);
        return newPage;
    }

    public Map<PDFPage, PDFPage> partiallyAppendPages(PDFDocument srcDoc, PDFPage afterPage, boolean appendToEnd, PDFPage firstPage, int pageCount) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        Object[] srcPages = new PDFPage[pageCount];
        Iterator srcPagesIter = srcDoc.requirePages().iterator(firstPage.getPageNumber());
        int index = 0;
        while (pageCount-- > 0 && srcPagesIter.hasNext()) {
            srcPages[index++] = (PDFPage)srcPagesIter.next();
        }
        srcPages = PMMPages.trimArray((PDFPage[])srcPages, index);
        Arrays.sort(srcPages);
        if (appendToEnd) {
            return this.partiallyAppendPagesAfterLastPage(afterPage, (PDFPage[])srcPages);
        }
        return this.partiallyAppendPages(afterPage, (PDFPage[])srcPages);
    }

    public static PDFPage[] trimArray(PDFPage[] pageList, int expectedSize) {
        if (pageList.length != expectedSize) {
            PDFPage[] pagesArray = new PDFPage[expectedSize];
            System.arraycopy(pageList, 0, pagesArray, 0, expectedSize);
            return pagesArray;
        }
        return pageList;
    }

    public Map<PDFPage, PDFPage> partiallyAppendTemplate(PDFDocument srcDoc, PDFXObject xObjectForPage, PDFPage afterPage, boolean appendToEnd, PDFPage template, int pageCount, String templateName) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFUnableToCompleteOperationException {
        PDFPage newPage = null;
        newPage = appendToEnd ? this.spawnAndPartiallyAppendPages(afterPage, xObjectForPage, template, true, templateName) : this.spawnAndPartiallyAppendPages(afterPage, xObjectForPage, template, false, templateName);
        LinkedHashMap<PDFPage, PDFPage> templateToNewPage = new LinkedHashMap<PDFPage, PDFPage>();
        templateToNewPage.put(template, newPage);
        return templateToNewPage;
    }

    public Map<PDFAnnotation, PDFAnnotation> propagateAnnots(Map<PDFPage, PDFPage> mapPages, PMMNamedDestinations curDests, Map<ASString, PDFDestinationNamed> allDests, Map<PDFAction, PDFAction> allActions, Map<PDFAdditionalActions, PDFAdditionalActions> allAdditionalActions) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        LinkedHashMap<PDFAnnotation, PDFAnnotation> allAnnots = new LinkedHashMap<PDFAnnotation, PDFAnnotation>();
        for (Map.Entry<PDFPage, PDFPage> mapPagesEntry : mapPages.entrySet()) {
            PDFPage srcPage = mapPagesEntry.getKey();
            PDFAnnotationList annots = srcPage.getAnnotationList();
            PDFAnnotationList newAnnots = null;
            LinkedHashMap<PDFAnnotation, PDFAnnotation> pageAnnots = new LinkedHashMap<PDFAnnotation, PDFAnnotation>();
            if (annots != null) {
                newAnnots = this.cloneAnnots(annots, mapPages, curDests, allDests, pageAnnots, allActions, allAdditionalActions);
            }
            if (newAnnots == null) continue;
            PDFPage copiedPage = mapPagesEntry.getValue();
            PDFAnnotationList targetAnnots = copiedPage.procureAnnotationList();
            targetAnnots.addAnnotations(newAnnots);
            for (Map.Entry entry : pageAnnots.entrySet()) {
                allAnnots.put((PDFAnnotation)entry.getKey(), (PDFAnnotation)entry.getValue());
            }
        }
        return allAnnots;
    }

    public PDFAnnotationList cloneAnnots(PDFAnnotationList annots, Map<PDFPage, PDFPage> mapPages, PMMNamedDestinations curDests, Map<ASString, PDFDestinationNamed> allDests, Map<PDFAnnotation, PDFAnnotation> mapAnnots, Map<PDFAction, PDFAction> allActions, Map<PDFAdditionalActions, PDFAdditionalActions> allAdditionalActions) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFAnnotationList copiedAnnots = PDFAnnotationList.newInstance((PDFDocument)this.curDoc);
        if (annots == null) {
            return null;
        }
        for (int annotsInd = 0; annotsInd < annots.size(); ++annotsInd) {
            PDFAnnotation curAnnot = annots.get(annotsInd);
            PDFAnnotation cloned = this.cloneAnnotation(curAnnot, mapPages, curDests, mapAnnots, allDests, allActions, allAdditionalActions);
            copiedAnnots.add(cloned);
        }
        return copiedAnnots;
    }

    public PDFAnnotation cloneAnnotation(PDFAnnotation srcAnnot, Map<PDFPage, PDFPage> mapPages, PMMNamedDestinations curDests, Map<PDFAnnotation, PDFAnnotation> allAnnots, Map<ASString, PDFDestinationNamed> allDests, Map<PDFAction, PDFAction> allActions, Map<PDFAdditionalActions, PDFAdditionalActions> allAdditionalActions) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (allAnnots.containsKey(srcAnnot)) {
            return allAnnots.get(srcAnnot);
        }
        CosDictionary cosAnnot = this.curDoc.getCosDocument().createCosDictionary();
        Iterator keyIterator = srcAnnot.getCosDictionary().keyIterator();
        while (keyIterator.hasNext()) {
            PDFDestination srcDest;
            PDFDestination dest;
            ASName curKey = (ASName)keyIterator.next();
            if (!Utility.nameInArray((ASName)curKey, (ASName[])specialAnnotationsKeys)) {
                cosAnnot.put(curKey, this.cloneHandler.clone(srcAnnot.getCosDictionary().get(curKey)));
                continue;
            }
            if (curKey == ASName.k_P) {
                PDFPage refPage = PDFPage.getInstance((CosObject)srcAnnot.getDictionaryDictionaryValue(ASName.k_P));
                if (refPage == null || mapPages == null || !mapPages.containsKey(refPage)) continue;
                cosAnnot.put(curKey, mapPages.get(refPage).getCosObject());
                continue;
            }
            if (curKey == ASName.k_A) {
                PDFAction clonedAction = this.cloneAction(allActions, srcAnnot.getAction(), curDests, allDests, mapPages);
                if (clonedAction == null) continue;
                cosAnnot.put(curKey, clonedAction.getCosObject());
                continue;
            }
            if (curKey == ASName.k_Popup) {
                PDFAnnotationPopup popup = ((PDFAnnotationMarkup)srcAnnot).getPopup();
                if (!allAnnots.containsKey(popup)) {
                    this.cloneAnnotation((PDFAnnotation)popup, mapPages, curDests, allAnnots, allDests, allActions, allAdditionalActions);
                }
                PDFAnnotation clonedPopup = allAnnots.get(popup);
                clonedPopup.getCosDictionary().put(ASName.k_Parent, (CosObject)cosAnnot);
                cosAnnot.put(curKey, clonedPopup.getCosObject());
                continue;
            }
            if (curKey == ASName.k_IRT) {
                CosObject cosIRT = ((PDFAnnotationMarkup)srcAnnot).getDictionaryCosObjectValue(ASName.k_IRT);
                if (cosIRT.getType() != 6) continue;
                PDFAnnotation reply = PDFAnnotationFactory.getInstance((CosObject)cosIRT);
                if (!allAnnots.containsKey(reply)) {
                    this.cloneAnnotation(reply, mapPages, curDests, allAnnots, allDests, allActions, allAdditionalActions);
                }
                cosAnnot.put(curKey, allAnnots.get(reply).getCosObject());
                continue;
            }
            if (curKey != ASName.k_Dest || (dest = PMMNamedDestinations.cloneDestination(srcDest = ((PDFAnnotationLink)srcAnnot).getDestination(), curDests, allDests, mapPages)) == null) continue;
            cosAnnot.put(curKey, dest.getCosObject());
        }
        ASName type = cosAnnot.getName(ASName.k_Subtype);
        if (type == null) {
            throw new PDFInvalidDocumentException("Invalid annotation.");
        }
        PDFAnnotation clonedAnnot = PDFAnnotationFactory.getInstance((CosObject)cosAnnot);
        PDFAdditionalActions clonedAdditionalAction = this.cloneAdditionalActions(this.curDoc, this.cloneHandler, srcAnnot.getAdditionalActions(), curDests, allDests, mapPages, allActions, allAdditionalActions);
        if (clonedAdditionalAction != null) {
            clonedAnnot.setAdditionalActions(clonedAdditionalAction);
        }
        allAnnots.put(srcAnnot, clonedAnnot);
        return clonedAnnot;
    }

    public PDFPage clonePage(PDFPage pdfPage) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFRectangle srcMediaBox = pdfPage.getMediaBox();
        PDFRectangle curMediaBox = srcMediaBox == null ? PDFRectangle.newInstance((PDFDocument)this.curDoc, (ASRectangle)new ASRectangle(0.0, 0.0, 612.0, 792.0)) : PDFRectangle.newInstance((PDFDocument)this.curDoc, (double)srcMediaBox.llx(), (double)srcMediaBox.lly(), (double)srcMediaBox.urx(), (double)srcMediaBox.ury());
        PDFRectangle curCropBox = pdfPage.getCropBox();
        if (curCropBox == null) {
            curCropBox = curMediaBox;
        }
        PDFPage newPage = null;
        ASName[] specialKeys = null;
        if (pdfPage instanceof PDFTemplate) {
            newPage = PDFTemplate.newInstance((PDFDocument)this.curDoc, (PDFRectangle)curMediaBox);
            specialKeys = specialTemplateKeys;
        } else {
            newPage = PDFPage.newInstance((PDFDocument)this.curDoc, (PDFRectangle)curMediaBox);
            newPage.setCropBox(curCropBox.llx(), curCropBox.lly(), curCropBox.urx(), curCropBox.ury());
            specialKeys = specialPageKeys;
        }
        Iterator keyIterator = pdfPage.getCosDictionary().keyIterator();
        while (keyIterator.hasNext()) {
            ASName curKey = (ASName)keyIterator.next();
            if (Utility.nameInArray((ASName)curKey, (ASName[])specialKeys)) continue;
            newPage.setDictionaryValue(curKey, this.cloneHandler.clone(pdfPage.getCosDictionary().get(curKey)));
        }
        this.cloneResources(pdfPage, newPage);
        return newPage;
    }

    public PDFPage createPageFromTemplate(PDFPage template, String templateName) throws PDFCosParseException, PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFUnableToCompleteOperationException {
        PDFRectangle srcMediaBox = template.getMediaBox();
        PDFRectangle curMediaBox = PDFRectangle.newInstance((PDFDocument)this.curDoc, (double)srcMediaBox.llx(), (double)srcMediaBox.lly(), (double)srcMediaBox.urx(), (double)srcMediaBox.ury());
        PDFPage newPage = null;
        ASName[] specialKeys = null;
        newPage = PDFPage.newInstance((PDFDocument)this.curDoc, (PDFRectangle)curMediaBox);
        specialKeys = specialPageKeys;
        Iterator keyIterator = template.getCosDictionary().keyIterator();
        while (keyIterator.hasNext()) {
            ASName curKey = (ASName)keyIterator.next();
            if (Utility.nameInArray((ASName)curKey, (ASName[])specialKeys) || curKey.asString().equalsIgnoreCase("type")) continue;
            newPage.setDictionaryValue(curKey, this.cloneHandler.clone(template.getCosDictionary().get(curKey)));
        }
        this.cloneResources(template, newPage);
        newPage.setTemplateName(templateName);
        return newPage;
    }

    public PDFPage createTemplateFromPage(PDFPage template, String templateName) throws PDFCosParseException, PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFUnableToCompleteOperationException {
        PDFRectangle srcMediaBox = template.getMediaBox();
        PDFRectangle curMediaBox = PDFRectangle.newInstance((PDFDocument)this.curDoc, (double)srcMediaBox.llx(), (double)srcMediaBox.lly(), (double)srcMediaBox.urx(), (double)srcMediaBox.ury());
        PDFPage newPage = null;
        ASName[] specialKeys = null;
        newPage = PDFTemplate.newInstance((PDFDocument)this.curDoc, (PDFRectangle)curMediaBox);
        specialKeys = specialPageKeys;
        Iterator keyIterator = template.getCosDictionary().keyIterator();
        while (keyIterator.hasNext()) {
            ASName curKey = (ASName)keyIterator.next();
            if (Utility.nameInArray((ASName)curKey, (ASName[])specialKeys) || curKey.asString().equalsIgnoreCase("type")) continue;
            newPage.setDictionaryValue(curKey, this.cloneHandler.clone(template.getCosDictionary().get(curKey)));
        }
        this.cloneResources(template, newPage);
        return newPage;
    }

    public PDFAdditionalActions cloneAdditionalActions(PDFDocument inDoc, CosCloneMgr cloneHandler, PDFAdditionalActions action, PMMNamedDestinations curDests, Map<ASString, PDFDestinationNamed> allDests, Map<PDFPage, PDFPage> mapPages, Map<PDFAction, PDFAction> allActions, Map<PDFAdditionalActions, PDFAdditionalActions> clonedAdditionalActions) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (action == null) {
            return null;
        }
        if (clonedAdditionalActions != null && clonedAdditionalActions.containsKey(action)) {
            return clonedAdditionalActions.get(action);
        }
        CosDictionary clonedActions = (CosDictionary)cloneHandler.clone((CosObject)inDoc.getCosDocument().createCosDictionary());
        Iterator actionsIter = action.getCosDictionary().keyIterator();
        while (actionsIter.hasNext()) {
            ASName key = (ASName)actionsIter.next();
            PDFAction srcAction = PDFActionFactory.getInstance((CosObject)action.getCosDictionary().get(key));
            PDFAction clonedAction = this.cloneAction(allActions, srcAction, curDests, allDests, mapPages);
            if (clonedAction == null) continue;
            clonedActions.put(key, clonedAction.getCosObject());
        }
        return PDFAdditionalActions.getInstance((CosObject)clonedActions, (PDFAdditionalActions)action);
    }

    public PDFAction cloneAction(Map<PDFAction, PDFAction> clonedActions, PDFAction action, PMMNamedDestinations curDests, Map<ASString, PDFDestinationNamed> allDests, Map<PDFPage, PDFPage> mapPages) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosObject bead;
        if (action == null || action instanceof PDFActionOCG) {
            return null;
        }
        if (clonedActions.containsKey(action)) {
            return clonedActions.get(action);
        }
        CosDictionary clonedAction = CosUtils.cloneOrdinaryKeys((CosDocument)this.curDoc.getCosDocument(), (CosCloneMgr)this.cloneHandler, (CosDictionary)action.getCosDictionary(), (ASName[])specialActionKeys);
        CosObject dKey = action.getDictionaryCosObjectValue(ASName.k_D);
        CosObject clonedDKey = null;
        if (dKey != null) {
            if (action instanceof PDFActionThread) {
                clonedDKey = this.cloneThread(dKey, mapPages);
            } else {
                PDFDestination dest = null;
                PDFDestination clonedDest = null;
                if (action instanceof PDFActionGoTo) {
                    dest = ((PDFActionGoTo)action).getDestination();
                } else if (action instanceof PDFActionGoToRemote) {
                    dest = ((PDFActionGoToRemote)action).getDestination();
                }
                if (dest != null) {
                    clonedDest = PMMNamedDestinations.cloneDestination(dest, curDests, allDests, mapPages);
                    clonedDKey = clonedDest.getCosObject();
                }
            }
        }
        if (clonedDKey != null) {
            clonedAction.put(ASName.k_D, clonedDKey);
        }
        if ((bead = this.cloneBead(action.getDictionaryCosObjectValue(ASName.k_B), mapPages)) != null) {
            clonedAction.put(ASName.k_B, bead);
        }
        CosObject next = action.getDictionaryCosObjectValue(ASName.k_Next);
        CosArray clonedNext = null;
        if (next != null) {
            if (next.getType() == 6) {
                PDFAction nextAction = PDFActionFactory.getInstance((CosObject)next);
                if (nextAction != null) {
                    clonedNext = this.cloneAction(clonedActions, nextAction, curDests, allDests, mapPages).getCosObject();
                }
            } else if (next.getType() == 5) {
                clonedNext = this.curDoc.getCosDocument().createCosArray();
                for (CosDictionary curAction : (CosArray)next) {
                    CosObject curCloned = null;
                    PDFAction nextAction = PDFActionFactory.getInstance((CosObject)curAction);
                    if (nextAction != null) {
                        curCloned = this.cloneAction(clonedActions, nextAction, curDests, allDests, mapPages).getCosObject();
                    }
                    if (curCloned == null) continue;
                    clonedNext.add(curCloned);
                }
            }
            if (clonedNext != null) {
                clonedAction.put(ASName.k_Next, (CosObject)clonedNext);
            }
        }
        PDFAction clonedPDFAction = PDFActionFactory.getInstance((CosObject)clonedAction);
        clonedActions.put(action, clonedPDFAction);
        return clonedPDFAction;
    }

    private CosObject cloneThread(CosObject thread, Map<PDFPage, PDFPage> mapPages) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (thread == null) {
            return null;
        }
        if (this.mClonedThreads.containsKey(thread)) {
            return this.mClonedThreads.get(thread);
        }
        if (thread instanceof CosScalar) {
            return this.cloneHandler.clone(thread);
        }
        if (thread.getType() != 6) {
            return null;
        }
        CosDictionary clonedThread = this.curDoc.getCosDocument().createCosDictionary();
        CosUtils.cloneOrdinaryKeys((CosDictionary)clonedThread, (CosCloneMgr)this.cloneHandler, (CosDictionary)((CosDictionary)thread), (ASName[])specialThreadKeys);
        this.mClonedThreads.put(thread, (CosObject)clonedThread);
        CosObject bead = this.cloneBead(((CosDictionary)thread).get(ASName.k_F), mapPages);
        if (bead != null) {
            clonedThread.put(ASName.k_F, bead);
        }
        return clonedThread;
    }

    private CosObject cloneBead(CosObject bead, Map<PDFPage, PDFPage> mapPages) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosObject refBead;
        CosObject page;
        if (bead == null) {
            return null;
        }
        if (this.mClonedBeads.containsKey(bead)) {
            return this.mClonedBeads.get(bead);
        }
        if (bead instanceof CosScalar) {
            return this.cloneHandler.clone(bead);
        }
        if (bead.getType() != 6) {
            return null;
        }
        CosDictionary clonedBead = this.curDoc.getCosDocument().createCosDictionary();
        CosUtils.cloneOrdinaryKeys((CosDictionary)clonedBead, (CosCloneMgr)this.cloneHandler, (CosDictionary)((CosDictionary)bead), (ASName[])specialBeadKeys);
        this.mClonedBeads.put(bead, (CosObject)clonedBead);
        CosObject thread = this.cloneThread(((CosDictionary)bead).get(ASName.k_T), mapPages);
        if (thread != null) {
            clonedBead.put(ASName.k_T, thread);
        }
        if ((page = ((CosDictionary)bead).get(ASName.k_P)) != null) {
            PDFPage pdfPage = mapPages.get(PDFPage.getInstance((CosObject)page));
            CosObject clonedPage = pdfPage != null ? pdfPage.getCosObject() : this.curDoc.getCosDocument().createCosNull();
            clonedBead.put(ASName.k_P, clonedPage);
        }
        if ((refBead = this.cloneBead(((CosDictionary)bead).get(ASName.k_N), mapPages)) != null) {
            clonedBead.put(ASName.k_N, refBead);
        }
        if ((refBead = this.cloneBead(((CosDictionary)bead).get(ASName.k_V), mapPages)) != null) {
            clonedBead.put(ASName.k_V, refBead);
        }
        return clonedBead;
    }

    private void cloneResources(PDFPage srcPage, PDFPage destPage) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFResources srcResources = srcPage.getResources();
        if (srcResources != null) {
            destPage.setResources(this.cloneResources(destPage.getPDFDocument(), this.cloneHandler, srcResources));
        }
    }

    public PDFResources cloneResources(PDFDocument toDoc, CosCloneMgr cloneHandler, PDFResources resources) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFMCPropertyMap properties;
        if (resources == null) {
            return null;
        }
        try {
            ((DocumentListenerRegistryBase)resources.getPDFDocument().getListenerRegistry()).sendMessage(new DocumentMessage(DocumentMessage.FLUSH_FONTS, this.curDoc), true);
        }
        catch (PDFUnableToCompleteOperationException e) {
            // empty catch block
        }
        CosDictionary clonedDict = CosUtils.cloneOrdinaryKeys((CosDocument)toDoc.getCosDocument(), (CosCloneMgr)cloneHandler, (CosDictionary)resources.getCosDictionary(), (ASName[])specialResourcesKeys);
        PDFResources clonedResources = PDFResources.getInstance((CosObject)clonedDict);
        PDFXObjectMap xObjects = resources.getXObjectMap();
        if (xObjects != null) {
            PDFXObjectMap clonedXObjectMap = null;
            for (ASName key : xObjects.keySet()) {
                PDFXObject clonedXObject;
                PDFXObject xObject = xObjects.get(key);
                if (xObject == null || (clonedXObject = this.cloneXObject(toDoc, cloneHandler, xObject)) == null) continue;
                if (clonedXObjectMap == null) {
                    clonedXObjectMap = PDFXObjectMap.newInstance((PDFDocument)toDoc);
                }
                clonedXObjectMap.set(key, clonedXObject);
            }
            if (clonedXObjectMap != null) {
                clonedResources.setXObjectMap(clonedXObjectMap);
            }
        }
        if ((properties = resources.getMCPropertyMap()) != null) {
            PDFMCPropertyMap clonedPropertiesMap = null;
            for (ASName key : properties.keySet()) {
                PDFMCProperty oneProperty = properties.get(key);
                PDFMCProperty clonedProperty = null;
                if (!PDFOCObject.isOCObject((CosObject)oneProperty.getCosObject())) {
                    clonedProperty = PDFMCProperty.getInstance((CosObject)cloneHandler.clone(oneProperty.getCosObject()));
                }
                if (clonedProperty == null) continue;
                if (clonedPropertiesMap == null) {
                    clonedPropertiesMap = PDFMCPropertyMap.newInstance((PDFDocument)toDoc);
                }
                clonedPropertiesMap.set(key, clonedProperty);
            }
            if (clonedPropertiesMap != null) {
                clonedResources.setMCPropertyMap(clonedPropertiesMap);
            }
        }
        return clonedResources;
    }

    private PDFXObject cloneXObject(PDFDocument toDoc, CosCloneMgr cloneHandler, PDFXObject xObject) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.mClonedXObjects.containsKey(xObject)) {
            return this.mClonedXObjects.get(xObject);
        }
        CosStream clonedCosXObject = toDoc.getCosDocument().createCosStream();
        CosUtils.cloneOrdinaryKeys((CosDictionary)clonedCosXObject, (CosCloneMgr)cloneHandler, (CosDictionary)xObject.getCosStream(), (ASName[])specialXObjectKeys);
        boolean encoded = true;
        InputByteStream streamData = xObject.getCosStream().getStreamEncoded();
        try {
            if (streamData == null || streamData.length() == 0L) {
                encoded = false;
                streamData = xObject.getCosStream().getStreamDecoded();
            }
            if (streamData != null && streamData.length() > 0L) {
                StreamManager streamManager = clonedCosXObject.getStreamManager();
                OutputByteStream clonedData = streamManager.getOutputByteStreamEncryptedDocument(ByteWriterFactory.Fixed.FIXED, streamData.length());
                IO.copy((InputByteStream)streamData, (OutputByteStream)clonedData);
                if (encoded) {
                    clonedCosXObject.newDataEncoded(clonedData.closeAndConvert());
                } else {
                    clonedCosXObject.newDataDecoded(clonedData.closeAndConvert());
                }
                clonedData = null;
            }
        }
        catch (IOException e) {
            throw new PDFIOException((Throwable)e);
        }
        PDFXObject clonedXObject = PDFXObjectFactory.getInstance((CosObject)clonedCosXObject);
        this.mClonedXObjects.put(xObject, clonedXObject);
        if (xObject instanceof PDFXObjectForm) {
            PDFPagePiece formPiece;
            PDFResources resources = ((PDFXObjectForm)xObject).getResources();
            if (resources != null) {
                PDFResources clonedResources = this.cloneResources(toDoc, cloneHandler, resources);
                ((PDFXObjectForm)clonedXObject).setResources(clonedResources);
            }
            if ((formPiece = ((PDFXObjectForm)xObject).getPieceInfo()) != null) {
                PDFCompoundTypeInfo clonedType = null;
                ASDate lastDate = null;
                PDFCompoundTypeInfo srcType = PDFCompoundTypeInfo.getInstance((PDFXObjectForm)xObject);
                if (srcType != null) {
                    PDFApplicationData clonedData;
                    PDFPagePiece clonedPagePiece;
                    clonedType = PDFCompoundTypeInfo.newInstance(toDoc, srcType.getType());
                    clonedType.setType((PDFXObjectForm)clonedXObject);
                    PDFApplicationData srcData = formPiece.getApplicationData(PDFCompoundTypeInfo.k_CompoundType);
                    if (srcData != null) {
                        lastDate = srcData.getLastModified();
                    }
                    if ((clonedPagePiece = ((PDFXObjectForm)clonedXObject).getPieceInfo()) != null && (clonedData = clonedPagePiece.getApplicationData(PDFCompoundTypeInfo.k_CompoundType)) != null && clonedData.getLastModified() == null) {
                        if (lastDate == null) {
                            lastDate = new ASDate();
                        }
                        clonedData.setLastModified(lastDate);
                    }
                }
            }
        }
        if (xObject instanceof PDFXObjectImage) {
            PDFXObjectImage clonedNestedXObject;
            PDFXObjectImage nestedXObject;
            PDFXObjectImageMask sourceMask = ((PDFXObjectImage)xObject).getMask();
            if (sourceMask != null) {
                nestedXObject = sourceMask.getImageMask();
                if (nestedXObject != null) {
                    clonedNestedXObject = (PDFXObjectImage)this.cloneXObject(toDoc, cloneHandler, (PDFXObject)nestedXObject);
                    if (clonedNestedXObject != null) {
                        ((PDFXObjectImage)clonedXObject).setMask(PDFXObjectImageMask.getInstance((CosObject)clonedNestedXObject.getCosObject()));
                    }
                } else {
                    PDFXObjectColorMask colorMask = sourceMask.getColorMask();
                    if (colorMask != null) {
                        ((PDFXObjectImage)clonedXObject).setMask(PDFXObjectImageMask.getInstance((CosObject)cloneHandler.clone(colorMask.getCosObject())));
                    }
                }
            }
            if ((nestedXObject = ((PDFXObjectImage)xObject).getSMask()) != null && (clonedNestedXObject = (PDFXObjectImage)this.cloneXObject(toDoc, cloneHandler, (PDFXObject)nestedXObject)) != null) {
                ((PDFXObjectImage)clonedXObject).setSMask(clonedNestedXObject);
            }
            PDFXObjectAltImageList altList = ((PDFXObjectImage)xObject).getAlternatesList();
            PDFXObjectAltImageList clonedAltList = null;
            if (altList != null) {
                for (PDFXObjectAltImage altImage : altList) {
                    nestedXObject = altImage.getImage();
                    if (nestedXObject == null || (clonedNestedXObject = (PDFXObjectImage)this.cloneXObject(toDoc, cloneHandler, (PDFXObject)nestedXObject)) == null) continue;
                    PDFXObjectAltImage clonedAltImage = PDFXObjectAltImage.getInstance((CosObject)CosUtils.cloneOrdinaryKeys((CosDocument)toDoc.getCosDocument(), (CosCloneMgr)cloneHandler, (CosDictionary)altImage.getCosDictionary(), (ASName[])specialAltImageKeys));
                    clonedAltImage.setImage(clonedNestedXObject);
                    if (clonedAltList == null) {
                        clonedAltList = PDFXObjectAltImageList.newInstance((PDFDocument)toDoc);
                    }
                    clonedAltList.add((PDFCosObjectContainer)clonedAltImage);
                }
                if (clonedAltList != null) {
                    ((PDFXObjectImage)clonedXObject).setAlternatesList(clonedAltList);
                }
            }
        }
        return clonedXObject;
    }

    public Map<PDFXObject, PDFXObject> getClonedXObjects() {
        return this.mClonedXObjects;
    }
}

