/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.manipulations;

import com.adobe.internal.pdftoolkit.core.cos.CosCloneMgr;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFConfigurationException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFUnableToCompleteOperationException;
import com.adobe.internal.pdftoolkit.core.types.ASString;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.document.PDFNameDictionary;
import com.adobe.internal.pdftoolkit.pdf.document.PDFTree;
import com.adobe.internal.pdftoolkit.pdf.graphics.xobject.PDFXObject;
import com.adobe.internal.pdftoolkit.pdf.interactive.forms.PDFNamedPages;
import com.adobe.internal.pdftoolkit.pdf.interactive.forms.PDFNamedTemplates;
import com.adobe.internal.pdftoolkit.pdf.page.PDFPage;
import com.adobe.internal.pdftoolkit.pdf.page.PDFTemplate;
import com.adobe.internal.pdftoolkit.services.manipulations.PMMOptions;
import com.adobe.internal.pdftoolkit.services.manipulations.PMMService;
import com.adobe.internal.pdftoolkit.services.manipulations.impl.PMMPages;
import com.adobe.internal.pdftoolkit.services.xobjhandler.PageContentXObject;
import java.util.ArrayList;
import java.util.Iterator;

public class PMMTemplates {
    private PDFDocument inDoc;
    private CosCloneMgr cloneHandler;
    private boolean toOverlay = true;
    private boolean append = false;

    public PMMTemplates(PDFDocument doc) {
        this.inDoc = doc;
        this.cloneHandler = new CosCloneMgr(this.inDoc.getCosDocument());
    }

    public PDFPage addTemplate(PDFDocument doc, String tempName, int pageNum) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        PDFNameDictionary pdfNameDict = doc.requireCatalog().getNameDictionary();
        if (this.templateExistsForName(doc, tempName) != null) {
            this.removeTemplate(doc, tempName);
        }
        PDFPage page = doc.requirePages().getPage(pageNum);
        PDFNamedPages pages = pdfNameDict.procureNamedPages();
        pages.addEntry((Object)new ASString(tempName), (Object)page);
        return page;
    }

    public void removeTemplate(PDFDocument doc, String tempName) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFNameDictionary pdfNameDict = doc.requireCatalog().getNameDictionary();
        PDFNamedTemplates namedtemplate = pdfNameDict.getNamedTemplates();
        Iterator destsIterator = namedtemplate.iterator();
        while (destsIterator.hasNext()) {
            PDFTree.Entry entry = (PDFTree.Entry)destsIterator.next();
            ASString key = (ASString)entry.getKey();
            if (!key.asString().equalsIgnoreCase(tempName)) continue;
            destsIterator.remove();
        }
        PDFNamedPages namedPagese = pdfNameDict.getNamedPages();
        Iterator namedPagesIterator = namedPagese.iterator();
        while (destsIterator.hasNext()) {
            PDFTree.Entry entry = (PDFTree.Entry)namedPagesIterator.next();
            ASString key = (ASString)entry.getKey();
            if (!key.asString().equalsIgnoreCase(tempName)) continue;
            destsIterator.remove();
        }
    }

    public void hideTemplate(PDFPage template, String templateName) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException, PDFUnableToCompleteOperationException {
        PDFNameDictionary pdfNameDict = template.getPDFDocument().requireCatalog().getNameDictionary();
        PDFNamedPages namedPagese = pdfNameDict.getNamedPages();
        Iterator destsIterator = namedPagese.iterator();
        while (destsIterator.hasNext()) {
            PDFTree.Entry entry = (PDFTree.Entry)destsIterator.next();
            ASString key = (ASString)entry.getKey();
            if (!key.asString().equalsIgnoreCase(templateName)) continue;
            destsIterator.remove();
        }
        PDFNamedTemplates namedtemplate = pdfNameDict.procureNamedTemplates();
        PMMPages pages = new PMMPages(this.inDoc, this.cloneHandler);
        namedtemplate.addEntry((Object)new ASString(templateName), (Object)((PDFTemplate)pages.createTemplateFromPage(template, templateName)));
        PMMService pmmServ = new PMMService(this.inDoc);
        pmmServ.deletePages(template, 1);
    }

    public boolean templateExistsForPage(PDFPage page) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        Iterator pages = page.getPDFDocument().requirePages().iterator();
        while (pages.hasNext()) {
            if (pages.next() != page) continue;
            return true;
        }
        return false;
    }

    public PDFPage templateExistsForName(PDFDocument doc, String tempName) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return (PDFPage)this.templateExistsForNameOrPage(doc, tempName, null);
    }

    public Object templateExistsForNameOrPage(PDFDocument doc, String tempName, Integer n) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFNameDictionary pdfNameDict = doc.requireCatalog().getNameDictionary();
        if (pdfNameDict != null) {
            PDFNamedPages namedPages;
            Integer n2;
            PDFNamedTemplates namedtemplate = pdfNameDict.getNamedTemplates();
            if (namedtemplate != null) {
                for (PDFTree.Entry entry : namedtemplate) {
                    ASString key = (ASString)entry.getKey();
                    if (n != null) {
                        if (n == 0) {
                            return key.asString();
                        }
                        Integer n3 = n;
                        n2 = n = Integer.valueOf(n - 1);
                        continue;
                    }
                    if (tempName == null || !key.asString().equalsIgnoreCase(tempName)) continue;
                    return entry.getValue();
                }
            }
            if ((namedPages = pdfNameDict.getNamedPages()) != null) {
                for (PDFTree.Entry entry : namedPages) {
                    ASString key = (ASString)entry.getKey();
                    if (n != null) {
                        if (n == 0) {
                            return key.asString();
                        }
                        n2 = n;
                        Integer n4 = n = Integer.valueOf(n - 1);
                        continue;
                    }
                    if (tempName == null || !key.asString().equalsIgnoreCase(tempName)) continue;
                    return entry.getValue();
                }
            }
        }
        return null;
    }

    public ArrayList getTemplatesInDocument(PDFDocument doc) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        ArrayList<PDFTree.Entry> templateList = new ArrayList<PDFTree.Entry>();
        PDFNameDictionary pdfNameDict = doc.requireCatalog().getNameDictionary();
        PDFNamedTemplates namedtemplate = pdfNameDict.getNamedTemplates();
        for (PDFTree.Entry entry : namedtemplate) {
            templateList.add(entry);
        }
        PDFNamedPages namedPages = pdfNameDict.getNamedPages();
        for (PDFTree.Entry entry : namedPages) {
            templateList.add(entry);
        }
        return templateList;
    }

    public PDFXObject spawnPageFromTemplate(PDFDocument doc, int nPage, boolean rename, boolean overlay, PDFXObject xObject, String tempName) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException, PDFConfigurationException, PDFUnableToCompleteOperationException {
        int iHere;
        int nPages = doc.requirePages().getNumPages();
        String cesPrefix = "";
        if (nPage >= 0 && nPage < nPages) {
            iHere = nPage--;
            this.toOverlay = overlay;
        } else {
            if (!overlay) {
                this.toOverlay = false;
                this.append = true;
            }
            nPage = nPages - 1;
            iHere = nPage + 1;
        }
        if (rename) {
            cesPrefix = "P" + iHere + "." + tempName;
        }
        return this.templateSpawnPage(doc, doc, nPage, this.toOverlay, cesPrefix, xObject, tempName, rename);
    }

    public PDFXObject templateSpawnPage(PDFDocument frDoc, PDFDocument toDoc, int nPage, boolean toOverlay, String cesPrefix, PDFXObject xObject, String tempName, boolean rename) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException, PDFConfigurationException, PDFUnableToCompleteOperationException {
        PDFPage templatePage = this.templateExistsForName(frDoc, tempName);
        if (templatePage == null) {
            return null;
        }
        PDFXObject xObjectForPage = null;
        if (xObject == null) {
            PMMPages pages = new PMMPages(this.inDoc, this.cloneHandler);
            PDFPage newPage = pages.createPageFromTemplate(templatePage, tempName);
            xObjectForPage = PageContentXObject.generateContentXObject(toDoc, newPage, null);
        } else {
            xObjectForPage = xObject;
        }
        PMMService pmmService = new PMMService(toDoc);
        if (!toOverlay && !this.append) {
            pmmService.insertPagesinRange(toDoc.requirePages().getPage(nPage), xObjectForPage, false, templatePage, 0, false, null, PMMOptions.newInstanceAll(), null, true, tempName, cesPrefix, rename);
            pmmService.copyAllNamedJavaScripts(toDoc);
            pmmService.copyAllTemplatePages(toDoc);
            pmmService.copyAllNamedEmbeddedFiles(toDoc);
        } else if (!toOverlay && this.append) {
            PMMOptions options = PMMOptions.newInstanceAll();
            options.disable(PMMOptions.Bookmarks);
            options.disable(PMMOptions.PageLabels);
            pmmService.insertPagesinRange(this.inDoc.requirePages().getLastPage(), xObjectForPage, true, templatePage, 0, true, null, options, null, true, tempName, cesPrefix, rename);
        } else {
            pmmService.insertPagesinRange(toDoc.requirePages().getPage(nPage), xObjectForPage, false, templatePage, 0, false, null, PMMOptions.newInstanceAll(), null, true, tempName, cesPrefix, rename);
            pmmService.copyAllNamedJavaScripts(toDoc);
            pmmService.copyAllTemplatePages(toDoc);
            pmmService.copyAllNamedEmbeddedFiles(toDoc);
        }
        return xObjectForPage;
    }
}

