/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.manipulations;

import com.adobe.internal.pdftoolkit.core.cos.CosArray;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosObject;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.document.PDFTree;
import com.adobe.internal.pdftoolkit.pdf.page.PDFPage;
import com.adobe.internal.pdftoolkit.pdf.page.PDFPageLabel;
import com.adobe.internal.pdftoolkit.pdf.page.PDFPageLabelStyle;
import com.adobe.internal.pdftoolkit.pdf.page.PDFPageLabels;
import com.adobe.internal.pdftoolkit.pdf.page.PDFPageTree;
import com.adobe.internal.pdftoolkit.pdf.utils.PDFUtil;
import java.util.Iterator;

final class PMMPageLabels {
    PDFDocument mDoc;

    PMMPageLabels(PDFDocument pdfDoc) {
        this.mDoc = pdfDoc;
    }

    void delete(int fromPage, int toPage, int numPages) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        PDFPageLabels labels = this.mDoc.requireCatalog().getPageLabels();
        PDFPageLabels newLabels = null;
        if (labels == null) {
            return;
        }
        PDFPageTree pages = this.mDoc.requireCatalog().getPages();
        if (pages != null && pages.getNumPages() != 0) {
            if (fromPage > numPages) {
                return;
            }
            toPage = Math.min(toPage, numPages);
            labels.split(fromPage);
            if (toPage < numPages) {
                labels.split(toPage + 1);
            }
            Iterator labelsIter = labels.iterator();
            newLabels = PDFPageLabels.newInstance((PDFDocument)this.mDoc);
            while (labelsIter.hasNext()) {
                PDFTree.Entry labelEntry = (PDFTree.Entry)labelsIter.next();
                if ((Integer)labelEntry.getKey() < fromPage) {
                    newLabels.replaceEntry(labelEntry.getKey(), labelEntry.getValue());
                }
                if ((Integer)labelEntry.getKey() <= toPage) continue;
                newLabels.replaceEntry((Object)((Integer)labelEntry.getKey() - toPage + fromPage - 1), labelEntry.getValue());
            }
            if (newLabels.isEmpty()) {
                newLabels = null;
            } else {
                this.removeExtraLabels(newLabels, newLabels.getPDFDocument().requirePages().getNumPages());
            }
        }
        this.mDoc.requireCatalog().setPageLabels(newLabels);
    }

    void insert(int afterPage, PDFDocument srcDoc, PDFPageLabels srcLabels, int fromPage, int toPage) throws PDFInvalidDocumentException, PDFIOException, PDFInvalidParameterException, PDFSecurityException {
        PDFPageLabels oldLabels;
        if (srcLabels == null) {
            srcLabels = this.makeDefaultPageLabels(srcDoc, fromPage, toPage - fromPage + 1);
        }
        if ((oldLabels = this.mDoc.requireCatalog().getPageLabels()) == null) {
            oldLabels = this.makeDefaultPageLabels(this.mDoc, 0, this.mDoc.requirePages().getNumPages() - 1);
        }
        oldLabels.split(afterPage + 1);
        PDFPageLabels newLabels = PDFPageLabels.newInstance((PDFDocument)this.mDoc);
        boolean inserted = false;
        Iterator labelsIter = oldLabels.iterator();
        PDFPageLabels srcLabelsCopy = PDFPageLabels.newInstance((PDFDocument)this.mDoc);
        this.copyPageLabels(this.mDoc, srcLabels, srcLabelsCopy);
        if (srcLabelsCopy != null && !srcLabelsCopy.isEmpty()) {
            srcLabelsCopy.split(fromPage);
            srcLabelsCopy.split(toPage + 1);
            while (labelsIter.hasNext()) {
                PDFTree.Entry labelEntry = (PDFTree.Entry)labelsIter.next();
                if ((Integer)labelEntry.getKey() <= afterPage) {
                    if (labelEntry.getValue() == null) continue;
                    newLabels.replaceEntry(labelEntry.getKey(), labelEntry.getValue());
                    continue;
                }
                if (!inserted) {
                    this.insertSourceLabels(newLabels, srcLabelsCopy, afterPage, fromPage, toPage);
                    inserted = true;
                }
                newLabels.replaceEntry((Object)((Integer)labelEntry.getKey() + toPage - fromPage + 1), labelEntry.getValue());
            }
            if (!inserted) {
                this.insertSourceLabels(newLabels, srcLabelsCopy, afterPage, fromPage, toPage);
            }
            this.removeExtraLabels(newLabels, newLabels.getPDFDocument().requirePages().getNumPages());
            this.mDoc.requireCatalog().setPageLabels(newLabels);
        }
    }

    void extract(PDFPageLabels srcLabels, int fromPage, int toPage) throws PDFInvalidDocumentException, PDFIOException, PDFInvalidParameterException, PDFSecurityException {
        PDFPageLabels labels = PDFPageLabels.newInstance((PDFDocument)this.mDoc);
        this.copyPageLabels(this.mDoc, srcLabels, labels);
        if (labels != null) {
            this.mDoc.requireCatalog().setPageLabels(labels);
            int numPages = this.mDoc.requirePages().getNumPages();
            this.delete(0, fromPage - 1, numPages);
            this.delete(toPage + 1, this.mDoc.requirePages().getNumPages(), numPages);
        }
    }

    void extract(PDFPageLabels srcLabels, PDFPage[] pageList) throws PDFInvalidDocumentException, PDFIOException, PDFInvalidParameterException, PDFSecurityException {
        if (srcLabels == null) {
            return;
        }
        int pageInd = 0;
        PDFPage startPage = pageList[pageInd];
        int startPageInd = startPage.getIndex();
        Iterator pageIter = srcLabels.getPDFDocument().requirePages().iterator(startPageInd);
        int fromPage = 0;
        int toPage = 0;
        int afterPage = -1;
        int pageCnt = -1;
        boolean inserted = false;
        boolean started = true;
        while (pageIter.hasNext() && pageInd < pageList.length) {
            PDFPage curPage;
            PDFPage nextPage = (PDFPage)pageIter.next();
            if (!PDFUtil.isPDFCosObjectRefEqual((PDFCosObject)nextPage, (PDFCosObject)(curPage = pageList[pageInd++]))) {
                this.insert(afterPage, srcLabels.getPDFDocument(), srcLabels, fromPage, toPage);
                started = true;
                inserted = true;
                pageIter = srcLabels.getPDFDocument().requirePages().iterator(curPage.getIndex());
                --pageInd;
                --pageCnt;
            } else if (started) {
                fromPage = toPage = curPage.getIndex();
                afterPage = pageCnt;
                started = false;
                inserted = false;
            } else {
                ++toPage;
            }
            ++pageCnt;
        }
        if (!inserted) {
            this.insert(afterPage, srcLabels.getPDFDocument(), srcLabels, fromPage, toPage);
        }
    }

    private void insertSourceLabels(PDFPageLabels newLabels, PDFPageLabels srcLabels, int afterPage, int fromPage, int toPage) throws PDFInvalidDocumentException, PDFIOException, PDFInvalidParameterException, PDFSecurityException {
        CosArray numsArray;
        PDFPageLabel lastEntryOfNewLabel = null;
        int index = 0;
        String prefix = null;
        int startingNumber = 0;
        if (newLabels != null && newLabels.getCosDictionary() != null && (numsArray = newLabels.getCosDictionary().getCosArray(ASName.k_Nums)) != null && !numsArray.isEmpty()) {
            int arraySize = numsArray.size();
            if (arraySize >= 2) {
                lastEntryOfNewLabel = PDFPageLabel.getInstance((CosObject)numsArray.getCosDictionary(arraySize - 1));
                index = numsArray.getInt(arraySize - 2);
            }
            startingNumber = lastEntryOfNewLabel.getStartingNumber();
            prefix = lastEntryOfNewLabel.getPrefix() != null ? lastEntryOfNewLabel.getPrefix().trim() : null;
        }
        for (PDFTree.Entry srcLabelEntry : srcLabels) {
            String srcLabelPrefix;
            if ((Integer)srcLabelEntry.getKey() < fromPage) continue;
            if ((Integer)srcLabelEntry.getKey() > toPage) break;
            PDFPageLabel addLabel = PDFPageLabel.newInstance((PDFDocument)this.mDoc, (PDFPageLabel)((PDFPageLabel)srcLabelEntry.getValue()));
            String string = srcLabelPrefix = srcLabelEntry.getValue() != null ? ((PDFPageLabel)srcLabelEntry.getValue()).getPrefix() : null;
            if (prefix != null && srcLabelPrefix != null) {
                if (prefix.equals(srcLabelPrefix.trim())) {
                    addLabel.setStartingNumber(startingNumber + (afterPage - fromPage + (Integer)srcLabelEntry.getKey() + 1) - index);
                } else {
                    addLabel.setStartingNumber(addLabel.getStartingNumber());
                }
            } else if (prefix == null && srcLabelPrefix != null || prefix != null && srcLabelPrefix == null) {
                addLabel.setStartingNumber(addLabel.getStartingNumber());
            } else {
                addLabel.setStartingNumber(addLabel.getStartingNumber() + afterPage + 1);
            }
            newLabels.replaceEntry((Object)(afterPage - fromPage + (Integer)srcLabelEntry.getKey() + 1), (Object)addLabel);
            startingNumber = addLabel.getStartingNumber();
            prefix = addLabel.getPrefix() == null ? null : addLabel.getPrefix().trim();
            index = afterPage - fromPage + (Integer)srcLabelEntry.getKey() + 1;
        }
    }

    PDFPageLabels makeDefaultPageLabels(PDFDocument pdfDoc, int startPage, int pageCount) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        PDFPageLabel madeUpLabel = PDFPageLabel.newInstance((PDFDocument)pdfDoc);
        madeUpLabel.setStartingNumber(startPage + 1);
        madeUpLabel.setPageLabelStyle(PDFPageLabelStyle.Decimal);
        PDFPageLabels labels = PDFPageLabels.newInstance((PDFDocument)pdfDoc);
        labels.addEntry((Object)0, (Object)madeUpLabel);
        if (pageCount > 0) {
            madeUpLabel = PDFPageLabel.newInstance((PDFDocument)pdfDoc);
            madeUpLabel.setStartingNumber(startPage + pageCount);
            madeUpLabel.setPageLabelStyle(PDFPageLabelStyle.Decimal);
            labels.replaceEntry((Object)(pageCount - 1), (Object)madeUpLabel);
        }
        return labels;
    }

    private void removeExtraLabels(PDFPageLabels labels, int limit) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        Iterator labelsIter = labels.iterator();
        while (labelsIter.hasNext()) {
            PDFTree.Entry labelEntry = (PDFTree.Entry)labelsIter.next();
            if ((Integer)labelEntry.getKey() < limit) continue;
            labelsIter.remove();
        }
    }

    private void copyPageLabels(PDFDocument pdfDocument, PDFPageLabels src, PDFPageLabels dest) throws PDFInvalidDocumentException, PDFIOException, PDFInvalidParameterException, PDFSecurityException {
        if (src == null || dest == null) {
            return;
        }
        for (PDFTree.Entry labelEntry : src) {
            if (labelEntry.getValue() == null) continue;
            dest.replaceEntry(labelEntry.getKey(), (Object)PDFPageLabel.newInstance((PDFDocument)pdfDocument, (PDFPageLabel)((PDFPageLabel)labelEntry.getValue())));
        }
    }
}

