/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.manipulations;

import com.adobe.internal.pdftoolkit.core.cos.CosCloneMgr;
import com.adobe.internal.pdftoolkit.core.cos.CosDictionary;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.core.types.ASString;
import com.adobe.internal.pdftoolkit.core.util.Utility;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosObject;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.interactive.action.PDFAction;
import com.adobe.internal.pdftoolkit.pdf.interactive.action.PDFActionGoTo;
import com.adobe.internal.pdftoolkit.pdf.interactive.navigation.PDFBookmark;
import com.adobe.internal.pdftoolkit.pdf.interactive.navigation.PDFBookmarkNode;
import com.adobe.internal.pdftoolkit.pdf.interactive.navigation.PDFBookmarkRoot;
import com.adobe.internal.pdftoolkit.pdf.interactive.navigation.PDFBookmarkUtils;
import com.adobe.internal.pdftoolkit.pdf.interactive.navigation.PDFDestination;
import com.adobe.internal.pdftoolkit.pdf.interactive.navigation.PDFDestinationExplicit;
import com.adobe.internal.pdftoolkit.pdf.interactive.navigation.PDFDestinationNamed;
import com.adobe.internal.pdftoolkit.pdf.page.PDFPage;
import com.adobe.internal.pdftoolkit.pdf.utils.PDFUtil;
import com.adobe.internal.pdftoolkit.services.manipulations.impl.PDFPageWrapperSet;
import com.adobe.internal.pdftoolkit.services.manipulations.impl.PMMNamedDestinations;
import com.adobe.internal.pdftoolkit.services.manipulations.impl.PMMPages;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

final class PMMBookmark {
    private static final ASName[] specialBoomarkKeys = new ASName[]{ASName.k_Parent, ASName.k_Prev, ASName.k_Next, ASName.k_First, ASName.k_Last, ASName.k_Dest, ASName.k_A, ASName.k_SE};
    private PDFDocument inDoc;
    private CosCloneMgr cloneHandler;
    private Map<PDFBookmarkNode, PDFBookmarkNode> clonedBookmarks;
    private PMMPages pagesHandler;

    PMMBookmark(PDFDocument doc, CosCloneMgr clonehandler, PMMPages pages) {
        this.inDoc = doc;
        this.cloneHandler = clonehandler;
        this.pagesHandler = pages;
    }

    private PDFBookmarkNode walkBookmarksTree(PDFBookmarkNode parent, PDFBookmarkNode startMark, BookmarkOperation action) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (startMark == null) {
            return null;
        }
        PDFBookmarkNode clonedMark = action.firstAction(parent, startMark);
        PDFBookmarkNode found = startMark;
        PDFBookmark lastMark = startMark.getLastKid();
        for (PDFBookmark curMark = startMark.getFirstKid(); curMark != null; curMark = curMark.getNext()) {
            String title = curMark.getTitle();
            title.equals(title);
            PDFBookmarkNode childMark = this.walkBookmarksTree(clonedMark, (PDFBookmarkNode)curMark, action);
            if (action.conditionAction(startMark, (PDFBookmarkNode)curMark)) {
                action.lastAction(startMark, (PDFBookmarkNode)curMark, childMark);
            }
            if (PDFUtil.isPDFCosObjectRefEqual((PDFCosObject)curMark, (PDFCosObject)lastMark)) break;
        }
        return found;
    }

    private boolean isBookmarkOnPage(PDFBookmarkNode bookmark, MapPages pagesMapping) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFAction action;
        if (pagesMapping == null) {
            return true;
        }
        PDFDestination dest = ((PDFBookmark)bookmark).getDestination();
        if (dest == null && (action = ((PDFBookmark)bookmark).getAction()) != null && action instanceof PDFActionGoTo) {
            dest = ((PDFActionGoTo)action).getDestination();
        }
        if (dest != null) {
            return pagesMapping.contains(dest.getPage());
        }
        return false;
    }

    private PDFBookmarkRoot reverseAppendedBookmarks(PDFBookmarkRoot root, PDFBookmark firstMark, PDFBookmark lastMark) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (root == null || firstMark == null || lastMark == null) {
            return root;
        }
        PDFBookmark curMark = firstMark;
        while (!PDFUtil.isPDFCosObjectRefEqual((PDFCosObject)curMark, (PDFCosObject)lastMark)) {
            curMark = curMark.getNext();
        }
        if (curMark == null) {
            return root;
        }
        if ((curMark = curMark.getNext()) == null) {
            return root;
        }
        PDFBookmarkRoot newRoot = PDFBookmarkRoot.newInstance((PDFDocument)root.getPDFDocument(), (PDFBookmark)curMark);
        while ((curMark = curMark.getNext()) != null) {
            PDFBookmarkUtils.appendLastKid((PDFBookmark)curMark, (PDFBookmarkNode)newRoot);
        }
        for (curMark = firstMark; curMark != null; curMark = curMark.getNext()) {
            PDFBookmarkUtils.appendLastKid((PDFBookmark)curMark, (PDFBookmarkNode)newRoot);
            if (!PDFUtil.isPDFCosObjectRefEqual((PDFCosObject)curMark, (PDFCosObject)lastMark)) continue;
            curMark.setNext(null);
            break;
        }
        root.getPDFDocument().requireCatalog().setBookmarkRoot(newRoot);
        return newRoot;
    }

    void deleteBookmarks(List<PDFPage> pages) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        DeleteBookmark deleteAction = new DeleteBookmark(pages);
        PDFBookmarkRoot root = this.inDoc.requireCatalog().getBookmarkRoot();
        if (root != null) {
            this.walkBookmarksTree((PDFBookmarkNode)root, (PDFBookmarkNode)root, deleteAction);
        }
    }

    PDFBookmarkNode appendBookmarks(PDFDocument srcDoc, PDFPage afterPage, PDFPage startPage, boolean importAllBookmarks, String title, Map<ASString, PDFDestinationNamed> allDests, PMMNamedDestinations curDests, Map<PDFPage, PDFPage> mapPages, Map<PDFAction, PDFAction> allActions, Map<PDFBookmarkNode, PDFBookmarkNode> allBookmarks, boolean prepend) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFBookmarkRoot rootMark;
        PDFBookmarkRoot oldRoot = rootMark = this.inDoc.requireCatalog().getBookmarkRoot();
        PDFBookmarkRoot appendRoot = rootMark;
        PDFBookmark firstMark = null;
        PDFBookmark lastMark = null;
        if (afterPage == null && rootMark != null) {
            firstMark = rootMark.getFirstKid();
            lastMark = rootMark.getLastKid();
        }
        if (title != null) {
            appendRoot = PDFBookmark.newInstance((PDFDocument)this.inDoc, (String)title);
        }
        this.clonedBookmarks = allBookmarks == null ? new HashMap() : allBookmarks;
        AppendBookmark appendBookmark = new AppendBookmark((PDFBookmarkNode)appendRoot, allDests, curDests, importAllBookmarks, mapPages, allActions);
        this.walkBookmarksTree((PDFBookmarkNode)appendRoot, (PDFBookmarkNode)srcDoc.requireCatalog().getBookmarkRoot(), appendBookmark);
        PDFBookmarkNode newRoot = appendBookmark.getTargetRoot();
        if (rootMark == null && (rootMark = newRoot instanceof PDFBookmark ? PDFBookmarkRoot.newInstance((PDFDocument)this.inDoc, (PDFBookmark)((PDFBookmark)newRoot)) : (PDFBookmarkRoot)newRoot) != null) {
            this.inDoc.requireCatalog().setBookmarkRoot(rootMark);
        }
        if (appendRoot != null && appendRoot instanceof PDFBookmark) {
            PDFPage destPage = mapPages.get(startPage);
            if (destPage != null) {
                PDFDestinationExplicit dest = PDFDestinationExplicit.newDestFit((PDFPage)destPage);
                ((PDFBookmark)appendRoot).setDestination((PDFDestination)dest);
            }
            if (oldRoot != null) {
                PDFBookmarkUtils.appendLastKid((PDFBookmark)((PDFBookmark)appendRoot), (PDFBookmarkNode)rootMark);
            }
        }
        this.reverseAppendedBookmarks(rootMark, firstMark, lastMark);
        return appendRoot;
    }

    PDFBookmarkNode extractBookmarks(PDFDocument srcDoc, Map<ASString, PDFDestinationNamed> allDests, boolean importAllBookmarks, PMMNamedDestinations curDests, Map<PDFPage, PDFPage> mapPages, Map<PDFAction, PDFAction> allActions, Map<PDFBookmarkNode, PDFBookmarkNode> allBookmarks) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFBookmarkRoot rootMark = srcDoc.requireCatalog().getBookmarkRoot();
        if (rootMark != null) {
            this.clonedBookmarks = allBookmarks == null ? new HashMap() : allBookmarks;
            AppendBookmark extractBookmark = new AppendBookmark(null, allDests, curDests, importAllBookmarks, mapPages, allActions);
            this.walkBookmarksTree((PDFBookmarkNode)rootMark, (PDFBookmarkNode)srcDoc.requireCatalog().getBookmarkRoot(), extractBookmark);
            PDFBookmarkRoot targetRoot = (PDFBookmarkRoot)extractBookmark.getTargetRoot();
            if (targetRoot != null) {
                this.inDoc.requireCatalog().setBookmarkRoot(targetRoot);
            }
        }
        return rootMark;
    }

    private class DeleteBookmark
    implements BookmarkOperation {
        private MapPages mappingPages;

        DeleteBookmark(List<PDFPage> pages) {
            this.mappingPages = new MapPages(pages);
        }

        @Override
        public boolean conditionAction(PDFBookmarkNode parent, PDFBookmarkNode bookmark) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
            return PMMBookmark.this.isBookmarkOnPage(bookmark, this.mappingPages);
        }

        @Override
        public PDFBookmarkNode firstAction(PDFBookmarkNode parent, PDFBookmarkNode bookmark) {
            return bookmark;
        }

        @Override
        public PDFBookmarkNode lastAction(PDFBookmarkNode parent, PDFBookmarkNode bookmark, PDFBookmarkNode childMark) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
            return bookmark.getFirstKid() == null ? (PDFBookmark)((PDFBookmark)bookmark).delete() : null;
        }
    }

    private class AppendBookmark
    implements BookmarkOperation {
        private Map<ASString, PDFDestinationNamed> allDestsMapping;
        private PMMNamedDestinations curDests;
        private Map<PDFPage, PDFPage> pagesMapping;
        private MapPages mappingPages;
        private Map<PDFAction, PDFAction> allActions;
        private PDFBookmarkNode targetRoot;

        AppendBookmark(PDFBookmarkNode appendRoot, Map<ASString, PDFDestinationNamed> allDests, PMMNamedDestinations targetDests, boolean importAllBookmarks, Map<PDFPage, PDFPage> mapPages, Map<PDFAction, PDFAction> clonedActions) {
            this.allDestsMapping = allDests;
            this.curDests = targetDests;
            this.allActions = clonedActions;
            this.pagesMapping = mapPages;
            this.mappingPages = importAllBookmarks ? null : new MapPages(this.pagesMapping);
            this.targetRoot = appendRoot;
        }

        @Override
        public PDFBookmarkNode firstAction(PDFBookmarkNode parent, PDFBookmarkNode bookmark) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
            if (bookmark instanceof PDFBookmark && PMMBookmark.this.isBookmarkOnPage(bookmark, this.mappingPages)) {
                PDFBookmarkNode cloned = this.cloneBookmark(PMMBookmark.this.inDoc, (PDFBookmark)bookmark, this.curDests, this.allDestsMapping, this.pagesMapping);
                if (this.targetRoot == null && cloned instanceof PDFBookmarkRoot) {
                    this.targetRoot = cloned;
                }
                return cloned;
            }
            return parent;
        }

        @Override
        public PDFBookmarkNode lastAction(PDFBookmarkNode oldParent, PDFBookmarkNode oldChildDuplicateCopy, PDFBookmarkNode oldChild) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
            PDFBookmarkNode clonedParent = (PDFBookmarkNode)PMMBookmark.this.clonedBookmarks.get(oldParent);
            PDFBookmark cloned = (PDFBookmark)PMMBookmark.this.clonedBookmarks.get(oldChild);
            if (cloned == null) {
                return null;
            }
            boolean madeRoot = false;
            if (clonedParent == null) {
                if (oldParent instanceof PDFBookmarkRoot) {
                    clonedParent = this.targetRoot;
                    if (clonedParent == null) {
                        clonedParent = this.targetRoot = PDFBookmarkRoot.newInstance((PDFDocument)PMMBookmark.this.inDoc, (PDFBookmark)cloned);
                        PMMBookmark.this.clonedBookmarks.put(oldParent, this.targetRoot);
                        madeRoot = true;
                    }
                } else {
                    clonedParent = this.cloneBookmark(PMMBookmark.this.inDoc, (PDFBookmark)oldParent, this.curDests, this.allDestsMapping, this.pagesMapping);
                    if (this.targetRoot == null && clonedParent instanceof PDFBookmarkRoot) {
                        this.targetRoot = clonedParent;
                    }
                }
            }
            if (!madeRoot && clonedParent != null) {
                PDFBookmarkUtils.appendLastKid((PDFBookmark)cloned, (PDFBookmarkNode)clonedParent);
            }
            return cloned;
        }

        @Override
        public boolean conditionAction(PDFBookmarkNode parent, PDFBookmarkNode bookmark) {
            return true;
        }

        public PDFBookmarkNode getTargetRoot() {
            return this.targetRoot;
        }

        private PDFBookmarkNode cloneBookmark(PDFDocument toDoc, PDFBookmark srcMark, PMMNamedDestinations curDests, Map<ASString, PDFDestinationNamed> allDests, Map<PDFPage, PDFPage> mapPages) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
            if (PMMBookmark.this.clonedBookmarks.containsKey(srcMark)) {
                return (PDFBookmarkNode)PMMBookmark.this.clonedBookmarks.get(srcMark);
            }
            PDFBookmark mark = PDFBookmark.newInstance((PDFDocument)toDoc, (String)srcMark.getTitle());
            CosDictionary cosMark = mark.getCosDictionary();
            Iterator keyIterator = srcMark.getCosDictionary().keyIterator();
            while (keyIterator.hasNext()) {
                PDFAction clonedAction;
                PDFDestination dest;
                ASName curKey = (ASName)keyIterator.next();
                if (!Utility.nameInArray((ASName)curKey, (ASName[])specialBoomarkKeys)) {
                    cosMark.put(curKey, PMMBookmark.this.cloneHandler.clone(srcMark.getDictionaryCosObjectValue(curKey)));
                    continue;
                }
                if (curKey.equals((Object)ASName.k_Dest) && (dest = PMMNamedDestinations.cloneDestination(srcMark.getDestination(), curDests, allDests, mapPages)) != null) {
                    cosMark.put(curKey, dest.getCosObject());
                }
                if (!curKey.equals((Object)ASName.k_A) || (clonedAction = PMMBookmark.this.pagesHandler.cloneAction(this.allActions, srcMark.getAction(), curDests, allDests, mapPages)) == null) continue;
                cosMark.put(curKey, clonedAction.getCosObject());
            }
            PDFBookmark cloned = PDFBookmark.getInstance((CosObject)cosMark);
            PMMBookmark.this.clonedBookmarks.put(srcMark, cloned);
            return cloned;
        }
    }

    private static class MapPages {
        private PDFPageWrapperSet set;

        public MapPages(Map<PDFPage, PDFPage> pages) {
            this.set = new PDFPageWrapperSet(pages.keySet());
        }

        public MapPages(List<PDFPage> pages) {
            this.set = new PDFPageWrapperSet(pages);
        }

        public boolean contains(PDFPage page) {
            return this.set.contains(page);
        }
    }

    private static interface BookmarkOperation {
        public PDFBookmarkNode firstAction(PDFBookmarkNode var1, PDFBookmarkNode var2) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException;

        public PDFBookmarkNode lastAction(PDFBookmarkNode var1, PDFBookmarkNode var2, PDFBookmarkNode var3) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException;

        public boolean conditionAction(PDFBookmarkNode var1, PDFBookmarkNode var2) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException;
    }
}

