/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.imageconversion;

import com.adobe.internal.io.ByteArrayByteWriter;
import com.adobe.internal.io.ByteWriter;
import com.adobe.internal.io.ByteWriterFactory;
import com.adobe.internal.io.DataBufferByteWriter;
import com.adobe.internal.io.stream.IO;
import com.adobe.internal.io.stream.InputByteStream;
import com.adobe.internal.io.stream.OutputByteStream;
import com.adobe.internal.pdftoolkit.color.ColorSpaceCache;
import com.adobe.internal.pdftoolkit.core.cos.CosCloneMgr;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.cos.CosStream;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFCosParseException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFUnsupportedFeatureException;
import com.adobe.internal.pdftoolkit.core.filter.CustomFilterRegistry;
import com.adobe.internal.pdftoolkit.core.filter.FilterParams;
import com.adobe.internal.pdftoolkit.core.types.ASMatrix;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.graphicsDOM.utils.ImageInputSourceImpl;
import com.adobe.internal.pdftoolkit.image.ARGBImage;
import com.adobe.internal.pdftoolkit.image.ImageInputSource;
import com.adobe.internal.pdftoolkit.image.Resampler;
import com.adobe.internal.pdftoolkit.pdf.content.Content;
import com.adobe.internal.pdftoolkit.pdf.content.ContentReader;
import com.adobe.internal.pdftoolkit.pdf.content.Instruction;
import com.adobe.internal.pdftoolkit.pdf.content.OperandStack;
import com.adobe.internal.pdftoolkit.pdf.content.XObjectsCycleDetector;
import com.adobe.internal.pdftoolkit.pdf.contentmodify.ContentModifier;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosObjectContainer;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.document.PDFResources;
import com.adobe.internal.pdftoolkit.pdf.filters.PDFFilter;
import com.adobe.internal.pdftoolkit.pdf.filters.PDFFilterFlate;
import com.adobe.internal.pdftoolkit.pdf.filters.PDFFilterList;
import com.adobe.internal.pdftoolkit.pdf.filters.PDFFilterParams;
import com.adobe.internal.pdftoolkit.pdf.graphics.PDFExtGState;
import com.adobe.internal.pdftoolkit.pdf.graphics.PDFRectangle;
import com.adobe.internal.pdftoolkit.pdf.graphics.colorspaces.PDFColorSpace;
import com.adobe.internal.pdftoolkit.pdf.graphics.colorspaces.PDFColorSpaceDeviceCMYK;
import com.adobe.internal.pdftoolkit.pdf.graphics.colorspaces.PDFColorSpaceDeviceGray;
import com.adobe.internal.pdftoolkit.pdf.graphics.colorspaces.PDFColorSpaceIndexed;
import com.adobe.internal.pdftoolkit.pdf.graphics.impl.ColorSpaceCacheImpl;
import com.adobe.internal.pdftoolkit.pdf.graphics.xobject.PDFGroupAttributes;
import com.adobe.internal.pdftoolkit.pdf.graphics.xobject.PDFXObject;
import com.adobe.internal.pdftoolkit.pdf.graphics.xobject.PDFXObjectAltImage;
import com.adobe.internal.pdftoolkit.pdf.graphics.xobject.PDFXObjectAltImageList;
import com.adobe.internal.pdftoolkit.pdf.graphics.xobject.PDFXObjectForm;
import com.adobe.internal.pdftoolkit.pdf.graphics.xobject.PDFXObjectImage;
import com.adobe.internal.pdftoolkit.pdf.graphics.xobject.PDFXObjectImageWithLocation;
import com.adobe.internal.pdftoolkit.pdf.graphics.xobject.PDFXObjectImageWithLocationMap;
import com.adobe.internal.pdftoolkit.pdf.inlineimage.InlineImage;
import com.adobe.internal.pdftoolkit.pdf.inlineimage.InlineImageColorSpace;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotation;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationList;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAppearance;
import com.adobe.internal.pdftoolkit.pdf.page.PDFPage;
import com.adobe.internal.pdftoolkit.pdf.transparency.PDFXObjectImageSoftMask;
import com.adobe.internal.pdftoolkit.services.imageconversion.BufferedImageWrapper;
import com.adobe.internal.pdftoolkit.services.imageconversion.CMStack;
import com.adobe.internal.pdftoolkit.services.imageconversion.DataBufferFactoryInterface;
import com.adobe.internal.pdftoolkit.services.imageconversion.DataBufferWritableRaster;
import com.adobe.internal.pdftoolkit.services.xobjhandler.XObjectApplyOptions;
import com.adobe.internal.pdftoolkit.services.xobjhandler.XObjectUseOptions;
import java.awt.Point;
import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferInt;
import java.awt.image.DirectColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.WritableRaster;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Iterator;

public class ImageManager {
    private static final ASMatrix IDENTITY_MATRIX = new ASMatrix(1.0, 0.0, 0.0, 1.0, 0.0, 0.0);

    private ImageManager() {
    }

    public static PDFXObjectImageWithLocationMap getPDFXObjectMap(PDFDocument pdfDocument) throws PDFIOException, PDFSecurityException, PDFInvalidDocumentException {
        PDFXObjectImageWithLocationMap imageMap = new PDFXObjectImageWithLocationMap();
        int imageNum = 0;
        Iterator pagesIter = pdfDocument.requirePages().iterator();
        while (pagesIter.hasNext()) {
            PDFAnnotationList widgets;
            CMStack stack = new CMStack(IDENTITY_MATRIX);
            PDFPage pdfPage = (PDFPage)pagesIter.next();
            PDFResources pdfResources = pdfPage.getResources();
            if (pdfResources != null) {
                imageNum = ImageManager.getImagesFromContentStream(Content.newInstance((PDFPage)pdfPage), pdfResources, imageMap, imageNum, IDENTITY_MATRIX, stack);
            }
            if ((widgets = pdfPage.getAnnotationList()) == null) continue;
            for (PDFAnnotation widget : widgets) {
                PDFResources apResources;
                PDFXObjectForm apNorm;
                PDFAppearance ap = widget.getAppearance();
                if (ap == null || (apNorm = ap.getNormalAppearance()) == null || (apResources = apNorm.getResources()) == null) continue;
                ASMatrix mat = widget.getTransformationMatrix(pdfDocument, apNorm);
                imageNum = ImageManager.getImagesFromContentStream(Content.newInstance((PDFXObjectForm)apNorm), apResources, imageMap, imageNum, mat, stack);
            }
        }
        return imageMap;
    }

    public static PDFXObjectImageWithLocationMap getPDFXObjectMap(PDFPage pdfPage) throws PDFIOException, PDFSecurityException, PDFInvalidDocumentException {
        PDFAnnotationList widgets;
        CMStack stack = new CMStack(IDENTITY_MATRIX);
        PDFXObjectImageWithLocationMap imageMap = new PDFXObjectImageWithLocationMap();
        int imageNum = 0;
        PDFResources pdfResources = pdfPage.getResources();
        if (pdfResources != null) {
            imageNum = ImageManager.getImagesFromContentStream(Content.newInstance((PDFPage)pdfPage), pdfResources, imageMap, imageNum, IDENTITY_MATRIX, stack);
        }
        if ((widgets = pdfPage.getAnnotationList()) != null) {
            for (PDFAnnotation widget : widgets) {
                PDFResources apResources;
                PDFXObjectForm apNorm;
                PDFAppearance ap = widget.getAppearance();
                if (ap == null || (apNorm = ap.getNormalAppearance()) == null || (apResources = apNorm.getResources()) == null) continue;
                ASMatrix mat = widget.getTransformationMatrix(pdfPage.getPDFDocument(), apNorm);
                imageNum = ImageManager.getImagesFromContentStream(Content.newInstance((PDFXObjectForm)apNorm), apResources, imageMap, imageNum, mat, stack);
            }
        }
        return imageMap;
    }

    public static PDFXObjectImageWithLocationMap getPDFXObjectMap(PDFPage[] pdfPageArr) throws PDFIOException, PDFSecurityException, PDFInvalidDocumentException {
        ASMatrix currCTM = IDENTITY_MATRIX;
        CMStack stack = new CMStack(currCTM);
        PDFXObjectImageWithLocationMap imageMap = new PDFXObjectImageWithLocationMap();
        int imageNum = 0;
        for (int i = 0; i < pdfPageArr.length; ++i) {
            PDFAnnotationList widgets;
            PDFPage pdfPage = pdfPageArr[i];
            PDFResources pdfResources = pdfPage.getResources();
            if (pdfResources != null) {
                imageNum = ImageManager.getImagesFromContentStream(Content.newInstance((PDFPage)pdfPage), pdfResources, imageMap, imageNum, currCTM, stack);
            }
            if ((widgets = pdfPage.getAnnotationList()) == null) continue;
            for (PDFAnnotation widget : widgets) {
                ASMatrix mat;
                PDFResources apResources;
                PDFXObjectForm apNorm;
                currCTM = IDENTITY_MATRIX;
                PDFAppearance ap = widget.getAppearance();
                if (ap == null || (apNorm = ap.getNormalAppearance()) == null || (apResources = apNorm.getResources()) == null) continue;
                currCTM = mat = widget.getTransformationMatrix(pdfPage.getPDFDocument(), apNorm);
                imageNum = ImageManager.getImagesFromContentStream(Content.newInstance((PDFXObjectForm)apNorm), apResources, imageMap, imageNum, currCTM, stack);
            }
        }
        return imageMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int getImagesFromContentStream(Content content, PDFResources pdfResources, PDFXObjectImageWithLocationMap imageMap, int imageNum, ASMatrix currCTM, CMStack stack) throws PDFIOException, PDFSecurityException, PDFInvalidDocumentException {
        XObjectsCycleDetector cycleDetector = XObjectsCycleDetector.getInstance((PDFDocument)pdfResources.getPDFDocument());
        ContentReader reader = null;
        PDFResources resources = pdfResources;
        Instruction instruction = null;
        try {
            reader = ContentReader.newInstance((Content)content);
            while (reader.hasNext()) {
                try {
                    OperandStack operands;
                    instruction = reader.next();
                    ASName operator = instruction.getOperator();
                    if (operator == ASName.CM) {
                        operands = instruction.getOperands();
                        ASMatrix matrix = ContentModifier.getMatrixFromOperands((OperandStack)operands);
                        currCTM = matrix.concat(currCTM);
                        continue;
                    }
                    if (operator == ASName.k_q) {
                        if (currCTM == null) continue;
                        stack.push(currCTM);
                        continue;
                    }
                    if (operator == ASName.k_Q) {
                        if (stack.isEmpty()) continue;
                        currCTM = stack.pop();
                        continue;
                    }
                    if (operator != ASName.k_Do) continue;
                    operands = instruction.getOperands();
                    ASName name = ContentModifier.getObjectName((OperandStack)operands);
                    if (resources.getXObject(name) instanceof PDFXObjectImage) {
                        PDFXObjectImage xImage = (PDFXObjectImage)resources.getXObject(name);
                        PDFXObjectImageWithLocation xImageWithMatrix = new PDFXObjectImageWithLocation(content.getPDFDocument(), xImage, currCTM);
                        imageMap.set(ASName.create((String)("Image-" + imageNum)), xImageWithMatrix);
                        ++imageNum;
                        continue;
                    }
                    if (!(resources.getXObject(name) instanceof PDFXObjectForm)) continue;
                    PDFXObjectForm xForm = (PDFXObjectForm)resources.getXObject(name);
                    if (cycleDetector.cycleDetected((PDFXObject)xForm)) {
                        throw new PDFInvalidDocumentException("Cyclic dependency found while processing xobjects.");
                    }
                    cycleDetector.push((PDFXObject)xForm);
                    try {
                        PDFResources formResources = xForm.getResources();
                        if (formResources == null) {
                            formResources = resources;
                        }
                        imageNum = ImageManager.getImagesFromContentStream(Content.newInstance((PDFXObjectForm)xForm), formResources, imageMap, imageNum, currCTM, stack);
                    }
                    finally {
                        cycleDetector.pop();
                    }
                }
                finally {
                    try {
                        if (instruction == null) continue;
                        instruction.close();
                    }
                    catch (PDFIOException e) {}
                }
            }
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException e) {
                throw new PDFIOException((Throwable)e);
            }
        }
        return imageNum;
    }

    public static void insertImageInPDF(PDFXObjectImage xImage, PDFPage page, PDFExtGState gState, ASMatrix matrix) throws PDFIOException, PDFSecurityException, PDFInvalidDocumentException {
        try {
            PDFXObjectImage image = xImage;
            XObjectApplyOptions options = new XObjectApplyOptions();
            options.applyXObjectImage(page, image, gState, matrix);
        }
        catch (PDFCosParseException e) {
            throw new PDFInvalidDocumentException((Throwable)e);
        }
    }

    public static PDFXObjectImage getPDFImage(BufferedImage bim, PDFDocument pdfDocument) throws PDFIOException, PDFSecurityException, PDFInvalidDocumentException {
        if (bim == null) {
            return null;
        }
        try {
            PDFXObjectImage image = PDFXObjectImage.newInstance((PDFDocument)pdfDocument);
            image.setWidth(bim.getWidth());
            image.setHeight(bim.getHeight());
            DataBuffer buffer = bim.getRaster().getDataBuffer();
            OutputByteStream byteStream = pdfDocument.getStreamManager().getOutputByteStreamClearTemp(ByteWriterFactory.Fixed.FIXED, (long)buffer.getSize());
            image.setColorSpace(PDFColorSpace.createColorSpace((PDFDocument)pdfDocument, (ColorSpace)bim.getColorModel().getColorSpace()));
            if (bim.getType() == 5) {
                for (int x = 0; x < buffer.getSize() - 2; ++x) {
                    byteStream.write(buffer.getElem(x + 2));
                    byteStream.write(buffer.getElem(x + 1));
                    byteStream.write(buffer.getElem(x));
                    x += 2;
                }
                image.setBitsPerComponent(8);
            } else if (bim.getType() == 12 && !(bim.getColorModel() instanceof IndexColorModel)) {
                for (int x = 0; x < buffer.getSize(); ++x) {
                    byteStream.write(buffer.getElem(x));
                }
                image.setBitsPerComponent(1);
                image.setColorSpace((PDFColorSpace)PDFColorSpaceDeviceGray.newInstance((PDFDocument)pdfDocument));
            } else if (bim.getType() == 12 && bim.getColorModel() instanceof IndexColorModel) {
                for (int x = 0; x < buffer.getSize(); ++x) {
                    byteStream.write(buffer.getElem(x));
                }
                image.setBitsPerComponent(bim.getColorModel().getPixelSize());
                PDFColorSpaceIndexed index = PDFColorSpaceIndexed.newInstance((PDFDocument)pdfDocument);
                index.setLookupColor(1, 3, 1, bim.getColorModel());
                image.setColorSpace((PDFColorSpace)index);
            } else if (bim.getType() == 0 && !(bim.getColorModel() instanceof IndexColorModel)) {
                int x;
                if (bim.getColorModel().getNumComponents() != bim.getColorModel().getNumColorComponents()) {
                    for (x = 0; x < buffer.getSize() - 3; x += 4) {
                        byteStream.write(buffer.getElem(x));
                        byteStream.write(buffer.getElem(x + 1));
                        byteStream.write(buffer.getElem(x + 2));
                    }
                } else {
                    for (x = 0; x < buffer.getSize(); ++x) {
                        byteStream.write(buffer.getElem(x));
                    }
                }
                image.setBitsPerComponent(8);
            } else if (bim.getType() == 0 && bim.getColorModel() instanceof IndexColorModel) {
                int x;
                for (x = 0; x < buffer.getSize(); ++x) {
                    byteStream.write(buffer.getElem(x));
                }
                image.setBitsPerComponent(bim.getColorModel().getPixelSize());
                if (buffer.getDataType() == 1) {
                    image.setBitsPerComponent(bim.getColorModel().getPixelSize() / 2);
                } else {
                    for (x = 0; x < buffer.getSize(); ++x) {
                        byteStream.write(buffer.getElem(x));
                    }
                }
                image.setColorSpace((PDFColorSpace)PDFColorSpaceDeviceGray.newInstance((PDFDocument)pdfDocument));
            } else if (bim.getType() == 13) {
                int x;
                if (bim.getColorModel().getNumComponents() != bim.getColorModel().getNumColorComponents()) {
                    for (x = 0; x < buffer.getSize(); ++x) {
                        int elem = buffer.getElem(x);
                        byteStream.write(elem);
                    }
                } else {
                    for (x = 0; x < buffer.getSize(); ++x) {
                        byteStream.write(buffer.getElem(x));
                    }
                }
                image.setBitsPerComponent(bim.getColorModel().getPixelSize());
                PDFColorSpaceIndexed index = PDFColorSpaceIndexed.newInstance((PDFDocument)pdfDocument);
                index.setLookupColor(1, 3, 1, bim.getColorModel());
                image.setColorSpace((PDFColorSpace)index);
            } else if (bim.getType() == 10) {
                for (int x = 0; x < buffer.getSize(); ++x) {
                    byteStream.write(buffer.getElem(x));
                }
                image.setBitsPerComponent(8);
                image.setColorSpace((PDFColorSpace)PDFColorSpaceDeviceGray.newInstance((PDFDocument)pdfDocument));
            } else if (bim.getType() == 2) {
                int x;
                ColorModel colorModel = bim.getColorModel();
                if (colorModel instanceof ComponentColorModel) {
                    for (x = 0; x < buffer.getSize() - 3; x += 4) {
                        byteStream.write(buffer.getElem(x + 1));
                        byteStream.write(buffer.getElem(x + 2));
                        byteStream.write(buffer.getElem(x + 3));
                    }
                } else {
                    for (x = 0; x < buffer.getSize(); ++x) {
                        int dataElem = buffer.getElem(x);
                        byteStream.write(colorModel.getRed(dataElem));
                        byteStream.write(colorModel.getGreen(dataElem));
                        byteStream.write(colorModel.getBlue(dataElem));
                    }
                }
                image.setBitsPerComponent(8);
            } else if (bim.getType() == 1) {
                for (int x = 0; x < buffer.getSize(); ++x) {
                    byte[] bArr = ImageManager.intToByteArray(buffer.getElem(x));
                    for (int b = 1; b < bArr.length; ++b) {
                        byteStream.write((int)bArr[b]);
                    }
                }
                image.setBitsPerComponent(8);
            } else if (bim.getType() == 9) {
                for (int x = 0; x < buffer.getSize(); ++x) {
                    int r = ((buffer.getElem(x) & 0x7C00) >> 10) * 8;
                    byteStream.write(r);
                    int g = ((buffer.getElem(x) & 0x3E0) >> 5) * 8;
                    byteStream.write(g);
                    int bl = (buffer.getElem(x) & 0x1F) * 8;
                    byteStream.write(bl);
                }
                image.setBitsPerComponent(8);
            } else if (bim.getType() == 8) {
                for (int x = 0; x < buffer.getSize(); ++x) {
                    int r = ((buffer.getElem(x) & 0xF800) >> 11) * 8;
                    byteStream.write(r);
                    int g = ((buffer.getElem(x) & 0x7E0) >> 6) * 8;
                    byteStream.write(g);
                    int bl = (buffer.getElem(x) & 0x1F) * 8;
                    byteStream.write(bl);
                }
                image.setBitsPerComponent(8);
            } else if (bim.getType() == 6) {
                for (int x = 0; x < buffer.getSize(); x += 4) {
                    byteStream.write(buffer.getElem(x + 3));
                    byteStream.write(buffer.getElem(x + 2));
                    byteStream.write(buffer.getElem(x + 1));
                }
                image.setBitsPerComponent(8);
            } else {
                throw new PDFUnsupportedFeatureException("BufferedImage type  " + bim.getType() + " is not supported");
            }
            if (bim.getColorModel().hasAlpha() && !bim.isAlphaPremultiplied()) {
                image.setSMask(ImageManager.getPDFXObjectImageSoftMask(bim, pdfDocument));
            }
            InputByteStream inputByteStream = byteStream.closeAndConvert();
            image.setImageStreamData(inputByteStream);
            PDFFilterList list = PDFFilterList.newInstance((PDFDocument)pdfDocument);
            list.add((PDFFilter)PDFFilterFlate.newInstance((PDFDocument)pdfDocument, null));
            image.setOutputFilters(list);
            return image;
        }
        catch (PDFInvalidParameterException e) {
            throw new PDFInvalidDocumentException((Throwable)e);
        }
        catch (IOException e) {
            throw new PDFIOException((Throwable)e);
        }
    }

    private static boolean DCTFilterSupported(PDFDocument doc) {
        if (CustomFilterRegistry.getDefaultEncodeFilters().contains(ASName.k_DCTDecode)) {
            return true;
        }
        CustomFilterRegistry registry = doc.getCosDocument().getOptions().getCustomFilterRegistry();
        return registry.isEncodeFilterRegistered(ASName.k_DCTDecode);
    }

    public static PDFXObjectImage getPDFImage(BufferedImage bim, PDFDocument pdfDocument, PDFFilterList filterList) throws PDFIOException, PDFSecurityException, PDFInvalidDocumentException {
        PDFXObjectImage image = ImageManager.getPDFImage(bim, pdfDocument);
        if (filterList != null) {
            PDFFilterList newFilterList = PDFFilterList.newInstance((PDFDocument)pdfDocument);
            for (PDFFilter filter : filterList) {
                PDFFilterFlate newFilter = null;
                FilterParams filterParams = null;
                if (filter.getFilterName() == ASName.k_DCTDecode && !ImageManager.DCTFilterSupported(pdfDocument) && filterList.size() != 1) {
                    newFilter = PDFFilterFlate.newInstance((PDFDocument)pdfDocument, null);
                } else {
                    PDFFilterParams pdfFilterParams = filter.getParams();
                    if (pdfFilterParams != null) {
                        filterParams = new FilterParams();
                        Iterator filterParamsIter = pdfFilterParams.getCosDictionary().keyIterator();
                        while (filterParamsIter.hasNext()) {
                            ASName key = (ASName)filterParamsIter.next();
                            CosObject value = pdfFilterParams.getDictionaryValue(key);
                            filterParams.put((Object)key.asString(), (Object)value);
                        }
                    }
                }
                if (filter.getFilterName() == ASName.k_DCTDecode && ImageManager.DCTFilterSupported(pdfDocument)) {
                    if (filterParams == null) {
                        filterParams = new FilterParams();
                    }
                    if (!filterParams.containsKey((Object)"Columns")) {
                        filterParams.put((Object)"Columns", (Object)image.getWidth());
                    }
                    if (!filterParams.containsKey((Object)"Rows")) {
                        filterParams.put((Object)"Rows", (Object)image.getHeight());
                    }
                    if (!filterParams.containsKey((Object)"BitsPerComponent")) {
                        filterParams.put((Object)"BitsPerComponent", (Object)image.getBitsPerComponent());
                    }
                    if (!filterParams.containsKey((Object)"ColorSpace")) {
                        filterParams.put((Object)"ColorSpace", (Object)image.getColorSpace().getCosObject());
                    }
                }
                if (newFilter == null) {
                    newFilter = PDFFilter.newInstance((PDFDocument)pdfDocument, (ASName)filter.getFilterName(), filterParams != null ? PDFFilterParams.getInstance((CosObject)filterParams.toCosObject(pdfDocument.getCosDocument())) : null);
                }
                newFilterList.add((PDFFilter)newFilter);
            }
            image.setOutputFilters(newFilterList);
        }
        return image;
    }

    public static PDFXObjectImage getPDFImage(BufferedImageWrapper biw, PDFDocument pdfDocument) throws PDFIOException, PDFSecurityException, PDFInvalidDocumentException {
        return ImageManager.getPDFImage(biw.getBufferedImage(), pdfDocument, biw.getPDFFilterList());
    }

    private static PDFXObjectImageSoftMask getPDFXObjectImageSoftMask(BufferedImage bim, PDFDocument pdfDocument) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        WritableRaster raster = bim.getRaster();
        int minX = raster.getMinX();
        int minY = raster.getMinY();
        int h = raster.getHeight();
        int w = raster.getWidth();
        int numBands = bim.getSampleModel().getNumBands();
        int dataType = raster.getDataBuffer().getDataType();
        ColorModel colorModel = bim.getColorModel();
        try {
            OutputByteStream sMaskByteStream = pdfDocument.getStreamManager().getOutputByteStreamClearTemp(ByteWriterFactory.Fixed.FIXED, (long)(h * w));
            switch (dataType) {
                case 0: {
                    byte[] b = new byte[numBands];
                    int[] iArray = new int[w * numBands];
                    for (int y = minY; y < minY + h; ++y) {
                        iArray = raster.getPixels(minX, y, w, 1, iArray);
                        int offset = 0;
                        for (int x = minX; x < minX + w; ++x) {
                            for (int i = 0; i < numBands; ++i) {
                                b[i] = (byte)iArray[offset++];
                            }
                            int alpha = colorModel.getAlpha(b);
                            sMaskByteStream.write(alpha);
                        }
                    }
                    break;
                }
                case 1: 
                case 2: {
                    short[] s = new short[numBands];
                    int[] iArray = new int[w * numBands];
                    for (int y = minY; y < minY + h; ++y) {
                        iArray = raster.getPixels(minX, y, w, 1, iArray);
                        int offset = 0;
                        for (int x = minX; x < minX + w; ++x) {
                            for (int i = 0; i < numBands; ++i) {
                                s[i] = (short)iArray[offset++];
                            }
                            int alpha = colorModel.getAlpha(s);
                            sMaskByteStream.write(alpha);
                        }
                    }
                    break;
                }
                case 3: {
                    int[] iArray;
                    if (colorModel instanceof DirectColorModel) {
                        for (int i = 0; i < h * w; ++i) {
                            int alpha = colorModel.getAlpha(raster.getDataBuffer().getElem(i));
                            sMaskByteStream.write(alpha);
                        }
                    } else {
                        int[] n = new int[numBands];
                        iArray = new int[w * numBands];
                        for (int y = minY; y < minY + h; ++y) {
                            iArray = raster.getPixels(minX, y, w, 1, iArray);
                            int offset = 0;
                            for (int x = minX; x < minX + w; ++x) {
                                for (int i = 0; i < numBands; ++i) {
                                    n[i] = iArray[offset++];
                                }
                                int alpha = colorModel.getAlpha(n);
                                sMaskByteStream.write(alpha);
                            }
                        }
                    }
                    break;
                }
                case 4: {
                    float[] f = new float[numBands];
                    float[] fArray = new float[w * numBands];
                    for (int y = minY; y < minY + h; ++y) {
                        fArray = raster.getPixels(minX, y, w, 1, fArray);
                        int offset = 0;
                        for (int x = minX; x < minX + w; ++x) {
                            for (int i = 0; i < numBands; ++i) {
                                f[i] = fArray[offset++];
                            }
                            int alpha = colorModel.getAlpha(f);
                            sMaskByteStream.write(alpha);
                        }
                    }
                    break;
                }
                case 5: {
                    double[] d = new double[numBands];
                    double[] dArray = new double[w * numBands];
                    for (int y = minY; y < minY + h; ++y) {
                        dArray = raster.getPixels(minX, y, w, 1, dArray);
                        int offset = 0;
                        for (int x = minX; x < minX + w; ++x) {
                            for (int i = 0; i < numBands; ++i) {
                                d[i] = dArray[offset++];
                            }
                            int alpha = colorModel.getAlpha(d);
                            sMaskByteStream.write(alpha);
                        }
                    }
                    break;
                }
                default: {
                    throw new PDFUnsupportedFeatureException("Raster Data Buffer Data Type " + dataType + " is not supported");
                }
            }
            InputByteStream sMaskInputByteStream = sMaskByteStream.closeAndConvert();
            PDFXObjectImageSoftMask sMask = PDFXObjectImageSoftMask.newInstance((PDFDocument)pdfDocument, (int)8, (int)bim.getWidth(), (int)bim.getHeight());
            sMask.setImageStreamData(sMaskInputByteStream);
            sMask.setBitsPerComponent(8);
            return sMask;
        }
        catch (IOException e) {
            throw new PDFIOException((Throwable)e);
        }
    }

    public static PDFXObjectForm getXObjPDFImage(PDFDocument pdfDocument, BufferedImage bim, XObjectUseOptions useOptions) throws PDFIOException, PDFSecurityException, PDFInvalidDocumentException, PDFInvalidParameterException {
        PDFXObjectImage image = ImageManager.getPDFImage(bim, pdfDocument);
        if (image == null) {
            return null;
        }
        PDFXObjectForm xobj = PDFXObjectForm.newInstance((PDFDocument)pdfDocument);
        PDFRectangle bbox = PDFRectangle.newInstance((PDFDocument)pdfDocument, (double)0.0, (double)0.0, (double)image.getWidth(), (double)image.getHeight());
        xobj.setBBox(bbox);
        XObjectApplyOptions imageApplyOptions = new XObjectApplyOptions();
        imageApplyOptions.setHScale(image.getWidth());
        imageApplyOptions.setVScale(image.getHeight());
        XObjectUseOptions imageUseOptions = new XObjectUseOptions();
        imageApplyOptions.applyXObjectForm(xobj, (PDFXObject)image, imageUseOptions);
        ASName[] names = new ASName[]{ASName.k_PDF, ASName.create((String)"ImageC")};
        xobj.getResources().setProcSetList(names);
        PDFGroupAttributes newGroup = PDFGroupAttributes.newInstance((PDFDocument)pdfDocument);
        newGroup.setSubType(ASName.k_Transparency);
        newGroup.setKnockout(true);
        xobj.setGroupAttributes(newGroup);
        if (useOptions != null) {
            if (useOptions.hasOptionalContent()) {
                useOptions.applyOptionalContent(xobj);
            }
            if (useOptions.hasContentType()) {
                useOptions.getContentType().applyPieceInfo(xobj);
            }
        }
        return xobj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static InlineImage getInlineImage(BufferedImage bim, PDFDocument pdfDocument) throws PDFIOException, PDFSecurityException, PDFInvalidDocumentException, PDFInvalidParameterException {
        InputByteStream inputByteStream = null;
        OutputByteStream byteStream = null;
        try {
            int bpc;
            DataBuffer buffer = bim.getRaster().getDataBuffer();
            byteStream = pdfDocument.getStreamManager().getOutputByteStreamClearTemp(ByteWriterFactory.Fixed.FIXED, (long)buffer.getSize());
            PDFColorSpace colorSpace = PDFColorSpace.createColorSpace((PDFDocument)pdfDocument, (ColorSpace)bim.getColorModel().getColorSpace());
            if (bim.getType() == 5) {
                for (int x = 0; x < buffer.getSize() - 2; ++x) {
                    byteStream.write(buffer.getElem(x + 2));
                    byteStream.write(buffer.getElem(x + 1));
                    byteStream.write(buffer.getElem(x));
                    x += 2;
                }
                bpc = 8;
            } else if (bim.getType() == 12 && !(bim.getColorModel() instanceof IndexColorModel)) {
                for (int x = 0; x < buffer.getSize(); ++x) {
                    byteStream.write(buffer.getElem(x));
                }
                bpc = 1;
                colorSpace = PDFColorSpaceDeviceGray.newInstance((PDFDocument)pdfDocument);
            } else if (bim.getType() == 12 && bim.getColorModel() instanceof IndexColorModel) {
                for (int x = 0; x < buffer.getSize(); ++x) {
                    byteStream.write(buffer.getElem(x));
                }
                bpc = bim.getColorModel().getPixelSize();
                PDFColorSpaceIndexed indexCS = PDFColorSpaceIndexed.newInstance((PDFDocument)pdfDocument);
                indexCS.setLookupColor(1, 3, 1, bim.getColorModel());
                colorSpace = indexCS;
            } else if (bim.getType() == 0 && !(bim.getColorModel() instanceof IndexColorModel)) {
                for (int x = 0; x < buffer.getSize(); ++x) {
                    byteStream.write(buffer.getElem(x));
                }
                bpc = 8;
            } else if (bim.getType() == 0 && bim.getColorModel() instanceof IndexColorModel) {
                int x;
                for (x = 0; x < buffer.getSize(); ++x) {
                    byteStream.write(buffer.getElem(x));
                }
                bpc = bim.getColorModel().getPixelSize();
                if (buffer.getDataType() == 1) {
                    bpc = bim.getColorModel().getPixelSize() / 2;
                } else {
                    for (x = 0; x < buffer.getSize(); ++x) {
                        byteStream.write(buffer.getElem(x));
                    }
                }
                colorSpace = PDFColorSpaceDeviceGray.newInstance((PDFDocument)pdfDocument);
            } else if (bim.getType() == 13) {
                for (int x = 0; x < buffer.getSize(); ++x) {
                    byteStream.write(buffer.getElem(x));
                }
                bpc = bim.getColorModel().getPixelSize();
                PDFColorSpaceIndexed indexCS = PDFColorSpaceIndexed.newInstance((PDFDocument)pdfDocument);
                indexCS.setLookupColor(1, 3, 1, bim.getColorModel());
                colorSpace = indexCS;
            } else if (bim.getType() == 10) {
                for (int x = 0; x < buffer.getSize(); ++x) {
                    byteStream.write(buffer.getElem(x));
                }
                bpc = 8;
                colorSpace = PDFColorSpaceDeviceGray.newInstance((PDFDocument)pdfDocument);
            } else {
                throw new PDFUnsupportedFeatureException("BufferedImage type  " + bim.getType() + " is not supported");
            }
            inputByteStream = byteStream.closeAndConvert();
            byteStream = null;
            InlineImage inlineImage = InlineImage.newInstance(null, null, (InputByteStream)inputByteStream, (int)bim.getHeight(), (int)bim.getWidth(), (Integer)bpc, (PDFColorSpace)colorSpace, null, (boolean)false, (boolean)false, null);
            return inlineImage;
        }
        catch (PDFCosParseException e) {
            throw new PDFInvalidDocumentException((Throwable)e);
        }
        catch (IOException e) {
            throw new PDFIOException((Throwable)e);
        }
        finally {
            try {
                try {
                    if (inputByteStream != null) {
                        inputByteStream.close();
                    }
                }
                finally {
                    if (byteStream != null) {
                        byteStream.close();
                    }
                }
            }
            catch (IOException e) {
                throw new PDFIOException((Throwable)e);
            }
        }
    }

    public static BufferedImageWrapper toBufferedImage(PDFXObjectImage xImage, ByteWriter byteWriter) throws PDFIOException, PDFSecurityException, PDFInvalidDocumentException, PDFInvalidParameterException {
        return ImageManager.toBufferedImage(xImage, byteWriter, null);
    }

    public static BufferedImageWrapper toBufferedImage(PDFXObjectImage xImage, ByteWriter byteWriter, DataBufferFactoryInterface dataBufferFactory) throws PDFIOException, PDFSecurityException, PDFInvalidDocumentException, PDFInvalidParameterException {
        BufferedImageWrapper biw = ImageManager.useARGBIfCSColorModelNotSupported(xImage, byteWriter);
        if (biw != null) {
            return biw;
        }
        try {
            biw = ImageManager.createBufferedImage(xImage, byteWriter, dataBufferFactory);
        }
        catch (IOException e) {
            throw new PDFIOException((Throwable)e);
        }
        return biw;
    }

    private static BufferedImageWrapper useARGBIfCSColorModelNotSupported(PDFXObjectImage xImage, ByteWriter byteWriter) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFColorSpace cs = xImage.getColorSpace();
        if (cs == null && xImage.getIsImageMask()) {
            cs = PDFColorSpaceDeviceGray.newInstance((PDFDocument)xImage.getPDFDocument());
        }
        ASName csName = cs.getName();
        double[] decode = xImage.getDecode();
        if (csName == ASName.k_Indexed) {
            csName = ((PDFColorSpaceIndexed)cs).getBaseColorSpace().getName();
        }
        if (!(csName != ASName.k_DeviceRGB && csName != ASName.k_DeviceGray && csName != ASName.k_DeviceCMYK && csName != ASName.k_ICCBased || decode != null && !Arrays.equals(decode, cs.getRange()) && csName != ASName.k_DeviceGray)) {
            return null;
        }
        ARGBImage rgbImage = null;
        try {
            BufferedImageWrapper biw;
            rgbImage = new ARGBImage((ImageInputSource)new ImageInputSourceImpl((Object)xImage.getImageStreamData(), false), xImage.getWidth(), xImage.getHeight(), xImage.getBitsPerComponent(), (ColorSpaceCache)ColorSpaceCacheImpl.newInstance((PDFColorSpace)cs, null, null, (double[])xImage.getDecode()), xImage.hasDecodeArray() ? xImage.getDecode() : null);
            BufferedImage bim = ImageManager.getBufferedImage(rgbImage, xImage.getWidth(), xImage.getHeight(), 2);
            BufferedImageWrapper bufferedImageWrapper = biw = new BufferedImageWrapper(bim, null);
            return bufferedImageWrapper;
        }
        catch (IOException e) {
            throw new PDFIOException((Throwable)e);
        }
        finally {
            if (rgbImage != null) {
                rgbImage.close();
            }
            rgbImage = null;
        }
    }

    private static BufferedImage getBufferedImage(ARGBImage rgbImage, int width, int height, int type) {
        BufferedImage bim = new BufferedImage(width, height, type);
        Iterator itr = rgbImage.getBufferedImagesIterator();
        BufferedImage tile = null;
        int offset = 0;
        while (itr.hasNext()) {
            tile = (BufferedImage)itr.next();
            int length = tile.getWidth() * tile.getHeight();
            System.arraycopy(((DataBufferInt)tile.getRaster().getDataBuffer()).getData(), 0, ((DataBufferInt)bim.getRaster().getDataBuffer()).getData(), offset, length);
            offset += length;
        }
        return bim;
    }

    public static BufferedImageWrapper toBufferedImage(InlineImage inlineImage, ByteWriter byteWriter) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        BufferedImageWrapper biw = null;
        biw = ImageManager.createBufferedImage(inlineImage, byteWriter);
        return biw;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static BufferedImageWrapper createBufferedImage(PDFXObjectImage xImage, ByteWriter byteWriter, DataBufferFactoryInterface dataBufferFactory) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException, IOException {
        int bpc = xImage.getBitsPerComponent();
        Object colorSpace = null;
        colorSpace = !xImage.getIsImageMask() ? xImage.getColorSpace() : PDFColorSpaceDeviceGray.newInstance((PDFDocument)xImage.getPDFDocument());
        if (bpc < 8 && !(colorSpace instanceof PDFColorSpaceDeviceGray)) {
            try (ARGBImage argbImage = new ARGBImage((ImageInputSource)new ImageInputSourceImpl((Object)xImage.getImageStreamData(), false), xImage.getWidth(), xImage.getHeight(), xImage.getBitsPerComponent(), (ColorSpaceCache)ColorSpaceCacheImpl.newInstance((PDFColorSpace)colorSpace, null, null, (double[])xImage.getDecode()), xImage.hasDecodeArray() ? xImage.getDecode() : null);){
                int width = argbImage.getWidth();
                int height = argbImage.getHeight();
                BufferedImage image = ImageManager.getBufferedImage(argbImage, width, height, 1);
                BufferedImageWrapper bufferedImageWrapper = new BufferedImageWrapper(image, byteWriter, xImage.getInputFilters());
                return bufferedImageWrapper;
            }
        }
        int width = xImage.getWidth();
        int height = xImage.getHeight();
        boolean blackIs1 = xImage.getBlackIs1();
        double[] decode = xImage.getDecode();
        PDFFilterList filterList = xImage.getInputFilters();
        InputByteStream ibstr = null;
        OutputByteStream obs = null;
        try {
            obs = xImage.getStreamManager().getUnregisteredOutputByteStream(byteWriter);
            ibstr = xImage.getCosStream().getStreamDecoded();
            if (colorSpace instanceof PDFColorSpaceDeviceCMYK) {
                while (ibstr.bytesAvailable() > 0L) {
                    int i = ibstr.read();
                    int j = 255 - i;
                    obs.write(j);
                }
            } else if (colorSpace instanceof PDFColorSpaceIndexed) {
                if (((PDFColorSpaceIndexed)colorSpace).getBaseColorSpace() instanceof PDFColorSpaceDeviceCMYK) {
                    while (ibstr.bytesAvailable() > 0L) {
                        int i = ibstr.read();
                        int j = 255 - i;
                        obs.write(j);
                    }
                } else {
                    xImage.getCosStream().copyStream((Object)obs, false);
                }
            } else {
                xImage.getCosStream().copyStream((Object)obs, false);
            }
        }
        catch (PDFCosParseException e) {
            throw new PDFInvalidDocumentException((Throwable)e);
        }
        catch (IOException e) {
            throw new PDFIOException((Throwable)e);
        }
        finally {
            if (ibstr != null) {
                ibstr.close();
            }
            if (obs != null) {
                obs.close();
            }
        }
        return ImageManager.createBufferedImage(byteWriter, height, width, bpc, colorSpace, blackIs1, decode, filterList, dataBufferFactory);
    }

    private static BufferedImageWrapper createBufferedImage(InlineImage inlineImage, ByteWriter byteWriter) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        int width = inlineImage.getWidth();
        int height = inlineImage.getHeight();
        int bpc = inlineImage.getBitsPerComponent();
        InlineImageColorSpace colorSpace = inlineImage.getColorSpace();
        boolean blackIs1 = false;
        double[] decode = inlineImage.getImageDecodeArray();
        InputStream is = null;
        OutputByteStream obs = null;
        try {
            is = inlineImage.getImageData();
            obs = inlineImage.getContent().getPDFDocument().getStreamManager().getOutputByteStream(byteWriter);
            IO.copy((InputStream)is, (OutputByteStream)obs);
        }
        catch (IOException e) {
            throw new PDFIOException((Throwable)e);
        }
        finally {
            try {
                if (obs != null) {
                    obs.close();
                }
            }
            catch (IOException e) {
                throw new PDFIOException((Throwable)e);
            }
        }
        if (colorSpace != null) {
            colorSpace.setBlackIs1(blackIs1);
            if (decode != null && decode.length != 0 && decode[0] == 1.0) {
                colorSpace.setImageInverted(true);
            }
            Content content = inlineImage.getContent();
            ColorModel cm = colorSpace.createColorModel(bpc, content.getResources());
            WritableRaster raster = cm.createCompatibleWritableRaster(width, height);
            DataBufferByteWriter buffer = new DataBufferByteWriter(byteWriter, 0, 1);
            DataBufferWritableRaster newRaster = new DataBufferWritableRaster(raster.getSampleModel(), (DataBuffer)buffer, new Point(0, 0));
            BufferedImage image = new BufferedImage(cm, newRaster, false, null);
            return new BufferedImageWrapper(image, byteWriter);
        }
        throw new PDFInvalidParameterException("ColorSpace for image is null");
    }

    private static BufferedImageWrapper createBufferedImage(ByteWriter byteWriter, int height, int width, int bpc, PDFColorSpace colorSpace, boolean blackIs1, double[] decode, PDFFilterList filterList, DataBufferFactoryInterface dataBufferFactory) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        if (colorSpace != null) {
            colorSpace.setBlackIs1(blackIs1);
            if (decode != null && decode.length != 0 && decode[0] == 1.0) {
                colorSpace.setImageInverted(true);
            }
            ColorModel cm = colorSpace.createColorModel(bpc, 0);
            WritableRaster raster = cm.createCompatibleWritableRaster(width, height);
            int length = 0;
            try {
                length = (int)byteWriter.length();
            }
            catch (IOException e) {
                throw new PDFIOException((Throwable)e);
            }
            DataBuffer buffer = null;
            if (dataBufferFactory == null || (buffer = dataBufferFactory.getDataBuffer(byteWriter)) == null) {
                buffer = new DataBufferByteWriter(byteWriter, raster.getDataBuffer().getDataType(), length);
            }
            DataBufferWritableRaster newRaster = new DataBufferWritableRaster(raster.getSampleModel(), buffer, new Point(0, 0));
            BufferedImage image = new BufferedImage(cm, newRaster, false, null);
            return new BufferedImageWrapper(image, byteWriter, filterList);
        }
        throw new PDFInvalidParameterException("ColorSpace for image is null");
    }

    public static PDFXObjectImage resampleXObjImage(PDFDocument targetDoc, PDFXObjectImage xobjSourceImage, double hScale, double vScale, int method) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        PDFXObjectAltImageList altSourceImageList;
        int width = xobjSourceImage.getWidth();
        int height = xobjSourceImage.getHeight();
        int destHeight = (int)Math.round((double)height * vScale);
        int destWidth = (int)Math.round((double)width * hScale);
        PDFXObjectImage xobjDestImage = null;
        CosCloneMgr cloner = new CosCloneMgr(targetDoc.getCosDocument());
        xobjDestImage = ImageManager.resampleImage(targetDoc, xobjSourceImage, destWidth, destHeight, method);
        if (xobjSourceImage.hasMask()) {
            PDFXObjectImage xobjSourceMaskImage = xobjSourceImage.getMaskImage();
            PDFXObjectImage xobjDestMaskImage = ImageManager.resampleImage(targetDoc, xobjSourceMaskImage, destWidth, destHeight, method);
            xobjDestMaskImage = ImageManager.fillClonedAttributes(xobjSourceMaskImage, xobjDestMaskImage, cloner);
            xobjDestImage.setMaskImage(xobjDestMaskImage);
        }
        if (xobjSourceImage.hasSoftMask()) {
            PDFXObjectImage xobjSourceSMaskIamge = xobjSourceImage.getSMask();
            PDFXObjectImage xobjDestSMaskImage = ImageManager.resampleImage(targetDoc, xobjSourceSMaskIamge, destWidth, destHeight, method);
            xobjDestSMaskImage = ImageManager.fillClonedAttributes(xobjSourceSMaskIamge, xobjDestSMaskImage, cloner);
            xobjDestImage.setSMask(xobjDestSMaskImage);
        }
        if ((altSourceImageList = xobjSourceImage.getAlternatesList()) != null) {
            PDFXObjectAltImageList altDestImageList = PDFXObjectAltImageList.newInstance((PDFDocument)targetDoc);
            Iterator iter = altSourceImageList.iterator();
            while (iter.hasNext()) {
                PDFXObjectImage altSourceImage = ((PDFXObjectAltImage)iter.next()).getImage();
                PDFXObjectImage altDestImage = ImageManager.resampleXObjImage(targetDoc, altSourceImage, destWidth, destHeight, method);
                altDestImageList.add((PDFCosObjectContainer)PDFXObjectAltImage.newInstance((PDFXObjectImage)altDestImage, (PDFDocument)targetDoc));
            }
            xobjDestImage.setAlternatesList(altDestImageList);
        }
        xobjDestImage = ImageManager.fillClonedAttributes(xobjSourceImage, xobjDestImage, cloner);
        return xobjDestImage;
    }

    public static BufferedImage getResampledBufferedImage(BufferedImage sourceImage, double hScale, double vScale, int method) throws PDFInvalidParameterException {
        int width = sourceImage.getWidth();
        int height = sourceImage.getHeight();
        int destHeight = (int)Math.round((double)height * vScale);
        int destWidth = (int)Math.round((double)width * hScale);
        return Resampler.resampleImage((BufferedImage)sourceImage, (int)destWidth, (int)destHeight, (int)method);
    }

    private static PDFXObjectImage resampleImage(PDFDocument targetDoc, PDFXObjectImage xobjSourceImage, int destWidth, int destHeight, int method) throws PDFIOException, PDFSecurityException, PDFInvalidDocumentException, PDFInvalidParameterException {
        BufferedImage destBufferedImage;
        ByteArrayByteWriter babw = new ByteArrayByteWriter();
        BufferedImageWrapper sourceBufferedImage = ImageManager.toBufferedImage(xobjSourceImage, (ByteWriter)babw);
        try {
            destBufferedImage = Resampler.resampleImage((BufferedImage)sourceBufferedImage.getBufferedImage(), (int)destWidth, (int)destHeight, (int)method);
        }
        catch (Exception e) {
            throw new PDFInvalidParameterException("Error while downsampling image", (Throwable)e);
        }
        return ImageManager.getPDFImage(destBufferedImage, targetDoc, xobjSourceImage.getInputFilters());
    }

    private static PDFXObjectImage fillClonedAttributes(PDFXObjectImage xobjSourceImage, PDFXObjectImage xobjDestImage, CosCloneMgr cloner) throws PDFIOException, PDFSecurityException, PDFInvalidDocumentException {
        CosStream sourceObj = xobjSourceImage.getCosStream();
        CosStream destObj = xobjDestImage.getCosStream();
        Iterator iter = sourceObj.keyIterator();
        while (iter.hasNext()) {
            ASName key = (ASName)iter.next();
            if (destObj.containsKey((Object)key)) continue;
            destObj.put(key, cloner.clone(sourceObj.get(key)));
        }
        return PDFXObjectImage.getInstance((CosObject)destObj);
    }

    public static final byte[] intToByteArray(int value) {
        return new byte[]{(byte)(value >>> 24), (byte)(value >>> 16), (byte)(value >>> 8), (byte)value};
    }
}

