/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.pieceinfo.editablepdf;

import com.adobe.internal.pdftoolkit.core.cos.CosDictionary;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASDate;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosDictionary;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosObject;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.document.PDFTextEncoding;
import com.adobe.internal.pdftoolkit.pdf.graphics.PDFRectangle;
import com.adobe.internal.pdftoolkit.pdf.graphics.xobject.PDFXObjectForm;
import com.adobe.internal.pdftoolkit.pdf.interchange.PDFApplicationData;
import com.adobe.internal.pdftoolkit.pdf.interchange.structure.PDFStructureClassMap;
import com.adobe.internal.pdftoolkit.pdf.page.PDFPagePiece;
import com.adobe.internal.pdftoolkit.pdf.pieceinfo.editablepdf.PDFWPFlow;
import com.adobe.internal.pdftoolkit.pdf.pieceinfo.editablepdf.PDFWPPageInfo;

public class PDFWPXObjectInfo
extends PDFCosDictionary {
    public static final ASName k_PaginationArtifact = ASName.create((String)"PaginationArtifact");
    public static final ASName k_MarginTop = ASName.create((String)"MarginTop");
    public static final ASName k_MarginBottom = ASName.create((String)"MarginBottom");
    public static final ASName k_MarginLeft = ASName.create((String)"MarginLeft");
    public static final ASName k_MarginRight = ASName.create((String)"MarginRight");
    public static final ASName k_BBoxMin = ASName.create((String)"BBoxMin");
    public static final ASName k_BBoxMax = ASName.create((String)"BBoxMax");

    private PDFWPXObjectInfo(CosObject cosObject) throws PDFInvalidDocumentException {
        super(cosObject);
    }

    public static PDFWPXObjectInfo getInstance(CosObject cosObject) throws PDFInvalidDocumentException {
        if (PDFCosObject.checkNullCosObject((CosObject)cosObject) == null) {
            return null;
        }
        PDFWPXObjectInfo pdfObject = (PDFWPXObjectInfo)PDFCosObject.getCachedInstance((CosObject)cosObject, PDFWPXObjectInfo.class);
        if (pdfObject == null) {
            pdfObject = new PDFWPXObjectInfo(cosObject);
        }
        return pdfObject;
    }

    public static PDFWPXObjectInfo getInstance(PDFXObjectForm form) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFPagePiece pageInfo = form.getPieceInfo();
        if (pageInfo == null) {
            return null;
        }
        PDFApplicationData pieceInfo = pageInfo.getApplicationData(PDFWPPageInfo.k_PDFWP);
        if (pieceInfo == null) {
            return null;
        }
        return new PDFWPXObjectInfo(pieceInfo.getPrivateData());
    }

    public static PDFWPXObjectInfo newInstance(PDFDocument pdfDocument, String flowName) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosDictionary cosObject = PDFCosObject.newCosDictionary((PDFDocument)pdfDocument);
        PDFWPXObjectInfo pdfObject = new PDFWPXObjectInfo((CosObject)cosObject);
        pdfObject.setFlowName(flowName);
        return pdfObject;
    }

    public String getFlowName() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryTextStringValue(PDFWPFlow.k_Flow);
    }

    public void setFlowName(String name) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryStringValue(PDFWPFlow.k_Flow, name);
    }

    public void setFlowName(String name, PDFTextEncoding unicode) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryStringValue(PDFWPFlow.k_Flow, name, unicode);
    }

    public PDFStructureClassMap getClassMap() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFStructureClassMap.getInstance((CosObject)this.getDictionaryValue(ASName.k_ClassMap));
    }

    public void setClassMap(PDFStructureClassMap classMap) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryValue(ASName.k_ClassMap, (PDFCosObject)classMap);
    }

    public ASName getArtifactType() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryNameValue(k_PaginationArtifact);
    }

    public void setArtifactType(ASName type) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryNameValue(k_PaginationArtifact, type);
    }

    public Number getMarginTop() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryNumericValue(k_MarginTop);
    }

    public void setMarginTop(Number top) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (top == null) {
            this.removeValue(k_MarginTop);
        } else {
            this.setDictionaryValue(k_MarginTop, (CosObject)PDFCosObject.newCosNumeric((PDFDocument)this.getPDFDocument(), (Number)top));
        }
    }

    public Number getMarginBottom() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryNumericValue(k_MarginBottom);
    }

    public void setMarginBottom(Number top) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (top == null) {
            this.removeValue(k_MarginBottom);
        } else {
            this.setDictionaryValue(k_MarginBottom, (CosObject)PDFCosObject.newCosNumeric((PDFDocument)this.getPDFDocument(), (Number)top));
        }
    }

    public Number getMarginLeft() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryNumericValue(k_MarginLeft);
    }

    public void setMarginLeft(Number top) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (top == null) {
            this.removeValue(k_MarginLeft);
        } else {
            this.setDictionaryValue(k_MarginLeft, (CosObject)PDFCosObject.newCosNumeric((PDFDocument)this.getPDFDocument(), (Number)top));
        }
    }

    public Number getMarginRight() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryNumericValue(k_MarginRight);
    }

    public void setMarginRight(Number top) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (top == null) {
            this.removeValue(k_MarginRight);
        } else {
            this.setDictionaryValue(k_MarginRight, (CosObject)PDFCosObject.newCosNumeric((PDFDocument)this.getPDFDocument(), (Number)top));
        }
    }

    public PDFRectangle getMinBox() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFRectangle.getInstance((CosObject)this.getDictionaryValue(k_BBoxMin));
    }

    public void setMinBox(PDFRectangle rect) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryValue(k_BBoxMin, (PDFCosObject)rect);
    }

    public PDFRectangle getMaxBox() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFRectangle.getInstance((CosObject)this.getDictionaryValue(k_BBoxMax));
    }

    public void setMaxBox(PDFRectangle rect) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryValue(k_BBoxMax, (PDFCosObject)rect);
    }

    public PDFApplicationData setXObjectInfo(PDFXObjectForm form, PDFXObjectForm srcForm) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFPagePiece formInfo = form.procurePieceInfo();
        PDFApplicationData appData = PDFApplicationData.newInstance((PDFDocument)form.getPDFDocument());
        appData.setPrivateData((PDFCosObject)this);
        ASDate modDate = srcForm.getPieceInfo().getApplicationData(PDFWPPageInfo.k_PDFWP).getLastModified();
        if (modDate != null) {
            appData.setLastModified(modDate);
        }
        formInfo.setApplicationData(PDFWPPageInfo.k_PDFWP, appData);
        form.setPieceInfo(formInfo);
        return appData;
    }
}

