/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.pieceinfo.editablepdf;

import com.adobe.internal.pdftoolkit.core.cos.CosDictionary;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosDictionary;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosObject;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.document.PDFTextEncoding;
import com.adobe.internal.pdftoolkit.pdf.interchange.structure.PDFStructureClassMap;
import com.adobe.internal.pdftoolkit.pdf.pieceinfo.editablepdf.PDFWPContentRegion;

public class PDFWPFlow
extends PDFCosDictionary {
    public static final ASName k_Flow = ASName.create((String)"Flow");
    public static final ASName k_UIName = ASName.create((String)"UIName");

    private PDFWPFlow(CosObject cosObject) throws PDFInvalidDocumentException {
        super(cosObject);
    }

    public static PDFWPFlow getInstance(CosObject cosObject) throws PDFInvalidDocumentException {
        if (PDFCosObject.checkNullCosObject((CosObject)cosObject) == null) {
            return null;
        }
        PDFWPFlow pdfObject = (PDFWPFlow)PDFCosObject.getCachedInstance((CosObject)cosObject, PDFWPFlow.class);
        if (pdfObject == null) {
            pdfObject = new PDFWPFlow(cosObject);
        }
        return pdfObject;
    }

    public static PDFWPFlow newInstance(PDFDocument pdfDocument, String flowName, PDFTextEncoding unicode) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosDictionary cosObject = PDFCosObject.newCosDictionary((PDFDocument)pdfDocument);
        PDFWPFlow pdfObject = new PDFWPFlow((CosObject)cosObject);
        pdfObject.setDictionaryNameValue(ASName.k_Type, k_Flow);
        pdfObject.setDictionaryStringValue(ASName.k_Name, flowName, unicode);
        return pdfObject;
    }

    public static PDFWPFlow newInstance(PDFDocument pdfDocument, String flowName) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosDictionary cosObject = PDFCosObject.newCosDictionary((PDFDocument)pdfDocument);
        PDFWPFlow pdfObject = new PDFWPFlow((CosObject)cosObject);
        pdfObject.setDictionaryNameValue(ASName.k_Type, k_Flow);
        pdfObject.setDictionaryStringValue(ASName.k_Name, flowName);
        return pdfObject;
    }

    public String getName() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryTextStringValue(ASName.k_Name);
    }

    public String requireName() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        String name = this.getDictionaryTextStringValue(ASName.k_Name);
        if (name == null) {
            throw new PDFInvalidDocumentException("Required Instance");
        }
        return name;
    }

    public void setName(String name) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryStringValue(ASName.k_Name, name);
    }

    public void setName(String name, PDFTextEncoding unicode) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryStringValue(ASName.k_Name, name, unicode);
    }

    public String getUIName() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryTextStringValue(k_UIName);
    }

    public void setUIName(String uiName) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryStringValue(k_UIName, uiName);
    }

    public void setUIName(String uiName, PDFTextEncoding unicode) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryStringValue(k_UIName, uiName, unicode);
    }

    public PDFWPContentRegion getFirstRegion() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFWPContentRegion.getInstance(this.getDictionaryValue(ASName.k_F));
    }

    public void setFirstRegion(PDFWPContentRegion firstRegion) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryValue(ASName.k_F, (PDFCosObject)firstRegion);
    }

    public PDFStructureClassMap getClassMap() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFStructureClassMap.getInstance((CosObject)this.getDictionaryValue(ASName.k_ClassMap));
    }

    public void setClassMap(PDFStructureClassMap classMap) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryValue(ASName.k_ClassMap, (PDFCosObject)classMap);
    }
}

