/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.pieceinfo.editablepdf;

import com.adobe.internal.pdftoolkit.core.cos.CosArray;
import com.adobe.internal.pdftoolkit.core.cos.CosDictionary;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASDate;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCatalog;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosDictionary;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosObject;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.interchange.PDFApplicationData;
import com.adobe.internal.pdftoolkit.pdf.page.PDFPagePiece;
import com.adobe.internal.pdftoolkit.pdf.pieceinfo.editablepdf.PDFWPFlowsTree;
import com.adobe.internal.pdftoolkit.pdf.pieceinfo.editablepdf.PDFWPMasterPagesTree;
import com.adobe.internal.pdftoolkit.pdf.pieceinfo.editablepdf.PDFWPPageInfo;

public class PDFWPCatalogInfo
extends PDFCosDictionary {
    private static final ASName k_MasterPages = ASName.create((String)"MasterPages");
    private static final ASName k_Flows = ASName.create((String)"Flows");

    private PDFWPCatalogInfo(CosObject cosObject) throws PDFInvalidDocumentException {
        super(cosObject);
    }

    public static PDFWPCatalogInfo getInstance(PDFDocument pdfDoc) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFPagePiece docInfo = pdfDoc.requireCatalog().getPieceInfo();
        if (docInfo == null) {
            return null;
        }
        PDFApplicationData pieceInfo = docInfo.getApplicationData(PDFWPPageInfo.k_PDFWP);
        if (pieceInfo == null) {
            return null;
        }
        return new PDFWPCatalogInfo(pieceInfo.getPrivateData());
    }

    public static PDFWPCatalogInfo newInstance(PDFDocument pdfDocument, int[] version) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosDictionary cosObject = PDFCosObject.newCosDictionary((PDFDocument)pdfDocument);
        PDFWPCatalogInfo pdfObject = new PDFWPCatalogInfo((CosObject)cosObject);
        pdfObject.setVersion(version);
        return pdfObject;
    }

    public PDFWPMasterPagesTree getMasterPages() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFWPMasterPagesTree.getInstance((CosObject)this.getDictionaryDictionaryValue(k_MasterPages));
    }

    public void setMasterPages(PDFWPMasterPagesTree pages) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryValue(k_MasterPages, (PDFCosObject)pages);
    }

    public PDFWPFlowsTree getFlows() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFWPFlowsTree.getInstance(this.getDictionaryValue(k_Flows));
    }

    public void setFlows(PDFWPFlowsTree flows) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryValue(k_Flows, (PDFCosObject)flows);
    }

    public int[] getVersion() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosArray cosVersion = this.getDictionaryArrayValue(ASName.k_Version);
        if (cosVersion == null) {
            return null;
        }
        int[] version = new int[cosVersion.size()];
        for (int verInd = 0; verInd < version.length; ++verInd) {
            version[verInd] = cosVersion.getInt(verInd);
        }
        return version;
    }

    public int[] requireVersion() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        int[] version = this.getVersion();
        if (version == null) {
            throw new PDFInvalidDocumentException("Required Instance");
        }
        return version;
    }

    public void setVersion(int[] version) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosArray cosVersion = PDFCosObject.newCosArray((PDFDocument)this.getPDFDocument());
        for (int verInd = 0; verInd < version.length; ++verInd) {
            cosVersion.addInt(version[verInd]);
        }
        this.setDictionaryArrayValue(ASName.k_Version, cosVersion);
    }

    public PDFApplicationData setCatalogInfo(PDFDocument pdfDoc, PDFDocument srcDoc) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFCatalog catalog = pdfDoc.requireCatalog();
        PDFPagePiece catalogInfo = catalog.procurePieceInfo();
        PDFApplicationData appData = PDFApplicationData.newInstance((PDFDocument)pdfDoc);
        appData.setPrivateData((PDFCosObject)this);
        ASDate modDate = srcDoc.requireCatalog().getPieceInfo().getApplicationData(PDFWPPageInfo.k_PDFWP).getLastModified();
        if (modDate != null) {
            appData.setLastModified(modDate);
        }
        catalogInfo.setApplicationData(PDFWPPageInfo.k_PDFWP, appData);
        catalog.setPieceInfo(catalogInfo);
        return appData;
    }
}

