/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.pieceinfo.compoundtype;

import com.adobe.internal.pdftoolkit.core.cos.CosName;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosObject;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.graphics.xobject.PDFXObjectForm;
import com.adobe.internal.pdftoolkit.pdf.interchange.PDFApplicationData;
import com.adobe.internal.pdftoolkit.pdf.page.PDFPagePiece;

public class PDFCompoundTypeInfo
extends PDFCosObject {
    public static final ASName k_CompoundType = ASName.create((String)"ADBE_CompoundType");

    private PDFCompoundTypeInfo(CosObject cosObject) throws PDFInvalidDocumentException {
        super(cosObject);
    }

    public static PDFCompoundTypeInfo getInstance(PDFXObjectForm form) {
        PDFCompoundTypeInfo pdfObject = null;
        try {
            PDFPagePiece formPiece = form.getPieceInfo();
            if (formPiece == null) {
                return null;
            }
            CosObject cosCompoundType = formPiece.getDictionaryCosObjectValue(k_CompoundType);
            if (cosCompoundType == null) {
                return null;
            }
            if (cosCompoundType.getType() == 3) {
                return PDFCompoundTypeInfo.newInstance(formPiece.getPDFDocument(), cosCompoundType.nameValue());
            }
            PDFApplicationData formData = formPiece.getApplicationData(k_CompoundType);
            if (formData == null) {
                return null;
            }
            pdfObject = new PDFCompoundTypeInfo(formData.getPrivateData());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return pdfObject;
    }

    public static PDFCompoundTypeInfo newInstance(PDFDocument pdfDocument, ASName type) throws PDFInvalidDocumentException {
        CosName cosObject = PDFCosObject.newCosName((PDFDocument)pdfDocument, (ASName)type);
        return new PDFCompoundTypeInfo((CosObject)cosObject);
    }

    public ASName getType() {
        return this.getCosObject().nameValue();
    }

    public PDFApplicationData setType(PDFXObjectForm form) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFPagePiece formInfo = form.procurePieceInfo();
        PDFApplicationData appData = PDFApplicationData.newInstance((PDFDocument)form.getPDFDocument());
        appData.setPrivateData((PDFCosObject)this);
        formInfo.setApplicationData(k_CompoundType, appData);
        return appData;
    }
}

