/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aem.integrations.ajo.servlets;

import com.adobe.aem.integrations.ajo.AjoException;
import com.adobe.granite.toggle.api.ToggleCondition;
import com.day.cq.replication.ReplicationActionType;
import com.day.cq.replication.Replicator;
import com.day.cq.wcm.core.reference.ActivationReferenceSearchService;
import com.day.cq.wcm.core.reference.ReferenceSearchFilter;
import com.day.cq.wcm.core.reference.ReferenceSearchFilterConstants;
import com.day.cq.wcm.core.reference.ReferenceSearchFilterFactory;
import com.day.cq.wcm.core.reference.ReferencesConverter;
import java.util.Collections;
import java.util.stream.StreamSupport;
import javax.annotation.Nonnull;
import javax.jcr.Session;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.servlets.SlingAllMethodsServlet;
import org.apache.sling.commons.json.JSONArray;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, service={Servlet.class}, property={"sling.servlet.methods=POST", "sling.servlet.paths=/bin/ajo/publishReferences"}, reference={@Reference(service=ToggleCondition.class, name="toggleCondition", target="(toggle.name=ft-sites-7041)", policy=ReferencePolicy.STATIC, cardinality=ReferenceCardinality.MANDATORY)})
public class ReferencePublisherServlet
extends SlingAllMethodsServlet {
    private static final Logger log = LoggerFactory.getLogger(ReferencePublisherServlet.class);
    public static final String PATH_PARAM = "path";
    static final ReferencesConverter<String[]> ARRAY_REFERENCES_CONVERTER = iterable -> (String[])StreamSupport.stream(iterable.spliterator(), false).map(com.day.cq.wcm.api.reference.Reference::getResource).map(Resource::getPath).toArray(String[]::new);
    private final transient ActivationReferenceSearchService activationReferenceSearchService;
    private final transient ReferenceSearchFilterFactory referenceSearchFilterFactory;
    private final transient Replicator replicator;

    @Activate
    public ReferencePublisherServlet(@Reference ActivationReferenceSearchService activationReferenceSearchService, @Reference ReferenceSearchFilterFactory referenceSearchFilterFactory, @Reference Replicator replicator) {
        this.activationReferenceSearchService = activationReferenceSearchService;
        this.referenceSearchFilterFactory = referenceSearchFilterFactory;
        this.replicator = replicator;
    }

    protected void doPost(@Nonnull SlingHttpServletRequest request, @Nonnull SlingHttpServletResponse response) throws ServletException {
        try {
            String[] references;
            log.debug("Publishing templates...");
            ResourceResolver resourceResolver = request.getResourceResolver();
            Session session = (Session)resourceResolver.adaptTo(Session.class);
            String[] paths = request.getParameterValues(PATH_PARAM);
            if (paths == null || paths.length == 0) {
                throw new AjoException("Missing parameter: path");
            }
            for (String path : paths) {
                Resource resource = resourceResolver.getResource(path);
                if (resource != null) continue;
                throw new AjoException("Template not found: " + path);
            }
            ReferenceSearchFilter referenceSearchFilter = this.referenceSearchFilterFactory.createFilter(ReferenceSearchFilterConstants.ACTIVE_FILTER, Collections.emptySet(), "publish");
            log.debug("Searching for references...");
            for (String reference : references = (String[])this.activationReferenceSearchService.getReferences(resourceResolver, paths, ARRAY_REFERENCES_CONVERTER, referenceSearchFilter)) {
                log.debug("Publishing reference: {}", (Object)reference);
                this.replicator.replicate(session, ReplicationActionType.ACTIVATE, reference);
            }
            for (String path : paths) {
                log.debug("Publishing template: {}", (Object)path);
                this.replicator.replicate(session, ReplicationActionType.ACTIVATE, path);
            }
            JSONArray payload = new JSONArray();
            for (String reference : references) {
                payload.put((Object)reference);
            }
            for (String path : paths) {
                payload.put((Object)path);
            }
            response.setContentType("application/json");
            response.getWriter().write(payload.toString());
        }
        catch (Exception e) {
            throw new ServletException("Error while publishing references", (Throwable)e);
        }
    }
}

