/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.servlets.post.impl.operations;

import java.util.Iterator;
import java.util.List;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.request.RequestPathInfo;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.servlets.post.Modification;
import org.apache.sling.servlets.post.PostResponse;
import org.apache.sling.servlets.post.VersioningConfiguration;
import org.apache.sling.servlets.post.impl.helper.SlingFileUploadHandler;
import org.apache.sling.servlets.post.impl.operations.AbstractPostOperation;

public class DeleteOperation
extends AbstractPostOperation {
    private final SlingFileUploadHandler uploadHandler = new SlingFileUploadHandler();

    @Override
    protected void doRun(SlingHttpServletRequest request, PostResponse response, List<Modification> changes) throws PersistenceException {
        RequestPathInfo rpi = request.getRequestPathInfo();
        if (rpi.getSelectors() != null && rpi.getSelectors().length > 0 || rpi.getExtension() != null && rpi.getExtension().length() > 0 || rpi.getSuffix() != null && rpi.getSuffix().length() > 0) {
            response.setStatus(403, "DeleteOperation request cannot include any selectors, extension or suffix");
            return;
        }
        VersioningConfiguration versioningConfiguration = this.getVersioningConfiguration(request);
        boolean deleteChunks = this.isDeleteChunkRequest(request);
        Iterator<Resource> res = this.getApplyToResources(request);
        if (res == null) {
            Resource resource = request.getResource();
            this.deleteResource(resource, changes, versioningConfiguration, deleteChunks);
        } else {
            while (res.hasNext()) {
                Resource resource = res.next();
                this.deleteResource(resource, changes, versioningConfiguration, deleteChunks);
            }
        }
    }

    private void deleteResource(Resource resource, List<Modification> changes, VersioningConfiguration versioningConfiguration, boolean deleteChunks) throws PersistenceException {
        if (deleteChunks) {
            this.uploadHandler.deleteChunks(resource);
        } else {
            this.jcrSupport.checkoutIfNecessary(resource.getParent(), changes, versioningConfiguration);
        }
        resource.getResourceResolver().delete(resource);
        changes.add(Modification.onDeleted(resource.getPath()));
    }

    protected boolean isDeleteChunkRequest(SlingHttpServletRequest request) {
        return Boolean.parseBoolean(request.getParameter(":applyToChunks"));
    }
}

