/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.servlets.post.impl.helper;

import java.util.List;
import javax.jcr.AccessDeniedException;
import javax.jcr.InvalidItemStateException;
import javax.jcr.Item;
import javax.jcr.ItemExistsException;
import javax.jcr.ItemNotFoundException;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.UnsupportedRepositoryOperationException;
import javax.jcr.Value;
import javax.jcr.ValueFormatException;
import javax.jcr.lock.LockException;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.nodetype.NoSuchNodeTypeException;
import javax.jcr.nodetype.NodeType;
import javax.jcr.nodetype.NodeTypeManager;
import javax.jcr.nodetype.PropertyDefinition;
import javax.jcr.version.VersionException;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.servlets.post.Modification;
import org.apache.sling.servlets.post.VersioningConfiguration;
import org.apache.sling.servlets.post.exceptions.PreconditionViolatedPersistenceException;
import org.apache.sling.servlets.post.exceptions.TemporaryPersistenceException;
import org.apache.sling.servlets.post.impl.helper.ReferenceParser;

public class JCRSupportImpl {
    private boolean isVersionable(Node node) throws RepositoryException {
        return node.isNodeType("mix:versionable");
    }

    public boolean isVersionable(Resource rsrc) throws PersistenceException {
        try {
            Node node = (Node)rsrc.adaptTo(Node.class);
            return node != null && this.isVersionable(node);
        }
        catch (RepositoryException re) {
            throw new PersistenceException(re.getMessage(), (Throwable)re, rsrc.getPath(), null);
        }
    }

    public boolean checkin(Resource rsrc) throws PersistenceException {
        Node node = (Node)rsrc.adaptTo(Node.class);
        if (node != null) {
            try {
                if (node.isCheckedOut() && this.isVersionable(node)) {
                    node.getSession().getWorkspace().getVersionManager().checkin(node.getPath());
                    return true;
                }
            }
            catch (AccessDeniedException e) {
                throw new PreconditionViolatedPersistenceException(e.getMessage(), e, rsrc.getPath(), null);
            }
            catch (InvalidItemStateException | UnsupportedRepositoryOperationException | LockException e) {
                throw new TemporaryPersistenceException(e.getMessage(), e, rsrc.getPath(), null);
            }
            catch (RepositoryException re) {
                throw new PersistenceException(re.getMessage(), (Throwable)re, rsrc.getPath(), null);
            }
        }
        return false;
    }

    private Node findVersionableAncestor(Node node) throws RepositoryException {
        if (this.isVersionable(node)) {
            return node;
        }
        try {
            node = node.getParent();
            return this.findVersionableAncestor(node);
        }
        catch (AccessDeniedException | ItemNotFoundException e) {
            return null;
        }
    }

    public void checkoutIfNecessary(Resource resource, List<Modification> changes, VersioningConfiguration versioningConfiguration) throws PersistenceException {
        Node node;
        if (resource != null && versioningConfiguration.isAutoCheckout() && (node = (Node)resource.adaptTo(Node.class)) != null) {
            try {
                Node versionableNode = this.findVersionableAncestor(node);
                if (versionableNode != null && !versionableNode.isCheckedOut()) {
                    versionableNode.getSession().getWorkspace().getVersionManager().checkout(versionableNode.getPath());
                    changes.add(Modification.onCheckout(versionableNode.getPath()));
                }
            }
            catch (AccessDeniedException e) {
                throw new PreconditionViolatedPersistenceException(e.getMessage(), (Exception)((Object)e));
            }
            catch (UnsupportedRepositoryOperationException e) {
                throw new TemporaryPersistenceException(e.getMessage(), (Exception)((Object)e));
            }
            catch (RepositoryException re) {
                throw new PersistenceException(re.getMessage(), (Throwable)re);
            }
        }
    }

    public boolean isNode(Resource rsrc) {
        return rsrc.adaptTo(Node.class) != null;
    }

    public boolean isNodeType(Resource rsrc, String typeHint) {
        Node node = (Node)rsrc.adaptTo(Node.class);
        if (node != null) {
            try {
                return node.isNodeType(typeHint);
            }
            catch (RepositoryException repositoryException) {
                // empty catch block
            }
        }
        return false;
    }

    public Boolean isFileNodeType(ResourceResolver resolver, String nodeType) {
        Session session = (Session)resolver.adaptTo(Session.class);
        if (session != null) {
            try {
                NodeTypeManager ntMgr = session.getWorkspace().getNodeTypeManager();
                NodeType nt = ntMgr.getNodeType(nodeType);
                return nt.isNodeType("nt:file");
            }
            catch (RepositoryException e) {
                return null;
            }
        }
        return false;
    }

    private PropertyDefinition searchPropertyDefinition(NodeType nodeType, String name) {
        if (nodeType.getPropertyDefinitions() != null) {
            for (PropertyDefinition pd : nodeType.getPropertyDefinitions()) {
                if (!pd.getName().equals(name)) continue;
                return pd;
            }
        }
        return null;
    }

    private PropertyDefinition searchPropertyDefinition(Node node, String name) throws RepositoryException {
        PropertyDefinition result = this.searchPropertyDefinition(node.getPrimaryNodeType(), name);
        if (result == null && node.getMixinNodeTypes() != null) {
            for (NodeType mt : node.getMixinNodeTypes()) {
                result = this.searchPropertyDefinition(mt, name);
                if (result == null) continue;
                return result;
            }
        }
        return result;
    }

    public boolean isPropertyProtectedOrNewAutoCreated(Object n, String name) throws PersistenceException {
        Node node = (Node)n;
        try {
            PropertyDefinition pd = this.searchPropertyDefinition(node, name);
            if (pd != null && (node.isNew() && pd.isAutoCreated() || pd.isProtected())) {
                return true;
            }
        }
        catch (RepositoryException re) {
            throw new PersistenceException(re.getMessage(), (Throwable)re);
        }
        return false;
    }

    public boolean isNewNode(Object node) {
        return ((Node)node).isNew();
    }

    public boolean isPropertyMandatory(Object node, String name) throws PersistenceException {
        try {
            Property prop = ((Node)node).getProperty(name);
            return prop.getDefinition().isMandatory();
        }
        catch (PathNotFoundException e) {
            throw new PreconditionViolatedPersistenceException(e.getMessage(), (Exception)((Object)e));
        }
        catch (RepositoryException re) {
            throw new PersistenceException(re.getMessage(), (Throwable)re);
        }
    }

    public boolean isPropertyMultiple(Object node, String name) throws PersistenceException {
        try {
            Property prop = ((Node)node).getProperty(name);
            return prop.getDefinition().isMultiple();
        }
        catch (PathNotFoundException e) {
            throw new PreconditionViolatedPersistenceException(e.getMessage(), (Exception)((Object)e));
        }
        catch (RepositoryException re) {
            throw new PersistenceException(re.getMessage(), (Throwable)re);
        }
    }

    public Integer getPropertyType(Object node, String name) throws PersistenceException {
        try {
            if (((Node)node).hasProperty(name)) {
                return ((Node)node).getProperty(name).getType();
            }
        }
        catch (PathNotFoundException | ConstraintViolationException | NoSuchNodeTypeException e) {
            throw new PreconditionViolatedPersistenceException(e.getMessage(), (Exception)e);
        }
        catch (LockException | VersionException e) {
            throw new TemporaryPersistenceException(e.getMessage(), (Exception)e);
        }
        catch (RepositoryException re) {
            throw new PersistenceException(re.getMessage(), (Throwable)re);
        }
        return null;
    }

    private boolean isWeakReference(int propertyType) {
        return propertyType == 10;
    }

    public Modification storeAsReference(Object n, String name, String[] values, int type, boolean multiValued) throws PersistenceException {
        try {
            Value v;
            Node node = (Node)n;
            if (multiValued) {
                Value[] array = ReferenceParser.parse(node.getSession(), values, this.isWeakReference(type));
                if (array != null) {
                    return Modification.onModified(node.setProperty(name, array).getPath());
                }
            } else if (values.length >= 1 && (v = ReferenceParser.parse(node.getSession(), values[0], this.isWeakReference(type))) != null) {
                return Modification.onModified(node.setProperty(name, v).getPath());
            }
            return null;
        }
        catch (ConstraintViolationException | NoSuchNodeTypeException e) {
            throw new PreconditionViolatedPersistenceException(e.getMessage(), (Exception)e);
        }
        catch (LockException | VersionException e) {
            throw new TemporaryPersistenceException(e.getMessage(), (Exception)e);
        }
        catch (RepositoryException re) {
            throw new PersistenceException(re.getMessage(), (Throwable)re);
        }
    }

    public boolean hasSession(ResourceResolver resolver) {
        return resolver.adaptTo(Session.class) != null;
    }

    public void setTypedProperty(Object n, String name, String[] values, int type, boolean multiValued) throws PersistenceException {
        try {
            if (multiValued) {
                ((Node)n).setProperty(name, values, type);
            } else if (values.length >= 1) {
                ((Node)n).setProperty(name, values[0], type);
            }
        }
        catch (ValueFormatException | ConstraintViolationException e) {
            throw new PreconditionViolatedPersistenceException(e.getMessage(), (Exception)e);
        }
        catch (LockException | VersionException e) {
            throw new TemporaryPersistenceException(e.getMessage(), (Exception)e);
        }
        catch (RepositoryException re) {
            throw new PersistenceException(re.getMessage(), (Throwable)re);
        }
    }

    public Object getNode(Resource rsrc) {
        return rsrc.adaptTo(Node.class);
    }

    public Object getItem(Resource rsrc) {
        return rsrc.adaptTo(Item.class);
    }

    public void setPrimaryNodeType(Object node, String type) throws PersistenceException {
        try {
            ((Node)node).setPrimaryType(type);
        }
        catch (ConstraintViolationException | NoSuchNodeTypeException e) {
            throw new PreconditionViolatedPersistenceException(e.getMessage(), (Exception)e);
        }
        catch (LockException | VersionException e) {
            throw new TemporaryPersistenceException(e.getMessage(), (Exception)e);
        }
        catch (RepositoryException re) {
            throw new PersistenceException(re.getMessage(), (Throwable)re);
        }
    }

    public void move(Object src, Object dstParent, String name) throws PersistenceException {
        try {
            Session session = ((Item)src).getSession();
            Item source = (Item)src;
            String targetParentPath = ((Node)dstParent).getPath();
            String targetPath = (targetParentPath.equals("/") ? "" : targetParentPath) + '/' + name;
            session.move(source.getPath(), targetPath);
        }
        catch (ItemExistsException | PathNotFoundException | ConstraintViolationException e) {
            throw new PreconditionViolatedPersistenceException(e.getMessage(), (Exception)e);
        }
        catch (LockException | VersionException e) {
            throw new TemporaryPersistenceException(e.getMessage(), (Exception)e);
        }
        catch (RepositoryException re) {
            throw new PersistenceException(re.getMessage(), (Throwable)re);
        }
    }

    public String copy(Object src, Object dstParent, String name) throws PersistenceException {
        try {
            Item result = ((Item)src).isNode() ? this.copy((Node)src, (Node)dstParent, name) : this.copy((Property)src, (Node)dstParent, name);
            return result.getPath();
        }
        catch (ConstraintViolationException | NoSuchNodeTypeException e) {
            throw new PreconditionViolatedPersistenceException(e.getMessage(), (Exception)e);
        }
        catch (LockException | VersionException e) {
            throw new TemporaryPersistenceException(e.getMessage(), (Exception)e);
        }
        catch (RepositoryException re) {
            throw new PersistenceException(re.getMessage(), (Throwable)re);
        }
    }

    private Item copy(Node src, Node dstParent, String name) throws RepositoryException {
        if (JCRSupportImpl.isAncestorOrSameNode(src, dstParent)) {
            throw new RepositoryException("Cannot copy ancestor " + src.getPath() + " to descendant " + dstParent.getPath());
        }
        if (name == null) {
            name = src.getName();
        }
        if (dstParent.hasNode(name)) {
            dstParent.getNode(name).remove();
        }
        Node dst = dstParent.addNode(name, src.getPrimaryNodeType().getName());
        for (NodeType mix : src.getMixinNodeTypes()) {
            dst.addMixin(mix.getName());
        }
        PropertyIterator iter = src.getProperties();
        while (iter.hasNext()) {
            this.copy(iter.nextProperty(), dst, (String)null);
        }
        iter = src.getNodes();
        while (iter.hasNext()) {
            Node n = iter.nextNode();
            if (n.getDefinition().isProtected()) continue;
            this.copy(n, dst, (String)null);
        }
        return dst;
    }

    public static boolean isAncestorOrSameNode(Node src, Node dest) throws RepositoryException {
        if (src.getPath().equals("/")) {
            return true;
        }
        if (src.getPath().equals(dest.getPath())) {
            return true;
        }
        return dest.getPath().startsWith(src.getPath() + "/");
    }

    private Item copy(Property src, Node dstParent, String name) throws RepositoryException {
        if (!src.getDefinition().isProtected()) {
            if (name == null) {
                name = src.getName();
            }
            if (dstParent.hasProperty(name)) {
                dstParent.getProperty(name).remove();
            }
            if (src.getDefinition().isMultiple()) {
                return dstParent.setProperty(name, src.getValues());
            }
            return dstParent.setProperty(name, src.getValue());
        }
        return null;
    }
}

