/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.servlets.post.impl;

import java.io.IOException;
import javax.servlet.http.HttpServletResponse;
import org.apache.sling.servlets.post.AbstractPostResponseWrapper;
import org.apache.sling.servlets.post.PostResponse;

public class ErrorHandlingPostResponseWrapper
extends AbstractPostResponseWrapper {
    private final PostResponse wrapped;

    public ErrorHandlingPostResponseWrapper(PostResponse wrapped) {
        this.wrapped = wrapped;
    }

    @Override
    public PostResponse getWrapped() {
        return this.wrapped;
    }

    @Override
    public void send(HttpServletResponse response, boolean setStatus) throws IOException {
        if (!this.isSuccessful()) {
            Throwable error;
            this.prepare(response, setStatus);
            String statusMsg = this.getStatusMessage();
            if (statusMsg == null && (error = this.getError()) != null) {
                statusMsg = error.toString();
            }
            if (statusMsg == null) {
                response.sendError(this.getStatusCode());
            } else {
                response.sendError(this.getStatusCode(), statusMsg);
            }
        } else {
            super.send(response, setStatus);
        }
    }

    private void prepare(HttpServletResponse response, boolean setStatus) {
        if (setStatus) {
            int statusCode = this.getStatusCode();
            response.setStatus(statusCode);
        }
    }
}

