/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.ups.profile.lookup.service.impl;

import com.adobe.cq.ups.integration.service.UpsTokenProviderProxy;
import com.adobe.cq.ups.profile.lookup.service.UpsProfileLookupService;
import com.adobe.granite.crypto.CryptoException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.MissingNode;
import java.io.Closeable;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.time.Duration;
import java.time.Instant;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.osgi.services.HttpClientBuilderFactory;
import org.apache.http.util.EntityUtils;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.commons.json.JSONException;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={UpsProfileLookupService.class})
@Designate(ocd=Configuration.class)
public class UpsProfileLookupServiceImpl
implements UpsProfileLookupService {
    private static final Logger LOG = LoggerFactory.getLogger(UpsProfileLookupServiceImpl.class);
    private static final String UPS_PROFILE_LOOKUP_PATH = "/data/core/ups/access/entities";
    private static final String UPS_REQUEST_CONTENT_TYPE = "application/vnd.api+json";
    @Reference
    private HttpClientBuilderFactory clientBuilderFactory;
    @Reference
    private UpsTokenProviderProxy utpp;
    private String upsEndpointUri;
    private int connectionTimeout;
    private int socketTimeout;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JsonNode getProfile(String entityId, String entityIdNS, String schemaName) {
        String profileData;
        block12: {
            profileData = null;
            if (!this.validateArguments(entityId, entityIdNS, schemaName)) {
                LOG.warn("Empty Arguments found: entityId  {}, entityIdNS {}, schemaName {}", new Object[]{entityId, entityIdNS, schemaName});
                return MissingNode.getInstance();
            }
            CloseableHttpResponse response = null;
            RequestConfig config = RequestConfig.custom().setConnectTimeout(this.connectionTimeout).setConnectionRequestTimeout(this.connectionTimeout).setSocketTimeout(this.socketTimeout).build();
            CloseableHttpClient httpClient = this.clientBuilderFactory.newBuilder().setDefaultRequestConfig(config).build();
            try {
                Instant start = Instant.now();
                response = this.performQuery(httpClient, this.getProfileLookupUri(entityId, entityIdNS, schemaName));
                Instant stop = Instant.now();
                LOG.debug("Profile lookup api call duration: {} miliseconds", (Object)Duration.between(start, stop).toMillis());
                if (response != null) {
                    if (response.getStatusLine().getStatusCode() == 200) {
                        profileData = EntityUtils.toString((HttpEntity)response.getEntity());
                        LOG.debug("Response from profile fetch profileData: {}", (Object)profileData);
                    } else if (response.getStatusLine().getStatusCode() == 404) {
                        LOG.warn("No profile found for {}: {}", (Object)entityId, (Object)response.getStatusLine());
                    } else {
                        LOG.warn("Response from profile fetch is not ok: {}", (Object)response.getStatusLine());
                    }
                } else {
                    LOG.error("Response is null from profile fetch");
                }
                IOUtils.closeQuietly((Closeable)response);
            }
            catch (Exception e) {
                LOG.error("Unable to fetch profile data:", (Throwable)e);
                break block12;
            }
            finally {
                IOUtils.closeQuietly(response);
                IOUtils.closeQuietly((Closeable)httpClient);
            }
            IOUtils.closeQuietly((Closeable)httpClient);
        }
        return this.transformJson(profileData);
    }

    private JsonNode transformJson(String json) {
        MissingNode result = MissingNode.getInstance();
        try {
            JsonNode entireJson;
            if (json != null && (entireJson = new ObjectMapper().readTree(json)) != null) {
                result = entireJson.get((String)entireJson.fieldNames().next());
            }
        }
        catch (IOException e) {
            LOG.error("Unable to process json data:", (Throwable)e);
        }
        return result;
    }

    private URI getProfileLookupUri(String entityId, String entityIdNS, String schemaName) throws URISyntaxException {
        URIBuilder uriBuilder = new URIBuilder(this.upsEndpointUri + UPS_PROFILE_LOOKUP_PATH).addParameter("entityId", entityId).addParameter("entityIdNS", entityIdNS).addParameter("schema.name", schemaName);
        URI uri = uriBuilder.build();
        LOG.debug("URI: {}", (Object)uri.toString());
        return uri;
    }

    private CloseableHttpResponse performQuery(CloseableHttpClient httpClient, URI uri) throws IOException, LoginException, CryptoException, JSONException {
        HttpGet apiRequest = new HttpGet(uri);
        String accessPayloadData = this.utpp.getAccessPayloadData("Adobe Experience Platform");
        if (accessPayloadData == null) {
            LOG.warn("AccessPayloadData from UpsTockenProviderProxy is null, potentially missing IMS configuration");
            return null;
        }
        JsonNode accessPayload = new ObjectMapper().readTree(accessPayloadData);
        LOG.debug("ApiKey: {}, OrgId: {}", (Object)accessPayload.findPath("apikey").asText(), (Object)accessPayload.findPath("org").asText());
        LOG.trace("token: {}", (Object)accessPayload.findPath("token").asText());
        apiRequest.addHeader("Accept", "application/vnd.api+json;revision=1");
        apiRequest.addHeader("Content-Type", UPS_REQUEST_CONTENT_TYPE);
        apiRequest.addHeader("x-api-key", accessPayload.findPath("apikey").asText());
        apiRequest.addHeader("x-gw-ims-org-id", accessPayload.findPath("org").asText());
        apiRequest.addHeader("Authorization", "Bearer " + accessPayload.findPath("token").asText());
        return httpClient.execute((HttpUriRequest)apiRequest);
    }

    private boolean validateArguments(String ... arguments) {
        for (String argument : arguments) {
            if (!StringUtils.isBlank((CharSequence)argument)) continue;
            return false;
        }
        return true;
    }

    @Activate
    protected void activate(Configuration configuration) {
        this.upsEndpointUri = configuration.upsEndpointUri();
        this.connectionTimeout = configuration.connectionTimeout() >= 0 ? configuration.connectionTimeout() : 10000;
        this.socketTimeout = configuration.socketTimeout() >= 0 ? configuration.socketTimeout() : 5000;
    }

    @ObjectClassDefinition(name="Unified Profile Lookup Service (UPS)", description="Configuration for the service performing lookup request to Unified Profile Service (UPS)")
    public static @interface Configuration {
        @AttributeDefinition(name="Unified Profile Service API endpoint URI", description="Default is https://platform.adobe.io")
        public String upsEndpointUri() default "https://platform.adobe.io";

        @AttributeDefinition(name="Unified Profile Service Connection Timeout in milliseconds", description="Default is 10000")
        public int connectionTimeout() default 10000;

        @AttributeDefinition(name="Unified Profile Service API Socket Timeout in milliseconds", description="Default is 5000")
        public int socketTimeout() default 5000;
    }
}

