/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.ups.profile.lookup.internal;

import com.adobe.granite.toggle.api.ToggleRouter;
import com.google.common.net.MediaType;
import java.io.IOException;
import java.io.Writer;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.servlet.Servlet;
import org.apache.jackrabbit.api.security.user.Authorizable;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.servlets.SlingSafeMethodsServlet;
import org.apache.sling.commons.json.JSONException;
import org.apache.sling.commons.json.io.JSONWriter;
import org.apache.sling.servlets.annotations.SlingServletResourceTypes;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferencePolicyOption;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={Servlet.class})
@SlingServletResourceTypes(resourceTypes={"/apps/cq/ups/user-fetch"}, methods={"GET"}, extensions={"json"})
public class UpsUserFetchServlet
extends SlingSafeMethodsServlet {
    @Reference(policyOption=ReferencePolicyOption.GREEDY)
    private transient ToggleRouter toggleRouter;
    private static final Logger LOG = LoggerFactory.getLogger(UpsUserFetchServlet.class);
    private static final String UUID = "uuid";

    public void doGet(SlingHttpServletRequest request, SlingHttpServletResponse response) throws IOException {
        if (this.toggleRouter.isEnabled("CQ-4280691_aem_unified_profile_integration")) {
            ResourceResolver resolver = request.getResourceResolver();
            response.setContentType(String.valueOf(MediaType.JSON_UTF_8));
            try {
                JSONWriter writer;
                Authorizable authorizable = (Authorizable)resolver.adaptTo(Authorizable.class);
                if (authorizable != null) {
                    Session userSession = (Session)resolver.adaptTo(Session.class);
                    Node userNode = userSession != null ? userSession.getNode(authorizable.getPath()) : null;
                    writer = new JSONWriter((Writer)response.getWriter());
                    writer.object();
                    if (userNode != null && userNode.hasProperty("{http://www.jcp.org/jcr/1.0}uuid")) {
                        writer.key(UUID);
                        writer.value((Object)userNode.getProperty("{http://www.jcp.org/jcr/1.0}uuid").getString());
                    }
                } else {
                    String msg = "No valid authorizable at requested path";
                    LOG.error(msg);
                    throw new IOException(msg);
                }
                writer.endObject();
            }
            catch (RepositoryException | JSONException e) {
                LOG.error("Unable to fetch user data");
                throw new IOException(e);
            }
        } else {
            String msg = "UPS Feature is disabled. Couldn't fetch user";
            LOG.error(msg);
            response.sendError(404, msg);
        }
    }
}

