/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.ups.profile.lookup.internal;

import com.adobe.cq.ups.profile.lookup.service.UpsProfileLookupService;
import com.adobe.granite.toggle.api.ToggleRouter;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.MissingNode;
import java.io.IOException;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.servlet.Servlet;
import org.apache.jackrabbit.api.security.user.Authorizable;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.servlets.SlingSafeMethodsServlet;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferencePolicyOption;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={Servlet.class}, property={"sling.servlet.paths=/apps/cq/ups/profile-lookup", "sling.servlet.methods=GET", "sling.servlet.extensions=json"})
public class UpsProfileLookupServlet
extends SlingSafeMethodsServlet {
    private static final long serialVersionUID = -7024659228710210443L;
    private static final Logger LOG = LoggerFactory.getLogger(UpsProfileLookupServlet.class);
    private static final String XDM_PROFILE_SCHEMA_NAME = "_xdm.context.profile";
    private static final String USER_ID = "UserId";
    @Reference
    private transient UpsProfileLookupService upsProfileLookupService;
    @Reference(policyOption=ReferencePolicyOption.GREEDY)
    private ToggleRouter toggleRouter;

    private Boolean isAuthenticated(SlingHttpServletRequest request) {
        ResourceResolver resourceResolver = request.getResourceResolver();
        String userID = resourceResolver.getUserID();
        return request.getAuthType() != null && userID != null;
    }

    private String getUUID(SlingHttpServletRequest request) {
        try {
            ResourceResolver resolver = request.getResourceResolver();
            Session session = (Session)resolver.adaptTo(Session.class);
            Authorizable auth = (Authorizable)resolver.adaptTo(Authorizable.class);
            Node node = session.getNode(auth.getPath());
            return node.getProperty("{http://www.jcp.org/jcr/1.0}uuid").getString();
        }
        catch (PathNotFoundException e) {
            LOG.error("Unexpected error:", (Throwable)e);
            return null;
        }
        catch (RepositoryException e) {
            LOG.error("Unexpected error:", (Throwable)e);
            return null;
        }
    }

    public void doGet(SlingHttpServletRequest request, SlingHttpServletResponse response) throws IOException {
        String json = "{}";
        if (this.toggleRouter.isEnabled("CQ-4280691_aem_unified_profile_integration")) {
            int statusCode;
            if (this.isAuthenticated(request).booleanValue()) {
                JsonNode profileData;
                String entityId = this.getUUID(request);
                statusCode = 404;
                LOG.debug("Profile lookup for entity Id: {}", (Object)entityId);
                if (entityId != null && !((profileData = this.upsProfileLookupService.getProfile(entityId, USER_ID, XDM_PROFILE_SCHEMA_NAME)) instanceof MissingNode)) {
                    statusCode = 200;
                    json = profileData.toString();
                }
            } else {
                statusCode = 401;
                LOG.debug("User has to be logged in to perform UPS Lookup");
            }
            try {
                response.setHeader("Content-Type", "application/json; charset=utf-8");
                response.setContentLength(json.getBytes("utf-8").length);
                response.setStatus(statusCode);
                response.getWriter().print(json);
            }
            catch (IOException e) {
                LOG.error("Unexpected error:", (Throwable)e);
            }
        } else {
            String msg = "UPS Feature is disabled. Couldn't fetch profile";
            LOG.error(msg);
            response.sendError(404, msg);
            return;
        }
    }
}

