/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.ups.integration.service.impl.servlets;

import com.adobe.cq.ups.integration.service.UpsTokenProviderProxy;
import com.adobe.granite.toggle.api.ToggleRouter;
import com.adobe.granite.ui.components.ds.DataSource;
import com.adobe.granite.ui.components.ds.SimpleDataSource;
import com.adobe.granite.ui.components.ds.ValueMapResource;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.servlet.Servlet;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.api.servlets.SlingAllMethodsServlet;
import org.apache.sling.api.wrappers.ValueMapDecorator;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferencePolicyOption;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={Servlet.class}, property={"sling.servlet.methods=GET", "sling.servlet.resourceTypes=cq/ups/components/admin/datasources/tokenproviders"})
public class TokenProvidersDataSource
extends SlingAllMethodsServlet {
    static final String TOKEN_PROVIDERS_RT = "cq/ups/components/admin/datasources/tokenproviders";
    @Reference
    private transient UpsTokenProviderProxy tokenProviderProxy;
    @Reference(policyOption=ReferencePolicyOption.GREEDY)
    private ToggleRouter toggleRouter;
    private transient Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());

    protected void doGet(SlingHttpServletRequest request, SlingHttpServletResponse response) {
        if (this.toggleRouter.isEnabled("CQ-4280691_aem_unified_profile_integration")) {
            ArrayList<ValueMapResource> resourceList = new ArrayList<ValueMapResource>();
            Set<Map<String, String>> tokenProvidersInfo = this.tokenProviderProxy.getTokenProvidersInfo();
            for (Map<String, String> info : tokenProvidersInfo) {
                ValueMapDecorator vm = new ValueMapDecorator(new HashMap());
                vm.put((Object)"value", (Object)info.get("name"));
                vm.put((Object)"text", (Object)info.get("title"));
                resourceList.add(new ValueMapResource(request.getResourceResolver(), "", "", (ValueMap)vm));
            }
            request.setAttribute(DataSource.class.getName(), (Object)new SimpleDataSource(resourceList.iterator()));
        } else {
            this.logger.error("UPS Feature is disabled. Couldn't provide access token");
        }
    }
}

