/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.ups.integration.service.impl.servlets;

import com.adobe.cq.ups.integration.service.PlatformService;
import com.adobe.cq.ups.integration.service.PlatformServiceException;
import com.adobe.cq.ups.integration.service.UpsTokenProviderProxy;
import com.adobe.granite.crypto.CryptoException;
import com.adobe.granite.toggle.api.ToggleRouter;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import javax.servlet.Servlet;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.api.servlets.SlingAllMethodsServlet;
import org.apache.sling.commons.json.JSONException;
import org.apache.sling.commons.json.JSONObject;
import org.apache.sling.commons.json.io.JSONWriter;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferencePolicyOption;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={Servlet.class}, property={"sling.servlet.methods=GET", "sling.servlet.resourceTypes=cq/ups/components/admin/datasources/schemas"})
public class SchemaDataSource
extends SlingAllMethodsServlet {
    static final String SCHEMAS_RT = "cq/ups/components/admin/datasources/schemas";
    static final String PARAM_IMS_CONFIG_ID = "imsConfigurationId";
    @Reference
    private transient PlatformService upsService;
    @Reference
    private transient UpsTokenProviderProxy tokenProviderProxy;
    @Reference(policyOption=ReferencePolicyOption.GREEDY)
    private ToggleRouter toggleRouter;
    private transient Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());

    protected void doGet(SlingHttpServletRequest request, SlingHttpServletResponse response) throws IOException {
        if (!this.toggleRouter.isEnabled("CQ-4280691_aem_unified_profile_integration")) {
            String msg = "UPS Feature is disabled. Can't provide Schema List";
            this.logger.error(msg);
            response.sendError(404, msg);
            return;
        }
        response.setContentType("text/html");
        String imsConfigurationId = request.getParameter(PARAM_IMS_CONFIG_ID);
        if (StringUtils.isBlank((CharSequence)imsConfigurationId)) {
            String msg = String.format("Invalid request parameter [imsConfigurationId=%s]", imsConfigurationId);
            this.logger.error(msg);
            response.sendError(400, msg);
            return;
        }
        String token = null;
        String apiKey = null;
        String orgId = null;
        try {
            JSONObject accessPayload = new JSONObject(this.tokenProviderProxy.getAccessPayloadData(imsConfigurationId));
            token = accessPayload.get("token").toString();
            apiKey = accessPayload.get("apikey").toString();
            orgId = accessPayload.get("org").toString();
        }
        catch (CryptoException | LoginException | JSONException e) {
            this.logger.error(String.format("Unable to obtain a valid access token for configuration [%s]", imsConfigurationId), e);
            response.sendError(500, "Unable to obtain a valid access token");
            return;
        }
        if (StringUtils.isBlank((CharSequence)token)) {
            String msg = String.format("Invalid access token [%s]", token);
            this.logger.error(msg);
            response.sendError(500, msg);
            return;
        }
        try {
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("Authorization", "Bearer " + token);
            headers.put("x-api-key", apiKey);
            headers.put("x-gw-ims-org-id", orgId);
            JsonNode results = this.upsService.getUnionList(headers, null);
            if (results != null) {
                JSONWriter resultsJson = new JSONWriter((Writer)response.getWriter());
                resultsJson.setTidy(true);
                resultsJson.array();
                JsonNode schemaList = results.get("results");
                for (JsonNode schema : schemaList) {
                    String schemaId = schema.get("meta:altId").asText();
                    schemaId = schemaId.substring(0, schemaId.indexOf("__union"));
                    String schemaName = schema.get("title").asText();
                    resultsJson.object();
                    resultsJson.key("value").value((Object)schemaId);
                    resultsJson.key("content").value((Object)schemaName);
                    resultsJson.endObject();
                }
                resultsJson.endArray();
            }
        }
        catch (PlatformServiceException | IllegalArgumentException | JSONException e) {
            this.logger.error("Unable to retrieve schemas from Adobe Experience Platform", e);
            response.sendError(500, "Unable to retrieve schemas from Adobe Experience Platform");
        }
    }
}

