/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.ups.integration.service.impl;

import com.adobe.cq.ups.integration.service.UpsSchemaFetch;
import com.adobe.cq.ups.integration.service.UpsTokenProviderProxy;
import com.adobe.cq.ups.integration.service.XdmSchema;
import com.adobe.granite.crypto.CryptoException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.json.Json;
import javax.json.JsonReader;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.commons.json.JSONException;
import org.apache.sling.xss.XSSAPI;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={UpsSchemaFetch.class})
@Designate(ocd=Configuration.class)
public class UpsSchemaFetchImpl
implements UpsSchemaFetch {
    private static final Logger LOG = LoggerFactory.getLogger(UpsSchemaFetchImpl.class);
    private static final String INVALID_ACCESS_PAYLOAD = "Invalid access payload : ";
    private final CloseableHttpClient httpClient = HttpClients.createDefault();
    private String upsEndpointUri;
    private int connectionTimeout;
    private int socketTimeout;
    @Reference
    private UpsTokenProviderProxy upsTokenProviderProxy;
    @Reference
    private XSSAPI xssAPI;

    @Override
    public XdmSchema fetchSchema(@Nonnull String schemaName, String schemaVersion) throws IOException {
        String url = this.xssAPI.getValidHref(this.upsEndpointUri + "/data/foundation/schemaregistry/tenant" + "/schemas" + "/" + schemaName);
        HashMap<String, String> headers = new HashMap<String, String>();
        String version = StringUtils.isEmpty((CharSequence)schemaVersion) ? "1" : schemaVersion;
        try {
            String accessPayloadData = this.upsTokenProviderProxy.getAccessPayloadData("Adobe Experience Platform");
            JsonNode accessPayload = new ObjectMapper().readTree(accessPayloadData);
            if (Boolean.FALSE.equals(this.validateAccessPayload(accessPayload, new String[]{"token", "apikey", "org"}))) {
                return null;
            }
            headers.put("Accept", "application/vnd.adobe.xed-full+json;version=" + version);
            headers.put("Cache-Control", "no-cache");
            headers.put("Authorization", "Bearer " + accessPayload.findPath("token").asText());
            headers.put("x-api-key", accessPayload.findPath("apikey").asText());
            headers.put("x-gw-ims-org-id", accessPayload.findPath("org").asText());
            XdmSchema schemaObj = new XdmSchema();
            String schemaResponse = this.executeGet(url, headers);
            if (schemaResponse != null) {
                try (JsonReader jsonReader = Json.createReader((Reader)new StringReader(schemaResponse));){
                    schemaObj.setXdmSchemaObj(jsonReader.readObject());
                }
                return schemaObj;
            }
            LOG.warn("Unable to fetch schema");
            return null;
        }
        catch (CryptoException | IOException | LoginException | JSONException e) {
            LOG.error(String.format("[%s]", "Unable to fetch schema"));
            throw new IOException(e);
        }
    }

    private Boolean validateAccessPayload(JsonNode accessPayload, String[] keys) {
        ArrayList<String> invalidKeys = new ArrayList<String>();
        for (String key : keys) {
            if (!accessPayload.findPath(key).isMissingNode()) continue;
            LOG.error(String.format("[%s] [%s]", INVALID_ACCESS_PAYLOAD, key));
            invalidKeys.add(key);
        }
        return invalidKeys.isEmpty();
    }

    String executeGet(String url, Map<String, String> headers) throws IOException {
        HttpGet request = new HttpGet(url);
        for (Map.Entry<String, String> entry : headers.entrySet()) {
            request.addHeader(entry.getKey(), entry.getValue());
        }
        CloseableHttpResponse response = this.httpClient.execute((HttpUriRequest)request);
        return EntityUtils.toString((HttpEntity)response.getEntity());
    }

    @Activate
    protected void activate(Configuration configuration) {
        this.upsEndpointUri = configuration.upsEndpointUri();
        this.connectionTimeout = configuration.connectionTimeout() >= 0 ? configuration.connectionTimeout() : 10000;
        this.socketTimeout = configuration.socketTimeout() >= 0 ? configuration.socketTimeout() : 5000;
    }

    @ObjectClassDefinition(name="Adobe Experience Platform Schema Service (UPS)", description="Configuration for the service performing schema request")
    public static @interface Configuration {
        @AttributeDefinition(name="Adobe Experience Platform API endpoint URI", description="Default is https://platform.adobe.io")
        public String upsEndpointUri() default "https://platform.adobe.io";

        @AttributeDefinition(name="Unified Profile Service Connection Timeout in milliseconds", description="Default is 10000")
        public int connectionTimeout() default 10000;

        @AttributeDefinition(name="Unified Profile Service API Socket Timeout in milliseconds", description="Default is 5000")
        public int socketTimeout() default 5000;
    }
}

