/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.unifiedshell.impl.config;

import java.io.IOException;
import javax.jcr.Node;
import javax.servlet.Servlet;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.request.RequestParameter;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.api.servlets.SlingAllMethodsServlet;
import org.jetbrains.annotations.NotNull;
import org.osgi.service.component.annotations.Component;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, service={Servlet.class}, property={"sling.servlet.methods=POST", "sling.servlet.paths=/bin/unifiedshell/config", "sling.servlet.extensions=json"})
public class ShellConfigServlet
extends SlingAllMethodsServlet {
    private static final Logger LOG = LoggerFactory.getLogger((String)ShellConfigServlet.class.getName());
    public static final String SHELL_CONFIG_PATH = "/conf/global/settings/unifiedshell";
    public static final String SHELL_CONFIG_PROP_ENABLE = "enable";
    private static final String NT_SLING_FOLDER = "sling:Folder";
    private static final String SHELL_ENABLE_PARAMETER = "enabled";
    private static final String HEADER_CONTENT_TYPE = "Content-Type";
    private static final String APPLICATION_JSON = "application/json";

    public void doPost(@NotNull SlingHttpServletRequest request, @NotNull SlingHttpServletResponse response) throws IOException {
        try {
            RequestParameter shellEnabledParam = request.getRequestParameter(SHELL_ENABLE_PARAMETER);
            boolean shellEnabled = shellEnabledParam != null ? Boolean.parseBoolean(shellEnabledParam.getString()) : false;
            ResourceResolver resolver = request.getResourceResolver();
            Resource configResource = ResourceUtil.getOrCreateResource((ResourceResolver)resolver, (String)SHELL_CONFIG_PATH, (String)NT_SLING_FOLDER, (String)NT_SLING_FOLDER, (boolean)false);
            Node configResourceNode = (Node)configResource.adaptTo(Node.class);
            configResourceNode.setProperty(SHELL_CONFIG_PROP_ENABLE, shellEnabled);
            resolver.commit();
            response.setHeader(HEADER_CONTENT_TYPE, APPLICATION_JSON);
            response.setStatus(200);
            response.getWriter().write("{\"success\": true}");
        }
        catch (Exception ex) {
            LOG.error("Cannot write to unified shell config", (Object)ex.getMessage());
            response.setHeader(HEADER_CONTENT_TYPE, APPLICATION_JSON);
            response.setStatus(400);
            response.getWriter().write("{\"success\": false}");
        }
    }
}

