/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.stock.models;

import com.adobe.stock.enums.AssetLicenseState;
import com.adobe.stock.enums.AssetPremiumLevel;
import com.adobe.stock.enums.AssetTemplateCategory;
import com.adobe.stock.enums.AssetTemplatesType;
import com.adobe.stock.enums.AssetType;
import com.adobe.stock.exception.StockException;
import com.adobe.stock.models.StockFileCategory;
import com.adobe.stock.models.StockFileComps;
import com.adobe.stock.models.StockFileKeyword;
import com.adobe.stock.models.StockFileLicenses;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.JsonNode;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;

@JsonIgnoreProperties(ignoreUnknown=true)
public final class StockFile {
    private Integer mId;
    private String mTitle;
    private Integer mCreatorId;
    private String mCreatorName;
    private Date mCreationDate;
    private String mCountryName;
    private String mThumbnailUrl;
    private String mThumbnailHtmlTag;
    private Integer mThumbnailWidth;
    private Integer mThumbnailHeight;
    private String mThumbnail110Url;
    private Double mThumbnail110Width;
    private Integer mThumbnail110Height;
    private String mThumbnail160Url;
    private Double mThumbnail160Width;
    private Integer mThumbnail160Height;
    private String mThumbnail220Url;
    private Double mThumbnail220Width;
    private Integer mThumbnail220Height;
    private String mThumbnail240Url;
    private Double mThumbnail240Width;
    private Integer mThumbnail240Height;
    private String mThumbnail500Url;
    private Double mThumbnail500Width;
    private Integer mThumbnail500Height;
    private String mThumbnail1000Url;
    private Double mThumbnail1000Width;
    private Integer mThumbnail1000Height;
    private Integer mWidth;
    private Integer mHeight;
    private AssetLicenseState mIsLicensed;
    private String mCompUrl;
    private Integer mCompWidth;
    private Integer mCompHeight;
    private Integer mNbViews;
    private Integer mNbDownloads;
    private StockFileCategory mCategory;
    private ArrayList<StockFileKeyword> mKeywords;
    private Boolean mHasReleases;
    private AssetType mAssetTypeId;
    private String mVectorType;
    private String mContentType;
    private Double mFrameRate;
    private Integer mDuration;
    private String mStockId;
    private StockFileComps mComps;
    private String mDetailsUrl;
    private AssetTemplatesType mTemplateTypeId;
    private ArrayList<AssetTemplateCategory> mTemplateCategoryIds;
    private String mMarketingText;
    private String mDescription;
    private Integer mSizeBytes;
    private AssetPremiumLevel mPremiumLevelId;
    private Boolean mIsPremium;
    private Boolean mIsEditorial;
    private StockFileLicenses mLicenses;
    private String mVideoPreviewUrl;
    private Integer mVideoPreviewHeight;
    private Integer mVideoPreviewWidth;
    private Integer mVideoPreviewContentLength;
    private String mVideoPreviewContentType;
    private String mVideoSmallPreviewUrl;
    private Integer mVideoSmallPreviewHeight;
    private Integer mVideoSmallPreviewWidth;
    private Integer mVideoSmallPreviewContentLength;
    private String mVideoSmallPreviewContentType;

    public Integer getId() {
        return this.mId;
    }

    public String getTitle() {
        return this.mTitle;
    }

    public Integer getCreatorId() {
        return this.mCreatorId;
    }

    public String getCreatorName() {
        return this.mCreatorName;
    }

    public Date getCreationDate() {
        return this.mCreationDate;
    }

    public String getCountryName() {
        return this.mCountryName;
    }

    public String getThumbnailUrl() {
        return this.mThumbnailUrl;
    }

    public String getThumbnailHtmlTag() {
        return this.mThumbnailHtmlTag;
    }

    public Integer getThumbnailWidth() {
        return this.mThumbnailWidth;
    }

    public Integer getThumbnailHeight() {
        return this.mThumbnailHeight;
    }

    public String getThumbnail110Url() {
        return this.mThumbnail110Url;
    }

    public Double getThumbnail110Width() {
        return this.mThumbnail110Width;
    }

    public Integer getThumbnail110Height() {
        return this.mThumbnail110Height;
    }

    public String getThumbnail160Url() {
        return this.mThumbnail160Url;
    }

    public Double getThumbnail160Width() {
        return this.mThumbnail160Width;
    }

    public Integer getThumbnail160Height() {
        return this.mThumbnail160Height;
    }

    public String getThumbnail220Url() {
        return this.mThumbnail220Url;
    }

    public Double getThumbnail220Width() {
        return this.mThumbnail220Width;
    }

    public Integer getThumbnail220Height() {
        return this.mThumbnail220Height;
    }

    public String getThumbnail240Url() {
        return this.mThumbnail240Url;
    }

    public Double getThumbnail240Width() {
        return this.mThumbnail240Width;
    }

    public Integer getThumbnail240Height() {
        return this.mThumbnail240Height;
    }

    public String getThumbnail500Url() {
        return this.mThumbnail500Url;
    }

    public Double getThumbnail500Width() {
        return this.mThumbnail500Width;
    }

    public Integer getThumbnail500Height() {
        return this.mThumbnail500Height;
    }

    public String getThumbnail1000Url() {
        return this.mThumbnail1000Url;
    }

    public Double getThumbnail1000Width() {
        return this.mThumbnail1000Width;
    }

    public Integer getThumbnail1000Height() {
        return this.mThumbnail1000Height;
    }

    public Integer getWidth() {
        return this.mWidth;
    }

    public Integer getHeight() {
        return this.mHeight;
    }

    public AssetLicenseState getIsLicensed() {
        return this.mIsLicensed;
    }

    public String getCompUrl() {
        return this.mCompUrl;
    }

    public Integer getCompWidth() {
        return this.mCompWidth;
    }

    public Integer getCompHeight() {
        return this.mCompHeight;
    }

    public Integer getNbViews() {
        return this.mNbViews;
    }

    public Integer getNbDownloads() {
        return this.mNbDownloads;
    }

    public StockFileCategory getCategory() {
        return this.mCategory;
    }

    public ArrayList<StockFileKeyword> getKeywords() {
        return this.mKeywords;
    }

    public Boolean getHasReleases() {
        return this.mHasReleases;
    }

    public AssetType getAssetTypeId() {
        return this.mAssetTypeId;
    }

    public String getVectorType() {
        return this.mVectorType;
    }

    public String getContentType() {
        return this.mContentType;
    }

    public Double getFrameRate() {
        return this.mFrameRate;
    }

    public Integer getDuration() {
        return this.mDuration;
    }

    public String getStockId() {
        return this.mStockId;
    }

    public StockFileComps getComps() {
        return this.mComps;
    }

    public String getDetailsUrl() {
        return this.mDetailsUrl;
    }

    public AssetTemplatesType getTemplateTypeId() {
        return this.mTemplateTypeId;
    }

    public ArrayList<AssetTemplateCategory> getTemplateCategoryIds() {
        return this.mTemplateCategoryIds;
    }

    public String getMarketingText() {
        return this.mMarketingText;
    }

    public String getDescription() {
        return this.mDescription;
    }

    public Integer getSizeBytes() {
        return this.mSizeBytes;
    }

    public AssetPremiumLevel getPremiumLevelId() {
        return this.mPremiumLevelId;
    }

    public Boolean getIsPremium() {
        return this.mIsPremium;
    }

    public Boolean getIsEditorial() {
        return this.mIsEditorial;
    }

    public StockFileLicenses getLicenses() {
        return this.mLicenses;
    }

    public String getVideoPreviewUrl() {
        return this.mVideoPreviewUrl;
    }

    public Integer getVideoPreviewHeight() {
        return this.mVideoPreviewHeight;
    }

    public Integer getVideoPreviewWidth() {
        return this.mVideoPreviewWidth;
    }

    public Integer getVideoPreviewContentLength() {
        return this.mVideoPreviewContentLength;
    }

    public String getVideoPreviewContentType() {
        return this.mVideoPreviewContentType;
    }

    public String getVideoSmallPreviewUrl() {
        return this.mVideoSmallPreviewUrl;
    }

    public Integer getVideoSmallPreviewHeight() {
        return this.mVideoSmallPreviewHeight;
    }

    public Integer getVideoSmallPreviewWidth() {
        return this.mVideoSmallPreviewWidth;
    }

    public Integer getVideoSmallPreviewContentLength() {
        return this.mVideoSmallPreviewContentLength;
    }

    public String getVideoSmallPreviewContentType() {
        return this.mVideoSmallPreviewContentType;
    }

    @JsonSetter(value="id")
    public void setId(Integer id) {
        this.mId = id;
    }

    @JsonSetter(value="title")
    public void setTitle(String title) {
        this.mTitle = title;
    }

    @JsonSetter(value="creator_id")
    public void setCreatorId(Integer creatorId) {
        this.mCreatorId = creatorId;
    }

    @JsonSetter(value="creator_name")
    public void setCreatorName(String creatorName) {
        this.mCreatorName = creatorName;
    }

    @JsonSetter(value="creation_date")
    public void setCreationDate(String creationDate) throws StockException {
        String formatString = "yyyy-MM-dd hh:mm:ss";
        SimpleDateFormat format = new SimpleDateFormat(formatString + ".SSS");
        SimpleDateFormat formatWithoutMS = new SimpleDateFormat(formatString);
        try {
            this.mCreationDate = creationDate.length() <= formatString.length() ? formatWithoutMS.parse(creationDate) : format.parse(creationDate);
        }
        catch (ParseException e) {
            throw new StockException("Could not parse date string");
        }
    }

    @JsonSetter(value="country_name")
    public void setCountryName(String countryName) {
        this.mCountryName = countryName;
    }

    @JsonSetter(value="thumbnail_url")
    public void setThumbnailUrl(String thumbnailUrl) {
        this.mThumbnailUrl = thumbnailUrl;
    }

    @JsonSetter(value="thumbnail_html_tag")
    public void setThumbnailHtmlTag(String thumbnailHtmlTag) {
        this.mThumbnailHtmlTag = thumbnailHtmlTag;
    }

    @JsonSetter(value="thumbnail_width")
    public void setThumbnailWidth(Integer thumbnailWidth) {
        this.mThumbnailWidth = thumbnailWidth;
    }

    @JsonSetter(value="thumbnail_height")
    public void setThumbnailHeight(Integer thumbnailHeight) {
        this.mThumbnailHeight = thumbnailHeight;
    }

    @JsonSetter(value="thumbnail_110_url")
    public void setThumbnail110Url(String thumbnail110Url) {
        this.mThumbnail110Url = thumbnail110Url;
    }

    @JsonSetter(value="thumbnail_110_width")
    public void setThumbnail110Width(Double thumbnail110Width) {
        this.mThumbnail110Width = thumbnail110Width;
    }

    @JsonSetter(value="thumbnail_110_height")
    public void setThumbnail110Height(Integer thumbnail110Height) {
        this.mThumbnail110Height = thumbnail110Height;
    }

    @JsonSetter(value="thumbnail_160_url")
    public void setThumbnail160Url(String thumbnail160Url) {
        this.mThumbnail160Url = thumbnail160Url;
    }

    @JsonSetter(value="thumbnail_160_width")
    public void setThumbnail160Width(Double thumbnail160Width) {
        this.mThumbnail160Width = thumbnail160Width;
    }

    @JsonSetter(value="thumbnail_160_height")
    public void setThumbnail160Height(Integer thumbnail160Height) {
        this.mThumbnail160Height = thumbnail160Height;
    }

    @JsonSetter(value="thumbnail_220_url")
    public void setThumbnail220Url(String thumbnail220Url) {
        this.mThumbnail220Url = thumbnail220Url;
    }

    @JsonSetter(value="thumbnail_220_width")
    public void setThumbnail220Width(Double thumbnail220Width) {
        this.mThumbnail220Width = thumbnail220Width;
    }

    @JsonSetter(value="thumbnail_220_height")
    public void setThumbnail220Height(Integer thumbnail220Height) {
        this.mThumbnail220Height = thumbnail220Height;
    }

    @JsonSetter(value="thumbnail_240_url")
    public void setThumbnail240Url(String thumbnail240Url) {
        this.mThumbnail240Url = thumbnail240Url;
    }

    @JsonSetter(value="thumbnail_240_width")
    public void setThumbnail240Width(Double thumbnail240Width) {
        this.mThumbnail240Width = thumbnail240Width;
    }

    @JsonSetter(value="thumbnail_240_height")
    public void setThumbnail240Height(Integer thumbnail240Height) {
        this.mThumbnail240Height = thumbnail240Height;
    }

    @JsonSetter(value="thumbnail_500_url")
    public void setThumbnail500Url(String thumbnail500Url) {
        this.mThumbnail500Url = thumbnail500Url;
    }

    @JsonSetter(value="thumbnail_500_width")
    public void setThumbnail500Width(Double thumbnail500Width) {
        this.mThumbnail500Width = thumbnail500Width;
    }

    @JsonSetter(value="thumbnail_500_height")
    public void setThumbnail500Height(Integer thumbnail500Height) {
        this.mThumbnail500Height = thumbnail500Height;
    }

    @JsonSetter(value="thumbnail_1000_url")
    public void setThumbnail1000Url(String thumbnail1000Url) {
        this.mThumbnail1000Url = thumbnail1000Url;
    }

    @JsonSetter(value="thumbnail_1000_width")
    public void setThumbnail1000Width(Double thumbnail1000Width) {
        this.mThumbnail1000Width = thumbnail1000Width;
    }

    @JsonSetter(value="thumbnail_1000_height")
    public void setThumbnail1000Height(Integer thumbnail1000Height) {
        this.mThumbnail1000Height = thumbnail1000Height;
    }

    @JsonSetter(value="width")
    public void setWidth(Integer width) {
        this.mWidth = width;
    }

    @JsonSetter(value="height")
    public void setHeight(Integer height) {
        this.mHeight = height;
    }

    @JsonSetter(value="is_licensed")
    public void setIsLicensed(AssetLicenseState isLicensed) {
        this.mIsLicensed = isLicensed;
    }

    @JsonSetter(value="comp_url")
    public void setCompUrl(String compUrl) {
        this.mCompUrl = compUrl;
    }

    @JsonSetter(value="comp_width")
    public void setCompWidth(Integer compWidth) {
        this.mCompWidth = compWidth;
    }

    @JsonSetter(value="comp_height")
    public void setCompHeight(Integer compHeight) {
        this.mCompHeight = compHeight;
    }

    @JsonSetter(value="nb_views")
    public void setNbViews(Integer nbViews) {
        this.mNbViews = nbViews;
    }

    @JsonSetter(value="nb_downloads")
    public void setNbDownloads(Integer nbDownloads) {
        this.mNbDownloads = nbDownloads;
    }

    @JsonSetter(value="category")
    public void setCategory(JsonNode node) {
        if (node != null && node.isObject()) {
            Integer id = node.get("id").intValue();
            String name = node.get("name").asText();
            this.mCategory = new StockFileCategory(id, name);
        }
    }

    @JsonSetter(value="keywords")
    public void setKeywords(ArrayList<StockFileKeyword> keywords) {
        this.mKeywords = keywords;
    }

    @JsonSetter(value="has_releases")
    public void setHasReleases(Boolean hasReleases) {
        this.mHasReleases = hasReleases;
    }

    @JsonSetter(value="media_type_id")
    public void setAssetTypeId(AssetType assetType) {
        this.mAssetTypeId = assetType;
    }

    @JsonSetter(value="vector_type")
    public void setVectorType(String vectorType) {
        this.mVectorType = vectorType;
    }

    @JsonSetter(value="content_type")
    public void setContentType(String contentType) {
        this.mContentType = contentType;
    }

    @JsonSetter(value="framerate")
    public void setFrameRate(Double frameRate) {
        this.mFrameRate = frameRate;
    }

    @JsonSetter(value="duration")
    public void setDuration(Integer duration) {
        this.mDuration = duration;
    }

    @JsonSetter(value="stock_id")
    public void setStockId(String stockId) {
        this.mStockId = stockId;
    }

    @JsonSetter(value="comps")
    public void setComps(StockFileComps comps) {
        this.mComps = comps;
    }

    @JsonSetter(value="details_url")
    public void setDetailsUrl(String detailsUrl) {
        this.mDetailsUrl = detailsUrl;
    }

    @JsonSetter(value="template_type_id")
    public void setTemplateTypeId(AssetTemplatesType templateTypeId) {
        this.mTemplateTypeId = templateTypeId;
    }

    @JsonSetter(value="template_category_ids")
    public void setTemplateCategoryIds(ArrayList<AssetTemplateCategory> templateCategoryIds) {
        this.mTemplateCategoryIds = templateCategoryIds;
    }

    @JsonSetter(value="marketing_text")
    public void setMarketingText(String marketingText) {
        this.mMarketingText = marketingText;
    }

    @JsonSetter(value="description")
    public void setDescription(String description) {
        this.mDescription = description;
    }

    @JsonSetter(value="size_bytes")
    public void setSizeBytes(Integer sizeBytes) {
        this.mSizeBytes = sizeBytes;
    }

    @JsonSetter(value="premium_level_id")
    public void setPremiumLevelId(AssetPremiumLevel premiumLevelId) {
        this.mPremiumLevelId = premiumLevelId;
    }

    @JsonSetter(value="is_premium")
    public void setIsPremium(Boolean isPremium) {
        this.mIsPremium = isPremium;
    }

    @JsonSetter(value="is_editorial")
    public void setIsEditorial(Boolean isEditorial) {
        this.mIsEditorial = isEditorial;
    }

    @JsonSetter(value="licenses")
    public void setLicenses(StockFileLicenses licenses) {
        this.mLicenses = licenses;
    }

    @JsonSetter(value="video_preview_url")
    public void setVideoPreviewUrl(String videoPreviewUrl) {
        this.mVideoPreviewUrl = videoPreviewUrl;
    }

    @JsonSetter(value="video_preview_height")
    public void setVideoPreviewHeight(Integer videoPreviewHeight) {
        this.mVideoPreviewHeight = videoPreviewHeight;
    }

    @JsonSetter(value="video_preview_width")
    public void setVideoPreviewWidth(Integer videoPreviewWidth) {
        this.mVideoPreviewWidth = videoPreviewWidth;
    }

    @JsonSetter(value="video_preview_content_length")
    public void setVideoPreviewContentLength(Integer videoPreviewContentLength) {
        this.mVideoPreviewContentLength = videoPreviewContentLength;
    }

    @JsonSetter(value="video_preview_content_type")
    public void setVideoPreviewContentType(String videoPreviewContentType) {
        this.mVideoPreviewContentType = videoPreviewContentType;
    }

    @JsonSetter(value="video_small_preview_url")
    public void setVideoSmallPreviewUrl(String videoSmallPreviewUrl) {
        this.mVideoSmallPreviewUrl = videoSmallPreviewUrl;
    }

    @JsonSetter(value="video_small_preview_height")
    public void setVideoSmallPreviewHeight(Integer videoSmallPreviewHeight) {
        this.mVideoSmallPreviewHeight = videoSmallPreviewHeight;
    }

    @JsonSetter(value="video_small_preview_width")
    public void setVideoSmallPreviewWidth(Integer videoSmallPreviewWidth) {
        this.mVideoSmallPreviewWidth = videoSmallPreviewWidth;
    }

    @JsonSetter(value="video_small_preview_content_length")
    public void setVideoSmallPreviewContentLength(Integer videoSmallPreviewContentLength) {
        this.mVideoSmallPreviewContentLength = videoSmallPreviewContentLength;
    }

    @JsonSetter(value="video_small_preview_content_type")
    public void setVideoSmallPreviewContentType(String videoSmallPreviewContentType) {
        this.mVideoSmallPreviewContentType = videoSmallPreviewContentType;
    }
}

