/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.stock.models;

import com.adobe.stock.enums.AssetLicenseState;
import com.adobe.stock.enums.AssetPurchaseState;
import com.adobe.stock.exception.StockException;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonSetter;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

@JsonIgnoreProperties(ignoreUnknown=true)
public final class LicensePurchaseDetails {
    private Date mDate;
    private Date mCancelledDate;
    private AssetLicenseState mLicenseState;
    private AssetPurchaseState mPurchaseState;
    private String mUrl;
    private String mContentType;
    private Integer mWidth;
    private Integer mHeight;
    private Double mFrameRate;
    private Integer mContentLength;
    private Integer mDuration;

    public Date getDate() {
        return this.mDate;
    }

    public Date getCancelledDate() {
        return this.mCancelledDate;
    }

    public AssetLicenseState getLicenseState() {
        return this.mLicenseState;
    }

    public AssetPurchaseState getPurchaseState() {
        return this.mPurchaseState;
    }

    public String getUrl() {
        return this.mUrl;
    }

    public String getContentType() {
        return this.mContentType;
    }

    public Integer getWidth() {
        return this.mWidth;
    }

    public Integer getHeight() {
        return this.mHeight;
    }

    public Double getFrameRate() {
        return this.mFrameRate;
    }

    public Integer getContentLength() {
        return this.mContentLength;
    }

    public Integer getDuration() {
        return this.mDuration;
    }

    @JsonSetter(value="date")
    public void setDate(String date) throws StockException {
        String formatString = "yyyy-MM-dd hh:mm:ss";
        SimpleDateFormat format = new SimpleDateFormat(formatString + ".SSS");
        SimpleDateFormat formatWithoutMS = new SimpleDateFormat(formatString);
        try {
            this.mDate = date.length() <= formatString.length() ? formatWithoutMS.parse(date) : format.parse(date);
        }
        catch (ParseException e) {
            throw new StockException("Could not parse the date string");
        }
    }

    @JsonSetter(value="cancelled")
    public void setCancelledDate(String cancelledDate) throws StockException {
        String formatString = "yyyy-MM-dd hh:mm:ss";
        SimpleDateFormat format = new SimpleDateFormat(formatString + ".SSS");
        SimpleDateFormat formatWithoutMS = new SimpleDateFormat(formatString);
        try {
            this.mCancelledDate = cancelledDate.length() <= formatString.length() ? formatWithoutMS.parse(cancelledDate) : format.parse(cancelledDate);
        }
        catch (ParseException e) {
            throw new StockException("Could not parse the date string");
        }
    }

    @JsonSetter(value="license")
    public void setLicenseState(AssetLicenseState licenseState) {
        this.mLicenseState = licenseState;
    }

    @JsonSetter(value="state")
    public void setPurchaseState(AssetPurchaseState purchaseState) {
        this.mPurchaseState = purchaseState;
    }

    @JsonSetter(value="url")
    public void setUrl(String url) {
        this.mUrl = url;
    }

    @JsonSetter(value="content_type")
    public void setContentType(String contentType) {
        this.mContentType = contentType;
    }

    @JsonSetter(value="width")
    public void setWidth(Integer width) {
        this.mWidth = width;
    }

    @JsonSetter(value="height")
    public void setHeight(Integer height) {
        this.mHeight = height;
    }

    @JsonSetter(value="framerate")
    public void setFrameRate(Double frameRate) {
        this.mFrameRate = frameRate;
    }

    @JsonSetter(value="content_length")
    public void setContentLength(Integer contentLength) {
        this.mContentLength = contentLength;
    }

    @JsonSetter(value="duration")
    public void setDuration(Integer duration) {
        this.mDuration = duration;
    }
}

