/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.stock.apis;

import com.adobe.stock.annotations.SearchParamURLMapperInternal;
import com.adobe.stock.apis.ApiUtils;
import com.adobe.stock.apis.HttpUtils;
import com.adobe.stock.apis.JsonUtils;
import com.adobe.stock.config.StockConfig;
import com.adobe.stock.enums.LicenseHistoryResultColumn;
import com.adobe.stock.exception.StockException;
import com.adobe.stock.models.LicenseHistoryRequest;
import com.adobe.stock.models.LicenseHistoryResponse;
import com.adobe.stock.models.SearchParametersLicenseHistory;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.util.Map;
import org.apache.http.client.utils.URIBuilder;

final class LicenseHistoryAPIHelpers {
    private static final String LOCALE = "locale";
    private static final String RESULT_COLUMNS = "result_columns[]";
    private static final String SEARCH_PARAMS_PREFIX = "search_parameters";

    private LicenseHistoryAPIHelpers() {
    }

    static void validateLicenseHistoryQueryParams(LicenseHistoryRequest request) throws StockException {
        if (request.getSearchParams() == null) {
            throw new StockException("Search parameter must be present in the request object");
        }
    }

    static String createLicenseHistoryApiUrl(String endpoint, LicenseHistoryRequest request) throws StockException {
        try {
            URIBuilder uriBuilder = new URIBuilder(endpoint);
            if (!request.getLocale().isEmpty()) {
                uriBuilder.setParameter(LOCALE, request.getLocale());
            }
            SearchParametersLicenseHistory searchParams = request.getSearchParams();
            for (Field field : searchParams.getClass().getDeclaredFields()) {
                SearchParamURLMapperInternal paramAnnotation;
                field.setAccessible(true);
                if (field.get(searchParams) == null || (paramAnnotation = field.getAnnotation(SearchParamURLMapperInternal.class)) == null) continue;
                String paramName = SEARCH_PARAMS_PREFIX + paramAnnotation.value();
                uriBuilder.setParameter(paramName, field.get(searchParams).toString());
            }
            LicenseHistoryResultColumn[] resultColumns = request.getResultColumns();
            if (resultColumns != null) {
                for (int i = 0; i < Array.getLength(resultColumns); ++i) {
                    uriBuilder.addParameter(RESULT_COLUMNS, resultColumns[i].toString());
                }
            }
            String url = uriBuilder.build().toURL().toString();
            return url;
        }
        catch (IllegalAccessException | IllegalArgumentException | NullPointerException | MalformedURLException | URISyntaxException e) {
            throw new StockException("Could not create the LicenseHistory request url");
        }
    }

    static LicenseHistoryResponse licenseHistory(StockConfig config, String accessToken, LicenseHistoryRequest request) throws StockException {
        String requestURL = LicenseHistoryAPIHelpers.createLicenseHistoryApiUrl(config.getEndpoints().getLicenseHistoryEndpoint(), request);
        Map<String, String> headers = ApiUtils.generateCommonAPIHeaders(config, accessToken);
        String responseString = null;
        responseString = HttpUtils.doGet(requestURL, headers);
        LicenseHistoryResponse licenseHistoryResponse = (LicenseHistoryResponse)JsonUtils.parseJson(LicenseHistoryResponse.class, responseString);
        return licenseHistoryResponse;
    }
}

