/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.stock.apis;

import com.adobe.stock.apis.LicenseHistoryAPIHelpers;
import com.adobe.stock.apis.ModelsUtil;
import com.adobe.stock.config.StockConfig;
import com.adobe.stock.exception.StockException;
import com.adobe.stock.models.LicenseHistoryRequest;
import com.adobe.stock.models.LicenseHistoryResponse;

public final class LicenseHistory {
    public static final int LICENSE_HISTORY_RETURN_ERROR = -1;
    private static final int DEFAULT_LICENSE_HISTORY_FILES_LIMIT = 100;
    private StockConfig mConfig;
    private String mAccessToken;
    private LicenseHistoryRequest mRequest;
    private LicenseHistoryRequest mLastRequest;
    private boolean mApiInProgress;
    private LicenseHistoryResponse mResponse;
    private boolean mInitialInvalidState = true;

    public LicenseHistory(StockConfig config, String accessToken, LicenseHistoryRequest request) throws StockException {
        if (config == null) {
            throw new StockException("config can't be null");
        }
        this.mConfig = new StockConfig().setApiKey(config.getApiKey()).setProduct(config.getProduct()).setTargetEnvironment(config.getTargetEnvironment()).setProductLocation(config.getProductLocation());
        if (request == null) {
            throw new StockException("request can't be null");
        }
        LicenseHistoryAPIHelpers.validateLicenseHistoryQueryParams(request);
        this.mRequest = (LicenseHistoryRequest)ModelsUtil.deepClone(request);
        this.mAccessToken = accessToken;
        this.mApiInProgress = false;
        if (this.mRequest.getSearchParams().getLimit() == null) {
            this.mRequest.getSearchParams().setLimit(100);
        }
        if (this.mRequest.getSearchParams().getOffset() == null) {
            this.mRequest.getSearchParams().setOffset(0);
        }
    }

    private void storeLicenseHistoryRequestState() {
        this.mLastRequest = this.mRequest;
    }

    private void revertToLastLicenseHistoryRequestState() {
        if (this.mLastRequest != null) {
            this.mRequest = this.mLastRequest;
        }
        this.mLastRequest = null;
    }

    private void doOnSuccess(LicenseHistoryResponse response) {
        this.mResponse = response;
        this.mApiInProgress = false;
        if (this.mInitialInvalidState) {
            this.mInitialInvalidState = false;
        }
    }

    private void doOnError() {
        this.revertToLastLicenseHistoryRequestState();
        this.mApiInProgress = false;
    }

    private LicenseHistoryResponse doApiCall(LicenseHistoryRequest request) throws StockException {
        if (this.mApiInProgress) {
            throw new StockException("Some other search is already in progress!");
        }
        try {
            this.mApiInProgress = true;
            this.storeLicenseHistoryRequestState();
            this.mRequest = request;
            LicenseHistoryResponse response = LicenseHistoryAPIHelpers.licenseHistory(this.mConfig, this.mAccessToken, request);
            this.doOnSuccess(response);
        }
        catch (StockException e) {
            this.doOnError();
            throw e;
        }
        return this.getLastLicenseHistory();
    }

    public int getTotalLicenseHistoryFiles() {
        if (!this.mInitialInvalidState && this.mResponse.getNbResults() != null) {
            return this.mResponse.getNbResults();
        }
        return -1;
    }

    public int getTotalLicenseHistoryPages() {
        if (!this.mInitialInvalidState && this.mResponse.getNbResults() != null) {
            return (int)Math.ceil((double)this.mResponse.getNbResults().intValue() / (double)this.mRequest.getSearchParams().getLimit().intValue());
        }
        return -1;
    }

    public int currentLicenseHistoryPageIndex() {
        if (!this.mInitialInvalidState && this.mResponse.getNbResults() != null) {
            int offset = this.mRequest.getSearchParams().getOffset();
            return (int)Math.ceil((double)offset / (double)this.mRequest.getSearchParams().getLimit().intValue());
        }
        return -1;
    }

    public LicenseHistoryResponse getLastLicenseHistory() {
        LicenseHistoryResponse userResponse = null;
        if (!this.mInitialInvalidState) {
            userResponse = (LicenseHistoryResponse)ModelsUtil.deepClone(this.mResponse);
        }
        return userResponse;
    }

    public LicenseHistoryResponse getNextLicenseHistory() throws StockException {
        LicenseHistoryRequest request = (LicenseHistoryRequest)ModelsUtil.deepClone(this.mRequest);
        if (!this.mInitialInvalidState) {
            int limit = request.getSearchParams().getLimit();
            int offset = request.getSearchParams().getOffset();
            request.getSearchParams().setOffset(offset + limit);
            if (this.mResponse.getNbResults() == null || request.getSearchParams().getOffset() >= this.mResponse.getNbResults()) {
                throw new StockException("No more results available!");
            }
        }
        return this.doApiCall(request);
    }

    public LicenseHistoryResponse getPreviousLicenseHistory() throws StockException {
        try {
            LicenseHistoryRequest request = (LicenseHistoryRequest)ModelsUtil.deepClone(this.mRequest);
            int offset = request.getSearchParams().getOffset();
            request.getSearchParams().setOffset(offset - request.getSearchParams().getLimit());
            return this.doApiCall(request);
        }
        catch (IllegalArgumentException e) {
            throw new StockException("No more results available!");
        }
    }

    public LicenseHistoryResponse getLicenseHistoryPage(int pageIndex) throws StockException {
        LicenseHistoryRequest request = (LicenseHistoryRequest)ModelsUtil.deepClone(this.mRequest);
        int totalPages = this.getTotalLicenseHistoryPages();
        if (pageIndex < 0 || totalPages != -1 && pageIndex >= totalPages) {
            throw new StockException("Page index out of bounds");
        }
        request.getSearchParams().setOffset(pageIndex * request.getSearchParams().getLimit());
        return this.doApiCall(request);
    }
}

