/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.stock.apis;

import com.adobe.stock.annotations.SearchParamURLMapperInternal;
import com.adobe.stock.exception.StockException;
import com.adobe.stock.models.LicenseRequest;
import java.lang.reflect.Field;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.http.client.utils.URIBuilder;

final class LicenseAPIHelpers {
    private LicenseAPIHelpers() {
    }

    static void validateLicenseQueryParams(LicenseRequest request, String accessToken, boolean requiresLicenseState) throws StockException {
        if (request == null) {
            throw new StockException("Request can't be null");
        }
        if (request.getContentId() == null) {
            throw new StockException("Asset Content id must be present in the license request");
        }
        if (requiresLicenseState && request.getLicenseState() == null) {
            throw new StockException("Licensing state must be present in the license request");
        }
        if (accessToken == null || accessToken.isEmpty()) {
            throw new StockException("Access token can't be null or empty");
        }
    }

    static String createLicenseApiUrl(String endPoint, LicenseRequest request) throws StockException {
        try {
            new URI(endPoint).toURL();
            URIBuilder uriBuilder = new URIBuilder(endPoint);
            for (Field field : request.getClass().getDeclaredFields()) {
                SearchParamURLMapperInternal paramAnnotation;
                field.setAccessible(true);
                if (field.get(request) == null || (paramAnnotation = field.getAnnotation(SearchParamURLMapperInternal.class)) == null) continue;
                uriBuilder.setParameter(paramAnnotation.value(), field.get(request).toString());
            }
            String url = uriBuilder.toString();
            return url;
        }
        catch (IllegalAccessException | IllegalArgumentException | NullPointerException | MalformedURLException | URISyntaxException e) {
            throw new StockException("Could not create the license request url");
        }
    }

    static String getLicenseApiHttpMethod(LicenseRequest request) {
        String method = "GET";
        if (request.getLicenseReference() != null) {
            method = "POST";
        }
        return method;
    }
}

