/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.stock.apis;

import com.adobe.stock.exception.StockException;
import java.io.ByteArrayInputStream;
import java.net.URI;
import java.net.URLConnection;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.util.EntityUtils;

final class HttpUtils {
    public static final String HTTP_GET = "GET";
    public static final String HTTP_POST = "POST";
    private static final int HTTP_STATUS_CODE_DIVISOR = 100;
    private static final int HTTP_STATUS_CODE_API_ERROR = 4;
    private static final int HTTP_STATUS_CODE_SERVER_ERROR = 5;
    private static final int HTTP_STATUS_CODE_REDIRECT = 3;
    private static final int MAX_TOTAL_CONNECTIONS = 200;
    private static final int MAX_PER_ROUTE_CONNECTIONS = 20;
    private static HttpClient sHttpClient;
    private static final int TIME_OUT = 6000;

    private HttpUtils() {
    }

    private static HttpClient initialize() {
        PoolingHttpClientConnectionManager connManager = new PoolingHttpClientConnectionManager();
        connManager.setMaxTotal(200);
        connManager.setDefaultMaxPerRoute(20);
        RequestConfig config = RequestConfig.custom().setConnectionRequestTimeout(6000).setSocketTimeout(6000).build();
        CloseableHttpClient httpClient = HttpClients.custom().setConnectionManager((HttpClientConnectionManager)connManager).disableRedirectHandling().setDefaultRequestConfig(config).build();
        return httpClient;
    }

    static String resolveDownloadUrl(String uri, Map<String, String> headers) throws StockException {
        if (sHttpClient == null) {
            sHttpClient = HttpUtils.initialize();
        }
        if (uri == null || uri.isEmpty()) {
            throw new StockException(-1, "URI cannot be null or Empty");
        }
        HttpHead request = new HttpHead();
        if (headers != null) {
            for (Map.Entry<String, String> entry : headers.entrySet()) {
                request.setHeader(entry.getKey(), entry.getValue());
            }
        }
        try {
            request.setURI(new URI(uri));
            HttpResponse response = sHttpClient.execute((HttpUriRequest)request);
            if (response.getStatusLine().getStatusCode() / 100 == 3) {
                String string = response.getFirstHeader("Location").getValue();
                return string;
            }
        }
        catch (Exception e) {
            throw new StockException(e.getMessage());
        }
        finally {
            request.releaseConnection();
        }
        return uri;
    }

    public static String doGet(String uri, Map<String, String> headers) throws StockException {
        if (sHttpClient == null) {
            sHttpClient = HttpUtils.initialize();
        }
        HttpResponse response = null;
        String responseBody = null;
        HttpGet request = new HttpGet();
        if (uri == null || uri.isEmpty()) {
            throw new StockException(-1, "URI cannot be null or Empty");
        }
        if (headers != null) {
            for (Map.Entry<String, String> entry : headers.entrySet()) {
                request.setHeader(entry.getKey(), entry.getValue());
            }
        }
        try {
            request.setURI(new URI(uri));
            response = sHttpClient.execute((HttpUriRequest)request);
            if (response.getStatusLine().getStatusCode() == 200) {
                responseBody = EntityUtils.toString((HttpEntity)response.getEntity());
            } else if (response.getStatusLine().getStatusCode() == 204) {
                responseBody = String.valueOf(204);
            } else {
                if (response.getStatusLine().getStatusCode() / 100 == 4) {
                    responseBody = EntityUtils.toString((HttpEntity)response.getEntity());
                    throw new StockException(response.getStatusLine().getStatusCode(), responseBody);
                }
                if (response.getStatusLine().getStatusCode() / 100 == 3) {
                    String locationHeader;
                    responseBody = locationHeader = response.getHeaders("Location")[0].getValue();
                } else if (response.getStatusLine().getStatusCode() / 100 == 5) {
                    throw new StockException(response.getStatusLine().getStatusCode(), "API returned with Server Error");
                }
            }
        }
        catch (StockException se) {
            throw se;
        }
        catch (Exception ex) {
            throw new StockException(ex.getMessage());
        }
        finally {
            if (response != null) {
                EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
            }
            request.releaseConnection();
        }
        return responseBody;
    }

    public static String doPost(String uri, Map<String, String> headers, byte[] postData, ContentType contentType) throws StockException {
        if (sHttpClient == null) {
            sHttpClient = HttpUtils.initialize();
        }
        HttpResponse response = null;
        String responseBody = null;
        if (uri == null || uri.isEmpty()) {
            throw new StockException(-1, "URI cannot be null or Empty");
        }
        HttpPost request = new HttpPost(uri);
        if (headers != null) {
            for (Map.Entry<String, String> entry : headers.entrySet()) {
                request.setHeader(entry.getKey(), entry.getValue());
            }
        }
        try {
            int statusCode;
            if (postData != null) {
                ByteArrayEntity entity = new ByteArrayEntity(postData, contentType);
                request.setEntity((HttpEntity)entity);
            }
            if ((statusCode = (response = sHttpClient.execute((HttpUriRequest)request)).getStatusLine().getStatusCode()) == 200 || statusCode == 201 || statusCode == 204) {
                responseBody = EntityUtils.toString((HttpEntity)response.getEntity());
            } else {
                if (response.getStatusLine().getStatusCode() / 100 == 4) {
                    responseBody = EntityUtils.toString((HttpEntity)response.getEntity());
                    throw new StockException(response.getStatusLine().getStatusCode(), responseBody);
                }
                if (response.getStatusLine().getStatusCode() / 100 == 5) {
                    throw new StockException(response.getStatusLine().getStatusCode(), "API returned with Server Error");
                }
            }
        }
        catch (StockException se) {
            throw se;
        }
        catch (Exception ex) {
            throw new StockException(-1, ex.getMessage());
        }
        finally {
            if (response != null) {
                EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
            }
            request.releaseConnection();
        }
        return responseBody;
    }

    public static String doMultiPart(String uri, byte[] file, Map<String, String> headers) throws StockException {
        if (sHttpClient == null) {
            sHttpClient = HttpUtils.initialize();
        }
        HttpResponse response = null;
        String responseBody = null;
        if (uri == null || uri.isEmpty()) {
            throw new StockException(-1, "URI cannot be null or Empty");
        }
        HttpPost request = new HttpPost(uri);
        if (headers != null) {
            for (Map.Entry<String, String> entry : headers.entrySet()) {
                request.setHeader(entry.getKey(), entry.getValue());
            }
        }
        MultipartEntityBuilder builder = MultipartEntityBuilder.create();
        builder.setMode(HttpMultipartMode.BROWSER_COMPATIBLE);
        try {
            if (file != null) {
                String contentType = URLConnection.guessContentTypeFromStream(new ByteArrayInputStream(file));
                builder.addBinaryBody("similar_image", file, ContentType.create((String)contentType), "file");
            }
            HttpEntity entity = builder.build();
            request.setEntity(entity);
            response = sHttpClient.execute((HttpUriRequest)request);
            if (response.getStatusLine().getStatusCode() == 200 || response.getStatusLine().getStatusCode() == 201) {
                responseBody = EntityUtils.toString((HttpEntity)response.getEntity());
            } else {
                if (response.getStatusLine().getStatusCode() / 100 == 4) {
                    responseBody = EntityUtils.toString((HttpEntity)response.getEntity());
                    throw new StockException(response.getStatusLine().getStatusCode(), responseBody);
                }
                if (response.getStatusLine().getStatusCode() / 100 == 5) {
                    throw new StockException(response.getStatusLine().getStatusCode(), "API returned with Server Error");
                }
            }
        }
        catch (StockException se) {
            throw se;
        }
        catch (Exception ex) {
            throw new StockException(-1, ex.getMessage());
        }
        return responseBody;
    }
}

