/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.stock.apis;

import com.adobe.stock.exception.StockException;
import java.net.URISyntaxException;
import org.apache.http.client.utils.URIBuilder;

final class EntitlementsApiHelper {
    private static final String ENTITY_REF_PARAM = "entity_ref";

    private EntitlementsApiHelper() {
    }

    static String createApiURL(String endPoint, String accessToken, String entityReference) throws StockException {
        try {
            if (accessToken == null || accessToken.isEmpty()) {
                throw new StockException("Access token can't be null or empty");
            }
            URIBuilder uriBuilder = new URIBuilder(endPoint);
            if (entityReference != null && !entityReference.isEmpty()) {
                uriBuilder.setParameter(ENTITY_REF_PARAM, entityReference);
            }
            return uriBuilder.toString();
        }
        catch (IllegalArgumentException | NullPointerException | URISyntaxException e) {
            throw new StockException("Could not create the entitlement request url");
        }
    }
}

