/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.xfdf.impl;

import com.adobe.internal.io.stream.InputByteStream;
import com.adobe.internal.pdftoolkit.core.cos.CosArray;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFCosParseException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidXMLException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.core.util.ByteOps;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotation3D;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.DecimalFormat;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.xml.sax.helpers.AttributesImpl;

class XFDFUtil {
    public static final String XFDF_NAMESPACE = "http://ns.adobe.com/xfdf/";
    private static final String ATTR_ORIG = "original";
    private static final String ATTR_MOD = "modified";
    private static final String xfdfCharacterReferencePatternString = "&#x([\\da-fA-F]+);";
    private static final Pattern xfdfCharacterReferencePattern = Pattern.compile("&#x([\\da-fA-F]+);");
    private static final String[][] xfdfCharacterEntityStrings = new String[][]{{"&quot;", "\""}, {"&amp;", "&"}, {"&lt;", "<"}, {"&gt;", ">"}};
    private static final String[] ToXFDFStringCharMappingTable = new String[]{"\\000", "\\001", "\\002", "\\003", "\\004", "\\005", "\\006", "\\007", "\\010", "&#x9;", "&#xa;", "\\013", "\\014", "&#xd;", "\\016", "\\017", "\\020", "\\021", "\\022", "\\023", "\\024", "\\025", "\\026", "\\027", "\\030", "\\031", "\\032", "\\033", "\\034", "\\035", "\\036", "\\037", " ", "!", "\"", "#", "$", "%", "&", "'", "(", ")", "*", "+", ",", "-", ".", "/", "0", "1", "2", "3", "4", "5", "6", "7", "8", "9", ":", ";", "<", "=", ">", "?", "@", "A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "L", "M", "N", "O", "P", "Q", "R", "S", "T", "U", "V", "W", "X", "Y", "Z", "[", "\\", "]", "^", "_", "`", "a", "b", "c", "d", "e", "f", "g", "h", "i", "j", "k", "l", "m", "n", "o", "p", "q", "r", "s", "t", "u", "v", "w", "x", "y", "z", "{", "|", "}", "~", "\\177", "\\200", "\\201", "\\202", "\\203", "\\204", "\\205", "\\206", "\\207", "\\210", "\\211", "\\212", "\\213", "\\214", "\\215", "\\216", "\\217", "\\220", "\\221", "\\222", "\\223", "\\224", "\\225", "\\226", "\\227", "\\230", "\\231", "\\232", "\\233", "\\234", "\\235", "\\236", "\\237", "\u00a0", "\u00a1", "\u00a2", "\u00a3", "\u00a4", "\u00a5", "\u00a6", "\u00a7", "\u00a8", "\u00a9", "\u00aa", "\u00ab", "\u00ac", "\u00ad", "\u00ae", "\u00af", "\u00b0", "\u00b1", "\u00b2", "\u00b3", "\u00b4", "\u00b5", "\u00b6", "\u00b7", "\u00b8", "\u00b9", "\u00ba", "\u00bb", "\u00bc", "\u00bd", "\u00be", "\u00bf", "\u00c0", "\u00c1", "\u00c2", "\u00c3", "\u00c4", "\u00c5", "\u00c6", "\u00c7", "\u00c8", "\u00c9", "\u00ca", "\u00cb", "\u00cc", "\u00cd", "\u00ce", "\u00cf", "\u00d0", "\u00d1", "\u00d2", "\u00d3", "\u00d4", "\u00d5", "\u00d6", "\u00d7", "\u00d8", "\u00d9", "\u00da", "\u00db", "\u00dc", "\u00dd", "\u00de", "\u00df", "\u00e0", "\u00e1", "\u00e2", "\u00e3", "\u00e4", "\u00e5", "\u00e6", "\u00e7", "\u00e8", "\u00e9", "\u00ea", "\u00eb", "\u00ec", "\u00ed", "\u00ee", "\u00ef", "\u00f0", "\u00f1", "\u00f2", "\u00f3", "\u00f4", "\u00f5", "\u00f6", "\u00f7", "\u00f8", "\u00f9", "\u00fa", "\u00fb", "\u00fc", "\u00fd", "\u00fe", "\u00ff"};

    XFDFUtil() {
    }

    static AttributesImpl createXFDFAttributes() {
        AttributesImpl xfdfAttrs = new AttributesImpl();
        xfdfAttrs.addAttribute("http://www.w3.org/XML/1998/namespace", "space", "xml:space", "CDATA", "preserve");
        return xfdfAttrs;
    }

    static AttributesImpl createTrailerAttributes(PDFDocument doc) throws PDFIOException, PDFInvalidDocumentException, PDFInvalidXMLException, PDFSecurityException {
        AttributesImpl trailerAtts = new AttributesImpl();
        CosArray ids = (CosArray)doc.getCosDocument().getTrailer().get(ASName.k_ID);
        if (ids != null && ids.size() == 2) {
            trailerAtts.addAttribute("", ATTR_ORIG, ATTR_ORIG, "CDATA", XFDFUtil.stripBrackets(ids.getCosString(0).toString()));
            trailerAtts.addAttribute("", ATTR_MOD, ATTR_MOD, "CDATA", XFDFUtil.stripBrackets(ids.getCosString(1).toString()));
        }
        return trailerAtts;
    }

    static String stripBrackets(String ids) {
        if (ids == null) {
            return null;
        }
        if (ids.charAt(0) == '<') {
            ids = ids.substring(1);
        }
        if (ids.endsWith(">")) {
            ids = ids.substring(0, ids.length() - 1);
        }
        return ids;
    }

    static String toXFDFStringFromByteString(byte[] b) {
        if (b == null) {
            return null;
        }
        StringBuilder buffer = new StringBuilder(b.length * 2);
        for (int i = 0; i < b.length; ++i) {
            buffer.append(ToXFDFStringCharMappingTable[b[i] & 0xFF]);
        }
        return buffer.toString();
    }

    static byte[] toByteStringFromXFDFString(String s) {
        byte[] in;
        StringBuilder sb = new StringBuilder(s);
        for (int i = 0; i < xfdfCharacterEntityStrings.length; ++i) {
            XFDFUtil.stringBufferReplaceAll(sb, xfdfCharacterEntityStrings[i][0], xfdfCharacterEntityStrings[i][1]);
        }
        Matcher characterEntityMatcher = xfdfCharacterReferencePattern.matcher(s);
        int matchPointer = 0;
        char[] replacements = new char[2];
        while (characterEntityMatcher.find(matchPointer)) {
            int charactersWritten = 0;
            int entityValue = Integer.parseInt(characterEntityMatcher.group(1), 16);
            if (entityValue <= 0x10FFFF) {
                if (entityValue > 65535) {
                    replacements[0] = (char)(((entityValue -= 65536) & 0xFFC00) >> 10 & 0xD800);
                    replacements[1] = (char)(entityValue & 0x3FF & 0xDC00);
                    sb.replace(characterEntityMatcher.start(), characterEntityMatcher.end(), new String(replacements));
                    charactersWritten = 2;
                } else {
                    sb.replace(characterEntityMatcher.start(), characterEntityMatcher.end(), new String(new char[]{(char)entityValue}));
                }
            }
            matchPointer += charactersWritten - (characterEntityMatcher.end() - characterEntityMatcher.start());
        }
        replacements = null;
        try {
            in = sb.toString().getBytes("ISO-8859-1");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("ISO-8859-1 encoding is not supported", e);
        }
        byte[] out = new byte[in.length];
        int inPos = 0;
        int outPos = 0;
        while (inPos < in.length) {
            if (in[inPos] == 92 && inPos + 4 < in.length && ByteOps.isLeadingOctalDigit((byte)in[inPos + 1]) && ByteOps.isOctalDigit((byte)in[inPos + 2]) && ByteOps.isOctalDigit((byte)in[inPos + 3])) {
                out[outPos++] = (byte)(ByteOps.getNumericalValue((byte)in[inPos + 1]) * 64 + ByteOps.getNumericalValue((byte)in[inPos + 2]) * 8 + ByteOps.getNumericalValue((byte)in[inPos + 3]));
                inPos += 4;
                continue;
            }
            out[outPos++] = in[inPos++];
        }
        if (out.length > outPos) {
            byte[] outTrimmed = new byte[outPos];
            System.arraycopy(out, 0, outTrimmed, 0, outPos);
            out = outTrimmed;
        }
        return out;
    }

    private static final int stringBufferReplaceAll(StringBuilder sb, String search, String replace) {
        int numberFound = 0;
        int searchIndex = 0;
        while ((searchIndex = sb.indexOf(search, searchIndex)) != -1) {
            sb.replace(searchIndex, searchIndex + search.length(), replace);
            searchIndex += search.length();
            ++numberFound;
        }
        return numberFound;
    }

    static String getMD5ChecksumString(byte[] MD5ChecksumBytes) {
        StringBuilder mD5Checksum = new StringBuilder();
        for (int i = 0; i < MD5ChecksumBytes.length; ++i) {
            if (MD5ChecksumBytes[i] < 0) {
                mD5Checksum.append(256 + MD5ChecksumBytes[i]);
            } else {
                mD5Checksum.append(MD5ChecksumBytes[i]);
            }
            mD5Checksum.append(" ");
        }
        return mD5Checksum.toString().trim();
    }

    static byte[] calculateMD5Checksum(PDFAnnotation3D annot3D) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        InputByteStream byteStreamDecoded = annot3D.get3DDictOrStreamAsStream().getCosStream().getStreamDecoded();
        byte[] byteStream = new byte[8192];
        MessageDigest md5Digest = null;
        try {
            md5Digest = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            throw new PDFSecurityException((Throwable)e);
        }
        try {
            while (byteStreamDecoded.bytesAvailable() > 0L) {
                int numBytesRead = byteStreamDecoded.read(byteStream);
                md5Digest.update(byteStream, 0, numBytesRead);
            }
            byteStreamDecoded.close();
        }
        catch (IOException e) {
            throw new PDFIOException((Throwable)e);
        }
        byte[] checkSum = md5Digest.digest();
        if (checkSum == null || checkSum.length == 0) {
            throw new PDFSecurityException("MD5 checksum can not be calculated");
        }
        return checkSum;
    }

    static String toStringFromDoubleArray(double[] array) throws PDFCosParseException, PDFIOException, PDFSecurityException {
        if (array == null) {
            return null;
        }
        DecimalFormat df = new DecimalFormat("0.0000000000");
        StringBuilder stringFromDoubleArray = new StringBuilder();
        for (int i = 0; i < array.length; ++i) {
            stringFromDoubleArray.append(df.format(array[i]));
            stringFromDoubleArray.append(" ");
        }
        return stringFromDoubleArray.toString().trim();
    }
}

