/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.xfdf.impl;

import com.adobe.internal.pdftoolkit.core.exceptions.PDFConfigurationException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFUnableToCompleteOperationException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotation;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationRotationEnum;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationText;
import com.adobe.internal.pdftoolkit.services.xfdf.impl.XFDFAnnotation;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

final class XFDFAnnotationText
extends XFDFAnnotation {
    static final String ATTR_ICON = "icon";
    static final String ATTR_STATE = "state";
    static final String ATTR_STATEMODEL = "statemodel";
    static final String ATTR_INREPLYTO = "inreplyto";
    static final String ELEM_TEXT = "text";

    public XFDFAnnotationText(PDFAnnotationText pdfAnnotation) {
        this.pdfAnnot = pdfAnnotation;
        this.pdfDoc = null;
    }

    XFDFAnnotationText(PDFDocument pdfDocument) {
        this.pdfDoc = pdfDocument;
        this.pdfAnnot = null;
    }

    @Override
    void transformToXFDF(ContentHandler handler, int pageNum) throws PDFIOException, PDFInvalidDocumentException, PDFSecurityException, PDFConfigurationException, PDFUnableToCompleteOperationException {
        AttributesImpl annotsAtts = new AttributesImpl();
        this.addCommonXFDFAttributes(annotsAtts, pageNum);
        this.addMarkupXFDFAttributes(annotsAtts);
        PDFAnnotation irt = ((PDFAnnotationText)this.pdfAnnot).getInReplyTo();
        if (irt != null) {
            annotsAtts.addAttribute("", ATTR_INREPLYTO, ATTR_INREPLYTO, "CDATA", irt.getName());
        }
        if (this.pdfAnnot instanceof PDFAnnotationText && ((PDFAnnotationText)this.pdfAnnot).hasIconName()) {
            annotsAtts.addAttribute("", ATTR_ICON, ATTR_ICON, "CDATA", ((PDFAnnotationText)this.pdfAnnot).getIconName());
        }
        if (this.pdfAnnot.dictionaryContains(ASName.k_State)) {
            annotsAtts.addAttribute("", ATTR_STATE, ATTR_STATE, "CDATA", ((PDFAnnotationText)this.pdfAnnot).getState());
        }
        if (this.pdfAnnot.dictionaryContains(ASName.k_StateModel)) {
            annotsAtts.addAttribute("", ATTR_STATEMODEL, ATTR_STATEMODEL, "CDATA", ((PDFAnnotationText)this.pdfAnnot).getStateModel());
        }
        try {
            handler.startElement("", ELEM_TEXT, ELEM_TEXT, annotsAtts);
            if (!this.createXFDFRichContent(handler)) {
                this.createXFDFContent(handler);
            }
            this.createXFDFExData3DMarkup(handler);
            this.addAppearanceToXFDF(handler);
            this.createXFDFPopupElement(handler, pageNum);
            handler.endElement("", ELEM_TEXT, ELEM_TEXT);
            handler.characters(END_ELEM, 0, 1);
        }
        catch (SAXException e) {
            throw new PDFUnableToCompleteOperationException("Unable to create XFDF element", (Throwable)e);
        }
    }

    @Override
    PDFAnnotation createPDFAnnotation(Attributes elemAttrs) throws PDFIOException, PDFInvalidParameterException, PDFInvalidDocumentException, PDFSecurityException {
        if (this.pdfDoc == null) {
            return null;
        }
        int gotPage = -1;
        PDFAnnotationText textAnnot = PDFAnnotationText.newInstance((PDFDocument)this.pdfDoc);
        this.pdfAnnot = null;
        gotPage = this.fillCommonAttributes((PDFAnnotation)textAnnot, elemAttrs);
        if (gotPage >= 0) {
            String rotation;
            int attrInd;
            int state;
            this.fillMarkupAttributes((PDFAnnotation)textAnnot, elemAttrs);
            int icon = XFDFAnnotationText.findAttribute(ATTR_ICON, elemAttrs);
            if (icon != -1) {
                textAnnot.setIconName(elemAttrs.getValue(icon));
            }
            if ((state = XFDFAnnotationText.findAttribute(ATTR_STATE, elemAttrs)) != -1) {
                textAnnot.setState(elemAttrs.getValue(state));
            }
            if ((state = XFDFAnnotationText.findAttribute(ATTR_STATEMODEL, elemAttrs)) != -1) {
                textAnnot.setStateModel(elemAttrs.getValue(state));
            }
            if ((attrInd = XFDFAnnotationText.findAttribute("rotation", elemAttrs)) != 0 && (rotation = elemAttrs.getValue(attrInd)) != null) {
                textAnnot.setRotation(Integer.parseInt(rotation));
                PDFAnnotationRotationEnum rotationType = this.getRotationType();
                if (rotationType == PDFAnnotationRotationEnum.OnlyPageRotation || rotationType == PDFAnnotationRotationEnum.WithPageRotation) {
                    textAnnot.applyRotation(this.pdfDoc.requirePages().getPage(gotPage).getCropBox(), this.pdfDoc.requirePages().getPage(gotPage).getRotation().getValue());
                }
            }
            if (this.setAnnotation((PDFAnnotation)textAnnot, gotPage)) {
                this.pdfAnnot = textAnnot;
                this.curPage = gotPage;
            }
        }
        return this.pdfAnnot;
    }

    @Override
    protected String getInReplyTo(Attributes elemAttrs) {
        int repInd = XFDFAnnotationText.findAttribute(ATTR_INREPLYTO, elemAttrs);
        return repInd != -1 ? elemAttrs.getValue(repInd) : null;
    }
}

