/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.xfdf.impl;

import com.adobe.internal.pdftoolkit.core.exceptions.PDFConfigurationException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFUnableToCompleteOperationException;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotation;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationProjection;
import com.adobe.internal.pdftoolkit.services.xfdf.impl.XFDFAnnotation;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

final class XFDFAnnotationProjection
extends XFDFAnnotation {
    static final String ELEM_PROJECTION = "projection";
    static final String ELEM_VERTICES = "vertices";

    XFDFAnnotationProjection(PDFAnnotationProjection pdfAnnotation) {
        this.pdfAnnot = pdfAnnotation;
        this.pdfDoc = null;
    }

    XFDFAnnotationProjection(PDFDocument pdfDocument) {
        this.pdfDoc = pdfDocument;
        this.pdfAnnot = null;
    }

    @Override
    void transformToXFDF(ContentHandler handler, int pageNum) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFConfigurationException, PDFUnableToCompleteOperationException {
        AttributesImpl annotsAtts = new AttributesImpl();
        this.addCommonXFDFAttributes(annotsAtts, pageNum);
        this.addMarkupXFDFAttributes(annotsAtts);
        this.addBorderStyleXFDFAttributes(annotsAtts, true);
        this.addInteriorColorXFDFAttribute(annotsAtts);
        try {
            handler.startElement("", ELEM_PROJECTION, ELEM_PROJECTION, annotsAtts);
            if (!this.createXFDFRichContent(handler)) {
                this.createXFDFContent(handler);
            }
            this.createXFDFPopupElement(handler, pageNum);
            this.createXFDFExData3DMarkup(handler);
            this.addAppearanceToXFDF(handler);
            handler.endElement("", ELEM_PROJECTION, ELEM_PROJECTION);
            handler.characters(END_ELEM, 0, 1);
        }
        catch (SAXException e) {
            throw new PDFUnableToCompleteOperationException("Unable to create XFDF element", (Throwable)e);
        }
    }

    @Override
    PDFAnnotation createPDFAnnotation(Attributes elemAttrs) throws PDFIOException, PDFInvalidDocumentException, PDFInvalidParameterException, PDFSecurityException {
        if (this.pdfDoc == null) {
            return null;
        }
        int gotPage = -1;
        PDFAnnotationProjection projAnnot = PDFAnnotationProjection.newInstance((PDFDocument)this.pdfDoc);
        this.pdfAnnot = null;
        gotPage = this.fillCommonAttributes((PDFAnnotation)projAnnot, elemAttrs);
        if (gotPage >= 0) {
            this.fillMarkupAttributes((PDFAnnotation)projAnnot, elemAttrs);
            this.fillBorderStyleAttributes((PDFAnnotation)projAnnot, elemAttrs);
            this.fillBorderEffectsAttributes((PDFAnnotation)projAnnot, elemAttrs);
            this.fillInteriorColorAttribute((PDFAnnotation)projAnnot, elemAttrs);
            this.fillIntentAttribute((PDFAnnotation)projAnnot, elemAttrs);
            if (this.setAnnotation((PDFAnnotation)projAnnot, gotPage)) {
                this.pdfAnnot = projAnnot;
                this.curPage = gotPage;
            }
        }
        return this.pdfAnnot;
    }
}

